/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.RandomAccess;

public class Repair {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/06/21 00:02:18 $";
    public static final String USAGE = "java tool.pdf.Repair [-uncompress] [-password <word>] <PDF-file>";
    private String password_;
    boolean funcompress;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Repair() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.funcompress = false;
    }

    public void repair(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string) + "-repair.pdf";
        this.repair(file, new File(string2));
    }

    public void repair(File file, File file2) throws IOException, ParseException {
        String string;
        if (!$assertionsDisabled && file.equals(file2)) {
            throw new AssertionError();
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        PDFWriter pDFWriter = new PDFWriter(file2, pDFReader);
        pDFWriter.writePDF();
        pDFWriter.close();
        if (!pDFReader.isModified()) {
            string = "no errors to repair";
        } else if (pDFReader.isRepaired()) {
            string = "REPAIRED ERRORS";
        } else {
            int n;
            RandomAccess randomAccess = pDFReader.getRAF();
            int n2 = 0;
            while ((n = randomAccess.read()) != -1) {
                if (n < 128) continue;
                ++n2;
            }
            string = n2 < 20 ? "transferred over ASCII (not binary) channel -- unrepairable" : "cannot repair";
        }
        System.out.println(string);
        pDFReader.close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.equals("-uncompress")) {
                this.funcompress = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Repair repair = new Repair();
        int n = repair.commandLine(stringArray);
        File file = new File(stringArray[n]);
        try {
            repair.repair(file);
        }
        catch (Exception exception) {
            System.err.println(file + ": " + exception);
            exception.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !Repair.class.desiredAssertionStatus();
    }
}

