/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.FileList;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merge {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/18 22:41:32 $";
    public static final String USAGE = "java tool.pdf.Merge [options] <PDF-file1> <PDF-file2>...\n\t[-password <password>] [-append]";
    private boolean fappend_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$tool$pdf$Merge;

    public Merge() {
        this.defaults();
    }

    public void defaults() {
        this.fappend_ = false;
        this.password_ = null;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void merge(FileList fileList, File file) throws IOException, ParseException {
        if (!$assertionsDisabled && fileList == null) {
            throw new AssertionError();
        }
        Iterator<File> iterator = fileList.iterator();
        if (!iterator.hasNext()) {
            throw new IOException("need at least one file");
        }
        File file2 = iterator.next();
        if (file == null) {
            String string = file2.getPath();
            String string2 = new StringBuffer().append(string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string).append("-m.pdf").toString();
            file = new File(string2);
        }
        file.delete();
        if (!this.fquiet_) {
            this.out_.print(new StringBuffer().append("copy ").append(file2).toString());
        }
        Files.copy(file2, file);
        this.append(file, iterator);
    }

    public void merge(File file, FileList fileList) throws IOException, ParseException {
        if (!($assertionsDisabled || file != null && fileList != null)) {
            throw new AssertionError();
        }
        if (!this.fquiet_) {
            this.out_.print(new StringBuffer().append("append to ").append(file).toString());
        }
        this.append(file, fileList.iterator());
    }

    private void append(File file, Iterator<File> iterator) throws IOException, ParseException {
        Object object;
        Object object2;
        int n;
        if (!iterator.hasNext()) {
            return;
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        int n2 = n = pDFReader.getObjCnt();
        int n3 = n;
        int n4 = pDFReader.getPageCnt();
        int n5 = pDFReader.getMajorVersion();
        int n6 = pDFReader.getMinorVersion();
        String string = new StringBuffer().append(n5).append(".").append(n6).toString();
        long[] lArray = new long[n2 + 3];
        long l = pDFReader.getStartXRef();
        Dict dict = new Dict();
        Dict dict2 = pDFReader.getTrailer();
        String[] stringArray = new String[]{"Encrypt", "ID", "Compress", "Root"};
        for (String object32 : stringArray) {
            object2 = dict2.get(object32);
            if (object2 == null) continue;
            dict.put(object32, object2);
        }
        Dict dict3 = new Dict();
        dict3.put("Type", "Catalog");
        IRef iRef = new IRef(n2++, 0);
        Dict dict4 = (Dict)dict2.get("Compress");
        if (dict4 != null && dict4.get("Root") != null) {
            dict4.put("Root", iRef);
        } else {
            dict.put("Root", iRef);
        }
        Dict dict5 = new Dict();
        IRef iRef2 = new IRef(n2++, 0);
        dict5.put("Producer", new StringBuffer("Multivalent Merge -- see http://www.cs.berkeley.edu/~phelps/Multivalent/"));
        StringBuffer stringBuffer = new StringBuffer(200);
        dict5.put("Merge", stringBuffer);
        stringBuffer.append(file.getName());
        Dict dict6 = pDFReader.getInfo();
        StringBuffer stringBuffer2 = COS.createDate(System.currentTimeMillis());
        if (this.fappend_ && dict6 != null && (object2 = dict6.get("CreationDate")) != null) {
            dict5.put("CreationDate", object2);
            dict5.put("ModDate", stringBuffer2);
        } else {
            dict5.put("CreationDate", stringBuffer2);
        }
        dict.put("Info", iRef2);
        Dict dict7 = new Dict();
        dict7.put("Type", "Pages");
        IRef iRef3 = new IRef(n2++, 0);
        dict3.put("Pages", iRef3);
        ArrayList<IRef> arrayList = new ArrayList<IRef>(100);
        PDFWriter pDFWriter = new PDFWriter(file, pDFReader, true);
        RandomAccessFile randomAccessFile = pDFWriter.getRAF();
        randomAccessFile.seek(randomAccessFile.length());
        object2 = pDFReader.getCatalog().get("Pages");
        IRef iRef4 = null;
        if (object2 != null && COS.CLASS_IREF == object2.getClass() && COS.CLASS_DICTIONARY == pDFReader.getObject(object2).getClass()) {
            iRef4 = (IRef)object2;
            arrayList.add(iRef4);
            object = (Dict)pDFReader.getObject(object2);
            ((Dict)object).put("Parent", iRef3);
            lArray[iRef4.id] = pDFWriter.writeObject(object, iRef4.id, iRef4.generation);
        }
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuffer.append(' ').append(((File)object).getName());
            if (!this.fquiet_) {
                this.out_.print(new StringBuffer().append(" +").append(object).toString());
            }
            pDFReader = new PDFReader((File)object);
            pDFReader.setPassword(this.password_);
            pDFReader.setExact(true);
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append("/").append(pDFReader.getObjCnt()).append("/").append(pDFReader.getPageCnt()).toString());
            }
            n4 += pDFReader.getPageCnt();
            if (pDFReader.compareVersion(n5, n6) > 0) {
                n5 = pDFReader.getMajorVersion();
                n6 = pDFReader.getMinorVersion();
            }
            n = pDFReader.getObjCnt();
            int nArray = n2;
            int nArray2 = n2 + n - 1;
            long[] lArray2 = new long[nArray2];
            System.arraycopy(lArray, 0, lArray2, 0, n2);
            lArray = lArray2;
            pDFWriter.setObjCnt(nArray2);
            object2 = pDFReader.getCatalog().get("Pages");
            int n7 = object2 != null && COS.CLASS_IREF == object2.getClass() ? ((IRef)object2).id : -1;
            pDFReader.fault();
            int n8 = 1;
            while (n8 < n) {
                int n9 = pDFReader.getObjGen(n8);
                pDFWriter.setObjGen(nArray, n9);
                if (n9 != 0 && this.fmonitor_) {
                    System.out.println(new StringBuffer().append("gen = ").append(n9).toString());
                }
                object2 = pDFReader.getObject(n8);
                pDFReader.getStreamData(new IRef(n8, n9), false, true);
                this.renumber(object2, n2 - 1);
                if (n8 == n7 && COS.CLASS_DICTIONARY == object2.getClass()) {
                    ((Dict)object2).put("Parent", iRef3);
                    arrayList.add(new IRef(nArray, n9));
                }
                lArray[nArray] = pDFWriter.writeObject(object2, nArray, n9);
                pDFWriter.setObject(nArray, COS.OBJECT_NULL);
                ++n8;
                ++nArray;
            }
            n2 = nArray2;
            if (!$assertionsDisabled && n2 != nArray) {
                throw new AssertionError((Object)new StringBuffer().append(n2).append(" + ").append(n).append(" != ").append(nArray).toString());
            }
            pDFReader.close();
        }
        object = new StringBuffer().append(n5).append(".").append(n6).toString();
        if (!((String)object).equals(string)) {
            dict3.put("Version", object);
        }
        lArray[iRef.id] = pDFWriter.writeObject((Object)dict3, iRef.id, 0);
        lArray[iRef2.id] = pDFWriter.writeObject((Object)dict5, iRef2.id, 0);
        dict7.put("Kids", arrayList.toArray(new Object[arrayList.size()]));
        dict7.put("Count", Integers.getInteger(n4));
        lArray[iRef3.id] = pDFWriter.writeObject((Object)dict7, iRef3.id, 0);
        if (iRef4 != null) {
            int[] nArray = new int[]{iRef4.id, n3};
            int[] nArray2 = new int[]{1, n2 - n3};
            pDFWriter.writeXref(dict, n2, l, lArray, nArray, nArray2);
        } else {
            pDFWriter.writeXref(dict, n2, l, lArray, n3, n2 - n3);
        }
        pDFWriter.close();
        if (!this.fquiet_) {
            this.out_.println();
        }
        if (this.fmonitor_) {
            this.out_.println(new StringBuffer().append(file).append(": ").append(n4).append(" pages, ").append(n2).append(" objects").toString());
        }
    }

    private void renumber(Object object, int n) {
        Class<?> clazz = object.getClass();
        if (COS.CLASS_DICTIONARY == clazz) {
            Iterator iterator = ((Dict)object).values().iterator();
            while (iterator.hasNext()) {
                this.renumber(iterator.next(), n);
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            for (Object object2 : (Object[])object) {
                this.renumber(object2, n);
            }
        } else if (COS.CLASS_IREF == clazz) {
            ((IRef)object).id += n;
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-append")) {
                this.fappend_ = true;
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(new StringBuffer().append("Unknown option: ").append(string).toString());
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Merge merge = new Merge();
        int n = merge.commandLine(stringArray);
        try {
            if (merge.fappend_) {
                File file = Files.getFile(stringArray[n++]);
                merge.merge(file, new FileList(stringArray, n, COS.FILTER));
            } else {
                merge.merge(new FileList(stringArray, n, COS.FILTER), null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$tool$pdf$Merge == null ? (class$tool$pdf$Merge = Merge.class$("tool.pdf.Merge")) : class$tool$pdf$Merge).desiredAssertionStatus();
    }
}

