/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encrypt;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.io.FileList;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.text.Formats;

public class Info {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.1 of $Date: 2003/08/29 04:40:27 $";
    public static final String USAGE = "java tool.pdf.Info [information] [options] <PDF-file-or-directory...>\n\tinformation is one or more: [-general] [-image] [-anno] [-objects] [-content]\n\toptions: [-label] [-password <password>]";
    private static final String[] KEYS_TXT;
    private static final String[] CLASS_NAMES;
    private static final List<Class> DATA_TYPES;
    private String password_;
    private boolean fgeneral_;
    private boolean fimage_;
    private boolean fanno_;
    private boolean fobjects_;
    private boolean fcontent_;
    private boolean fjava_;
    private boolean fhist_;
    private boolean flabel_;
    private File dirbase = new File(".").getAbsoluteFile();
    private boolean fverbose_;
    private boolean fquiet_;
    private PrintStream out_;
    private String label_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Info() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.fhist_ = false;
        this.fjava_ = false;
        this.fcontent_ = false;
        this.fobjects_ = false;
        this.fanno_ = false;
        this.fimage_ = false;
        this.fgeneral_ = false;
        this.flabel_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    private void out(String string) {
        if (this.flabel_) {
            this.out_.print(this.label_);
        }
        if (string != null) {
            this.out_.print(string);
        }
    }

    private void outln(String string) {
        this.out(string);
        this.out_.println();
    }

    public void info(File file) throws IOException, ParseException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (this.flabel_) {
            this.label_ = Files.relative(this.dirbase, file) + ": ";
        }
        if (!(this.fgeneral_ || this.fimage_ || this.fanno_)) {
            this.fgeneral_ = true;
        }
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        if (this.fgeneral_) {
            this.general(pDFReader);
        }
        pDFReader.fault();
        if (this.fimage_) {
            this.image(pDFReader);
        }
        if (this.fanno_) {
            this.anno(pDFReader);
        }
        if (this.fobjects_) {
            this.objects(pDFReader);
        }
        if (this.fcontent_) {
            this.content(pDFReader);
        }
        if (this.fjava_) {
            this.profileJava(pDFReader);
        }
        pDFReader.close();
    }

    void general(PDFReader pDFReader) throws IOException {
        String string;
        Dict dict;
        Object object;
        Dict dict2 = pDFReader.getTrailer();
        Dict dict3 = pDFReader.getCatalog();
        Dict dict4 = pDFReader.getInfo();
        if (dict4 != null) {
            int n = KEYS_TXT.length;
            for (int i = 0; i < n; ++i) {
                String string2 = KEYS_TXT[i];
                object = pDFReader.getObject(dict4.get(string2));
                if (object == null) continue;
                this.outln(string2 + ": " + object);
            }
            long l = -1L;
            object = pDFReader.getObject(dict4.get("CreationDate"));
            if (object != null) {
                try {
                    l = COS.parseDate((StringBuffer)object, false);
                    this.outln("Created: " + new Date(l));
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            if ((object = pDFReader.getObject(dict4.get("ModDate"))) != null) {
                try {
                    long l2 = COS.parseDate((StringBuffer)object, false);
                    if (l2 != l) {
                        this.outln("Modified: " + new Date(l2));
                    }
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        this.outln("Page count: " + pDFReader.getPageCnt());
        this.outln("PDF version: " + pDFReader.getMajorVersion() + "." + pDFReader.getMinorVersion());
        if (dict3.get("Outlines") != null) {
            this.outln("outline");
        }
        if (dict3.get("Metadata") != null) {
            this.outln("metadata");
        }
        if (dict3.get("StructTreeRoot") != null) {
            this.outln("structured");
        }
        if (dict3.get("SpiderInfo") != null) {
            this.outln("converted from HTML");
        }
        if (dict3.get("AcroForm") != null) {
            this.outln("forms");
        }
        if (pDFReader.getLinearized() > 0) {
            object = (Dict)pDFReader.getObject(pDFReader.getLinearized());
            this.outln("Linearized: version " + ((Dict)object).get("Linearized"));
        }
        object = pDFReader.getEncrypt();
        Dict dict5 = (Dict)pDFReader.getObject(dict2.get("Encrypt"));
        SecurityHandler securityHandler = ((Encrypt)object).getSecurityHandler();
        if (securityHandler != SecurityHandler.IDENTITY) {
            this.out("Encrypted: filter ");
            if (securityHandler instanceof SecurityHandlerStandard) {
                SecurityHandlerStandard securityHandlerStandard = (SecurityHandlerStandard)securityHandler;
                int n = securityHandlerStandard.getR();
                int n2 = securityHandlerStandard.getP();
                this.outln("Standard (revision " + n + "), " + securityHandlerStandard.getLength() + "-bit key" + (securityHandler.isAuthorized() ? ", null password" : ""));
                if ((0xFFFFFFFC & n2) != -4) {
                    this.out("    restrictions:");
                    if ((4 & n2) == 0) {
                        this.out_.print("  print");
                    }
                    if ((8 & n2) == 0) {
                        this.out_.print("  modify");
                    }
                    if ((0x10 & n2) == 0) {
                        this.out_.print("  copy/extract");
                    }
                    if ((0x20 & n2) == 0) {
                        this.out_.print("  annotate");
                    }
                    if (n < 3 || (0x100 & n2) == 0) {
                        this.out_.print("  fill forms");
                    }
                    if (n < 3 || (0x200 & n2) == 0) {
                        this.out_.print("  accessibility");
                    }
                    if (n < 3 || (0x400 & n2) == 0) {
                        this.out_.print("  assemble");
                    }
                    if (n >= 3 && (0x800 & n2) == 0) {
                        this.out_.print("  high-quality print");
                    }
                    this.out_.println();
                }
            } else {
                this.outln(dict5.get("Filter") + ", " + (securityHandler.isAuthorized() ? ", null password" : ""));
            }
        }
        if ((dict = (Dict)dict2.get("Compress")) != null) {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("Compressed:");
            Number number = (Number)dict.get("LengthO");
            if (number != null) {
                int n = (int)pDFReader.getFile().length();
                stringBuffer.append(" ").append((number.intValue() - n) * 100 / number.intValue()).append("%");
            }
            if ((object2 = dict.get("Filter")) != null) {
                stringBuffer.append(", ").append(object2).append(" format");
            }
            if ((object2 = dict.get("V")) != null) {
                stringBuffer.append(" v").append(object2);
            }
            if ((object2 = dict.get("Producer")) != null) {
                stringBuffer.append(", by ").append(object2);
            }
            this.outln(stringBuffer.toString());
        }
        if ((string = pDFReader.getMetadata(dict3)).length() > 0) {
            this.outln(string);
        }
    }

    void image(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        for (int i = 0; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (COS.CLASS_DICTIONARY != object.getClass()) continue;
            Dict dict = (Dict)object;
            Object object2 = pDFReader.getObject(dict.get("Type"));
            Object object3 = pDFReader.getObject(dict.get("Subtype"));
            if (!"XObject".equals(object2) && object2 != null || !"Image".equals(object3)) continue;
            this.out("image: object " + i + ", " + pDFReader.getObject(dict.get("Width")) + "x" + pDFReader.getObject(dict.get("Height")));
            String string = Images.getFilter(dict, pDFReader);
            this.out_.print(", " + (string != null ? string : "raw samples"));
            this.out_.println(", length = " + pDFReader.getObject(dict.get("Length")));
        }
    }

    void anno(PDFReader pDFReader) throws IOException, ParseException {
        int n = pDFReader.getPageCnt();
        for (int i = 0; i < n; ++i) {
            Dict dict = (Dict)pDFReader.getObject(pDFReader.getPageRef(i + 1));
            Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Annots"));
            if (objectArray == null) continue;
            int n2 = objectArray.length;
            for (int j = 0; j < n2; ++j) {
                this.out("anno: page " + (i + 1) + ", ");
                Object object = objectArray[j];
                if (COS.CLASS_IREF == object.getClass()) {
                    this.out_.print("object " + ((IRef)object).id + ", ");
                }
                Dict dict2 = (Dict)pDFReader.getObject(objectArray[j]);
                Object object2 = pDFReader.getObject(dict2.get("Subtype"));
                this.out_.print(object2);
                object = pDFReader.getObject(dict2.get("Rect"));
                if (object != null) {
                    this.out_.print(", bounds " + Formats.pretty(COS.array2Rectangle((Object[])object, null, false)));
                }
                this.out_.println();
            }
        }
    }

    void objects(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        for (int i = 1; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (object == null || object.getClass() != COS.CLASS_DICTIONARY) continue;
            Dict dict = (Dict)object;
            String string = (String)dict.get("Type");
            String string2 = (String)dict.get("Subtype");
            if ("Font".equals(string)) {
                ++n2;
                arrayList.add(dict.get("BaseFont"));
                if ("Type1".equals(string2)) {
                    ++n3;
                } else if ("TrueType".equals(string2)) {
                    ++n4;
                } else if ("Type3".equals(string2)) {
                    ++n5;
                } else {
                    ++n6;
                }
            }
            if ("FontDescriptor".equals(string)) {
                if (dict.get("FontFile") == null && dict.get("FontFile2") == null && dict.get("FontFile3") == null) continue;
                ++n7;
                continue;
            }
            if ("XObject".equals(string)) {
                if ("Image".equals(string2)) {
                    ++n8;
                    continue;
                }
                if (!"Form".equals(string2)) continue;
                ++n9;
                continue;
            }
            if ("Page".equals(string)) {
                if (dict.get("Thumb") == null) continue;
                ++n10;
                continue;
            }
            if (!"Annot".equals(string)) continue;
            ++n11;
            if (!"Link".equals(string2)) continue;
            ++n12;
        }
        System.out.println(n + " objects");
        if (n2 > 0) {
            System.out.print("\t" + n2 + " fonts:  ");
            if (n3 > 0) {
                System.out.print(n3 + " Type 1   ");
            }
            if (n4 > 0) {
                System.out.print(n4 + " TrueType   ");
            }
            if (n5 > 0) {
                System.out.print(n5 + " Type 3   ");
            }
            if (n7 > 0) {
                System.out.print(n7 + " embedded   ");
            }
            System.out.print(arrayList);
            System.out.println();
        }
        if (n8 > 0) {
            System.out.println(n8 + " images");
        }
        if (n9 > 0) {
            System.out.println(n9 + " forms");
        }
        if (n10 > 0) {
            System.out.println(n10 + " thumbnails");
        }
        if (n11 > 0) {
            System.out.print("\t" + n11 + " annotations:   ");
            if (n12 > 0) {
                System.out.print(n12 + " hyperlinks   ");
            }
            System.out.println();
        }
    }

    void content(PDFReader pDFReader) throws IOException {
        Object object;
        Object[] objectArray = new Object[1];
        HashMap<String, Stat> hashMap = new HashMap<String, Stat>(150);
        int n = pDFReader.getPageCnt();
        for (int i = 0; i < n; ++i) {
            int n2;
            object = (Dict)pDFReader.getObject(pDFReader.getPageRef(i + 1));
            InputStreamComposite inputStreamComposite = pDFReader.getInputStream(((Dict)object).get("Contents"), true);
            StringBuffer stringBuffer = new StringBuffer(4096);
            while ((n2 = inputStreamComposite.peek()) != -1) {
                if (!Character.isLetter((char)n2) && n2 != 39 && n2 != 34) {
                    pDFReader.readObject(inputStreamComposite);
                    continue;
                }
                String string = (String)pDFReader.readObject(inputStreamComposite);
                Stat stat = (Stat)hashMap.get(string);
                if (stat == null) {
                    hashMap.put(string, new Stat());
                    continue;
                }
                ++stat.cnt;
            }
            inputStreamComposite.close();
        }
        System.out.println("Content streams command usage:");
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            object = (String)entry.getKey();
            int n3 = ((Stat)entry.getValue()).cnt;
            System.out.print((String)object + " " + n3 + "   ");
        }
        System.out.println();
    }

    void profileJava(PDFReader pDFReader) throws IOException {
        int n;
        Stat[] statArray = new Stat[DATA_TYPES.size()];
        int n2 = DATA_TYPES.size();
        for (n = 0; n < n2; ++n) {
            statArray[n] = new Stat();
        }
        n = pDFReader.getObjCnt();
        this.profileJava(pDFReader.getTrailer(), statArray, new boolean[n]);
        int n3 = DATA_TYPES.size();
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.println(CLASS_NAMES[n2] + " " + statArray[n2]);
        }
    }

    protected void profileJava(Object object, Stat[] statArray, boolean[] blArray) throws IOException {
        Class<?> clazz = object != null ? object.getClass() : null;
        int n = DATA_TYPES.indexOf(clazz);
        Stat stat = statArray[n];
        ++stat.cnt;
        stat.space += 4;
        if (COS.CLASS_IREF == clazz) {
            stat.space += 8;
            stat.wasted += 4;
            int n2 = ((IRef)object).id;
            if (!blArray[n2]) {
                blArray[n2] = true;
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            stat.space += n3 * 4 + 4;
            stat.size += n3;
            stat.min = Math.min(stat.min, n3);
            stat.max = Math.max(stat.max, n3);
            int n4 = objectArray.length;
            for (int i = 0; i < n4; ++i) {
                this.profileJava(objectArray[i], statArray, blArray);
            }
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            int n5 = 16;
            int n6 = dict.size();
            while ((double)n5 * 0.75 < (double)n6) {
                n5 <<= 1;
            }
            stat.space += 20 + dict.size() * (20 + 4 * n5);
            stat.wasted += (n5 - n6) * 3;
            stat.size += n6;
            stat.min = Math.min(stat.min, n6);
            stat.max = Math.max(stat.max, n6);
            Iterator iterator = dict.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.profileJava(entry.getValue(), statArray, blArray);
            }
        } else if (COS.CLASS_NAME == clazz) {
            String string = (String)object;
            int n7 = string.length();
            stat.space += n7 * 2 + 16;
            stat.size += n7;
            stat.min = Math.min(stat.min, n7);
            stat.max = Math.max(stat.max, n7);
        } else if (COS.CLASS_STRING == clazz) {
            StringBuffer stringBuffer = (StringBuffer)object;
            int n8 = stringBuffer.capacity();
            int n9 = stringBuffer.length();
            stat.space += n8 * 2 + 12;
            stat.wasted += (n8 - n9) * 2;
            stat.size += n9;
            stat.min = Math.min(stat.min, n9);
            stat.max = Math.max(stat.max, n9);
        } else if (COS.CLASS_REAL == clazz) {
            stat.space += 8;
        } else if (COS.CLASS_INTEGER == clazz) {
            stat.space += 4;
        } else if (COS.CLASS_BOOLEAN == clazz) {
            stat.space += 4;
        }
    }

    void hist(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        for (int i = 1; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (object.getClass() != COS.CLASS_DICTIONARY || !"Image".equals(pDFReader.getObject(((Dict)object).get("Subtype")))) continue;
            Dict dict = (Dict)object;
            System.out.print(i + "  " + dict.get("Width") + "x" + dict.get("Height") + ", " + dict.get("ColorSpace") + ":  ");
            int n2 = ((Number)dict.get("BitsPerComponent")).intValue();
            if (n2 == 8) {
                int n3;
                int n4;
                int[] nArray = new int[256];
                InputStreamComposite inputStreamComposite = pDFReader.getInputStream(dict);
                while ((n4 = ((InputStream)inputStreamComposite).read()) != -1) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                }
                ((InputStream)inputStreamComposite).close();
                n4 = 0;
                int n6 = nArray.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    if (nArray[n3] <= 0) continue;
                    ++n4;
                }
                Arrays.sort(nArray);
                System.out.print("(" + n4 + ")  ");
                n6 = 240;
                for (n3 = 255; n3 >= n6; --n3) {
                    System.out.print(" " + nArray[n3]);
                }
                System.out.println();
                continue;
            }
            System.out.println("bpc = " + n2);
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-gen")) {
                this.fgeneral_ = true;
                continue;
            }
            if (string.startsWith("-im")) {
                this.fimage_ = true;
                continue;
            }
            if (string.startsWith("-anno")) {
                this.fanno_ = true;
                continue;
            }
            if (string.startsWith("-obj")) {
                this.fobjects_ = true;
                continue;
            }
            if (string.startsWith("-con")) {
                this.fcontent_ = true;
                continue;
            }
            if (string.startsWith("-prof") || string.startsWith("-java")) {
                this.fjava_ = true;
                continue;
            }
            if (string.startsWith("-l")) {
                this.flabel_ = true;
                continue;
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Info info = new Info();
        int n = info.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!info.flabel_) {
                info.outln("Filename: " + file);
            }
            try {
                info.info(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !Info.class.desiredAssertionStatus();
        KEYS_TXT = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer"};
        CLASS_NAMES = new String[]{"null", "iref 0 R", "<<dict>>", "[array]", "/name", "(string)", "double", "long", "boolean", "data"};
        DATA_TYPES = Collections.unmodifiableList(Arrays.asList(null, COS.CLASS_IREF, COS.CLASS_DICTIONARY, COS.CLASS_ARRAY, COS.CLASS_NAME, COS.CLASS_STRING, COS.CLASS_REAL, COS.CLASS_INTEGER, COS.CLASS_BOOLEAN, COS.CLASS_DATA));
    }

    private static class Stat {
        int cnt = 0;
        int space = 0;
        int wasted = 0;
        int size = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        private Stat() {
        }

        public String toString() {
            String string = "#" + this.cnt + ", use=" + this.space;
            if (this.wasted > 0) {
                string = string + ", of which waste=" + this.wasted;
            }
            if (this.size > 0) {
                string = string + ", min/avg/max=" + this.min + ".." + this.size / this.cnt + ".." + this.max;
            }
            return string;
        }
    }
}

