/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.SecurityHandler;
import phelps.io.FileList;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

public class ExtractImages {
    static final boolean DEBUG = true;
    public static final String USAGE = "java tool.pdf.ExtractImages [options] <PDF-file...>\n\t[-page <page-range>] [-objnum <range>] [-password <owner-password]";
    public static final String VERSION = "0.1 of $Date: 2003/08/15 19:10:22 $";
    private String range_;
    private String objrange_;
    private String format_;
    private String password_;
    private boolean fverbose_;
    private boolean fquiet_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtractImages() {
        this.defaults();
    }

    public void defaults() {
        this.range_ = null;
        this.objrange_ = null;
        this.password_ = null;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void extract(File file) throws IOException, ParseException {
        if (this.fverbose_) {
            System.out.println(file);
        }
        if (!($assertionsDisabled || file != null && file.exists())) {
            throw new AssertionError();
        }
        PDFReader pDFReader = new PDFReader(file);
        SecurityHandler securityHandler = pDFReader.getEncrypt().getSecurityHandler();
        int n = pDFReader.getObjCnt();
        int n2 = pDFReader.getPageCnt();
        boolean[] blArray = new boolean[n];
        if (this.objrange_ != null) {
            int[] nArray = Integers.parseRange(this.objrange_, n);
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = nArray[i];
                if (blArray[n4]) continue;
                this.extract1(pDFReader, n4, "im" + n4);
                blArray[n4] = true;
            }
        } else {
            int[] nArray = Integers.parseRange(this.range_, n2);
            int n5 = nArray.length;
            for (int i = 0; i < n5; ++i) {
                Dict dict;
                int n6 = nArray[i];
                Dict dict2 = pDFReader.getPage(n6);
                Dict dict3 = (Dict)pDFReader.getObject(dict2.get("Resources"));
                if (dict3 == null || (dict = (Dict)pDFReader.getObject(dict3.get("XObject"))) == null) continue;
                int n7 = 1;
                Iterator iterator = dict.values().iterator();
                while (iterator.hasNext()) {
                    int n8;
                    Dict dict4;
                    IRef iRef = (IRef)iterator.next();
                    Object object = pDFReader.getObject(iRef);
                    if (COS.CLASS_DICTIONARY != object.getClass() || !"Image".equals(pDFReader.getObject((dict4 = (Dict)object).get("Subtype"))) || blArray[n8 = iRef.id]) continue;
                    this.extract1(pDFReader, n8, "im" + n6 + (n7 == 1 ? "" : "-" + n7));
                    ++n7;
                    blArray[n8] = true;
                }
            }
        }
        pDFReader.close();
    }

    public void extract1(PDFReader pDFReader, int n, String string) throws IOException {
        Dict dict = (Dict)pDFReader.getObject(n);
        String string2 = Images.getFilter(dict, pDFReader);
        String string3 = "DCTDecode".equals(string2) ? "jpg" : ("CCITTFaxDecode".equals(string2) ? "fax" : ("JPXDecode".equals(string2) ? "jp2" : ("JBIG2Decode".equals(string2) ? "jbig2" : "raw")));
        this.extract1(pDFReader, n, new File(string + "." + string3));
    }

    public void extract1(PDFReader pDFReader, int n, File file) throws IOException {
        Object object = pDFReader.getObject(n);
        if (object == null || COS.CLASS_DICTIONARY != object.getClass() || !"Image".equals(((Dict)object).get("Subtype"))) {
            this.out_.println("object #" + n + " not an image dictionary");
            return;
        }
        Dict dict = (Dict)object;
        if ("JBIG2Decode".equals(Images.getFilter(dict, pDFReader))) {
            this.out_.println("JBIG2 extraction not supported");
            return;
        }
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(new IRef(n, pDFReader.getObjGen(n)));
        if (this.format_ == null) {
            int n2;
            System.out.println("image " + n + " -> " + file);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            byte[] byArray = new byte[8192];
            while ((n2 = inputStreamComposite.read(byArray)) >= 0) {
                randomAccessFile.write(byArray, 0, n2);
            }
            randomAccessFile.close();
        }
        ((InputStream)inputStreamComposite).close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-page") || string.equals("-range")) {
                this.range_ = stringArray[++n];
                continue;
            }
            if (string.equals("-objnum")) {
                this.objrange_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-format")) {
                this.format_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        ExtractImages extractImages = new ExtractImages();
        int n = extractImages.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                extractImages.extract(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    static {
        $assertionsDisabled = !ExtractImages.class.desiredAssertionStatus();
    }
}

