/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.Utility;
import phelps.io.FileList;
import phelps.lang.Integers;

public class Encrypt {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/29 04:39:13 $";
    public static final String USAGE = "java tool.pdf.Encrypt [options] <PDF-file...>\n\t[-user <password>] [-owner <password>] [-password <existing-owner>]\n\t[-rest[rictions] [pPcCmtfa]]   [-perm[issions] [pPcCmtfa]]\n\t[-inplace]";
    static final String PERMS = "  Pmct  fCap";
    private String ownerpassword_;
    private String userpassword_;
    private String password_;
    private int permissions_;
    private int keylen_;
    private boolean finplace_;
    private boolean fverbose_;
    private boolean fquiet_;

    public Encrypt() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.userpassword_ = null;
        this.ownerpassword_ = null;
        this.permissions_ = -4;
        this.keylen_ = 128;
        this.finplace_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setOwnerPassword(String string) {
        this.ownerpassword_ = string;
    }

    public void setUserPassword(String string) {
        this.userpassword_ = string;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void setPermissions(int n) {
        this.permissions_ = n;
    }

    public void setPermissions(String string) {
        if (string.startsWith("all")) {
            this.permissions_ = -4;
        } else {
            this.permissions_ = 192;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                int n2 = PERMS.indexOf(c);
                if (n2 != -1) {
                    this.permissions_ |= 1 << n2;
                    continue;
                }
                Utility.error("invalid permission letter: " + c + ".  Valid: pPcCmtfa.");
            }
        }
    }

    public void setRestrictions(String string) {
        if (string.startsWith("all")) {
            this.permissions_ = 192;
        } else {
            this.permissions_ = -4;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                int n2 = PERMS.indexOf(c);
                if (n2 != -1) {
                    this.permissions_ &= ~(1 << n2);
                    continue;
                }
                Utility.error("invalid permission letter: " + c + ".  Valid: pPcCmtfa.");
            }
        }
    }

    public void setKeyLength(int n) {
        if (n >= 40 && n % 8 == 0) {
            this.keylen_ = n;
        }
    }

    public void encrypt(File file) throws IOException, IllegalStateException, ParseException {
        String string = file.getPath();
        String string2 = this.finplace_ ? string : (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string) + "-y.pdf";
        this.encrypt(file, new File(string2));
    }

    public void encrypt(File file, File file2) throws IOException, ParseException {
        StringBuffer stringBuffer;
        Dict dict;
        Object[] objectArray;
        Object object;
        PDFReader pDFReader = new PDFReader(file);
        if (pDFReader.getTrailer().get("Encrypt") != null) {
            object = pDFReader.getEncrypt().getSecurityHandler();
            ((SecurityHandler)object).authOwner(this.password_);
            if (!((SecurityHandler)object).isAuthorized()) {
                ((SecurityHandler)object).authOwner(this.ownerpassword_);
            }
            if (!((SecurityHandler)object).isAuthorized()) {
                throw new ParseException("existing owner password required");
            }
        }
        pDFReader.fault();
        object = new PDFWriter(file2, pDFReader);
        if (this.fverbose_) {
            ((PDFWriter)object).setMonitor(true);
        }
        if ((objectArray = (Object[])(dict = ((PDFWriter)object).getTrailer()).get("ID")) == null) {
            stringBuffer = (StringBuffer)objectArray[0];
        } else {
            stringBuffer = COS.createID(file, pDFReader.getInfo());
            objectArray = new Object[]{stringBuffer, stringBuffer};
            dict.put("ID", objectArray);
        }
        if (this.ownerpassword_ == null) {
            this.ownerpassword_ = this.userpassword_;
        }
        int n = this.permissions_;
        int n2 = this.keylen_;
        int n3 = n2 == 40 ? 1 : 2;
        int n4 = n3 == 1 ? 2 : 3;
        Dict dict2 = new Dict(13);
        dict2.put("Filter", "Standard");
        dict2.put("V", Integers.getInteger(n3));
        if (n2 != 40) {
            dict2.put("Length", Integers.getInteger(n2));
        }
        dict2.put("R", Integers.getInteger(n4));
        dict2.put("P", Integers.getInteger(n));
        SecurityHandlerStandard securityHandlerStandard = new SecurityHandlerStandard(stringBuffer, n4, n, n2, this.userpassword_, this.ownerpassword_);
        dict2.put("U", securityHandlerStandard.computeU(this.userpassword_));
        dict2.put("O", securityHandlerStandard.computeO(this.ownerpassword_, this.userpassword_));
        int n5 = ((PDFWriter)object).addObject(dict2);
        dict.put("Encrypt", new IRef(n5, 0));
        ((PDFWriter)object).setPassword(this.userpassword_);
        ((PDFWriter)object).writePDF();
        ((PDFWriter)object).close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-own")) {
                this.setOwnerPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-user")) {
                this.setUserPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-pass")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-rest")) {
                this.setRestrictions(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-perm")) {
                this.setPermissions(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-keylen")) {
                String string2 = stringArray[++n];
                try {
                    int n3 = Integer.parseInt(string2);
                    if (n3 < 40 || n3 % 8 != 0) {
                        Utility.error(n3 + " must be >=40 and a multiple of 8");
                    }
                    this.setKeyLength(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    Utility.error("Couldn't parse '" + string2 + "' as a number");
                }
                continue;
            }
            if (string.equals("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Encrypt encrypt = new Encrypt();
        int n = encrypt.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                encrypt.encrypt(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }
}

