/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.lang.Integers;

public class Dump {
    static final boolean DEBUG = true;
    public static final String USAGE = "java tool.pdf.Dump [-password] <PDF-file>\n [-objnum <objnum>] [-pagenum <pagenum>] [-range <range>]";
    public static final String VERSION = "1.0";
    String password_;
    String range_;
    String pages_;

    public Dump() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.range_ = "1-";
        this.pages_ = null;
    }

    public void dump(File file) throws IOException, ParseException {
        Object object;
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        PDFReader pDFReader = new PDFReader(file);
        pDFReader.setExact(true);
        pDFReader.setPassword(this.password_);
        if (this.pages_ != null) {
            nArray2 = Integers.parseRange(this.pages_, pDFReader.getPageCnt());
            nArray = new int[nArray2.length];
            n2 = nArray2.length;
            for (n = 0; n < n2; ++n) {
                IRef iRef = pDFReader.getPageRef(nArray2[n]);
                nArray[n] = iRef.id;
                object = pDFReader.getPage(nArray2[n]);
                Dump.oa2Rect((Dict)object, "MediaBox", pDFReader);
                Dump.oa2Rect((Dict)object, "CropBox", pDFReader);
            }
        } else {
            nArray = Integers.parseRange(this.range_, pDFReader.getObjCnt());
        }
        nArray2 = nArray;
        n = nArray2.length;
        for (n2 = 0; n2 < n; ++n2) {
            int n3;
            int n4 = nArray2[n2];
            object = pDFReader.getObject(n4);
            System.out.println(object);
            if (COS.CLASS_DICTIONARY != object.getClass() || ((Dict)object).get("DATA") == null) continue;
            InputStreamComposite inputStreamComposite = pDFReader.getInputStream(new IRef(n4, 0), false);
            while ((n3 = ((InputStream)inputStreamComposite).read()) != -1) {
                System.out.print((char)n3);
            }
            ((InputStream)inputStreamComposite).close();
            System.out.println();
        }
        pDFReader.close();
    }

    private static void oa2Rect(Dict dict, String string, PDFReader pDFReader) throws IOException {
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get(string));
        if (objectArray == null || objectArray.length != 4) {
            return;
        }
        int[] nArray = new int[4];
        double[] dArray = new double[4];
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            Object object = objectArray[i];
            if (COS.CLASS_REAL == object.getClass()) {
                bl = true;
            }
            nArray[i] = ((Number)object).intValue();
            dArray[i] = ((Number)object).doubleValue();
        }
        Rectangle2D rectangle2D = bl ? new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]) : new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
        dict.put(string, rectangle2D);
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-range") || string.startsWith("-objnum") || string.equals("-num")) {
                this.range_ = stringArray[++n];
                this.pages_ = null;
                continue;
            }
            if (string.startsWith("-page")) {
                this.pages_ = stringArray[++n];
                this.range_ = null;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n + 1 != n2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException, ParseException {
        Dump dump = new Dump();
        int n = dump.commandLine(stringArray);
        dump.dump(new File(stringArray[n]));
    }
}

