/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.awt.font.Type1;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

public class Diff {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/27 01:52:29 $";
    public static final String USAGE = "java [-Xmx128m] tool.pdf.Diff [options] <PDF-file1> <PDF-file2>\n\t[-page1 <range>] [-page2 <range>]\n\t[-password1 <password>] [-password2 <password>]";
    private static final Object OBJECT_INVALID;
    private boolean fignoredates_;
    private String password1_;
    private String password2_;
    private String range1_;
    private String range2_;
    private boolean fverbose_;
    private boolean fmonitor_;
    private PrintStream out_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Diff() {
        this.defaults();
    }

    public void defaults() {
        this.password2_ = null;
        this.password1_ = null;
        this.range2_ = null;
        this.range1_ = null;
        this.fignoredates_ = true;
        this.fverbose_ = false;
        this.out_ = PrintStreams.DEVNULL;
    }

    public void setIgnoreDates(boolean bl) {
        this.fignoredates_ = bl;
    }

    public void setPassword1(String string) {
        this.password1_ = string;
    }

    public void setPassword2(String string) {
        this.password2_ = string;
    }

    public void setRanges(String string, String string2) {
        this.range1_ = string;
        this.range2_ = string2;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    Object[] readAll(boolean[] blArray, PDFReader pDFReader) throws IOException {
        int n;
        Object object;
        pDFReader.fault();
        PDFWriter pDFWriter = new PDFWriter(null, pDFReader);
        int n2 = pDFWriter.getObjCnt();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray;
            byte[] byArray2;
            if (n3 == 1000 && this.fmonitor_) {
                this.out_.print(" " + (n2 - i) / 1000);
                n3 = 0;
            } else {
                ++n3;
            }
            Object object2 = pDFWriter.getObject(i, true);
            if (COS.CLASS_DICTIONARY != object2.getClass() || !"XObject".equals(((Dict)(object = (Dict)object2)).get("Type")) && ((Dict)object).get("Type") != null || !"Image".equals(((Dict)object).get("Subtype")) || ((Dict)object).get("Filter") != null || (byArray2 = PDFWriter.maybeDeflateData(byArray = (byte[])((Dict)object).get("DATA"))) == byArray) continue;
            ((Dict)object).put("DATA", byArray2);
            ((Dict)object).put("Filter", "FlateDecode");
        }
        Object[] objectArray = pDFWriter.getObjects();
        if (this.fmonitor_) {
            this.out_.print(" inherit");
        }
        int n4 = pDFReader.getPageCnt();
        for (n3 = 0; n3 < n4; ++n3) {
            object = pDFReader.getPage(n3 + 1);
            if (((Dict)object).get("CropBox") == null) {
                ((Dict)object).put("CropBox", ((Dict)object).get("MediaBox"));
            }
            ((Dict)object).put("CropBox", Arrays.asList((Object[])pDFWriter.getObject(((Dict)object).get("CropBox"))));
            ((Dict)object).put("MediaBox", Arrays.asList((Object[])pDFWriter.getObject(((Dict)object).get("MediaBox"))));
        }
        if (this.fmonitor_) {
            this.out_.print(" normalize");
        }
        Dict dict = pDFWriter.getCatalog();
        if (!$assertionsDisabled && dict == null) {
            throw new AssertionError();
        }
        dict.remove("Threads");
        if (this.range1_ != null) {
            dict.remove("Outlines");
            dict.remove("StructTreeRoot");
        }
        for (n4 = 1; n4 < n2; ++n4) {
            this.normalize(objectArray[n4], n4, blArray, pDFReader);
        }
        Dict dict2 = pDFReader.getTrailer();
        dict2.remove("ID");
        if (this.fmonitor_) {
            this.out_.print(" refcnt");
        }
        object = pDFWriter.refcnt();
        for (int i = 1; i < n2; ++i) {
            if (object[i] != false) continue;
            objectArray[i] = OBJECT_INVALID;
            blArray[i] = true;
        }
        if (this.fmonitor_) {
            this.out_.print(" hardcode");
        }
        Integer[] integerArray = new Integer[n2];
        int n5 = pDFReader.getPageCnt();
        for (n = 0; n < n5; ++n) {
            integerArray[pDFReader.getPageRef((int)(n + 1)).id] = Integers.getInteger(n + 1);
        }
        for (n = 1; n < n2; ++n) {
            this.hardcodePage(objectArray[n], integerArray);
        }
        dict.remove("Pages");
        pDFWriter.close();
        if (this.fmonitor_) {
            this.out_.println();
        }
        return objectArray;
    }

    private void hardcodePage(Object object, Integer[] integerArray) {
        block5: {
            Class<?> clazz;
            block4: {
                clazz = object.getClass();
                if (COS.CLASS_DICTIONARY != clazz) break block4;
                Dict dict = (Dict)object;
                Iterator iterator = dict.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object v = entry.getValue();
                    if (COS.CLASS_IREF == v.getClass()) {
                        Integer n = integerArray[((IRef)v).id];
                        if (n == null) continue;
                        entry.setValue(n);
                        continue;
                    }
                    this.hardcodePage(v, integerArray);
                }
                break block5;
            }
            if (COS.CLASS_ARRAY != clazz) break block5;
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray[i];
                if (COS.CLASS_IREF == object2.getClass()) {
                    Integer n2 = integerArray[((IRef)object2).id];
                    if (n2 == null) continue;
                    objectArray[i] = n2;
                    continue;
                }
                this.hardcodePage(object2, integerArray);
            }
        }
    }

    void normalize(Object object, int n, boolean[] blArray, PDFReader pDFReader) throws IOException {
        IRef iRef;
        Dict dict;
        Dict dict2;
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return;
        }
        Dict dict3 = (Dict)object;
        if (this.fignoredates_) {
            dict3.remove("ModDate");
            dict3.remove("LastModified");
        }
        dict3.remove("Parent");
        dict3.remove("Prev");
        dict3.remove("Next");
        dict3.remove("ProcSet");
        Object object2 = dict3.get("Type");
        Object object3 = dict3.get("Subtype");
        if ("Pages".equals(object2)) {
            dict3.remove("MediaBox");
            dict3.remove("CropBox");
            dict3.remove("TrimBox");
            dict3.remove("ArtBox");
            dict3.remove("BleedBox");
            dict3.remove("Rotate");
            dict3.remove("Resources");
        } else if ("Page".equals(object2)) {
            dict3.remove("B");
            dict3.remove("Thumb");
            object = dict3.get("Contents");
            if (object != null) {
                int n2;
                InputStreamComposite inputStreamComposite = pDFReader.getInputStream(object);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10240);
                while ((n2 = ((InputStream)inputStreamComposite).read()) != -1) {
                    if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) continue;
                    byteArrayOutputStream.write(n2);
                }
                byteArrayOutputStream.close();
                ((InputStream)inputStreamComposite).close();
                dict3.put("Contents", byteArrayOutputStream.toByteArray());
            }
        } else if ("Font".equals(object2) && "Type1".equals(object3) && (dict2 = (Dict)pDFReader.getObject(dict3.get("FontDescriptor"))) != null && dict2.get("FontFile") != null && !"Type1U".equals((dict = (Dict)pDFReader.getObject(iRef = (IRef)dict2.get("FontFile"))).get("Type"))) {
            int n3 = pDFReader.getObjInt(dict.get("Length1"));
            int n4 = pDFReader.getObjInt(dict.get("Length2"));
            byte[] byArray = (byte[])dict.get("DATA");
            if (!$assertionsDisabled && byArray == null) {
                throw new AssertionError(dict);
            }
            byArray = Type1.decrypt(byArray, n3, n4, 0);
            dict.put("DATA", byArray);
            dict.put("Length3", Integers.getInteger(0));
            dict.put("Type", "Type1U");
        }
    }

    boolean objEquals(Object object, Object object2, Object[] objectArray, Object[] objectArray2, boolean[] blArray, boolean[] blArray2, Object[] objectArray3, Object[] objectArray4, int n) {
        boolean bl;
        for (int i = 0; i < n; ++i) {
            if (objectArray3[i] != object || objectArray4[i] != object2) continue;
            return true;
        }
        if (n > objectArray3.length / 2) {
            System.out.println(n + ": " + object + " vs " + object2);
        }
        objectArray3[n] = object;
        objectArray4[n] = object2;
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (object == object2) {
            bl = true;
        } else if (COS.CLASS_IREF == clazz && COS.CLASS_IREF == clazz2) {
            int n2 = ((IRef)object).id;
            int n3 = ((IRef)object2).id;
            if (!($assertionsDisabled || 0 < n2 && n2 <= blArray.length && 0 < n3 && n3 <= blArray2.length)) {
                throw new AssertionError((Object)(object + " >= " + blArray.length + " or " + object2 + " >= " + blArray2.length));
            }
            bl = this.objEquals(objectArray[n2], objectArray2[n3], objectArray, objectArray2, blArray, blArray2, objectArray3, objectArray4, n + 1);
            if (!bl) {
                blArray2[n3] = false;
                blArray[n2] = false;
            }
        } else if (COS.CLASS_IREF == clazz) {
            int n4 = ((IRef)object).id;
            bl = this.objEquals(objectArray[n4], object2, objectArray, objectArray2, blArray, blArray2, objectArray3, objectArray4, n + 1);
            if (!bl) {
                blArray[n4] = false;
            }
        } else if (COS.CLASS_IREF == clazz2) {
            int n5 = ((IRef)object2).id;
            bl = this.objEquals(object, objectArray2[n5], objectArray, objectArray2, blArray, blArray2, objectArray3, objectArray4, n + 1);
            if (!bl) {
                blArray2[n5] = false;
            }
        } else if (COS.CLASS_INTEGER == clazz && COS.CLASS_REAL == clazz2 || COS.CLASS_REAL == clazz && COS.CLASS_INTEGER == clazz2) {
            bl = Math.abs(((Number)object).doubleValue() - ((Number)object2).doubleValue()) < 1.0E-4;
        } else if (clazz != clazz2) {
            bl = false;
        } else if (COS.CLASS_NAME == clazz || COS.CLASS_INTEGER == clazz || COS.CLASS_BOOLEAN == clazz) {
            bl = object.equals(object2);
        } else if (COS.CLASS_REAL == clazz) {
            bl = Math.abs(((Number)object).doubleValue() - ((Number)object2).doubleValue()) < 1.0E-4;
        } else if (COS.CLASS_STRING == clazz) {
            bl = object.toString().equals(object2.toString());
        } else if (COS.CLASS_DATA == clazz) {
            byte[] byArray = (byte[])object;
            byte[] byArray2 = (byte[])object2;
            bl = Arrays.equals(byArray, byArray2);
            if (!bl & this.fmonitor_) {
                int n6 = Math.min(byArray.length, byArray2.length);
                for (int i = 0; i < n6; ++i) {
                    if (byArray[i] == byArray2[i]) continue;
                    this.out_.println("@ [" + i + "] of " + byArray.length + "/" + byArray2.length + ":\n" + new String(byArray, Math.max(i - 10, 0), Math.min(30, n6 - i)) + " != " + new String(byArray2, Math.max(i - 10, 0), Math.min(30, n6 - i)));
                    break;
                }
            }
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            Dict dict2 = (Dict)object2;
            bl = dict.size() == dict2.size();
            Iterator iterator = dict.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object v = dict2.get(entry.getKey());
                bl = v != null && this.objEquals(entry.getValue(), v, objectArray, objectArray2, blArray, blArray2, objectArray3, objectArray4, n + 1) && bl;
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray5 = (Object[])object;
            Object[] objectArray6 = (Object[])object2;
            boolean bl2 = bl = objectArray5.length == objectArray6.length;
            if (bl) {
                int n7 = objectArray5.length;
                for (int i = 0; bl && i < n7; ++i) {
                    bl = this.objEquals(objectArray5[i], objectArray6[i], objectArray, objectArray2, blArray, blArray2, objectArray3, objectArray4, n + 1) && bl;
                }
            }
        } else if (object instanceof List) {
            bl = object.equals(object2);
        } else {
            if (!$assertionsDisabled && COS.OBJECT_DELETED != object && COS.OBJECT_NULL != object) {
                throw new AssertionError((Object)(object + " vs " + object2));
            }
            bl = false;
        }
        if (this.fmonitor_ && !bl) {
            this.out_.println(object + (bl ? " == " : " != ") + object2);
        }
        return bl;
    }

    void report(String string, Object[] objectArray, boolean[] blArray) {
        if (PrintStreams.DEVNULL == this.out_) {
            return;
        }
        int n = blArray.length;
        for (int i = 1; i < n; ++i) {
            Object object = objectArray[i];
            if (blArray[i]) continue;
            this.out_.println(string + " [" + i + "] " + object);
        }
    }

    public boolean diff(File file, File file2) throws IOException, ParseException {
        boolean bl;
        Object[] objectArray;
        String[] stringArray;
        PDFReader pDFReader = new PDFReader(file);
        PDFReader pDFReader2 = new PDFReader(file2);
        pDFReader.setPassword(this.password1_);
        pDFReader2.setPassword(this.password2_);
        if (!pDFReader.isAuthorized()) {
            throw new ParseException("need password for " + file);
        }
        if (!pDFReader2.isAuthorized()) {
            throw new ParseException("need password for " + file2);
        }
        int n = pDFReader.getObjCnt();
        int n2 = pDFReader2.getObjCnt();
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n2];
        Arrays.fill(blArray, true);
        Arrays.fill(blArray2, true);
        blArray2[0] = true;
        blArray[0] = true;
        if (this.fmonitor_) {
            this.out_.println("reading " + file + ", " + pDFReader.getObjCnt() + " objects");
        }
        Object[] objectArray2 = this.readAll(blArray, pDFReader);
        if (this.fmonitor_) {
            this.out_.println("reading " + file2 + ", " + pDFReader2.getObjCnt() + " objects");
        }
        Object[] objectArray3 = this.readAll(blArray2, pDFReader2);
        if (this.fmonitor_) {
            this.out_.println("free memory = " + Runtime.getRuntime().freeMemory());
        }
        if (this.fmonitor_) {
            this.out_.println("diff");
        }
        Dict dict = pDFReader.getTrailer();
        Dict dict2 = pDFReader2.getTrailer();
        String[] stringArray2 = stringArray = new String[]{"Size", "Prev", "Encrypt", "Compress"};
        int n3 = stringArray2.length;
        for (int i = 0; i < n3; ++i) {
            objectArray = stringArray2[i];
            dict.remove((String)objectArray);
            dict2.remove((String)objectArray);
        }
        int n4 = pDFReader.getPageCnt();
        n3 = pDFReader2.getPageCnt();
        Object[] objectArray4 = new Object[200];
        objectArray = new Object[200];
        if (this.range1_ == null && this.range2_ == null) {
            if (n4 != n3) {
                this.out_.println("different number of pages " + n4 + " vs " + n3);
            }
            bl = (bl = this.objEquals(dict, dict2, objectArray2, objectArray3, blArray, blArray2, objectArray4, objectArray, 0)) && n4 == n3;
            for (int i = 0; bl && i < n4; ++i) {
                int n5 = pDFReader.getPageRef((int)(i + 1)).id;
                int n6 = pDFReader2.getPageRef((int)(i + 1)).id;
                boolean bl2 = bl = this.objEquals(objectArray2[n5], objectArray3[n6], objectArray2, objectArray3, blArray, blArray2, objectArray4, objectArray, 0) && bl;
                if (bl) continue;
                blArray2[n6] = false;
                blArray[n5] = false;
                this.out_.println("different page #" + (i + 1) + ": " + n5 + " 0 R vs " + n6 + " 0 R");
            }
        } else {
            int[] nArray = Integers.parseRange(this.range1_ != null ? this.range1_ : this.range2_, n4);
            int[] nArray2 = Integers.parseRange(this.range2_ != null ? this.range2_ : this.range1_, n3);
            boolean bl3 = bl = nArray.length == nArray2.length;
            if (!bl) {
                this.out_.println("different number of pages in range " + nArray.length + " vs " + nArray2.length);
            }
            int n7 = nArray.length;
            for (int i = 0; bl && i < n7; ++i) {
                int n8 = pDFReader.getPageRef((int)nArray[i]).id;
                int n9 = pDFReader2.getPageRef((int)nArray2[i]).id;
                ((Dict)objectArray2[n8]).remove("Annots");
                ((Dict)objectArray3[n9]).remove("Annots");
                boolean bl4 = bl = this.objEquals(objectArray2[n8], objectArray3[n9], objectArray2, objectArray3, blArray, blArray2, objectArray4, objectArray, 0) && bl;
                if (bl) continue;
                blArray2[n9] = false;
                blArray[n8] = false;
                this.out_.println("different page #" + nArray[i] + "/" + n8 + " 0 R  vs  " + nArray2[i] + "/" + n9 + " 0 R");
            }
        }
        pDFReader.close();
        pDFReader2.close();
        if (!bl) {
            this.out_.println("< " + dict);
            this.report("<", objectArray2, blArray);
            this.out_.println("> " + dict2);
            this.report(">", objectArray3, blArray2);
        }
        return bl;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.setOut(System.out);
        this.setIgnoreDates(false);
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("-nodate") || string.startsWith("-ignoredate")) {
                this.fignoredates_ = true;
                continue;
            }
            if (string.startsWith("-password1")) {
                this.setPassword1(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-password2")) {
                this.setPassword2(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-page1") || string.startsWith("-range1")) {
                this.range1_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-page2") || string.startsWith("-range2")) {
                this.range2_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n + 2 != n2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException, ParseException {
        Diff diff = new Diff();
        int n = diff.commandLine(stringArray);
        try {
            diff.diff(new File(stringArray[n]), new File(stringArray[n + 1]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !Diff.class.desiredAssertionStatus();
        OBJECT_INVALID = new String("INVALID");
    }
}

