/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import phelps.io.FileList;

public class Decrypt
implements Observer {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.0 of $Date: 2003/08/29 04:37:32 $";
    public static final String USAGE = "java tool.pdf.Decrypt [-password <owner-password>] [-inplace] <PDF-file...>";
    private String password_;
    private boolean finplace_;
    private boolean fverbose_;
    private boolean fquiet_;
    private PDFReader pdfr_;
    private PDFWriter pdfw_;

    public Decrypt() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.finplace_ = false;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public void decrypt(File file) throws IOException, ParseException {
        String string = file.getPath();
        String string2 = this.finplace_ ? string : (string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - 4) : string) + "-d.pdf";
        this.decrypt(file, new File(string2));
    }

    public void decrypt(File file, File file2) throws IOException, ParseException {
        PDFReader pDFReader = new PDFReader(file);
        if (pDFReader.getTrailer().get("Encrypt") == null) {
            System.out.println("PDF not encrypted -- no action taken.");
            pDFReader.close();
            return;
        }
        SecurityHandler securityHandler = pDFReader.getEncrypt().getSecurityHandler();
        securityHandler.authOwner(this.password_);
        if (!securityHandler.isAuthorized()) {
            throw new ParseException("owner password required");
        }
        pDFReader.fault();
        PDFWriter pDFWriter = new PDFWriter(file2, pDFReader);
        pDFWriter.setExact(true);
        pDFWriter.getTrailer().remove("Encrypt");
        this.pdfr_ = pDFReader;
        this.pdfw_ = pDFWriter;
        pDFWriter.writePDF(this);
        this.pdfr_ = null;
        this.pdfw_ = null;
        pDFWriter.close();
    }

    public void update(Observable observable, Object object) {
        if (COS.CLASS_DICTIONARY == object.getClass() && ((Dict)object).get("DATA") != null) {
            try {
                Dict dict = (Dict)object;
                if (this.pdfr_.getEncrypt().getCryptFilter(dict) != CryptFilter.IDENTITY) {
                    this.pdfw_.removeFilter(dict, "Crypt");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.equals("-password")) {
                this.setPassword(stringArray[++n]);
                continue;
            }
            if (string.equals("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Decrypt decrypt = new Decrypt();
        int n = decrypt.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                decrypt.decrypt(file);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
    }
}

