/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.FileList;
import phelps.io.PrintStreams;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compress {
    static final boolean DEBUG = true;
    public static final String VERSION = "2.0 of $Date: 2003/08/29 04:35:53 $";
    public static final String USAGE = "java [-Xmx128m] tool.pdf.Compress [options] <PDF-file-or-directory...>\n\t[-compat(ible)] [-compact] [-force] [-inplace]\n\t[-nopagepiece] [-nostruct] [-nowebcap] [-jpeg] [-max]\n\t[-password <password>]";
    private static final int PREDICT_OVERHEAD;
    private static final int PREDICT_COMPACT_WORTHWHILE = 2048;
    private static final int JPEG_OVERHEAD = 300;
    private static final int LOSSY_WORTHWHILE = 5120;
    private static final int COMPACT_OVERHEAD = 714;
    private String password_;
    private boolean fcompat_;
    private boolean fforce_;
    private boolean finplace_;
    private boolean fcompact0_;
    private boolean fcompact_;
    private boolean fstruct_;
    private boolean fwebcap_;
    private boolean fpagepiece_;
    private boolean fjpeg_;
    private boolean fjpeg2000_;
    private boolean falt_;
    private boolean fverbose_;
    private boolean fmonitor_;
    private boolean fquiet_;
    private PrintStream out_;
    private boolean ftestable_;
    private boolean fpre_;
    private boolean fcontent_;
    private List<String> wacky_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$tool$pdf$Compress;

    public Compress() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.fcompat_ = false;
        this.fcompact0_ = false;
        this.finplace_ = false;
        this.fforce_ = false;
        this.falt_ = true;
        this.fpagepiece_ = true;
        this.fwebcap_ = true;
        this.fstruct_ = true;
        this.fjpeg2000_ = false;
        this.fjpeg_ = false;
        this.ftestable_ = false;
        this.fcontent_ = true;
        this.fpre_ = true;
        this.out_ = PrintStreams.DEVNULL;
        this.fmonitor_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setCompat(boolean bl) {
        this.fcompat_ = bl;
    }

    public void setCompact(boolean bl) {
        this.fcompact0_ = bl;
    }

    public void setStruct(boolean bl) {
        this.fstruct_ = bl;
    }

    public void setMax() {
        this.ftestable_ = false;
        this.fcompat_ = false;
        this.fjpeg_ = true;
        this.fcompact0_ = true;
        this.falt_ = false;
        this.fpagepiece_ = false;
        this.fwebcap_ = false;
        this.fstruct_ = false;
    }

    public void setTestable(boolean bl) {
        this.ftestable_ = bl;
    }

    public void setQuiet(boolean bl) {
        this.fquiet_ = bl;
    }

    public void setVerbose(boolean bl) {
        this.fverbose_ = bl;
    }

    public List<String> getWacky() {
        return this.wacky_;
    }

    public boolean compress(File file, File file2) throws IOException, ParseException {
        boolean bl;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        if (!$assertionsDisabled && file.equals(file2)) {
            throw new AssertionError();
        }
        long l = System.currentTimeMillis();
        this.wacky_ = new ArrayList<String>(5);
        PDFReader pDFReader = new PDFReader(file);
        int n2 = pDFReader.getMajorVersion();
        int n3 = pDFReader.getMinorVersion();
        pDFReader.setPassword(this.password_);
        Dict dict = (Dict)pDFReader.getTrailer().get("Compress");
        if (!this.fforce_ && dict != null && ((string = (String)dict.get("Filter")) == null && !this.fcompact0_ || "Compact".equals(string) && this.fcompact0_)) {
            pDFReader.close();
            this.out_.println("Already compressed.  (Force recompression with -force.)");
            return false;
        }
        long l2 = file.length();
        if (!this.fquiet_) {
            this.out_.print(new StringBuffer().append(file).append(", ").append(l2).append(" bytes").toString());
            if (pDFReader.getEncrypt().getStmF() != CryptFilter.IDENTITY) {
                this.out_.print(", encrypted");
            }
            this.out_.println();
            object4 = pDFReader.getInfo();
            if (object4 != null) {
                this.out_.println(new StringBuffer().append("producer=").append(((Dict)object4).get("Producer")).append(", creator=").append(((Dict)object4).get("Creator")).toString());
            }
        }
        if (this.fmonitor_) {
            this.out_.print(new StringBuffer().append(pDFReader.getObjCnt()).append(" objects / ").append(pDFReader.getPageCnt()).append(" pages").toString());
        }
        pDFReader.fault();
        object4 = new PDFWriter(file2, pDFReader);
        dict = (Dict)((PDFWriter)object4).getTrailer().get("Compress");
        if (dict == null) {
            dict = new Dict(5);
            ((PDFWriter)object4).getTrailer().put("Compress", dict);
            dict.put("LengthO", new Integer((int)l2));
            dict.put("SpecO", new StringBuffer().append(n2).append(".").append(n3).toString());
        }
        boolean bl2 = this.fcompact_ = this.fcompact0_ && l2 > l2 / 4L + 714L;
        if (this.fcompact_) {
            dict.put("Filter", "Compact");
        } else {
            dict.remove("Filter");
        }
        if (this.fcompat_) {
            pDFReader.setExact(true);
        } else if (!this.fcompact_) {
            ((PDFWriter)object4).setMinVersion(1, 5);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = pDFReader.getObjCnt();
        for (int i = 1; i < n14; ++i) {
            Object object52;
            Dict dict2;
            Object object6;
            block63: {
                block64: {
                    block65: {
                        block66: {
                            block62: {
                                object6 = pDFReader.getObject(i);
                                if (COS.OBJECT_DELETED != object6) break block62;
                                ++n6;
                                break block63;
                            }
                            if (COS.CLASS_DICTIONARY != object6.getClass()) break block63;
                            dict2 = (Dict)object6;
                            object3 = pDFReader.getObject(dict2.get("Filter"));
                            if (object3 == null) break block64;
                            if (COS.CLASS_NAME != object3.getClass()) break block65;
                            if (!"ASCII85Decode".equals(object3) && !"ASCIIHexDecode".equals(object3)) break block66;
                            ++n5;
                            break block64;
                        }
                        if (!"LZWDecode".equals(object3)) break block64;
                        ++n4;
                        break block64;
                    }
                    if (COS.CLASS_ARRAY == object3.getClass()) {
                        for (Object object52 : (Object[])object3) {
                            if ("ASCII85Decode".equals(object52) || "ASCIIHexDecode".equals(object52)) {
                                ++n5;
                                continue;
                            }
                            if (!"LZWDecode".equals(object52)) continue;
                            ++n4;
                        }
                    }
                }
                if (dict2.get("DATA") != null && dict2.get("Length") instanceof IRef) {
                    ++n9;
                }
                object2 = pDFReader.getObject(dict2.get("Type"));
                object = pDFReader.getObject(dict2.get("Subtype"));
                if (("XObject".equals(object2) || object2 == null) && "Image".equals(object) && dict2.get("Alternates") != null) {
                    ++n8;
                }
            }
            ((PDFWriter)object4).getObject(i, true);
            if (COS.CLASS_DICTIONARY != object6.getClass()) continue;
            dict2 = (Dict)object6;
            if (dict2.get("PieceInfo") != null) {
                ++n7;
            }
            object3 = pDFReader.getObject(dict2.get("Filter"));
            object2 = ((PDFWriter)object4).getObject(dict2.get("Type"));
            object = ((PDFWriter)object4).getObject(dict2.get("Subtype"));
            if (("XObject".equals(object2) || object2 == null) && "Image".equals(object)) {
                if (object3 != null) continue;
                ++n10;
                byte[] byArray = (byte[])dict2.get("DATA");
                n11 += byArray.length;
                continue;
            }
            if (!"Font".equals(object2) || !"Type1".equals(object)) continue;
            Dict dict3 = (Dict)((PDFWriter)object4).getObject(dict2.get("FontDescriptor"));
            Object object7 = object52 = dict3 != null ? (Dict)((PDFWriter)object4).getObject(dict3.get("FontFile")) : null;
            if (object52 == null) continue;
            ++n12;
            Object object8 = ((PDFWriter)object4).getObject(((Dict)object52).get("Length1"));
            if (object8 instanceof Number) {
                n13 += ((Number)object8).intValue();
            }
            if ((object8 = ((PDFWriter)object4).getObject(((Dict)object52).get("Length2"))) instanceof Number) {
                n13 += ((Number)object8).intValue();
            }
            if (!((object8 = ((PDFWriter)object4).getObject(((Dict)object52).get("Length3"))) instanceof Number)) continue;
            n13 += ((Number)object8).intValue();
        }
        if (this.fmonitor_) {
            if (n4 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n4).append(" LZW").toString());
            }
            if (n5 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n5).append(" ASCII").toString());
            }
            if (n6 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n6).append(" deleted").toString());
            }
            if (n7 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n7).append(" pagepiece").toString());
            }
            if (n8 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n8).append(" image /Alt").toString());
            }
            if (n9 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n9).append(" /Length IRef").toString());
            }
            if (n10 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n10).append(" raw samples = ").append(n11 / 1024).append("K").toString());
            }
            if (n12 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n12).append(" embedded Type 1 = ").append(n13 / 1024).append("K").toString());
            }
        }
        Dict dict4 = ((PDFWriter)object4).getCatalog();
        this.strip(dict4, (PDFWriter)object4);
        n14 = 0;
        int n15 = pDFReader.getPageCnt();
        for (n = 0; n < n15; ++n) {
            object3 = pDFReader.getPageRef(n + 1);
            object2 = ((PDFWriter)object4).getObject(object3);
            if (COS.OBJECT_NULL == object2 || object2 == null) continue;
            object = (Dict)object2;
            if ((object2 = ((Dict)object).get("Thumb")) != null) {
                ((Dict)object).remove("Thumb");
                if (COS.CLASS_IREF == object2.getClass()) {
                    ((PDFWriter)object4).setObject(((IRef)object2).id, COS.OBJECT_DELETED);
                }
                ++n14;
            }
            this.stripLZW((Dict)object, ((Dict)object).get("Contents"), pDFReader, (PDFWriter)object4);
        }
        if (this.fmonitor_ && n14 > 0) {
            this.out_.print(new StringBuffer().append(", ").append(n14).append(" thumb").toString());
        }
        this.recodeImages((PDFWriter)object4, pDFReader);
        ((PDFWriter)object4).liftPageTree();
        this.inline((PDFWriter)object4);
        this.unique((PDFWriter)object4);
        n = ((PDFWriter)object4).refcntRemove();
        if (n > 0 && this.fmonitor_) {
            this.out_.print(new StringBuffer().append(", ref cnt ").append(n).toString());
        }
        long l3 = System.currentTimeMillis();
        boolean bl3 = bl = this.fcompat_ || this.fcompact_ ? false : ((PDFWriter)object4).makeObjectStreams(0, ((PDFWriter)object4).getObjCnt());
        if (this.fmonitor_) {
            this.out_.print(", write");
        }
        ((PDFWriter)object4).writePDF();
        if (this.fmonitor_) {
            this.out_.print(new StringBuffer().append(" in ").append((System.currentTimeMillis() - l3) / 1000L).append(" sec").toString());
        }
        if (this.fmonitor_ && this.fcompact_ && "Flate".equals(object = (Dict)((PDFWriter)object4).getObject(dict.get("Compact")))) {
            this.out_.print(", Compact/Flate");
        }
        ((PDFWriter)object4).close();
        long l4 = System.currentTimeMillis();
        if (this.fmonitor_) {
            this.out_.println();
        }
        if (this.fverbose_) {
            if (pDFReader.getLinearized() > 0) {
                this.out_.println("lost Linearization (aka Fast Web View)");
            }
            if (pDFReader.isRepaired()) {
                this.out_.println("repaired errors");
            }
            if (n4 > 0) {
                this.out_.println("converted LZW to Flate");
            }
            if (n5 > 0) {
                this.out_.println("stripped off verbose ASCII filters");
            }
            if (n6 > 0) {
                this.out_.println("nulled out deleted objects");
            }
            if (n14 > 0) {
                this.out_.println("removed thumbnails (Acrobat can generate on the fly)");
            }
            if (n7 > 0 && !this.fpagepiece_) {
                this.out_.println("removed /PieceInfo");
            }
            if (n8 > 0 && !this.falt_) {
                this.out_.println("remove alternate images");
            }
            if (!this.fcompat_) {
                this.out_.println("cleaned and modernized");
                if (((COSSource)object4).compareVersion(n2, n3) > 0 && ((COSSource)object4).compareVersion(1, 5) >= 0) {
                    this.out_.println("\tcross references as stream");
                    if (bl) {
                        this.out_.println("\tadditional compression via object streams");
                    }
                    this.out_.println("\tnow REQUIRES Multivalent or Acrobat 6 to read (use -compat for older PDF)");
                }
            }
        }
        long l5 = file2.length();
        if (!this.fquiet_) {
            if (this.fcompact_) {
                this.out_.println("Compact PDF format -- requires Multivalent to read");
            }
            this.out_.println(new StringBuffer().append("=> new length = ").append(l5).append(", saved ").append((l2 - l5) * 100L / l2).append("%, elapsed time = ").append((l4 - l) / 1000L).append(" sec").toString());
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fcompat_ && ((COSSource)object4).compareVersion(1, 5) < 0) {
                stringBuffer.append(" [omit -compat]");
            }
            if (!this.fcompact0_) {
                stringBuffer.append(" -compact");
            }
            if (dict4.get("StructTreeRoot") != null) {
                stringBuffer.append(" -nostruct");
            }
            if (n10 > 0 && !this.fjpeg_) {
                stringBuffer.append(" -jpeg");
            }
            if (dict4.get("SpiderInfo") != null) {
                stringBuffer.append(" -nowebcap");
            }
            if (n7 > 0 && this.fpagepiece_) {
                stringBuffer.append(" -nopagepiece");
            }
            if (n8 > 0 && this.falt_) {
                stringBuffer.append(" -noalt");
            }
            if (stringBuffer.length() > 0) {
                this.out_.println("additional compression may be possible with:");
                this.out_.println(new StringBuffer().append("\t").append((Object)stringBuffer).toString());
            }
        }
        pDFReader.close();
        return l5 < l2;
    }

    private void strip(Dict dict, PDFWriter pDFWriter) {
        if (!this.fstruct_) {
            dict.remove("StructTreeRoot");
            dict.remove("MarkInfo");
        }
        if (!this.fwebcap_) {
            dict.remove("SpiderInfo");
        }
        if (!this.fpagepiece_) {
            dict.remove("PieceInfo");
        }
        if (!this.fpagepiece_) {
            int n = pDFWriter.getObjCnt();
            for (int i = 1; i < n; ++i) {
                Object object = pDFWriter.getCache(i);
                if (COS.CLASS_DICTIONARY != object.getClass()) continue;
                Dict dict2 = (Dict)object;
                dict2.remove("PieceInfo");
            }
        }
    }

    private void stripLZW(Dict dict, Object object, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Dict dict2;
        Object[] objectArray;
        if (this.ftestable_ || !this.fcontent_) {
            return;
        }
        Object object2 = pDFWriter.getObject(object);
        if (object2 == null) {
            objectArray = new Object[]{};
        } else if (COS.CLASS_DICTIONARY == object2.getClass()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = (Object[])object2;
        }
        Object[] objectArray3 = objectArray;
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            Dict dict3 = (Dict)pDFWriter.getObject(objectArray3[i]);
            try {
                Object object3 = pDFReader.readCommandArray(objectArray3[i]);
                dict3.put("DATA", pDFWriter.writeCommandArray((Cmd[])object3, false));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Dict dict4 = (Dict)pDFReader.getObject(dict.get("Resources"));
        Dict dict5 = dict2 = dict4 != null ? (Dict)pDFReader.getObject(dict4.get("XObject")) : null;
        if (dict2 != null) {
            for (Object object3 : dict2.values()) {
                Object object4 = pDFReader.getObject(object3);
                if (COS.CLASS_DICTIONARY != object4.getClass()) continue;
                Dict dict6 = (Dict)object4;
                if (!"Form".equals("Subtype")) continue;
                this.stripLZW(dict6, object3, pDFReader, pDFWriter);
            }
        }
    }

    private int unique(PDFWriter pDFWriter) {
        long l = System.currentTimeMillis();
        int n = pDFWriter.getObjCnt();
        Object[] objectArray = pDFWriter.getObjects();
        Class[] classArray = new Class[n];
        for (int i = 1; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5 = 0;
            objectArray = pDFWriter.getObjects();
            n = pDFWriter.getObjCnt();
            if (!$assertionsDisabled && lArray[0] != 0L) {
                throw new AssertionError();
            }
            for (n4 = 1; n4 < n; ++n4) {
                lArray[n4] = ((long)Compress.sign(objectArray[n4]) << 32) + (long)n4;
            }
            Arrays.sort(lArray, 1, n);
            for (n4 = 1; n4 < n; ++n4) {
                nArray[(int)(lArray[n4] & Integer.MAX_VALUE)] = n4;
            }
            int[] nArray2 = new int[n];
            block4: for (int i = 1; i < n; ++i) {
                nArray2[i] = i;
                Object object = objectArray[i];
                Class clazz = classArray[i];
                if (COS.CLASS_DICTIONARY == clazz && "Page".equals(((Dict)object).get("Type"))) continue;
                int n6 = nArray[i];
                long l2 = lArray[n6] & 0xFFFFFFFF00000000L;
                --n6;
                while (n6 > 0 && (lArray[n6] & l2) == l2) {
                    int n7 = (int)(lArray[n6] & Integer.MAX_VALUE);
                    if (clazz == classArray[n7] && pDFWriter.objEquals(object, objectArray[n7])) {
                        int n8;
                        nArray2[i] = n8 = nArray2[n7];
                        objectArray[i] = objectArray[n8];
                        ++n5;
                        continue block4;
                    }
                    --n6;
                }
            }
            if (n5 <= 0) break;
            int[] nArray3 = pDFWriter.renumberRemove(nArray2);
            for (int i = 1; i < n; ++i) {
                classArray[i - nArray3[i]] = classArray[i];
            }
            if (this.fmonitor_) {
                this.out_.print(n3 == 0 ? new StringBuffer().append(", ").append(n5).append(" dups").toString() : new StringBuffer().append(" + ").append(n5).toString());
            }
            n2 += n5;
            ++n3;
        }
        long l3 = System.currentTimeMillis() - l;
        return n2;
    }

    private static int sign(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        if (COS.OBJECT_NULL == object) {
            n = 0;
        } else if (COS.CLASS_NAME == clazz) {
            n = ((String)object).hashCode();
        } else if (COS.CLASS_STRING == clazz) {
            n = ((StringBuffer)object).length() * 11;
        } else if (COS.CLASS_DATA == clazz) {
            n = ((byte[])object).length << 8;
        } else if (COS.CLASS_BOOLEAN == clazz) {
            n = (Boolean)object != false ? 11 : 7;
        } else if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (COS.CLASS_IREF == clazz) {
            n = ((IRef)object).id * 131;
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            n += dict.size() * 13;
            for (Map.Entry entry : dict.entrySet()) {
                n += entry.getKey().hashCode();
                n += Compress.sign(entry.getValue());
            }
            n *= dict.size();
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray = (Object[])object;
            n += objectArray.length * 7;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                n += Compress.sign(objectArray[i]) * (i + 1);
            }
        }
        return n;
    }

    private int inline(PDFWriter pDFWriter) {
        Object object;
        Serializable serializable;
        int n;
        int n2 = 0;
        int n3 = pDFWriter.getObjCnt();
        Object[] objectArray = pDFWriter.getObjects();
        int[] nArray = pDFWriter.refcnt();
        if (this.fmonitor_) {
            this.out_.print(", inline");
        }
        for (n = 1; n < n3; ++n) {
            Object object2;
            serializable = objectArray[n].getClass();
            if (nArray[n] == 0) continue;
            if (COS.CLASS_ARRAY == serializable) {
                object2 = (Object[])objectArray[n];
                int n4 = ((Object[])object2).length;
                for (int i = 0; i < n4; ++i) {
                    object = this.inlineObj(object2[i], nArray, pDFWriter);
                    if (object == null) continue;
                    object2[i] = object;
                }
                continue;
            }
            if (COS.CLASS_DICTIONARY != serializable) continue;
            object2 = (Dict)objectArray[n];
            for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                object = this.inlineObj(entry.getValue(), nArray, pDFWriter);
                if (object == null) continue;
                entry.setValue(object);
            }
        }
        for (n = 1; n < n3; ++n) {
            if (COS.CLASS_DICTIONARY != objectArray[n].getClass() || nArray[n] == 0 || !"Page".equals(((Dict)(serializable = (Dict)objectArray[n])).get("Type")) || (object = ((Dict)serializable).get("Contents")) == null) continue;
            int n5 = -1;
            if (COS.CLASS_IREF == object.getClass()) {
                n5 = ((IRef)object).id;
                object = objectArray[n5];
            }
            if (COS.CLASS_ARRAY != object.getClass()) continue;
            Object[] objectArray2 = (Object[])object;
            Object[] objectArray3 = new Object[objectArray2.length];
            int n6 = 0;
            byte[] byArray = null;
            int n7 = -1;
            int n8 = 0;
            int n9 = objectArray2.length;
            for (int i = 0; i < n9; ++i) {
                IRef iRef = (IRef)objectArray2[i];
                int n10 = iRef.id;
                objectArray3[n6++] = iRef;
                byte[] byArray2 = (byte[])((Dict)objectArray[n10]).get("DATA");
                if (nArray[n10] == 1 || n7 != -1 && byArray2.length < PDFWriter.PDFOBJREF_OVERHEAD * 2) {
                    if (byArray == null) {
                        byArray = byArray2;
                        n7 = n10;
                        n8 = 1;
                        continue;
                    }
                    byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    byArray3[byArray.length] = 32;
                    System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
                    byArray = byArray3;
                    --n6;
                    ++n8;
                    continue;
                }
                if (n8 > 1) {
                    ((Dict)objectArray[n7]).put("DATA", byArray);
                }
                byArray = null;
                n7 = -1;
                n8 = 0;
            }
            if (n8 > 1) {
                ((Dict)objectArray[n7]).put("DATA", byArray);
            }
            if (n6 < objectArray2.length) {
                Object object3;
                n2 += objectArray2.length - n6;
                if (n6 == 1) {
                    object3 = objectArray3[0];
                } else {
                    object3 = new Object[n6];
                    System.arraycopy(objectArray3, 0, object3, 0, n6);
                }
                ((Dict)serializable).put("Contents", object3);
                continue;
            }
            ((Dict)serializable).put("Contents", objectArray2);
        }
        if (!$assertionsDisabled && pDFWriter.getObjGen(0) != 65535) {
            throw new AssertionError(pDFWriter.getObjGen(0));
        }
        n = pDFWriter.refcntRemove();
        if (!$assertionsDisabled && pDFWriter.getObjGen(0) != 65535) {
            throw new AssertionError();
        }
        if (this.fmonitor_) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" ").append(-n).toString());
            }
            if (n2 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n2).append(" concat").toString());
            }
        }
        return n;
    }

    private Object inlineObj(Object object, int[] nArray, PDFWriter pDFWriter) {
        if (!(object instanceof IRef)) {
            return null;
        }
        int n = ((IRef)object).id;
        object = pDFWriter.getCache(n);
        Class<?> clazz = object.getClass();
        if (COS.OBJECT_NULL == object || COS.CLASS_INTEGER == clazz || COS.CLASS_BOOLEAN == clazz || COS.CLASS_NAME == clazz && ((String)object).length() < PDFWriter.PDFOBJREF_OVERHEAD || COS.CLASS_STRING == clazz && ((StringBuffer)object).length() + 2 < PDFWriter.PDFOBJREF_OVERHEAD || nArray[n] == 1 && (COS.CLASS_NAME == clazz || COS.CLASS_STRING == clazz || COS.CLASS_REAL == clazz)) {
            int n2 = n;
            nArray[n2] = nArray[n2] - 1;
            return object;
        }
        return null;
    }

    private void recodeImages(PDFWriter pDFWriter, PDFReader pDFReader) throws IOException {
        int n = pDFWriter.getObjCnt();
        for (int i = 1; i < n; ++i) {
            int n2;
            boolean bl;
            Object object = pDFWriter.getCache(i);
            if (COS.CLASS_DICTIONARY != object.getClass()) continue;
            Dict dict = (Dict)object;
            String string = (String)pDFWriter.getObject(dict.get("Type"));
            String string2 = (String)pDFWriter.getObject(dict.get("Subtype"));
            byte[] byArray = (byte[])dict.get("DATA");
            boolean bl2 = bl = (null == string || "XObject".equals(string)) && "Image".equals(string2) && byArray != null;
            if (!bl) continue;
            String string3 = (String)pDFWriter.getObject(dict.get("Filter"));
            int n3 = ((Number)pDFWriter.getObject(dict.get("Width"))).intValue();
            int n4 = ((Number)pDFWriter.getObject(dict.get("Height"))).intValue();
            int n5 = n2 = pDFWriter.getObject(dict.get("ImageMask")) == Boolean.TRUE ? 1 : ((Number)pDFWriter.getObject(dict.get("BitsPerComponent"))).intValue();
            if (!this.falt_ && (object = pDFReader.getObject(dict.get("Alternates"))) != null) {
                Object[] objectArray = (Object[])object;
                ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
                for (Object object2 : objectArray) {
                    Dict dict2 = (Dict)pDFReader.getObject(object2);
                    if (dict2.get("OC") == null) {
                        objectArray[i] = COS.OBJECT_NULL;
                        continue;
                    }
                    arrayList.add(object2);
                }
                if (arrayList.size() == 0) {
                    dict.remove("Alternates");
                } else {
                    dict.put("Alternates", arrayList.toArray());
                }
            }
            if ("DCTDecode".equals(string3)) {
                this.recodeDCTAsRaw(dict, n3, n4, byArray);
                continue;
            }
            if ("CCITTFaxDecode".equals(string3) || string3 != null) continue;
            boolean bl3 = false;
            if (this.fjpeg_) {
                bl3 = this.recodeRawAsDCT(dict, n3, n4, n2, byArray, pDFReader);
            }
            if (bl3 || !this.fpre_) continue;
            bl3 = this.addPredictor(dict, n3, n4, n2, byArray, pDFReader);
        }
    }

    private boolean recodeDCTAsRaw(Dict dict, int n, int n2, byte[] byArray) throws IOException {
        if (this.ftestable_) {
            return false;
        }
        int n3 = byArray.length;
        if (n * n2 > n3) {
            return false;
        }
        try {
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
            imageReader.setInput(imageInputStream, true);
            BufferedImage bufferedImage = imageReader.read(0);
            imageReader.dispose();
            imageInputStream.close();
            int n4 = bufferedImage.getColorModel().getNumComponents();
            int n5 = n4 * n * n2;
            if (n5 / 2 < n3 && (n4 == 1 || n4 == 3)) {
                byte[] byArray2 = new byte[n5];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n7 = bufferedImage.getRGB(j, i);
                        if (n4 == 3) {
                            byArray2[n6++] = (byte)(n7 >> 16);
                            byArray2[n6++] = (byte)(n7 >> 8);
                        }
                        byArray2[n6++] = (byte)n7;
                    }
                }
                dict.put("DATA", byArray2);
                dict.remove("Filter");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recodeRawAsDCT(Dict dict, int n, int n2, int n3, byte[] byArray, PDFReader pDFReader) throws IOException {
        if (this.ftestable_) {
            return false;
        }
        if (n3 != 8 || n < 20 || n2 < 20 || byArray.length < 5420) {
            return false;
        }
        byte[] byArray2 = PDFWriter.maybeDeflateData(byArray);
        int n4 = byArray2.length;
        byArray2 = null;
        if (n4 < 5420) {
            return false;
        }
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(dict);
        BufferedImage bufferedImage = Images.createImage(dict, inputStreamComposite, Color.WHITE, pDFReader);
        ((InputStream)inputStreamComposite).close();
        if (bufferedImage == null) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n * n2);
        boolean bl = false;
        String string = bl ? "JPEG2000" : "JPEG";
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        ImageIO.setUseCache(false);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        try {
            imageWriter.write(null, iIOImage, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            imageWriter.dispose();
            imageOutputStream.close();
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        int n5 = n4 - byArray3.length;
        if (n5 > 5120) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" jpeg").append(n5).toString());
                if (n5 > 102400) {
                    this.out_.print(new StringBuffer().append("/").append(n).append("x").append(n2).toString());
                }
            }
            dict.put("Filter", "JPEG2000".equals(string) ? "JPXDecode" : "DCTDecode");
            dict.put("DATA", byArray3);
            dict.put("ColorSpace", "DeviceRGB");
        }
        return true;
    }

    private boolean addPredictor(Dict dict, int n, int n2, int n3, byte[] byArray, PDFReader pDFReader) throws IOException {
        int n4;
        int n5;
        if (!($assertionsDisabled || dict != null && n >= 1 && n2 >= 1 && byArray != null && byArray.length >= 1)) {
            throw new AssertionError();
        }
        if (n3 != 8 || byArray.length < PREDICT_OVERHEAD + n) {
            return false;
        }
        Object object = pDFReader.getObject(dict.get("ColorSpace"));
        ColorSpace colorSpace = pDFReader.getColorSpace(object, null, null);
        int n6 = colorSpace.getNumComponents();
        if (COS.CLASS_ARRAY == object.getClass() && "Indexed".equals(((Object[])object)[0])) {
            n6 = 1;
        }
        int n7 = n5 = (n6 * n3 + 7) / 8;
        int n8 = n * n2 * n6 * n3 / 8;
        if (!$assertionsDisabled && byArray.length < n8) {
            throw new AssertionError((Object)new StringBuffer().append(byArray.length).append(" != ").append(n).append(" * ").append(n2).append(" * ").append(n6).append(" * ").append(n3).append(" = ").append(n8).toString());
        }
        if (byArray.length > n8) {
            String string = new StringBuffer().append("extra bytes ").append(n).append("x").append(n2).append("*").append(n6).append("=").append(n8).append(" < ").append(byArray.length).toString();
            this.wacky_.add(string);
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" / ").append(string).toString());
            }
        }
        int n9 = n * n5;
        byte[] byArray2 = new byte[(n9 + 1) * n2];
        int n10 = n9 + n7;
        byte[] byArray3 = new byte[n10];
        byte[] byArray4 = new byte[n10];
        byte[] byArray5 = new byte[n10];
        byte[] byArray6 = new byte[n10];
        byte[] byArray7 = new byte[n10];
        int n11 = 0;
        byArray2[n11++] = 0;
        System.arraycopy(byArray, 0, byArray2, n11, n9);
        n11 += n9;
        int n12 = 1;
        int n13 = n9;
        int n14 = 0 - n7;
        while (n12 < n2) {
            int n15;
            int n16;
            n4 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            System.arraycopy(byArray, n13, byArray3, n7, n9);
            for (n16 = n10 - 1; n16 >= n7; --n16) {
                n4 += byArray3[n16] & 0xFF;
            }
            n16 = n4;
            int n21 = 0;
            byte[] byArray8 = byArray3;
            System.arraycopy(byArray, n13, byArray4, n7, n9);
            int n22 = n7 + n5;
            for (n15 = n10 - 1; n15 >= n22; --n15) {
                int n23 = n15;
                byArray4[n23] = (byte)(byArray4[n23] - (byArray4[n15 - n5] & 0xFF));
                n17 += byArray4[n15] & 0xFF;
            }
            if (n17 < n16) {
                n16 = n17;
                byArray8 = byArray4;
                n21 = 1;
            }
            System.arraycopy(byArray, n13, byArray5, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                int n24 = n15;
                byArray5[n24] = (byte)(byArray5[n24] - (byArray[n14 + n15] & 0xFF));
                n18 += byArray5[n15] & 0xFF;
            }
            if (n18 < n16) {
                n16 = n18;
                byArray8 = byArray5;
                n21 = 2;
            }
            System.arraycopy(byArray, n13, byArray6, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                int n25 = n15;
                byArray6[n25] = (byte)(byArray6[n25] - ((byArray6[n15 - n5] & 0xFF) + (byArray[n14 + n15] & 0xFF)) / 2);
                n19 += byArray6[n15] & 0xFF;
            }
            if (n19 < n16) {
                n16 = n19;
                byArray8 = byArray6;
                n21 = 3;
            }
            System.arraycopy(byArray, n13, byArray7, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                n22 = byArray7[n15 - n5] & 0xFF;
                int n26 = byArray[n14 + n15] & 0xFF;
                int n27 = n15 >= n7 + n5 ? byArray[n14 + n15 - n5] & 0xFF : 0;
                int n28 = n22 + n26 - n27;
                int n29 = Math.abs(n28 - n22);
                int n30 = Math.abs(n28 - n26);
                int n31 = Math.abs(n28 - n27);
                int n32 = n29 <= n30 && n29 <= n31 ? n22 : (n30 <= n31 ? n26 : n27);
                int n33 = n15;
                byArray7[n33] = (byte)(byArray7[n33] - (byte)n32);
                n20 += byArray7[n15] & 0xFF;
            }
            if (n20 < n16) {
                n16 = n20;
                byArray8 = byArray7;
                n21 = 4;
            }
            if (!($assertionsDisabled || n4 >= 0 && n17 >= 0 && n18 >= 0 && n19 >= 0 && n20 >= 0)) {
                throw new AssertionError();
            }
            byArray2[n11++] = n21;
            System.arraycopy(byArray8, n7, byArray2, n11, n9);
            n11 += n9;
            ++n12;
            n13 += n9;
            n14 += n9;
        }
        if (!$assertionsDisabled && n11 != byArray2.length) {
            throw new AssertionError((Object)new StringBuffer().append(n11).append(" != ").append(byArray2.length).toString());
        }
        byte[] byArray9 = PDFWriter.maybeDeflateData(byArray2);
        n13 = byArray9.length;
        n14 = PDFWriter.maybeDeflateData(byArray).length;
        int n34 = byArray2 != byArray9 && n13 + PREDICT_OVERHEAD + 10 + (this.fcompact_ ? 2048 : 0) < n14 ? 1 : (n4 = 0);
        if (n4 != 0) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" pre").append(n14 - n13).toString());
            }
            dict.put("Filter", "FlateDecode");
            dict.put("DATA", byArray9);
            Dict dict2 = new Dict(5);
            dict2.put("Predictor", Integers.getInteger(15));
            if (n6 != 1) {
                dict2.put("Colors", Integers.getInteger(n6));
            }
            dict2.put("Columns", Integers.getInteger(n));
            if (n3 != 8) {
                dict2.put("BitsPerComponent", Integers.getInteger(8));
            }
            dict.put("DecodeParms", dict2);
        }
        return n4 != 0;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.setOut(System.out);
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-force")) {
                this.fforce_ = true;
                continue;
            }
            if (string.startsWith("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-compat")) {
                this.fcompat_ = true;
                this.fcompact0_ = false;
                continue;
            }
            if (string.startsWith("-compact") || string.startsWith("-bulk")) {
                this.fcompact0_ = true;
                this.fcompat_ = false;
                continue;
            }
            if (string.startsWith("-nostruct")) {
                this.fstruct_ = false;
                continue;
            }
            if (string.startsWith("-nowebcap")) {
                this.fwebcap_ = false;
                continue;
            }
            if (string.startsWith("-nopagep")) {
                this.fpagepiece_ = false;
                continue;
            }
            if (string.equals("-jpeg") || string.equals("-jpg")) {
                this.fjpeg_ = true;
                continue;
            }
            if (string.startsWith("-jpeg2") || string.startsWith("-jpg2")) {
                this.fjpeg2000_ = true;
                continue;
            }
            if (string.startsWith("-noalt")) {
                this.falt_ = false;
                continue;
            }
            if (string.equals("-max") || string.equals("-all")) {
                this.setMax();
                continue;
            }
            if (string.equals("-nopre")) {
                this.fpre_ = false;
                continue;
            }
            if (string.startsWith("-test")) {
                this.ftestable_ = true;
                continue;
            }
            if (string.equals("-nocs")) {
                this.fcontent_ = false;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(new StringBuffer().append("Unknown option: ").append(string).toString());
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Compress compress = new Compress();
        int n = compress.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.canRead() || file.length() == 0L) continue;
            String string = file.getPath();
            String string2 = compress.finplace_ ? string : new StringBuffer().append(string.toLowerCase().endsWith(".pdf") ? string.substring(0, string.length() - ".pdf".length()) : string).append("-o.pdf").toString();
            try {
                compress.compress(file, new File(string2));
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer().append(file).append(": ").append(exception).toString());
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$tool$pdf$Compress == null ? (class$tool$pdf$Compress = Compress.class$("tool.pdf.Compress")) : class$tool$pdf$Compress).desiredAssertionStatus();
        PREDICT_OVERHEAD = "/DecodeParms<</Predictor 15/Columns10/Colors 3>>>>".length();
    }
}

