/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import phelps.io.FileList;

public class RC4 {
    public static final String USAGE = "java tool.RC4 <password> <file-or-directory...>";
    public static final String VERSION = "1.1 of $Date: 2003/08/28 20:35:44 $";
    private String password_;
    private boolean fverbose_;

    public RC4() {
        this.defaults();
    }

    public void defaults() {
        this.password_ = null;
        this.fverbose_ = false;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) continue;
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        if (this.password_ == null) {
            this.password_ = stringArray[++n];
        }
        return n;
    }

    public void rc4(File file) throws IOException {
        int n;
        phelps.crypto.RC4 rC4 = new phelps.crypto.RC4(this.password_.getBytes());
        File file2 = file.getParentFile();
        File file3 = File.createTempFile("crypt", "tmp", file2);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        byte[] byArray = new byte[8192];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            rC4.encrypt(byArray, 0, n);
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        fileInputStream.close();
        file.delete();
        n = file3.renameTo(file) ? 1 : 0;
        if (n == 0) {
            System.err.println("couldn't rename " + file3 + " to " + file);
        }
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n < 2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        RC4 rC4 = new RC4();
        int n2 = rC4.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n2, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.canWrite()) {
                System.out.println("can't write " + file);
                continue;
            }
            try {
                rC4.rc4(file);
            }
            catch (IOException iOException) {
                System.err.println(file + ": " + iOException);
            }
        }
    }
}

