/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import multivalent.Behavior;
import multivalent.Cache;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.MediaAdaptor;
import multivalent.Multivalent;
import multivalent.Node;
import multivalent.node.LeafText;
import phelps.io.FileList;
import phelps.io.InputStreamCached;
import phelps.lang.Integers;

public class ExtractText {
    static final boolean DEBUG = true;
    public static final String USAGE = "java tool.ExtractText [-page <range>] <file...>";
    public static final String VERSION = "1.1 of $Date: 2003/08/29 06:07:31 $";
    static final int FUZZ = 3;
    static String PAGE_DIVIDER;
    private String range_;
    private boolean flayout_;
    private boolean fverbose_;
    private boolean fquiet_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtractText() {
        this.defaults();
    }

    public void defaults() {
        this.range_ = null;
        this.flayout_ = false;
        this.fquiet_ = false;
        this.fverbose_ = false;
    }

    public void setVerbose(boolean bl) {
        this.fverbose_ = bl;
    }

    public void setQuiet(boolean bl) {
        this.fquiet_ = bl;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setLayout(boolean bl) {
        this.flayout_ = bl;
    }

    public String extract(URI uRI, String string) throws Exception {
        if (!this.fquiet_) {
            System.err.println(uRI);
        }
        StringBuffer stringBuffer = new StringBuffer(20000);
        Document document = new Document("top", null, null);
        Cache cache = Multivalent.getInstance().getCache();
        String string2 = cache.getGenre(string, uRI.toString(), null);
        if ("RawImage".equals(string2) || string2 == "ASCII") {
            return null;
        }
        MediaAdaptor mediaAdaptor = (MediaAdaptor)Behavior.getInstance(string2, string2, null, null, null);
        InputStreamCached inputStreamCached = new InputStreamCached(uRI.toURL().openStream(), new File(uRI.getPath()), null);
        mediaAdaptor.setInputStream(inputStreamCached);
        mediaAdaptor.setHints(270);
        mediaAdaptor.docURI = uRI;
        mediaAdaptor.parse(document);
        int n = Math.max(1, Integers.parseInt(document.getAttr("page"), -1));
        int n2 = Integers.parseInt(document.getAttr("pages"), -1);
        if (n2 <= 0) {
            this.extractFlow(document, stringBuffer);
        } else {
            int[] nArray = Integers.parseRange(this.range_, n2);
            int n3 = nArray.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = nArray[i];
                if (this.fverbose_) {
                    System.err.print(" " + n4);
                }
                document.clear();
                document.putAttr("page", Integer.toString(n4));
                document.putAttr("pages", Integer.toString(n2));
                mediaAdaptor.parse(document);
                if (this.flayout_) {
                    ExtractText.extractLayout(document, stringBuffer);
                } else {
                    this.extractFlow(document, stringBuffer);
                }
                stringBuffer.append("\n\n\n\n");
            }
            if (this.fverbose_) {
                System.err.println();
            }
        }
        mediaAdaptor.closeInputStream();
        return stringBuffer.toString();
    }

    public void extractFlow(Node node, StringBuffer stringBuffer) {
        if (node == null) {
            return;
        }
        Leaf leaf = node.getFirstLeaf();
        if (leaf.bbox.width != 0 || leaf.bbox.height != 0) {
            ExtractText.extractFlowFixed(node, stringBuffer);
        } else {
            ExtractText.extractFlowStruct(node, stringBuffer);
        }
    }

    public static void extractFlowStruct(Node node, StringBuffer stringBuffer) {
        if (node.breakBefore()) {
            stringBuffer.append("\n");
        }
        if (node.isLeaf()) {
            if (node instanceof LeafText) {
                stringBuffer.append(node.getName());
            }
        } else {
            if (!$assertionsDisabled && !node.isStruct()) {
                throw new AssertionError();
            }
            INode iNode = (INode)node;
            int n = iNode.size();
            for (int i = 0; i < n; ++i) {
                ExtractText.extractFlowStruct(iNode.childAt(i), stringBuffer);
                stringBuffer.append(" ");
            }
        }
        if (node.breakAfter()) {
            stringBuffer.append("\n");
        }
    }

    public static void extractFlowFixed(Node node, StringBuffer stringBuffer) {
        Point point = null;
        Point point2 = null;
        Leaf leaf = node.getLastLeaf().getNextLeaf();
        Leaf leaf2 = null;
        for (Leaf leaf3 = node.getFirstLeaf(); leaf3 != leaf && leaf3 != null; leaf3 = leaf3.getNextLeaf()) {
            if (leaf3 instanceof LeafText) {
                point = leaf3.getAbsLocation();
                if (point2 != null) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    boolean bl = true;
                    if (leaf3.childNum() == 0) {
                        n4 = point.y;
                        n3 = leaf3.bbox.height;
                        n2 = point2.y;
                        n = leaf2.bbox.height;
                        if (n2 + n - 3 <= n4) {
                            stringBuffer.append(n4 - (n2 + n) < Math.min(n3, n) ? "\n" : "\n\n");
                            bl = false;
                        } else if (n4 + n3 - 3 <= n2) {
                            stringBuffer.append(n2 - (n4 + n3) < Math.min(n3, n) ? "\n" : "\n\n");
                            bl = false;
                        }
                    }
                    if (bl) {
                        n4 = point.x;
                        n3 = leaf3.bbox.width;
                        n2 = point2.x;
                        n = leaf2.bbox.width;
                        if (n4 - (n2 + n) > 0) {
                            stringBuffer.append(' ');
                        }
                    }
                }
                stringBuffer.append(leaf3.getName());
            }
            leaf2 = leaf3;
            point2 = point;
        }
    }

    public static void extractLayout(Node node, StringBuffer stringBuffer) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4 = 320;
        int n5 = 240;
        int[] nArray = new int[1000];
        int n6 = 0;
        Leaf leaf = node.getLastLeaf().getNextLeaf();
        for (Leaf leaf2 = node.getFirstLeaf(); leaf2 != leaf && leaf2 != null; leaf2 = leaf2.getNextLeaf()) {
            if (!(leaf2 instanceof LeafText)) continue;
            n3 = leaf2.getName().length();
            n2 = leaf2.bbox.height;
            int n7 = n2 < 1000 ? n2 : 999;
            nArray[n7] = nArray[n7] + n3;
            object = leaf2.getAbsLocation();
            if (n4 < ((Point)object).x + leaf2.bbox.width) {
                n4 = ((Point)object).x + leaf2.bbox.width;
            }
            if (n5 < ((Point)object).y + leaf2.bbox.height) {
                n5 = ((Point)object).y + leaf2.bbox.height;
            }
            n6 += n3;
        }
        if (n6 == 0) {
            stringBuffer.append("\n\n\n");
            return;
        }
        int n8 = -1;
        int n9 = n6 / 4;
        n2 = nArray[0];
        for (n3 = 1; n3 < 1000; ++n3) {
            if ((n2 += nArray[n3]) < n9) continue;
            n8 = n3;
            break;
        }
        n3 = Math.max(24, n5 / n8 * 5 / 4);
        n2 = Math.max(40, n4 / n8 * 7 / 2);
        ++n5;
        object = new char[n3][n2];
        Object object2 = node.getLastLeaf().getNextLeaf();
        for (Leaf leaf3 = node.getFirstLeaf(); leaf3 != object2 && leaf3 != null; leaf3 = leaf3.getNextLeaf()) {
            if (!(leaf3 instanceof LeafText)) continue;
            Point point = leaf3.getAbsLocation();
            n = (point.y + leaf3.bbox.height) * n3 / n5;
            int c = point.x * n2 / n4;
            String string = leaf3.getName();
            Object object3 = object[n];
            int n10 = c + string.length();
            if (n10 > ((Object)object3).length) {
                char[] cArray = new char[n10];
                System.arraycopy(object3, 0, cArray, 0, ((Object)object3).length);
                object[n] = cArray;
                object3 = cArray;
            }
            int n11 = string.length();
            for (int cArray = 0; cArray < n11; ++cArray) {
                object3[c + cArray] = string.charAt(cArray);
            }
        }
        for (int i = 0; i < n3; ++i) {
            object2 = object[i];
            int n12 = -1;
            for (n = n2 - 1; n >= 0; --n) {
                if (object2[n] == false) continue;
                n12 = n + 1;
                break;
            }
            for (n = 0; n < n12; ++n) {
                Object object4 = object2[n];
                stringBuffer.append((char)(object4 != false ? object4 : (Object)32));
            }
            if (n12 <= 0) continue;
            stringBuffer.append("\n");
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-page") || string.equals("-range")) {
                this.range_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-lay") || string.startsWith("-form")) {
                this.flayout_ = true;
                continue;
            }
            if (string.startsWith("-flow")) {
                this.flayout_ = false;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) continue;
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        ExtractText extractText = new ExtractText();
        int n = extractText.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, null).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            try {
                String string = extractText.extract(file.toURI(), null);
                System.out.println(string);
            }
            catch (Exception exception) {
                System.out.println(file + ": " + exception);
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        $assertionsDisabled = !ExtractText.class.desiredAssertionStatus();
        PAGE_DIVIDER = "==============================================";
    }
}

