/*
 * Decompiled with CFR 0.152.
 */
package phelps.text;

import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;

public class Formats {
    private static final long SECOND = 1L;
    private static final long MINUTE = 60L;
    private static final long HOUR = 3600L;
    private static final long DAY = 86400L;
    private static final long WEEK = 604800L;
    private static final String[] int2dayOfWeek = new String[]{"XXX", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] int2day = new String[]{"XXX", "Sun", "Mon", "Tues", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] int2month = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] int2mon = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] ampm = new String[]{"am", "pm"};
    private static DateFormat dateFormat_ = null;
    private static Calendar cal_ = null;
    private static final String[] KSUFFIX = new String[]{"bytes", "KB", "MB", "GB", "TB", "EB"};

    private Formats() {
    }

    public static long parseDate(String string) throws ParseException {
        long l = -1L;
        try {
            long l2 = Long.parseLong(string);
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (dateFormat_ == null) {
                dateFormat_ = DateFormat.getDateTimeInstance();
            }
            dateFormat_.setLenient(true);
            try {
                l = dateFormat_.parse(string).getTime();
            }
            catch (ParseException parseException) {
                System.out.println("old date parsing: " + string);
            }
            if (l == -1L) {
                throw new ParseException("can't parse  date as either number or humand readable: " + string, -1);
            }
            return l;
        }
    }

    public static String relativeDate(long l) {
        return Formats.relativeDate(l, System.currentTimeMillis());
    }

    public static String relativeDate(long l, long l2) {
        long l3 = (l2 - l) / 1000L;
        boolean bl = l3 < 0L;
        String string = " ago";
        if (bl) {
            l3 = -l3;
            string = "";
        }
        if (l3 < 120L) {
            return (bl ? "+" : "") + l3 + " seconds" + string;
        }
        if (l3 < 7200L) {
            return (bl ? "+" : "") + l3 / 60L + " minutes" + string;
        }
        if (l3 < 86400L) {
            return (bl ? "+" : "") + l3 / 3600L + " hours" + string;
        }
        if (cal_ == null) {
            cal_ = Calendar.getInstance();
        }
        Calendar calendar = cal_;
        calendar.setTimeInMillis(l);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(2);
        if (l3 < 172800L) {
            return n + ":" + (n2 < 10 ? "0" : "") + n2 + (bl ? " tomorrow" : " yesterday");
        }
        if (l3 < 604800L) {
            return n + ":" + (n2 < 10 ? "0" : "") + n2 + " " + int2dayOfWeek[calendar.get(7)];
        }
        if (l3 < 27216000L) {
            return calendar.get(5) + " " + int2month[n3];
        }
        return calendar.get(5) + " " + int2month[n3] + " " + calendar.get(1);
    }

    public static String prettySize(long l) {
        if (l == 0L) {
            return "0 bytes";
        }
        if (l == 1L) {
            return "1 byte";
        }
        if (l == -1L) {
            return "-1 byte";
        }
        long l2 = l >= 0L ? 1 : -1;
        l = Math.abs(l);
        long l3 = 1024L;
        long l4 = 0L;
        long l5 = 0L;
        int n = 0;
        while (l > l3 && n + 1 < KSUFFIX.length) {
            l4 = l / l3;
            l5 = l - l4 * l3;
            l = l4;
            ++n;
        }
        return Long.toString(l2 * l) + (l5 > 0L ? "." : "") + (l <= 10L && l5 > 0L ? Long.toString(l5 * 10L / l3) : "") + " " + KSUFFIX[n];
    }

    public static String pretty(Rectangle2D rectangle2D) {
        return "" + rectangle2D.getWidth() + "x" + rectangle2D.getHeight() + "@(" + rectangle2D.getX() + "," + rectangle2D.getY() + ")";
    }

    public static String prettySeconds(int n) {
        int n2 = n / 60;
        n -= n2 * 60;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 24;
        n3 -= n4 * 24;
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = false;
        if (n4 > 0) {
            stringBuffer.append(n4).append("/");
            bl = true;
        }
        if (n3 > 0) {
            stringBuffer.append(n3).append(":");
            bl = true;
        }
        if (n2 > 0 || bl) {
            stringBuffer.append(n2 < 10 && bl ? "0" : "").append(n2).append(":");
            bl = true;
        }
        stringBuffer.append(n < 10 && bl ? "0" : "").append(n);
        return stringBuffer.toString();
    }
}

