/*
 * Decompiled with CFR 0.152.
 */
package phelps.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import multivalent.Leaf;
import multivalent.Node;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RobustHyperlink {
    public static boolean DEBUG;
    public static final String VERSION = "0.3";
    public static final String PARAMETER = "lexical-signature=";
    public static final int ALGORITHM_TFIDF = 0;
    public static final int ALGORITHM_TFIDF2 = 1;
    public static final int ALGORITHM_RAREST = 2;
    public static final int ALGORITHM_RANDOM = 3;
    public static final int ALGORITHM_RANDOM100K = 4;
    static final int DATABASE_VERSION = 3;
    public static boolean Verbose;
    static PrintWriter StudyOut;
    static File wordCache_;
    static String Engine;
    static String EngineHook;
    static int HUNK_LEN;
    public static boolean FoldCase;
    public static int MinWordLength;
    public static int SignatureLength;
    static int Algorithm_;
    static final int FREQ_MED = 5000000;
    static final int FREQ_BIG = 25000000;
    static final int ROUND_LITTLE = 1000;
    static final int ROUND_MEDIUM = 10000;
    static final Integer INT_MAX;
    static Integer[] INTS_LITTLE;
    static Integer[] INTS_MEDIUM;
    static Map<String, Integer> sys2cnt_;
    static Map<String, Integer> user2cnt_;
    static int newwords_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$phelps$net$RobustHyperlink;

    public static void setWordCache(File file) {
        wordCache_ = file;
    }

    public static void setEngine(String string, String string2) {
        Engine = string;
        EngineHook = string2;
    }

    public static void setAlgorithm(int n) {
        if (!($assertionsDisabled || 0 <= n && n <= 4)) {
            throw new AssertionError(n);
        }
        if (0 <= n && n <= 4) {
            Algorithm_ = n;
        }
    }

    private RobustHyperlink() {
    }

    public static String addSignature(URL uRL, String string) {
        String string2 = uRL.toString();
        if (string == null) {
            return string2;
        }
        char c = string2.indexOf(63) == -1 ? (char)'?' : '&';
        return new StringBuffer().append(string2).append("".equals(uRL.getFile()) ? "/" : "").append(c).append(PARAMETER).append(URIs.encode(string)).toString();
    }

    public static String stripSignature(String string) {
        String string2 = RobustHyperlink.getSignature(string);
        if (string2 != null) {
            int n = string.indexOf(string2);
            return new StringBuffer().append(string.substring(0, n)).append(string.substring(n + string2.length())).toString();
        }
        return string;
    }

    public static String getSignature(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = string.indexOf(PARAMETER);
        if (n != -1) {
            int n2 = string.indexOf(38, n + PARAMETER.length());
            if (n2 == -1) {
                n2 = string.indexOf(35, n + PARAMETER.length());
            }
            --n;
            string2 = n2 == -1 ? string.substring(n) : string.substring(n, n2);
        }
        return string2;
    }

    public static String getSignatureWords(String string) {
        int n;
        String string2 = RobustHyperlink.getSignature(string);
        if (string2 != null && (n = string2.indexOf(PARAMETER)) != -1) {
            string2 = string2.substring(n + PARAMETER.length());
        }
        if (string2 != null) {
            string2 = URIs.decode(string2);
        }
        return string2;
    }

    private static Integer getInteger(int n) {
        Integer n2;
        if (n < 5000000) {
            int n3 = (n = n < 1000 ? 1000 : n / 1000 * 1000) / 1000 - 1;
            n2 = INTS_LITTLE[n3];
            if (n2 == null) {
                n2 = RobustHyperlink.INTS_LITTLE[n3] = new Integer(n);
            }
        } else if (n < 25000000) {
            int n4 = ((n = n / 10000 * 10000) - 5000000) / 10000;
            n2 = INTS_MEDIUM[n4];
            if (n2 == null) {
                n2 = RobustHyperlink.INTS_MEDIUM[n4] = new Integer(n);
            }
        } else {
            n2 = INT_MAX;
        }
        return n2;
    }

    private static void readCache() {
        if (sys2cnt_ != null) {
            return;
        }
        INTS_LITTLE = new Integer[5000];
        INTS_MEDIUM = new Integer[2000];
        InputStream inputStream = new byRelFreq().getClass().getResourceAsStream("words.txt");
        if (inputStream != null) {
            sys2cnt_ = RobustHyperlink.readCache(inputStream);
        }
        if (sys2cnt_ == null) {
            sys2cnt_ = new HashMap<String, Integer>(1000);
        }
        String[] stringArray = new String[]{"lt", "gt", "nbsp", "quot", "meta", "script", "style"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            sys2cnt_.put(stringArray[i].toLowerCase(), INT_MAX);
        }
        try {
            if (wordCache_ == null) {
                File file = File.createTempFile("xxx", "yyy");
                wordCache_ = new File(file.getParent(), "wordfreq.txt");
                file.delete();
                if (Verbose) {
                    System.out.println(new StringBuffer().append("words cached to ").append(wordCache_).toString());
                }
            }
            if (wordCache_.canRead()) {
                user2cnt_ = RobustHyperlink.readCache(new FileInputStream(wordCache_));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (user2cnt_ == null) {
            user2cnt_ = new HashMap<String, Integer>(1000);
        }
        if (!$assertionsDisabled && user2cnt_ == null) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> readCache(InputStream inputStream) {
        FilterInputStream filterInputStream = null;
        HashMap<String, Integer> hashMap = null;
        try {
            filterInputStream = new DataInputStream(new GZIPInputStream(new BufferedInputStream(inputStream)));
            int n = ((DataInputStream)filterInputStream).readInt();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            if (3 == n) {
                hashMap = new HashMap<String, Integer>(n2 * 2);
                for (int i = 0; i < n2; ++i) {
                    String string = ((DataInputStream)filterInputStream).readUTF();
                    int n3 = ((DataInputStream)filterInputStream).readInt();
                    hashMap.put(string, RobustHyperlink.getInteger(n3));
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hashMap;
    }

    public static void writeCache() {
        if (DEBUG && newwords_ > 0) {
            System.out.println(new StringBuffer().append("writing to ").append(wordCache_).toString());
        }
        if (wordCache_ == null) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(wordCache_.getAbsolutePath(), false))));
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(user2cnt_.size());
            for (Map.Entry<String, Integer> entry : user2cnt_.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                dataOutputStream.writeInt(entry.getValue());
            }
            dataOutputStream.close();
            newwords_ = 0;
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("writeCache ").append(iOException).toString());
        }
    }

    public static int getFreq(String string) {
        RobustHyperlink.readCache();
        Integer n = sys2cnt_.get(string);
        if (n != null) {
            return n;
        }
        n = user2cnt_.get(string);
        if (n != null) {
            return n;
        }
        n = INT_MAX;
        try {
            int n2;
            int n3;
            URL uRL = new URL(new StringBuffer().append(Engine).append(string).toString());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            char[] cArray = new char[HUNK_LEN];
            for (n2 = 0; n2 < HUNK_LEN && (n3 = ((Reader)bufferedReader).read(cArray, n2, cArray.length - n2)) > 0; n2 += n3) {
            }
            ((Reader)bufferedReader).close();
            String string2 = new String(cArray, 0, n2);
            int n4 = string2.indexOf(EngineHook);
            int n5 = Math.min(n4 + 200, string2.length());
            if (n4 != -1) {
                int n6;
                char c;
                int n7;
                boolean bl = false;
                int n8 = 0;
                for (n7 = n4; n7 < n5 && (!Character.isDigit(c = string2.charAt(n7)) || bl); ++n7) {
                    if (c == '<') {
                        bl = true;
                        continue;
                    }
                    if (!bl || c != '>') continue;
                    bl = false;
                }
                if (n7 == n5) {
                    bl = false;
                    n6 = Math.max(0, n4 - 200);
                    for (n7 = n4; n7 > n6 && (!Character.isDigit(c = string2.charAt(n7)) || bl); --n7) {
                        if (c == '<') {
                            bl = true;
                            continue;
                        }
                        if (!bl || c != '>') continue;
                        bl = false;
                    }
                    n5 = n7 + 1;
                    while (n7 > n6 && (Character.isDigit(c = string2.charAt(n7)) || c == ',')) {
                        --n7;
                    }
                    ++n7;
                }
                for (n6 = n7; n6 < n5; ++n6) {
                    c = string2.charAt(n6);
                    if (Character.isDigit(c)) {
                        n8 = n8 * 10 + (c - 48);
                        continue;
                    }
                    if (c != ',') break;
                }
                Integer n9 = n = n8 == 0 ? INT_MAX : RobustHyperlink.getInteger(n8);
                if (Verbose) {
                    System.out.print(new StringBuffer().append("new word '").append(string).append("' => ").append(n8).toString());
                } else if (Verbose) {
                    System.out.print(newwords_ == 0 ? "." : "Fetching words not in caches.");
                }
                if (Verbose) {
                    System.out.println(new StringBuffer().append("->").append(n).toString());
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        user2cnt_.put(string, n);
        ++newwords_;
        return n;
    }

    static List<String> filterWords(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            if (string == null || string.indexOf(64) != -1) continue;
            int n2 = 0;
            int n3 = string.length();
            while (n2 < n3) {
                while (n2 < n3 && !Character.isLetter(string.charAt(n2))) {
                    ++n2;
                }
                int n4 = n2;
                while (n2 < n3 && Character.isLetter(string.charAt(n2))) {
                    ++n2;
                }
                if (n2 - n4 <= MinWordLength) continue;
                String string2 = string.substring(n4, n2);
                arrayList.add(FoldCase ? string2.toLowerCase() : string2);
            }
        }
        return arrayList;
    }

    public static String computeSignature(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>(1000);
        Leaf leaf = node.getLastLeaf().getNextLeaf();
        for (Leaf leaf2 = node.getFirstLeaf(); leaf2 != leaf; leaf2 = leaf2.getNextLeaf()) {
            String string = leaf2.getParentNode().getName();
            if (string == "script" || string == "style") continue;
            arrayList.add(leaf2.getName());
        }
        return RobustHyperlink.computeSignature(arrayList);
    }

    public static String computeSignature(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        return RobustHyperlink.computeSignature(arrayList);
    }

    public static String computeSignature(List<String> list) {
        int n;
        int n2;
        if (list.size() == 0) {
            return "(empty word list)";
        }
        RobustHyperlink.readCache();
        list = RobustHyperlink.filterWords(list);
        int n3 = list.size() + 1;
        Object[] objectArray = list.toArray(new String[n3]);
        objectArray[n3 - 1] = String.valueOf('\uffff');
        Arrays.sort(objectArray);
        ArrayList<WordFreq> arrayList = new ArrayList<WordFreq>();
        Object object = objectArray[0];
        int n4 = 0;
        int n5 = n3;
        for (int i = 0; i < n5; ++i) {
            Object object2 = objectArray[i];
            if (((String)object2).equals(object)) {
                ++n4;
                continue;
            }
            int n6 = RobustHyperlink.getFreq((String)object);
            if (n6 < Integer.MAX_VALUE) {
                arrayList.add(new WordFreq((String)object, n4, n6));
            }
            object = object2;
            n4 = 1;
        }
        if (arrayList.size() == 0) {
            return "(no valid words)";
        }
        WordFreq[] wordFreqArray = new WordFreq[]{};
        WordFreq[] wordFreqArray2 = arrayList.toArray(wordFreqArray);
        int n7 = Math.min(SignatureLength, wordFreqArray2.length);
        if (0 == Algorithm_) {
            Arrays.sort(wordFreqArray2, new byRelFreq());
        } else if (2 == Algorithm_) {
            Arrays.sort(wordFreqArray2, new byWebFreq());
        } else if (3 == Algorithm_) {
            Random random = new Random();
            n2 = n7;
            for (n = 0; n < n2; ++n) {
                int n8 = random.nextInt(n2);
                WordFreq wordFreq = wordFreqArray2[n];
                wordFreqArray2[n] = wordFreqArray2[n8];
                wordFreqArray2[n8] = wordFreq;
            }
        } else if (4 == Algorithm_) {
            Random random = new Random();
            n7 = 0;
            n2 = wordFreqArray2.length;
            for (n = 0; n < n2; ++n) {
                WordFreq wordFreq = wordFreqArray2[n];
                if (wordFreq.webcnt >= 100000) continue;
                int n9 = random.nextInt(n7 + 1);
                wordFreqArray2[n] = wordFreqArray2[n7];
                wordFreqArray2[n7] = wordFreqArray2[n9];
                wordFreqArray2[n9] = wordFreq;
                ++n7;
            }
            n7 = Math.min(n7, SignatureLength);
        } else {
            Arrays.sort(wordFreqArray2, new byRoFreq());
        }
        if (Verbose) {
            System.out.println("* Rankings *");
            for (int i = 0; i < Math.min(25, wordFreqArray2.length); ++i) {
                System.out.println(wordFreqArray2[i]);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        n2 = n7;
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(wordFreqArray2[n].word);
            if (StudyOut == null) continue;
            StudyOut.print(new StringBuffer().append(wordFreqArray2[n].pagecnt).append("/").append(wordFreqArray2[n].webcnt).append(" ").toString());
        }
        if (StudyOut != null) {
            StudyOut.println();
        }
        if (Verbose && newwords_ > 0) {
            System.out.println();
        }
        if (newwords_ > 100) {
            RobustHyperlink.writeCache();
        }
        return stringBuffer.substring(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$phelps$net$RobustHyperlink == null ? (class$phelps$net$RobustHyperlink = RobustHyperlink.class$("phelps.net.RobustHyperlink")) : class$phelps$net$RobustHyperlink).desiredAssertionStatus();
        DEBUG = true;
        Verbose = true;
        StudyOut = null;
        wordCache_ = null;
        Engine = "http://www.altavista.com/web/results?kgs=0&kls=1&avkw=xytx&q=";
        EngineHook = "AltaVista found ";
        HUNK_LEN = 30720;
        FoldCase = true;
        MinWordLength = 4;
        SignatureLength = 10;
        Algorithm_ = 1;
        INT_MAX = new Integer(Integer.MAX_VALUE);
        sys2cnt_ = null;
        user2cnt_ = null;
        newwords_ = 0;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class byWebFreq
    implements Comparator<WordFreq> {
        byWebFreq() {
        }

        @Override
        public int compare(WordFreq wordFreq, WordFreq wordFreq2) {
            return wordFreq.pagecnt - wordFreq2.pagecnt;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((WordFreq)object, (WordFreq)object2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class byRoFreq
    implements Comparator<WordFreq> {
        byRoFreq() {
        }

        @Override
        public int compare(WordFreq wordFreq, WordFreq wordFreq2) {
            double d;
            double d2 = (double)wordFreq.webcnt / (double)Math.min(3, wordFreq.pagecnt);
            return d2 == (d = (double)wordFreq2.webcnt / (double)Math.min(3, wordFreq2.pagecnt)) ? 0 : (d2 < d ? -1 : 1);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((WordFreq)object, (WordFreq)object2);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class byRelFreq
    implements Comparator<WordFreq> {
        byRelFreq() {
        }

        @Override
        public int compare(WordFreq wordFreq, WordFreq wordFreq2) {
            double d = (double)wordFreq.webcnt / (double)wordFreq.pagecnt;
            double d2 = (double)wordFreq2.webcnt / (double)wordFreq2.pagecnt;
            return d == d2 ? 0 : (d < d2 ? -1 : 1);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((WordFreq)object, (WordFreq)object2);
        }
    }

    static class WordFreq {
        String word;
        int pagecnt;
        int webcnt;

        WordFreq(String string, int n, int n2) {
            this.word = string;
            this.pagecnt = n;
            this.webcnt = n2;
        }

        public String toString() {
            return this.word + "=" + this.pagecnt + "/" + this.webcnt;
        }
    }
}

