/*
 * Decompiled with CFR 0.152.
 */
package phelps.lang.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import phelps.lang.reflect.Attribute_info;
import phelps.lang.reflect.Code_attribute;
import phelps.lang.reflect.Cp_info;
import phelps.lang.reflect.Deprecated_attribute;
import phelps.lang.reflect.Field_info;
import phelps.lang.reflect.LocalVariableTable_attribute;
import phelps.lang.reflect.Method_info;
import phelps.lang.reflect.SourceFile_attribute;

public class ClassFile {
    static final boolean VERBOSE = true;
    static Map<String, ClassFile> loaded_;
    byte[] raw;
    int offset = 0;
    static final int ACC_PUBLIC = 1;
    static final int ACC_FINAL = 16;
    static final int ACC_SUPER = 32;
    static final int ACC_INTERFACE = 512;
    static final int ACC_ABSTRACT = 1024;
    public short minor_version;
    public short major_version;
    public Cp_info[] constant_pool;
    public short access_flags;
    public String this_class;
    public String super_class;
    public String[] interfaces;
    public Field_info[] fields;
    public Method_info[] methods;
    public Attribute_info[] attributes;
    public ClassFile component = null;
    public int dimensions = 0;
    public String pkg;
    static final /* synthetic */ boolean $assertionsDisabled;

    long readu8() {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l = l << 8 | (long)(this.raw[this.offset++] & 0xFF);
        }
        return l;
    }

    int readu4() {
        return this.readu(4);
    }

    short readu2() {
        return (short)this.readu(2);
    }

    byte readu1() {
        return this.raw[this.offset++];
    }

    int readuu1() {
        return this.readu1() & 0xFF;
    }

    private int readu(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = (n2 << 8) + (this.raw[this.offset++] & 0xFF);
        }
        return n2;
    }

    int getPosition() {
        return this.offset;
    }

    void setPosition(int n) {
        this.offset = n;
    }

    private ClassFile(String string) {
        this.this_class = string;
        this.super_class = null;
        this.raw = null;
    }

    public ClassFile(ClassFile classFile, int n) {
        this.component = classFile;
        this.dimensions = n;
    }

    public ClassFile(File file) throws IOException {
        this.raw = new byte[(int)file.length()];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.raw);
        fileInputStream.close();
        this.load();
    }

    public ClassFile(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.raw = byteArrayOutputStream.toByteArray();
        this.load();
    }

    public ClassFile(byte[] byArray) {
        this.raw = byArray;
        this.load();
    }

    protected void load() {
        int n;
        this.offset = 0;
        int n2 = this.readu4();
        if (n2 != -889275714) {
            throw new ClassFormatError("bad magic number: " + Integer.toHexString(n2));
        }
        this.minor_version = this.readu2();
        this.major_version = this.readu2();
        this.constant_pool = new Cp_info[this.readu2()];
        int n3 = this.constant_pool.length;
        for (n = 1; n < n3; ++n) {
            Cp_info cp_info = this.constant_pool[n] = new Cp_info(this);
            if (cp_info.tag != 5 && cp_info.tag != 6) continue;
            ++n;
        }
        this.access_flags = this.readu2();
        this.this_class = this.constant_pool[this.readu2()].getString(this.constant_pool, this).replace('/', '.');
        n = this.readu2();
        this.super_class = (n > 0 ? this.constant_pool[n].getString(this.constant_pool, this) : "").replace('/', '.');
        n = this.this_class.lastIndexOf(47);
        this.pkg = n != -1 ? this.this_class.substring(0, n) : "";
        this.interfaces = new String[this.readu2()];
        int n4 = this.interfaces.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.interfaces[n3] = this.constant_pool[this.readu2()].getString(this.constant_pool, this).replace('/', '.');
        }
        this.fields = new Field_info[this.readu2()];
        n4 = this.fields.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.fields[n3] = new Field_info(this.constant_pool, this);
        }
        this.methods = new Method_info[this.readu2()];
        n4 = this.methods.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.methods[n3] = new Method_info(this.constant_pool, this);
        }
        this.attributes = new Attribute_info[this.readu2()];
        n4 = this.attributes.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.attributes[n3] = this.getAttributeInfo(this.constant_pool);
        }
    }

    public int getModifiers() {
        return this.access_flags;
    }

    public String getSuperclass() {
        return this.super_class;
    }

    public String getName() {
        return this.this_class;
    }

    public String getPackage() {
        return this.pkg;
    }

    public Method_info[] getDeclaredMethods() {
        return this.methods;
    }

    public static String access2String(int n) {
        if (n == 0) {
            return "class ";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("interface ");
        } else {
            stringBuffer.append("class ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("abstract ");
        }
        return stringBuffer.substring(0);
    }

    public static String type2String(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(50);
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            String string2 = null;
            switch (c) {
                case 'B': {
                    string2 = "byte";
                    break;
                }
                case 'C': {
                    string2 = "char";
                    break;
                }
                case 'D': {
                    string2 = "double";
                    break;
                }
                case 'F': {
                    string2 = "float";
                    break;
                }
                case 'I': {
                    string2 = "int";
                    break;
                }
                case 'J': {
                    string2 = "long";
                    break;
                }
                case 'S': {
                    string2 = "short";
                    break;
                }
                case 'Z': {
                    string2 = "boolean";
                    break;
                }
                case 'V': {
                    string2 = "void";
                    break;
                }
                case 'L': {
                    ++n;
                    while ((c = string.charAt(n)) != ';') {
                        stringBuffer.append(c);
                        ++n;
                    }
                    stringBuffer.append(' ');
                    break;
                }
                case '[': {
                    ++n2;
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(c);
                    }
                    break;
                }
            }
            if (string2 == null) continue;
            stringBuffer.append(string2).append(' ');
        }
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("[]");
        }
        return stringBuffer.substring(0);
    }

    public static int sizeof(String string) {
        int n = 0;
        char c = string.charAt(0);
        switch (c) {
            case 'B': {
                ++n;
                break;
            }
            case 'C': {
                n += 8;
                break;
            }
            case 'F': {
                n += 4;
                break;
            }
            case 'I': {
                n += 4;
                break;
            }
            case 'J': {
                n += 8;
                break;
            }
            case 'S': {
                n += 2;
                break;
            }
            case 'Z': {
                ++n;
                break;
            }
            case 'V': {
                break;
            }
            case 'L': {
                n = 4;
                break;
            }
            case '[': {
                n = 4;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError(c);
                }
                break;
            }
        }
        return n;
    }

    Attribute_info getAttributeInfo(Cp_info[] cp_infoArray) {
        Attribute_info attribute_info;
        String string = cp_infoArray[this.readu2()].getString(cp_infoArray, this);
        int n = this.readu4();
        if ("Code".equals(string)) {
            attribute_info = new Code_attribute(cp_infoArray, this, string, this.offset);
        } else if ("SourceFile".equals(string)) {
            attribute_info = new SourceFile_attribute(cp_infoArray, this, string, this.offset);
        } else if ("LocalVariableTable".equals(string)) {
            attribute_info = new LocalVariableTable_attribute(cp_infoArray, this, string, this.offset);
        } else if ("Deprecated".equals(string)) {
            attribute_info = new Deprecated_attribute(cp_infoArray, string, this.offset);
        } else {
            attribute_info = new Attribute_info(cp_infoArray, string, this.offset);
            this.offset += n;
        }
        return attribute_info;
    }

    public Attribute_info getAttribute(Attribute_info[] attribute_infoArray, String string) {
        int n = attribute_infoArray.length;
        for (int i = 0; i < n; ++i) {
            if (!attribute_infoArray[i].attribute_name.equals(string)) continue;
            return attribute_infoArray[i];
        }
        return null;
    }

    public String toString() {
        return ClassFile.access2String(this.getModifiers()) + this.getName() + " extends " + this.getSuperclass();
    }

    public boolean isAssignableFrom(ClassFile classFile) {
        if (!$assertionsDisabled && classFile == null) {
            throw new AssertionError();
        }
        if (this.isArray()) {
            return this.dimensions == classFile.dimensions ? this.component.isAssignableFrom(classFile.component) : false;
        }
        String string = this.getName();
        boolean bl = classFile.getName().equals(string);
        ClassFile classFile2 = classFile;
        while (!bl && classFile2 != null) {
            String string2 = classFile2.getSuperclass();
            if (string2.equals(string)) {
                bl = true;
                continue;
            }
            classFile2 = loaded_.get(string2);
        }
        return bl;
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public boolean isPrimitive() {
        return this.raw == null && this.component == null;
    }

    public static ClassFile forName(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        ClassFile classFile = loaded_.get(string);
        if (classFile == null) {
            int n = 0;
            int n2 = string.length();
            for (int i = 0; i < n2 && string.charAt(i) == '['; ++i) {
                ++n;
            }
            if (n == 0) {
                classFile = new ClassFile(string);
            } else {
                ClassFile classFile2 = loaded_.get(string.substring(n));
                if (classFile2 != null) {
                    classFile = new ClassFile(classFile2, n);
                } else {
                    classFile = new ClassFile(string);
                    classFile.dimensions = n;
                }
                ClassFile.putPool(classFile);
            }
        }
        return classFile;
    }

    public static void putPool(ClassFile classFile) {
        if (!$assertionsDisabled && classFile == null) {
            throw new AssertionError();
        }
        loaded_.put(classFile.getName(), classFile);
    }

    static {
        $assertionsDisabled = !ClassFile.class.desiredAssertionStatus();
        loaded_ = new HashMap<String, ClassFile>(101);
        String[] stringArray = new String[]{"byte", "B", "short", "S", "int", "I", "long", "J", "float", "F", "double", "D", "boolean", "Z", "void", "V", "char", "C"};
        int n = stringArray.length;
        for (int i = 0; i < n; i += 2) {
            ClassFile classFile = new ClassFile(stringArray[i + 1]);
            ClassFile.putPool(classFile);
            loaded_.put(stringArray[i], classFile);
        }
    }
}

