/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStore {
    static final boolean DEBUG = true;
    public static final int VERSION = 1;
    static final String FREE_SFX = ".free";
    static final int INT_LENGTH = 4;
    static final int LONG_LENGTH = 8;
    static final int HEADER_LENGTH = 1024;
    static final int HEADER_USED = 12;
    static final int NODE_OVERHEAD = 6;
    static final int ENTRY_OVERHEAD = 12;
    Node root_;
    String filename_;
    int blockSize_;
    int maxrec_;
    Map<Integer, SoftReference<Node>> cache_ = new HashMap<Integer, SoftReference<Node>>(100);
    Set<Node> dirty_ = new HashSet<Node>(10);
    List<Integer> recycle_;
    RandomAccessFile raf_;
    static /* synthetic */ Class class$phelps$io$KeyStore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public KeyStore(String string) throws IOException {
        this(string, 8192);
    }

    public KeyStore(String string, int n) throws IOException {
        this.filename_ = string;
        this.raf_ = new RandomAccessFile(string, "rw");
        if (this.raf_ != null && this.raf_.length() > 0L) {
            this.raf_.seek(0L);
            int n2 = this.raf_.readInt();
            if (!$assertionsDisabled && n2 != 1) {
                throw new AssertionError((Object)new StringBuffer().append(n2).append(" != ").append(1).toString());
            }
            this.blockSize_ = this.raf_.readInt();
            this.maxrec_ = this.raf_.readInt();
            if (!$assertionsDisabled && 12L != this.raf_.getFilePointer()) {
                throw new AssertionError((Object)new StringBuffer().append("12 vs ").append(this.raf_.getFilePointer()).toString());
            }
            this.recycle_ = null;
            this.root_ = this.readNode(0);
        } else {
            this.blockSize_ = Math.max(n, 1024);
            this.maxrec_ = 0;
            this.root_ = new Node(this.maxrec_++);
            this.dirty_.add(this.root_);
            this.recycle_ = new ArrayList<Integer>(10);
        }
    }

    public long get(String string) throws IOException {
        List<Object> list = this.find(string);
        int n = (Integer)list.get(list.size() - 1);
        return n >= 0 ? ((Node)list.get((int)(list.size() - 2))).data[n] : -1L;
    }

    public void set(String string, long l) throws IOException {
        List<Object> list = this.find(string);
        int n = (Integer)list.get(list.size() - 1);
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        Node node = (Node)list.get(list.size() - 2);
        System.out.println(new StringBuffer().append("setKey ").append(string).append("/").append(l).append(" @ ").append(n).append(" in ").append(node).toString());
        if (node.data[n] != l) {
            node.data[n] = l;
            this.dirty_.add(node);
        }
    }

    public synchronized void insert(String string, long l) throws IOException {
        List<Object> list = this.find(string);
        int n = (Integer)list.remove(list.size() - 1);
        if (!$assertionsDisabled && n >= 0) {
            throw new AssertionError((Object)new StringBuffer().append(n).append(" for ").append(string).append("/").append(l).toString());
        }
        n = -n - 1;
        list.add(new Integer(n));
        this.insert(string, l, 0, 0, list);
    }

    void insert(String string, long l, int n, int n2, List<Object> list) {
        int n3 = (Integer)list.remove(list.size() - 1);
        if (!$assertionsDisabled && n3 < 0) {
            throw new AssertionError();
        }
        Node node = (Node)list.remove(list.size() - 1);
        int n4 = node.size() + 1;
        String[] stringArray = new String[n4];
        System.arraycopy(node.key, 0, stringArray, 0, n3);
        System.arraycopy(node.key, n3, stringArray, n3 + 1, n4 - 1 - n3);
        node.key = stringArray;
        long[] lArray = new long[n4];
        System.arraycopy(node.data, 0, lArray, 0, n3);
        System.arraycopy(node.data, n3, lArray, n3 + 1, n4 - 1 - n3);
        node.data = lArray;
        int[] nArray = new int[n4 + 1];
        System.arraycopy(node.child, 0, nArray, 0, n3);
        System.arraycopy(node.child, n3 + 1, nArray, n3 + 1 + 1, n4 - 1 - n3);
        node.child = nArray;
        node.key[n3] = string;
        node.data[n3] = l;
        node.child[n3] = n;
        node.child[n3 + 1] = n2;
        node.bytelen += KeyStore.countUTF(string) + 12;
        this.dirty_.add(node);
        if (node.bytelen > this.blockSize_) {
            int n5 = n4 / 2;
            System.out.println(new StringBuffer().append("split at ").append(n5).append(" with ").append(n4).append(" / ").append(node.bytelen).toString());
            String string2 = node.key[n5];
            long l2 = node.data[n5];
            int n6 = n4 - n5 - 1;
            System.out.println(new StringBuffer().append("  right ").append(n5 + 1).append("+").append(n6).toString());
            stringArray = new String[n6];
            System.arraycopy(node.key, n5 + 1, stringArray, 0, n6);
            lArray = new long[n6];
            System.arraycopy(node.data, n5 + 1, lArray, 0, n6);
            nArray = new int[n6 + 1];
            System.arraycopy(node.child, n5 + 1 + 1, nArray, 1, n6);
            nArray[0] = 0;
            Node node2 = new Node(this.getRecNum(), stringArray, lArray, nArray, -1);
            this.dirty_.add(node2);
            this.cache_.put(new Integer(node2.index), new SoftReference<Node>(node2));
            int n7 = n5;
            System.out.println(new StringBuffer().append("  left 0+").append(n7).toString());
            stringArray = new String[n7];
            System.arraycopy(node.key, 0, stringArray, 0, n7);
            node.key = stringArray;
            lArray = new long[n7];
            System.arraycopy(node.data, 0, lArray, 0, n7);
            node.data = lArray;
            nArray = new int[n7 + 1];
            System.arraycopy(node.child, 0, nArray, 0, n7);
            nArray[n7] = 0;
            node.child = nArray;
            node.computeBytelen();
            if (list.size() > 0) {
                System.out.println("splitting internal");
                this.insert(string2, l2, node.index, node2.index, list);
            } else {
                System.out.println(new StringBuffer().append("splitting root ").append(node.index).append("/").append(node2.index).toString());
                if (!($assertionsDisabled || node.index == 0 && node == this.root_)) {
                    throw new AssertionError(node.index);
                }
                Node node3 = new Node(this.getRecNum(), node);
                this.cache_.put(new Integer(node3.index), new SoftReference<Node>(node3));
                this.dirty_.add(node3);
                stringArray = new String[]{string2};
                lArray = new long[]{l2};
                nArray = new int[]{node3.index, node2.index};
                System.out.println(new StringBuffer().append("   ").append(nArray[0]).append(" ").append(string2).append("/").append(l2).append("  ").append(nArray[1]).toString());
                node.set(stringArray, lArray, nArray, -1);
                this.root_.dump();
            }
        }
    }

    public synchronized void remove(String stringArray) throws IOException {
        String[] stringArray2;
        int n;
        Node node;
        Node node2;
        List<Object> list = this.find((String)stringArray);
        int n2 = (Integer)list.remove(list.size() - 1);
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        Node node3 = (Node)list.remove(list.size() - 1);
        this.dirty_.add(node3);
        int n3 = node3.child[n2];
        int n4 = node3.child[n2 + 1];
        if (n3 > 0) {
            node2 = this.readNode(n3);
            node = node3;
            n = n2;
            while ((n4 = node2.child[node2.size()]) > 0) {
                node = node2;
                n = node2.size();
                node2 = this.readNode(node2.child[n4]);
            }
            node3.key[n2] = stringArray2 = node2.key[node2.size() - 1];
            node3.data[n2] = node2.data[node2.size() - 1];
            node3.bytelen += KeyStore.countUTF((String)stringArray2) - KeyStore.countUTF((String)stringArray);
            stringArray = stringArray2;
            node3 = node2;
            n2 = node2.size() - 1;
        } else if (n4 > 0) {
            node2 = this.readNode(n4);
            node = node3;
            n = n2 + 1;
            while ((n3 = node2.child[0]) > 0) {
                node = node2;
                n = 0;
                node2 = this.readNode(node2.child[n3]);
            }
            node3.key[n2] = stringArray2 = node2.key[0];
            node3.data[n2] = node2.data[0];
            node3.bytelen += KeyStore.countUTF((String)stringArray2) - KeyStore.countUTF((String)stringArray);
            stringArray = stringArray2;
            node3 = node2;
            n2 = 0;
        } else {
            n = (Integer)list.remove(list.size() - 1);
            node = (Node)list.remove(list.size() - 1);
        }
        int n5 = node3.size() - 1;
        stringArray2 = new String[n5];
        System.arraycopy(node3.key, 0, stringArray2, 0, n2);
        System.arraycopy(node3.key, n2 + 1, stringArray2, n2, n5 - n2);
        long[] lArray = new long[n5];
        System.arraycopy(node3.data, 0, lArray, 0, n2);
        System.arraycopy(node3.data, n2 + 1, lArray, n2, n5 - n2);
        if (!($assertionsDisabled || node3.child[n2] == 0 && node3.child[n2 + 1] == 0)) {
            throw new AssertionError((Object)new StringBuffer().append(node3.child[n2]).append(" ").append(node3.child[n2 + 1]).toString());
        }
        int[] nArray = new int[n5 + 1];
        System.arraycopy(node3.child, 0, nArray, 0, n2);
        System.arraycopy(node3.child, n2 + 1, nArray, n2, n5 - n2 + 1);
        node3.set(stringArray2, lArray, nArray, node3.bytelen - (12 + KeyStore.countUTF((String)stringArray)));
        this.dirty_.add(node3);
        int n6 = node3.bytelen;
        if (!$assertionsDisabled && n6 != node3.computeBytelen()) {
            throw new AssertionError((Object)new StringBuffer().append(n6).append(" != ").append(node3.computeBytelen()).toString());
        }
        if (n5 == 0 && node3 != this.root_) {
            System.out.println("empties Node");
            node.child[n] = 0;
            this.dirty_.add(node);
            Integer n7 = new Integer(node3.index);
            this.cache_.remove(n7);
            this.dirty_.remove(node3);
            this.recycle_.add(n7);
        }
    }

    List<Object> find(String string) throws IOException {
        Node node;
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        Node node2 = node = this.root_;
        do {
            int n;
            arrayList.add(node);
            node2 = node;
            int n2 = Arrays.binarySearch(node.key, string);
            if (n2 < 0 && node.child[n = -(n2 + 1)] > 0) {
                n2 = n;
                node = this.readNode(node.child[n]);
            }
            arrayList.add(new Integer(n2));
        } while (node2 != node);
        if (!$assertionsDisabled && arrayList.size() % 2 != 0) {
            throw new AssertionError(arrayList.size());
        }
        return arrayList;
    }

    Node readNode(int n) throws IOException {
        if (!($assertionsDisabled || n >= 0 && n < this.maxrec_)) {
            throw new AssertionError();
        }
        if (n == 0 && this.root_ != null) {
            return this.root_;
        }
        Integer n2 = new Integer(n);
        SoftReference<Node> softReference = this.cache_.get(n2);
        if (softReference != null && softReference.get() != null) {
            return softReference.get();
        }
        RandomAccessFile randomAccessFile = this.raf_;
        long l = 1024 + n * this.blockSize_;
        randomAccessFile.seek(l);
        int n3 = (this.raf_.read() << 8 | this.raf_.read()) & 0xFFFF;
        String[] stringArray = new String[n3];
        long[] lArray = new long[n3];
        int[] nArray = new int[n3 + 1];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.raf_.readInt();
            stringArray[i] = this.raf_.readUTF();
            lArray[i] = this.raf_.readLong();
        }
        nArray[n3] = this.raf_.readInt();
        Node node = new Node(n, stringArray, lArray, nArray, (int)(randomAccessFile.getFilePointer() - l));
        this.cache_.put(n2, new SoftReference<Node>(node));
        return node;
    }

    void writeNode(Node node) throws IOException {
        RandomAccessFile randomAccessFile = this.raf_;
        randomAccessFile.seek(1024 + node.index * this.blockSize_);
        int n = node.size();
        String[] stringArray = node.key;
        long[] lArray = node.data;
        int[] nArray = node.child;
        this.raf_.writeByte(n >> 8);
        this.raf_.writeByte(n);
        for (int i = 0; i < n; ++i) {
            randomAccessFile.writeInt(nArray[i]);
            randomAccessFile.writeUTF(stringArray[i]);
            randomAccessFile.writeLong(lArray[i]);
        }
        randomAccessFile.writeInt(nArray[n]);
    }

    public Iterator<String> iterator() {
        return new KeyIterator();
    }

    public Iterator<String> iterator(String string, String string2) {
        List<Object> list = null;
        if (string != null) {
            try {
                list = this.find(string);
            }
            catch (IOException iOException) {
                list = new ArrayList<Object>(0);
                string = null;
            }
        } else {
            Node node = this.root_;
            while (true) {
                list.add(node);
                list.add(new Integer(0));
                if (node.child[0] <= 0) break;
                try {
                    node = this.readNode(node.child[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
        }
        return new KeyIterator(list, string2);
    }

    int getRecNum() {
        int n;
        if (this.recycle_ == null) {
            String string = new StringBuffer().append(this.filename_).append(FREE_SFX).toString();
            if (new File(string).canRead()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
                    int n2 = randomAccessFile.readInt();
                    this.recycle_ = new ArrayList<Integer>(n2);
                    for (int i = 0; i < n2; ++i) {
                        this.recycle_.add(new Integer(randomAccessFile.readInt()));
                    }
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.recycle_ == null) {
                this.recycle_ = new ArrayList<Integer>(10);
            }
        }
        if (this.recycle_.size() > 0) {
            n = this.recycle_.remove(this.recycle_.size() - 1);
        } else {
            int n3 = this.maxrec_;
            n = n3;
            this.maxrec_ = n3 + 1;
        }
        return n;
    }

    void writeFree(List<Integer> list) throws IOException {
        String string = new StringBuffer().append(this.filename_).append(FREE_SFX).toString();
        if (new File(string).canWrite()) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
            int n = list.size();
            randomAccessFile.writeInt(n);
            for (int i = 0; i < n; ++i) {
                randomAccessFile.writeInt(list.get(i));
            }
            randomAccessFile.close();
        }
    }

    public void flush() throws IOException {
        Iterator<Node> iterator = this.dirty_.iterator();
        while (iterator.hasNext()) {
            this.writeNode(iterator.next());
        }
        this.dirty_.clear();
        this.raf_.seek(0L);
        this.raf_.writeInt(1);
        this.raf_.writeInt(this.blockSize_);
        this.raf_.writeInt(this.maxrec_);
        this.writeFree(this.recycle_);
    }

    public void close() throws IOException {
        this.flush();
        this.raf_.close();
    }

    static int countUTF(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n;
                continue;
            }
            if (c > '\u07ff') {
                n += 3;
                continue;
            }
            n += 2;
        }
        return n + 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$phelps$io$KeyStore == null ? (class$phelps$io$KeyStore = KeyStore.class$("phelps.io.KeyStore")) : class$phelps$io$KeyStore).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    implements Iterator<String> {
        List<Object> stack_ = new ArrayList<Object>(10);
        String lastkey_ = null;
        String endrange_ = null;
        Node node_;
        int index_;

        KeyIterator() {
            Node node = KeyStore.this.root_;
            while (node.child[0] > 0) {
                this.stack_.add(node);
                this.stack_.add(new Integer(0));
                try {
                    node = KeyStore.this.readNode(node.child[0]);
                }
                catch (IOException iOException) {
                    node = null;
                    break;
                }
            }
            this.node_ = node;
            this.index_ = 0;
        }

        KeyIterator(List<Object> list, String string) {
            this.index_ = (Integer)list.remove(list.size() - 1);
            this.node_ = (Node)list.remove(list.size() - 1);
            this.stack_ = list;
            this.endrange_ = string;
        }

        @Override
        public boolean hasNext() {
            return this.node_ != null;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.node_ == null) {
                throw new NoSuchElementException();
            }
            this.lastkey_ = this.node_.key[this.index_];
            ++this.index_;
            while (this.node_.child[this.index_] > 0) {
                this.stack_.add(this.node_);
                this.stack_.add(new Integer(this.index_));
                try {
                    this.node_ = KeyStore.this.readNode(this.node_.child[this.index_]);
                }
                catch (IOException iOException) {
                    this.node_ = null;
                }
                this.index_ = 0;
            }
            while (this.index_ == this.node_.size() && this.stack_.size() > 0) {
                this.index_ = (Integer)this.stack_.remove(this.stack_.size() - 1);
                this.node_ = (Node)this.stack_.remove(this.stack_.size() - 1);
            }
            if (this.index_ == this.node_.size() || this.lastkey_.equals(this.endrange_)) {
                this.node_ = null;
            }
            return this.lastkey_;
        }

        @Override
        public void remove() throws UnsupportedOperationException, IllegalStateException {
            if (this.lastkey_ == null) {
                throw new IllegalStateException();
            }
            boolean bl = this.node_ != null && Arrays.binarySearch(this.node_.key, this.lastkey_) >= 0;
            try {
                KeyStore.this.remove(this.lastkey_);
                this.lastkey_ = null;
                if (bl) {
                    --this.index_;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    class Node {
        int index;
        int bytelen = 6;
        String[] key;
        long[] data;
        int[] child;
        static final /* synthetic */ boolean $assertionsDisabled;

        Node(int n, String[] stringArray, long[] lArray, int[] nArray, int n2) {
            this.index = n;
            this.set(stringArray, lArray, nArray, n2);
        }

        Node(int n) {
            this(n, new String[0], new long[0], new int[1], 6);
        }

        Node(int n, Node node) {
            this(n, node.key, node.data, node.child, node.bytelen);
        }

        public void set(String[] stringArray, long[] lArray, int[] nArray, int n) {
            if (!($assertionsDisabled || stringArray != null && lArray != null && nArray != null && stringArray.length == lArray.length && stringArray.length == nArray.length - 1)) {
                throw new AssertionError();
            }
            this.child = nArray;
            this.key = stringArray;
            this.data = lArray;
            if (n >= 6) {
                this.bytelen = n;
            } else {
                this.computeBytelen();
            }
        }

        public int size() {
            return this.key.length;
        }

        public int computeBytelen() {
            int n = 6 + this.size() * 12;
            int n2 = this.size();
            for (int i = 0; i < n2; ++i) {
                n += KeyStore.countUTF(this.key[i]);
            }
            this.bytelen = n;
            return n;
        }

        public String toString() {
            return "#" + this.index + " " + this.size() + "/" + this.bytelen;
        }

        public void dump() {
            try {
                int n;
                int n2 = this.size();
                System.out.print("#" + this.index + " " + n2 + "/" + this.bytelen + ": ");
                if (n2 == 0) {
                    System.out.println();
                    return;
                }
                ArrayList<Node> arrayList = new ArrayList<Node>(10);
                for (n = 0; n < n2; ++n) {
                    System.out.print(" " + this.child[n] + " " + this.key[n] + "/" + this.data[n]);
                    if (this.child[n] <= 0) continue;
                    Node node = KeyStore.this.readNode(this.child[n]);
                    if (!$assertionsDisabled && this.child[n] != node.index) {
                        throw new AssertionError((Object)(this.child[n] + " vs " + node.index));
                    }
                    arrayList.add(node);
                }
                if (this.child[n2] > 0) {
                    arrayList.add(KeyStore.this.readNode(this.child[n2]));
                }
                System.out.println(" " + this.child[n2]);
                int n3 = arrayList.size();
                for (n = 0; n < n3; ++n) {
                    ((Node)arrayList.get(n)).dump();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception);
            }
        }

        static {
            $assertionsDisabled = !(class$phelps$io$KeyStore == null ? (class$phelps$io$KeyStore = KeyStore.class$("phelps.io.KeyStore")) : class$phelps$io$KeyStore).desiredAssertionStatus();
        }
    }
}

