/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;

public class InputStreams {
    public static final InputStream DEVNULL = new InputStream(){

        public int read() {
            return -1;
        }

        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) {
            return -1;
        }

        public long skip(long l) {
            return l;
        }

        public int available() {
            return Integer.MAX_VALUE;
        }

        public void close() {
        }

        public void mark(int n) {
        }

        public void reset() {
        }

        public boolean markSupported() {
            return true;
        }
    };

    private InputStreams() {
    }

    public static InputStream uncompress(InputStream inputStream, String string) throws IOException {
        String string2;
        int n = string.lastIndexOf(46);
        String string3 = string2 = n != -1 ? string.substring(n + 1) : string;
        if ("gzip".equals(string2) || "gz".equals(string2) || "Z".equals(string2) || "z".equals(string2)) {
            inputStream = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(string2) || "flate".equals(string2)) {
            inputStream = new InflaterInputStream(inputStream);
        } else if ("bz2".equals(string2) || "bzip2".equals(string2)) {
            inputStream = new CBZip2InputStream(inputStream);
        }
        return inputStream;
    }
}

