/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phelps.io.Streams;

public class Files {
    public static final int BUFSIZ = 32768;
    private static final String[] Z = new String[]{".gz", ".Z", ".z", ".bzip2", ".bz2"};
    static final Matcher zregex_ = Pattern.compile("\\.(gz|Z|z|bzip2|bz2)$").matcher("");
    static final Matcher zbkup_ = Pattern.compile("((?i)~|\\.bak|\\.bkup|\\.backup)(\\.(gz|Z|z|bzip2|bz2))?$").matcher("");

    private Files() {
    }

    public static File getFile(String string) {
        if (string.equals("~") || string.startsWith("~/") || string.startsWith("~\\")) {
            string = System.getProperty("user.home") + string.substring(1);
        }
        return new File(string);
    }

    public static File getCanonicalFile(String string) throws IOException {
        return Files.getFile(string).getCanonicalFile();
    }

    public static File getFuzzyFile(File file, String string) throws IOException {
        File file2;
        block8: {
            File file3;
            block9: {
                file2 = new File(string);
                if (file2.exists()) {
                    return file2.getCanonicalFile();
                }
                if (string.equals("~") || string.startsWith("~/") || string.startsWith("~\\")) {
                    string = System.getProperty("user.home") + string.substring(1);
                    file2 = new File(string);
                }
                if (file != null && !file2.isAbsolute()) {
                    file2 = new File(file, string);
                }
                if (file2.exists() && file2.isDirectory()) {
                    file3 = new File(string + "index.html");
                    if (file3.exists()) {
                        file2 = file3;
                    } else {
                        file3 = new File(string + "index.htm");
                        if (file3.exists()) {
                            file2 = file3;
                        }
                    }
                }
                if (file2.exists()) break block8;
                if (!Files.isCompressed(string)) break block9;
                file3 = new File(string = string.substring(0, string.lastIndexOf(46)));
                if (!file3.exists()) break block8;
                file2 = file3;
                break block8;
            }
            int n = Z.length;
            for (int i = 0; i < n; ++i) {
                file3 = new File(string + Z);
                if (!file3.exists()) continue;
                file2 = file3;
                break;
            }
        }
        return file2.getCanonicalFile();
    }

    public static String relative(File file, File file2) throws IOException {
        String string;
        String string2;
        char c = File.separatorChar;
        file2 = Files.getCanonicalFile(file2.toString());
        String string3 = file2.toString();
        if (file2.isDirectory()) {
            string3 = string3 + c;
        }
        String string4 = string3;
        if (file != null) {
            int n;
            file = Files.getCanonicalFile(file.toString());
            string2 = file.toString();
            if (file.isDirectory()) {
                string2 = string2 + c;
            }
            int n2 = string2.length();
            int n3 = string3.length();
            int n4 = Math.min(n2, n3);
            for (n = 0; n < n4 && string2.charAt(n) == string3.charAt(n); ++n) {
            }
            --n;
            while (n > 0 && string3.charAt(n) != c) {
                --n;
            }
            StringBuffer stringBuffer = new StringBuffer(n3);
            for (int i = ++n; i < n2; ++i) {
                if (string2.charAt(i) != c) continue;
                stringBuffer.append("..").append(c);
            }
            stringBuffer.append(string3.substring(n));
            string4 = stringBuffer.toString();
        }
        if (string3.startsWith(string2 = System.getProperty("user.home")) && (string = "~" + string3.substring(string2.length())).length() < string4.length()) {
            string4 = string;
        }
        return string4;
    }

    public static boolean isCompressed(String string) {
        zregex_.reset(string);
        return zregex_.find();
    }

    public static boolean isBackup(String string) {
        zbkup_.reset(string);
        return zbkup_.find();
    }

    public static byte[] toByteArray(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        Streams.copy(new FileInputStream(file), byteArrayOutputStream, true);
        return byteArrayOutputStream.toByteArray();
    }

    public static void copy(File file, File file2) throws IOException {
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (!file.canRead()) {
            throw new IOException(file.getPath() + " not readable");
        }
        if (file.equals(file2)) {
            return;
        }
        File file3 = file2.getParentFile();
        if (!file3.exists()) {
            file2.mkdirs();
        }
        Streams.copy(new FileInputStream(file), new FileOutputStream(file2), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean secureDelete(File file) throws IOException {
        if (!file.canWrite()) {
            return false;
        }
        Random random = new Random();
        byte[] byArray = new byte[32768];
        long l = file.length();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            for (int i = 0; i < 10; ++i) {
                for (long j = l; j > 0L; j -= (long)byArray.length) {
                    random.nextBytes(byArray);
                    randomAccessFile.write(byArray, 0, (int)Math.min(j, (long)byArray.length));
                }
            }
        }
        finally {
            randomAccessFile.close();
        }
        return file.delete();
    }
}

