/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import phelps.io.Files;
import phelps.lang.Strings;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileList {
    static final boolean DEBUG = false;
    FileFilter filter_;
    List<File> base_;
    boolean fsort_ = true;
    boolean fdirsfirst_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$phelps$io$FileList;

    public FileList(String string, FileFilter fileFilter) {
        this(new String[]{string}, fileFilter);
    }

    public FileList(String[] stringArray, FileFilter fileFilter) {
        this(stringArray, 0, fileFilter);
    }

    public FileList(String[] stringArray, int n, FileFilter fileFilter) {
        this(FileList.s2f(stringArray, n), fileFilter);
    }

    private static File[] s2f(String[] stringArray, int n) {
        if (!($assertionsDisabled || stringArray != null && n >= 0)) {
            throw new AssertionError();
        }
        File[] fileArray = new File[stringArray.length - n];
        int n2 = stringArray.length;
        for (int i = n; i < n2; ++i) {
            fileArray[i - n] = Files.getFile(stringArray[i]);
        }
        return fileArray;
    }

    public FileList(File file, FileFilter fileFilter) {
        this(new File[]{file}, fileFilter);
    }

    public FileList(File[] fileArray, FileFilter fileFilter) {
        this.base_ = Arrays.asList((File[])fileArray.clone());
        this.filter_ = fileFilter;
    }

    public void addFile(File file) {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        this.base_.add(file);
    }

    public void setSorted(boolean bl) {
        this.fsort_ = bl;
    }

    public void setDirsFirst(boolean bl) {
        this.fdirsfirst_ = bl;
    }

    private boolean accept(File file) {
        return this.filter_ == null || this.filter_.accept(file);
    }

    public Iterator<File> iterator() {
        return this.depthFirstIterator();
    }

    public Iterator<File> depthFirstIterator() {
        return new dfs();
    }

    public Iterator<File> breadthFirstIterator() {
        return new bfs();
    }

    public File[] listFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(100);
        File[] fileArray = this.iterator();
        while (fileArray.hasNext()) {
            arrayList.add(fileArray.next());
        }
        fileArray = new File[arrayList.size()];
        arrayList.toArray(fileArray);
        return fileArray;
    }

    public long length() {
        long l = 0L;
        Iterator<File> iterator = this.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.isFile()) continue;
            l += file.length();
        }
        return l;
    }

    public boolean delete() {
        boolean bl = true;
        Iterator<File> iterator = this.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            bl = file.delete() && bl;
        }
        return bl;
    }

    public void copy(File file) throws IOException {
        Iterator<File> iterator = this.iterator();
        while (iterator.hasNext()) {
            File file2 = iterator.next();
            File file3 = new File(file, file2.getPath());
            Files.copy(file2, file3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$phelps$io$FileList == null ? (class$phelps$io$FileList = FileList.class$("phelps.io.FileList")) : class$phelps$io$FileList).desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class bfs
    implements Iterator<File> {
        List<File> q_ = new LinkedList<File>();
        File next_ = null;
        Comparator<File> comp_;

        bfs() {
            this.comp_ = new FileOrder(FileList.this.fsort_, FileList.this.fdirsfirst_);
            this.q_.addAll(FileList.this.base_);
        }

        @Override
        public boolean hasNext() {
            while (this.q_.size() > 0 && this.next_ == null) {
                File file = this.q_.remove(0);
                if (file.isDirectory()) {
                    if (file.canRead()) {
                        File[] fileArray = file.listFiles();
                        Arrays.sort(fileArray, this.comp_);
                        for (File file2 : fileArray) {
                            if (!FileList.this.accept(file2) && !file2.isDirectory()) continue;
                            this.q_.add(file2);
                        }
                    }
                    if (!FileList.this.accept(file)) continue;
                    this.next_ = file;
                    continue;
                }
                this.next_ = file;
            }
            return this.next_ != null;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            File file = this.next_;
            this.next_ = null;
            return file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class dfs
    implements Iterator<File> {
        List<File> q_ = new ArrayList<File>(100);
        File next_ = null;
        Comparator<File> comp_;

        dfs() {
            this.comp_ = new FileOrder(FileList.this.fsort_, FileList.this.fdirsfirst_);
            for (int i = FileList.this.base_.size() - 1; i >= 0; --i) {
                this.q_.add(FileList.this.base_.get(i));
            }
        }

        @Override
        public boolean hasNext() {
            while (this.q_.size() > 0 && this.next_ == null) {
                File file = this.q_.remove(this.q_.size() - 1);
                if (file.isDirectory()) {
                    if (file.canRead()) {
                        File[] fileArray = file.listFiles();
                        Arrays.sort(fileArray, this.comp_);
                        for (int i = fileArray.length - 1; i >= 0; --i) {
                            File file2 = fileArray[i];
                            if (!FileList.this.accept(file2) && !file2.isDirectory()) continue;
                            this.q_.add(file2);
                        }
                    }
                    if (!FileList.this.accept(file)) continue;
                    this.next_ = file;
                    continue;
                }
                this.next_ = file;
            }
            return this.next_ != null;
        }

        @Override
        public File next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            File file = this.next_;
            this.next_ = null;
            return file;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.next();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileOrder
    implements Comparator<File> {
        private boolean fsort_;
        private boolean fdir_;

        FileOrder(boolean bl, boolean bl2) {
            this.fsort_ = bl;
            this.fdir_ = bl2;
        }

        @Override
        public int compare(File file, File file2) {
            if (this.fdir_) {
                boolean bl = file.isDirectory();
                boolean bl2 = file2.isDirectory();
                if (bl && !bl2) {
                    return -1;
                }
                if (!bl && bl2) {
                    return 1;
                }
            }
            if (this.fsort_) {
                return Strings.DICTIONARY_CASE_INSENSITIVE_ORDER.compare(file.getName(), file2.getName());
            }
            return 0;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }
    }
}

