/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import phelps.io.RandomAccess;
import phelps.net.URIs;

public class ByteArrayRAF
implements RandomAccess {
    private String mode_;
    private static final File READABLE_FILE;
    private byte[] buf_;
    private long pos_ = 0L;
    private long length_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ByteArrayRAF(byte[] byArray, String string) throws FileNotFoundException {
        this.buf_ = byArray;
        this.length_ = byArray.length;
        this.mode_ = string;
    }

    public ByteArrayRAF(InputStream inputStream, String string) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        this.buf_ = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        inputStream.close();
        this.mode_ = string;
        this.length_ = this.buf_.length;
    }

    private void resize(long l) {
        if (l != (long)this.buf_.length) {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.buf_, 0, byArray, 0, (int)Math.min((long)this.buf_.length, l));
            this.buf_ = byArray;
        }
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.getFilePointer() == this.length()) {
            return -1;
        }
        n2 = Math.min(n2, (int)(this.length() - this.getFilePointer()));
        System.arraycopy(this.buf_, (int)this.pos_, byArray, n, n2);
        this.pos_ += (long)n2;
        return n2;
    }

    public int read() {
        return this.getFilePointer() < this.length() ? this.buf_[(int)this.pos_++] & 0xFF : -1;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.read(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.read(byArray, n, n2);
    }

    public void writeString8(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    public void writeString16(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeChar(char c) throws IOException {
        this.write(c >> 8);
        this.write(c);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mode_.indexOf("w") != -1) {
            throw new IOException("File not opened for writing");
        }
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        long l = Math.max(this.getFilePointer() + (long)n2, this.length());
        if (l > (long)this.buf_.length) {
            this.resize(l + 102400L);
            this.length_ = l;
        }
        System.arraycopy(byArray, n, this.buf_, (int)this.pos_, n2);
        this.pos_ += (long)n2;
    }

    public void write(int n) throws IOException {
        if (this.mode_.indexOf("w") != -1) {
            throw new IOException("File not opened for writing");
        }
        if (this.getFilePointer() + 1L > (long)this.buf_.length) {
            this.resize(this.length() + 102400L);
            ++this.length_;
        }
        this.buf_[(int)this.pos_++] = (byte)n;
    }

    public long getFilePointer() {
        return this.pos_;
    }

    public void setLength(long l) {
        if (!$assertionsDisabled && l < 0L) {
            throw new AssertionError();
        }
        this.resize((int)l);
        this.length_ = l;
    }

    public long length() {
        return this.length_;
    }

    public void seek(long l) {
        this.pos_ = Math.max(0L, Math.min(this.length(), l));
        if (!$assertionsDisabled && l != this.pos_) {
            throw new AssertionError((Object)(l + " != " + this.pos_));
        }
    }

    public int skipBytes(int n) throws IOException {
        long l = this.getFilePointer();
        this.seek(l + (long)n);
        return (int)(this.getFilePointer() - l);
    }

    public void close() {
        this.buf_ = null;
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[(int)this.length_];
        System.arraycopy(this.buf_, 0, byArray, 0, (int)this.length_);
        return byArray;
    }

    static {
        $assertionsDisabled = !ByteArrayRAF.class.desiredAssertionStatus();
        String string = new Integer(0).getClass().getResource("Integer.class").getPath();
        int n = string.indexOf(33);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("file:")) {
            string = string.substring("file:".length());
        }
        READABLE_FILE = new File(URIs.decode(string));
    }
}

