/*
 * Decompiled with CFR 0.152.
 */
package phelps.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import phelps.io.RandomAccess;

public class BufferedRandomAccessFile
extends RandomAccessFile
implements RandomAccess {
    private static final int READ_MIN = 32768;
    private byte[] buf_;
    private int bufi_;
    private long fp_ = 0L;
    private int limit_ = 0;
    private boolean dirty_ = false;
    private long length_ = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BufferedRandomAccessFile(File file, String string) throws FileNotFoundException {
        this(file, string, 32768);
    }

    public BufferedRandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(string, string2, 32768);
    }

    public BufferedRandomAccessFile(String string, String string2, int n) throws FileNotFoundException {
        this(new File(string), string2, n);
    }

    public BufferedRandomAccessFile(File file, String string, int n) throws FileNotFoundException {
        super(file, string);
        int n2 = Math.min(Math.max(n, 1), 32768);
        if ("r".equals(string)) {
            try {
                n2 = (int)Math.min((long)n2, this.length());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.buf_ = new byte[n2];
        this.limit_ = 0;
        this.bufi_ = 0;
    }

    void invalidate() throws IOException {
        this.flush();
        this.fp_ += (long)this.bufi_;
        this.limit_ = 0;
        this.bufi_ = 0;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.limit_ != -1 && this.limit_ < this.bufi_) {
            throw new AssertionError((Object)(this.limit_ + " < " + this.bufi_));
        }
        int n4 = Math.min(this.limit_ - this.bufi_, n2);
        if (n4 > 0) {
            System.arraycopy(this.buf_, this.bufi_, byArray, n, n4);
            this.bufi_ += n4;
            n3 = n4;
        } else if (n2 == 0) {
            n3 = 0;
        } else if (this.limit_ == -1) {
            n3 = -1;
        } else {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            this.limit_ = super.read(this.buf_, 0, this.buf_.length);
            n3 = this.read(byArray, n, n2);
        }
        if (!$assertionsDisabled && n3 != -1 && n3 < 1 && n2 != 0) {
            throw new AssertionError();
        }
        return n3;
    }

    public int read() throws IOException {
        int n;
        if (this.bufi_ < this.limit_) {
            n = this.buf_[this.bufi_++] & 0xFF;
        } else if (this.limit_ == -1) {
            n = -1;
        } else {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            this.limit_ = super.read(this.buf_, 0, this.buf_.length);
            if (this.limit_ == 0) {
                n = super.read();
                ++this.fp_;
            } else {
                n = this.read();
            }
        }
        return n;
    }

    public void writeString8(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    public void writeString16(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = Math.min(this.buf_.length - this.bufi_, n2);
        if (n3 > 0) {
            System.arraycopy(byArray, n, this.buf_, this.bufi_, n3);
            this.bufi_ += n3;
            this.limit_ = Math.max(this.bufi_, this.limit_);
            this.dirty_ = true;
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            if (n2 < this.buf_.length) {
                this.write(byArray, n, n2);
            } else {
                if (!$assertionsDisabled && this.fp_ != super.getFilePointer()) {
                    throw new AssertionError((Object)(this.fp_ + " != " + super.getFilePointer()));
                }
                super.write(byArray, n, n2);
                this.fp_ += (long)n2;
            }
        }
        if (this.fp_ + (long)this.bufi_ > this.length_) {
            this.length_ = this.fp_ + (long)this.bufi_;
        }
    }

    public void write(int n) throws IOException {
        if (this.bufi_ >= this.limit_) {
            if (this.limit_ < this.buf_.length) {
                if (this.limit_ == -1) {
                    this.limit_ = 0;
                }
                if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                    throw new AssertionError();
                }
                ++this.limit_;
            } else {
                if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                    throw new AssertionError();
                }
                this.invalidate();
                this.limit_ = 1;
            }
        }
        this.buf_[this.bufi_++] = (byte)n;
        this.dirty_ = true;
        if (this.fp_ + (long)this.bufi_ > this.length_) {
            this.length_ = this.fp_ + (long)this.bufi_;
        }
    }

    public void flush() throws IOException {
        if (!this.dirty_) {
            return;
        }
        super.seek(this.fp_);
        super.write(this.buf_, 0, this.limit_);
        this.dirty_ = false;
    }

    public long getFilePointer() throws IOException {
        return this.fp_ + (long)(this.limit_ >= 0 ? this.bufi_ : 0);
    }

    public void setLength(long l) throws IOException {
        if (!$assertionsDisabled && l < 0L) {
            throw new AssertionError(l);
        }
        if (l == this.length()) {
            return;
        }
        this.invalidate();
        super.setLength(l);
        this.length_ = l;
        if (this.fp_ > l) {
            this.fp_ = l;
        }
        super.seek(this.fp_);
    }

    public long length() throws IOException {
        if (this.length_ < 0L) {
            this.length_ = super.length();
        }
        return this.length_;
    }

    public void seek(long l) throws IOException {
        long l2 = this.length();
        if (this.fp_ <= l && l < this.fp_ + (long)this.limit_) {
            this.bufi_ = (int)(l - this.fp_);
        } else if (l2 - 32768L <= l && l <= l2) {
            this.invalidate();
            int n = Math.min((int)Math.min((long)this.buf_.length, l2), 32768);
            super.seek(l2 - (long)n);
            this.readFully(this.buf_, 0, n);
            this.limit_ = n;
            this.fp_ = l2 - (long)this.limit_;
            this.bufi_ = (int)(l - this.fp_);
        } else {
            this.invalidate();
            super.seek(l);
            this.fp_ = l;
        }
        if (!($assertionsDisabled || this.fp_ + (long)this.bufi_ == l && this.bufi_ >= 0)) {
            throw new AssertionError((Object)(this.fp_ + " " + this.bufi_ + " " + l));
        }
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    static {
        $assertionsDisabled = !BufferedRandomAccessFile.class.desiredAssertionStatus();
    }
}

