/*
 * Decompiled with CFR 0.152.
 */
package phelps.awt;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Fonts {
    static final boolean DEBUG = false;
    public static final int FLAG_NOFLAG = 0;
    public static final int FLAG_FIXEDPITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALLCAP = 65536;
    public static final int FLAG_SMALLCAP = 131072;
    public static final int FLAG_FORCEBOLD = 262144;
    public static final int FLAG_DEFAULT = 34;
    private static final Font BASEFONT = new Font("Times", 0, 12);
    private static Map<String, String> stand2gs_ = new HashMap<String, String>(70);
    public static final String[] FAMILIES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    public static final String[] NORMALFAMILIES;

    public static String getNormalFamily(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        string = string.trim();
        String string3 = string.toLowerCase();
        int n = -1;
        if (n < 0 && "Symbol".equals(string) && File.separatorChar == '\\') {
            n = Arrays.binarySearch(FAMILIES, "Standard Symbols L");
        }
        if (n < 0) {
            n = Arrays.binarySearch(FAMILIES, string);
        }
        if (n < 0) {
            string2 = stand2gs_.get(string3);
            if (string2 != null) {
                n = Arrays.binarySearch(FAMILIES, string2);
            }
            if (string2 != null && n < 0 && string.indexOf(45) != -1 && Character.isUpperCase(new Font(string2, 0, 12).getPSName().charAt(0))) {
                return string2;
            }
        }
        if (n < 0) {
            string2 = string3;
            if (string.indexOf(32) != -1) {
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    if (string.charAt(i) == ' ') continue;
                    stringBuffer.append(string.charAt(i));
                }
                string2 = stringBuffer.toString();
            }
            n = Arrays.binarySearch(NORMALFAMILIES, string2);
        }
        if (n < 0) {
            int n3 = NORMALFAMILIES.length;
            for (int i = 0; i < n3; ++i) {
                if (!NORMALFAMILIES[i].startsWith(string3)) continue;
                n = i;
                break;
            }
        }
        return n >= 0 ? FAMILIES[n] : null;
    }

    public static Font createFont(String string, String string2, float f, int n) {
        String string3;
        String string4;
        String string5 = string;
        int n2 = string5.indexOf(44);
        if (n2 != -1) {
            string5 = string5.substring(0, n2);
        }
        if ((n2 = string5.indexOf(45)) != -1) {
            string5 = string5.substring(0, n2);
        }
        if ((n2 = string5.indexOf(43)) != -1) {
            string5 = string5.substring(n2 + 1);
        }
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(5);
        hashMap.put(TextAttribute.FAMILY, string);
        hashMap.put(TextAttribute.SIZE, new Float(f));
        String string6 = string.toLowerCase();
        hashMap.put(TextAttribute.POSTURE, string6.indexOf("italic") != -1 || string6.indexOf("oblique") != -1 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        hashMap.put(TextAttribute.WEIGHT, string6.indexOf("bold") != -1 ? TextAttribute.WEIGHT_BOLD : (string6.indexOf("heavy") != -1 ? TextAttribute.WEIGHT_HEAVY : (string6.indexOf("demi") != -1 ? TextAttribute.WEIGHT_DEMIBOLD : TextAttribute.WEIGHT_MEDIUM)));
        boolean bl = false;
        Font font = BASEFONT;
        if (!bl && (string4 = Fonts.getNormalFamily(string)) != null) {
            hashMap.remove(TextAttribute.POSTURE);
            hashMap.remove(TextAttribute.WEIGHT);
            hashMap.put(TextAttribute.FAMILY, string4);
            font = BASEFONT.deriveFont(hashMap);
            bl = true;
        }
        if (!bl && !string5.equals(string) && (string4 = Fonts.getNormalFamily(string5)) != null) {
            hashMap.put(TextAttribute.FAMILY, string4);
            font = BASEFONT.deriveFont(hashMap);
            bl = true;
        }
        if (!bl && string2 != null && (string3 = string2) != null && !string3.equals(string5) && (string4 = Fonts.getNormalFamily(string3)) != null) {
            hashMap.put(TextAttribute.FAMILY, string4);
            font = BASEFONT.deriveFont(hashMap);
            bl = true;
        }
        if (!bl) {
            int n3;
            for (int i = n3 = string5.length() - 1; i > 0; --i) {
                if (Character.isUpperCase(string5.charAt(i))) continue;
                if (i >= n3 || (string4 = Fonts.getNormalFamily(string5.substring(0, i + 1))) == null) break;
                hashMap.put(TextAttribute.FAMILY, string4);
                font = BASEFONT.deriveFont(hashMap);
                bl = true;
                break;
            }
        }
        if (!bl) {
            string3 = (n & 4) != 0 ? "Times" : ((n & 1) != 0 ? "Courier" : ((n & 2) != 0 ? "Times" : "Helvetica"));
            string4 = Fonts.getNormalFamily(string3);
            if (string4 == null) {
                string4 = "Lucida";
            }
            if ((n & 0x40) != 0) {
                hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if ((n & 0x40000) != 0) {
                hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            hashMap.put(TextAttribute.FAMILY, string4);
            font = BASEFONT.deriveFont(hashMap);
            bl = true;
        }
        return font;
    }

    static {
        Arrays.sort(FAMILIES, String.CASE_INSENSITIVE_ORDER);
        NORMALFAMILIES = new String[FAMILIES.length];
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = FAMILIES.length;
        for (int i = 0; i < n; ++i) {
            String string = FAMILIES[i];
            if (string.indexOf(32) != -1) {
                int n2 = string.length();
                for (int j = 0; j < n2; ++j) {
                    if (string.charAt(j) == ' ') continue;
                    stringBuffer.append(string.charAt(j));
                }
                string = stringBuffer.substring(0);
                stringBuffer.setLength(0);
            }
            Fonts.NORMALFAMILIES[i] = string.toLowerCase();
        }
        String[] stringArray = new String[]{"Century Schoolbook L", "NewCenturySchlbk", "Dingbats", "ZapfDingbats", "Nimbus Mono L", "Courier", "Nimbus Roman No9 L", "Times", "Nimbus Roman No9 L", "Times-Roman", "Nimbus Sans L", "Helvetica", "Standard Symbols L", "Symbol", "URW Bookman L", "Bookman", "URW Chancery L", "ZapfChancery", "URW Gothic L", "AvantGarde", "URW Palladio L", "Palatino", "Nimbus Roman No9 L Medium", "Times-Bold", "Nimbus Roman No9 L Medium Italic", "Times-BoldItalic"};
        int n3 = stringArray.length;
        for (n = 0; n < n3; n += 2) {
            stand2gs_.put(stringArray[n + 1].toLowerCase(), stringArray[n]);
        }
    }
}

