/*
 * Decompiled with CFR 0.152.
 */
package phelps.awt;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class Colors {
    public static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    static final Color[] sRGB = new Color[]{Color.BLACK, new Color(0, 128, 0), new Color(192, 192, 192), Color.GREEN, Color.GRAY, new Color(128, 128, 0), Color.WHITE, Color.YELLOW, new Color(128, 0, 0), new Color(0, 0, 128), Color.RED, Color.BLUE, new Color(128, 0, 128), new Color(0, 128, 128), new Color(255, 0, 255), new Color(0, 255, 255)};
    static final String[] sRGBNAME = new String[]{"Black", "Green", "Silver", "Lime", "Gray", "Olive", "White", "Yellow", "Maroon", "Navy", "Red", "Blue", "Purple", "Teal", "Fuchsia", "Aqua"};
    private static Map<String, Color> string2color = new HashMap<String, Color>(50);
    private static Map<Color, String> color2string = new HashMap<Color, String>(50);

    public static void addColor(String string, Object object) {
        Color color = null;
        color = object instanceof Color ? (Color)object : new Color(Integer.parseInt(((String)object).substring(1), 16));
        string2color.put(string.toLowerCase(), color);
        color2string.put(color, string);
    }

    public static String getName(Color color) {
        if (color == null) {
            return null;
        }
        String string = color2string.get(color);
        if (string == null) {
            string = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        return string;
    }

    public static Color getColor(String string) {
        return Colors.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Color color2 = null;
        if (string == null || string.indexOf("default") != -1) {
            color2 = color;
        } else if ("transparent".equalsIgnoreCase(string)) {
            color2 = null;
        } else {
            if (!string.startsWith("#")) {
                color2 = string2color.get(string.toLowerCase());
            }
            if (color2 == null) {
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = -1;
                int n6 = n4 = string.startsWith("#") ? 1 : 0;
                if (string.length() >= 6 + n4) {
                    try {
                        n5 = Integer.parseInt(string.substring(0 + n4, 6 + n4), 16);
                        n3 = (n5 & 0xFF0000) >> 16;
                        n2 = (n5 & 0xFF00) >> 8;
                        n = n5 & 0xFF;
                        color2 = new Color(n3, n2, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (color2 == null && string.length() >= 3 + n4) {
                    try {
                        n5 = Integer.parseInt(string.substring(0 + n4, 3 + n4), 16);
                        n3 = (n5 & 0xF00) >> 4;
                        n2 = n5 & 0xF0;
                        n = (n5 & 0xF) << 4;
                        color2 = new Color(n3, n2, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (color2 == null) {
                color2 = color;
            }
        }
        return color2;
    }

    static {
        Colors.addColor("Black", Color.BLACK);
        Colors.addColor("White", Color.WHITE);
        Colors.addColor("Blue", Color.BLUE);
        Colors.addColor("Cyan", Color.CYAN);
        Colors.addColor("DarkGray", Color.DARK_GRAY);
        Colors.addColor("Gray", Color.GRAY);
        Colors.addColor("Green", Color.GREEN);
        Colors.addColor("LightGray", Color.LIGHT_GRAY);
        Colors.addColor("Magenta", Color.MAGENTA);
        Colors.addColor("Orange", Color.ORANGE);
        Colors.addColor("Pink", Color.PINK);
        Colors.addColor("Red", Color.RED);
        Colors.addColor("Yellow", Color.YELLOW);
        int n = sRGB.length;
        for (int i = 0; i < n; ++i) {
            Colors.addColor(sRGBNAME[i], sRGB[i]);
        }
    }
}

