/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;
import multivalent.gui.VMenuButton;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zoom
extends Behavior {
    public static final String MSG_GET = "getZoom";
    public static final String MSG_SET = "setZoom";
    public static final String MSG_CREATE_ZOOM = "createWidget/Zoom";
    public static final String ATTR_ZOOMS = "zooms";
    public static final String ATTR_ZOOM = "zoom";
    int[] zooms_ = null;
    int zoom_ = 100;
    VRadiogroup rg_ = new VRadiogroup();
    boolean all_ = false;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            VMenuButton vMenuButton = (VMenuButton)this.createUI("menubutton", "Zoom", "event createWidget/Zoom", (INode)semanticEvent.getOut(), "View", false);
            vMenuButton.setDynamic("Zoom");
        } else if (MSG_CREATE_ZOOM == string) {
            this.rg_.clear();
            for (int n : this.zooms_) {
                VRadiobox vRadiobox = (VRadiobox)this.createUI("radiobox", new StringBuffer().append("Zoom ").append(n).append("%").toString(), new StringBuffer().append("event setZoom ").append(n).toString(), (INode)semanticEvent.getOut(), "Zoom", false);
                vRadiobox.setRadiogroup(this.rg_);
                if (this.zoom_ != n) continue;
                this.rg_.setActive(vRadiobox);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_GET == string) {
            semanticEvent.setArg(new Double(this.zoom_));
        } else if (MSG_SET == string) {
            Object object = semanticEvent.getArg();
            Browser browser = this.getBrowser();
            System.out.println(new StringBuffer().append(string).append(" => ").append(object).toString());
            double d = -1.0;
            int n = this.zoom_;
            if (object instanceof String) {
                try {
                    d = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (object instanceof Number) {
                d = ((Number)object).doubleValue();
            }
            if (0.0 < d && d <= 1.0) {
                this.zoom_ = (int)(d * 100.0);
            } else if (1.0 < d && d < 1600.0) {
                this.zoom_ = (int)d;
            }
            if (this.zoom_ != n) {
                browser.eventq("reloadDocumentPage", null);
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String[] stringArray = this.getAttr(ATTR_ZOOMS, "50,100,110,125,150,175,200,400").split("\\s*,\\s*");
        this.zooms_ = new int[stringArray.length];
        int n = this.zooms_.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.zooms_[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.zooms_[i] = 100;
            }
        }
        this.zoom_ = Integers.parseInt(this.getAttr(ATTR_ZOOM), 100);
    }
}

