/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CursorMark;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.node.LeafText;

public class StandardEdit
extends Behavior {
    public static final String MSG_CUT = "editCut";
    public static final String MSG_COPY = "editCopy";
    public static final String MSG_PASTE = "editPaste";
    public static final String MSG_CLEAR = "editClear";
    public static final String MSG_UNDO = "editUndo";
    public static final String MSG_REDO = "editRedo";
    public static final String MSG_SELECT_ALL = "editSelectAll";
    public static final String MENU_CATEGORY_EDIT = "edit";
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Edit" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            Span span = browser.getSelectionSpan();
            CursorMark cursorMark = browser.getCursorMark();
            this.createUI("button", "Cut", "event editCut", iNode, MENU_CATEGORY_EDIT, !span.isSet());
            this.createUI("button", "Copy", "event editCopy", iNode, MENU_CATEGORY_EDIT, !span.isSet());
            this.createUI("button", "Paste", "event editPaste", iNode, MENU_CATEGORY_EDIT, !cursorMark.isSet());
            this.createUI("button", "Clear", "event editClear", iNode, MENU_CATEGORY_EDIT, !span.isSet());
            this.createUI("button", "Select All", "event editSelectAll", iNode, MENU_CATEGORY_EDIT, false);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        Span span = browser.getSelectionSpan();
        Leaf leaf = null;
        Leaf leaf2 = null;
        int n = -1;
        int n2 = -1;
        if (span.isSet()) {
            leaf = span.getStart().leaf;
            leaf2 = span.getEnd().leaf;
            n = span.getStart().offset;
            n2 = span.getEnd().offset;
        }
        if (MSG_CUT == string) {
            if (span.isSet()) {
                leaf.cut(n, leaf2, n2);
            }
        } else if (MSG_COPY == string) {
            this.copy(span);
        } else if (MSG_PASTE == string) {
            this.paste();
        } else if (MSG_CLEAR != string && MSG_SELECT_ALL == string) {
            Document document = browser.getCurDocument();
            Leaf leaf3 = document.getFirstLeaf();
            Leaf leaf4 = document.getLastLeaf();
            browser.getSelectionSpan().move(leaf3, 0, leaf4, leaf4.size());
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    void copy(Span span) {
        if (!$assertionsDisabled && span == null) {
            throw new AssertionError();
        }
        if (!span.isSet()) {
            return;
        }
        Browser browser = this.getBrowser();
        String string = browser.clipboard();
        if (string.length() > 0) {
            StringSelection stringSelection = new StringSelection(string);
            browser.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
    }

    void paste() {
        Browser browser = this.getBrowser();
        INode iNode = browser.getScope();
        if (iNode == null) {
            return;
        }
        Span span = browser.getSelectionSpan();
        CursorMark cursorMark = browser.getCursorMark();
        Mark mark = null;
        Leaf leaf = span.getEnd().leaf;
        int n = span.getEnd().offset;
        if (span.isSet()) {
            mark = span.getEnd();
        } else if (cursorMark.isSet()) {
            mark = cursorMark.getMark();
        }
        if (mark == null) {
            return;
        }
        System.out.println("PASTE into " + mark.leaf.getName() + '/' + mark.offset);
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        System.out.println("Transferable = " + transferable);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                System.out.println("txt = " + string);
                if (mark.leaf instanceof LeafText) {
                    Leaf leaf2 = mark.leaf;
                    leaf2.insert(mark.offset, string, iNode);
                    cursorMark.move(leaf2, mark.offset);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                System.err.println(unsupportedFlavorException);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        if (span.isSet()) {
            span.getStart().leaf.delete(span.getStart().offset, leaf, n);
        }
    }

    static {
        $assertionsDisabled = !StandardEdit.class.desiredAssertionStatus();
    }
}

