/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VEntry;
import multivalent.gui.VScrollbar;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Multipage
extends Behavior {
    public static final String MSG_OPENPAGE = "openDocumentPage";
    public static final String MSG_OPENEDPAGE = "openedDocumentPage";
    public static final String MSG_CLOSEPAGE = "closeDocumentPage";
    public static final String MSG_RELOADPAGE = "reloadDocumentPage";
    public static final String MSG_NEXTPAGE = "nextPage";
    public static final String MSG_PREVPAGE = "previousPage";
    public static final String MSG_FIRSTPAGE = "firstDocumentPage";
    public static final String MSG_LASTPAGE = "lastDocumentPage";
    public static final String MSG_GOPAGE = "goPageNum";
    public static final int PAGECOUNT_UNKNOWN = Integer.MAX_VALUE;
    public static final int PAGECOUNT_NOT_APPLICABLE = Integer.MIN_VALUE;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        boolean bl;
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        Browser browser = this.getBrowser();
        Document document = browser.getCurDocument();
        int n = Integers.parseInt(document.getAttr("page"), 1);
        int n2 = Integers.parseInt(document.getAttr("pages"), Integer.MAX_VALUE);
        boolean bl2 = n <= 1;
        boolean bl3 = bl = n >= n2;
        if ("createWidget/Go" == string || "createWidget/DOCPOPUP" == string && semanticEvent.getIn() != this.getBrowser().getSelectionSpan()) {
            String string2 = "createWidget/Go" == string ? "Go" : "NAVIGATE";
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", "Next Page", "event nextPage", iNode, string2, bl);
            this.createUI("button", "Previous Page", "event previousPage", iNode, string2, bl2);
            this.createUI("button", "First Page", "event firstDocumentPage", iNode, string2, bl2);
            this.createUI("button", "Last Page", "event lastDocumentPage", iNode, string2, bl);
        } else if ("createWidget/Toolbar" == string) {
            if (n2 != Integer.MIN_VALUE) {
                INode iNode = (INode)semanticEvent.getOut();
                this.createUI("button", "<img src='systemresource:/sys/images/StepBack16.gif'>", "event previousPage", iNode, null, bl2);
                this.createUI("button", "<img src='systemresource:/sys/images/StepForward16.gif'>", "event nextPage", iNode, null, bl);
                String string3 = new StringBuffer().append("").append(n).toString();
                VEntry vEntry = (VEntry)this.createUI("entry", string3, "event goPageNum $TEXT", iNode, null, false);
                vEntry.setSizeChars(string3.length(), 1);
                if (n2 != Integer.MAX_VALUE) {
                    this.createUI("label", new StringBuffer().append(" of ").append(n2).toString(), null, iNode, null, false);
                }
            }
        } else if ("closeDocument" == string) {
            browser.event(new SemanticEvent(browser, MSG_CLOSEPAGE, null));
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object;
        Browser browser = this.getBrowser();
        Document document = browser.getCurDocument();
        boolean bl = "openedDocument" == string;
        int n = Integers.parseInt(document.getAttr("page"), 1);
        int n2 = Integers.parseInt(document.getAttr("pages"), Integer.MAX_VALUE);
        int n3 = n;
        if (MSG_OPENPAGE == string) {
            if (document.getAttr("page") != null) {
                document.removeAllChildren();
                document.getLayer("<scratch>").clear();
                document.getLayers().buildBeforeAfter(document);
                browser.setCurDocument(document);
            }
        } else if (MSG_GOPAGE == string) {
            object = semanticEvent.getArg();
            if (object instanceof String) {
                String string2 = ((String)object).trim();
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (object instanceof Integer) {
                n3 = (Integer)object;
            }
        } else if (n2 != Integer.MIN_VALUE) {
            if (bl) {
                n3 = Math.max(1, Math.min(n3, n2));
            } else if (MSG_PREVPAGE == string) {
                --n3;
            } else if (MSG_NEXTPAGE == string) {
                ++n3;
            } else if (MSG_FIRSTPAGE == string) {
                n3 = 1;
            } else if (n2 != Integer.MAX_VALUE && MSG_LASTPAGE == string) {
                n3 = n2;
            }
        }
        if ((n3 != n || MSG_RELOADPAGE == string || bl) && (n3 >= 1 && n3 <= n2 || n2 == Integer.MAX_VALUE || n2 == Integer.MIN_VALUE)) {
            if (!bl) {
                browser.event(new SemanticEvent(browser, MSG_CLOSEPAGE, Integer.toString(n)));
            }
            object = Integer.toString(n3);
            document.putAttr("page", object);
            document.setValid(false);
            document.getVsb().setValue(0);
            browser.eventq(MSG_OPENPAGE, object);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void buildAfter(Document document) {
        document.addObserver(this);
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        if (aWTEvent.getID() == 401) {
            int n = ((KeyEvent)aWTEvent).getKeyCode();
            Document document = this.getDocument();
            VScrollbar vScrollbar = document.getVsb();
            int n2 = Integers.parseInt(document.getAttr("page"), 1);
            int n3 = Integers.parseInt(document.getAttr("pages"), Integer.MAX_VALUE);
            Browser browser = this.getBrowser();
            if (n3 != Integer.MIN_VALUE) {
                if (n == 32 || n == 34) {
                    if (n2 < n3 && vScrollbar.getValue() + document.bbox.height >= vScrollbar.getMax()) {
                        browser.eventq(MSG_GOPAGE, Integer.toString(n2 + 1));
                        return true;
                    }
                } else if (n == 33) {
                    if (n2 > 0 && vScrollbar.getValue() == vScrollbar.getMin()) {
                        browser.eventq(MSG_GOPAGE, Integer.toString(n2 - 1));
                        browser.eventq("scrollTo", new Integer(Integer.MAX_VALUE));
                        return true;
                    }
                } else if (n == 36) {
                    System.out.println(new StringBuffer().append("go page ").append(n2).append("=>1").toString());
                    if (n2 > 1) {
                        browser.eventq(MSG_GOPAGE, new Integer(1));
                    }
                } else if (n == 35) {
                    if (n2 < n3) {
                        browser.eventq(MSG_GOPAGE, new Integer(n3));
                    }
                } else if (n == 37) {
                    if (n2 > 1 && !browser.getCursorMark().isSet()) {
                        browser.eventq(MSG_GOPAGE, new Integer(n2 - 1));
                    }
                } else if (n == 39 && n2 < n3 && !browser.getCursorMark().isSet()) {
                    browser.eventq(MSG_GOPAGE, new Integer(n2 + 1));
                }
            }
        }
        return false;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        String string;
        super.restore(eSISNode, map, layer);
        Document document = this.getDocument();
        document.removeAttr("page");
        URI uRI = document.getURI();
        String string2 = uRI.getFragment();
        if (string2 != null && (string = string2.toLowerCase()).startsWith("page")) {
            char c;
            int n = 0;
            int n2 = string.length() - 1;
            int n3 = 1;
            while (Character.isDigit(c = string.charAt(n2))) {
                n += (c - 48) * n3;
                --n2;
                n3 *= 10;
            }
            if (n > 0) {
                document.putAttr("page", Integer.toString(n));
            }
        }
    }
}

