/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Cache;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.MediaAdaptor;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.node.LeafAscii;
import multivalent.std.adaptor.MediaAdaptorReader;
import phelps.Utility;
import phelps.net.URIs;
import phelps.text.Formats;

public class History
extends Behavior {
    public static final String FILENAME = "History.txt";
    static final int MAX = 500;
    static final int PERIOD = 100;
    static final String FAULTID = "[FAULT]";
    static List<DocRec> lrulist_ = null;
    static Map<String, DocRec> hash_ = null;
    static int periodcnt_ = 0;
    List[] reclist_ = null;

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("closeDocument" == string) {
            if (periodcnt_++ > 100) {
                this.writeHistory();
                periodcnt_ = 0;
            }
        } else if ("EXIT" == string || "closeBrowserInstance" == string) {
            this.writeHistory();
            System.out.println("saving history");
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if (object != null) {
            if ("openedDocument" == string && object instanceof DocInfo) {
                this.readHistory();
                DocInfo docInfo = (DocInfo)object;
                Document document = docInfo.doc;
                URI uRI = docInfo.uri;
                if (uRI != null && !"history".equals(uRI.getScheme())) {
                    String string2 = docInfo.uri.toString();
                    DocRec docRec = hash_.get(string2);
                    if (docRec != null) {
                        lrulist_.remove(docRec);
                    } else {
                        docRec = new DocRec(string2);
                        hash_.put(string2, docRec);
                    }
                    docRec.title = document.getAttr("title");
                    docRec.date = System.currentTimeMillis();
                    lrulist_.add(0, docRec);
                }
            } else if ("openDocument" == string && object instanceof DocInfo) {
                DocInfo docInfo = (DocInfo)object;
                URI uRI = docInfo.uri;
                if (uRI != null && "history".equals(uRI.getScheme())) {
                    docInfo.doc.removeAllChildren();
                    this.displayHistory(docInfo, uRI);
                    docInfo.genre = "History";
                    docInfo.returncode = 200;
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayHistory(DocInfo docInfo, URI uRI) {
        Object object;
        this.readHistory();
        Browser browser = this.getBrowser();
        Document document = docInfo.doc;
        int n = lrulist_.size();
        String[] stringArray = new String[n];
        List[] listArray = new List[n];
        int n2 = 0;
        Object object2 = lrulist_.iterator();
        while (object2.hasNext()) {
            int n3;
            int n4;
            object = object2.next();
            String string = ((DocRec)object).uri;
            String string2 = null;
            if (string.startsWith("http://")) {
                n4 = 7;
                n3 = string.indexOf(47, n4 + 1);
                if (string.startsWith("http://www") || string.startsWith("http://http")) {
                    n4 = Math.max(n4, string.indexOf(46, n4 + 1) + 1);
                }
                if (n4 != -1) {
                    string2 = string.substring(n4, n3);
                }
            } else {
                n4 = string.indexOf(47);
                if (n4 != -1) {
                    string2 = string.substring(0, n4);
                }
            }
            if (string2 == null) continue;
            ArrayList<Object> arrayList = null;
            for (n3 = 0; n3 < n2; ++n3) {
                if (!string2.equals(stringArray[n3])) continue;
                arrayList = listArray[n3];
                break;
            }
            if (arrayList == null) {
                stringArray[n2] = string2;
                listArray[n2] = arrayList = new ArrayList<Object>(10);
                ++n2;
            }
            arrayList.add(object);
        }
        this.reclist_ = listArray;
        document.removeAllChildren();
        object2 = document.getLayer("base");
        object = (MediaAdaptorReader)Behavior.getInstance("helper", "HTML", null, (Layer)object2);
        try {
            ((MediaAdaptorReader)object).docURI = uRI;
            ((MediaAdaptorReader)object).setReader(new StringReader(this.toHTML(stringArray, n2, listArray)));
            ((MediaAdaptor)object).parse(document);
        }
        catch (Exception exception) {
            new LeafAscii("ERROR " + exception, null, document);
        }
        finally {
            try {
                ((MediaAdaptorReader)object).closeInputStream();
            }
            catch (IOException iOException) {}
        }
        browser.event(new SemanticEvent(this, "buildDocument", docInfo));
    }

    String toHTML(String[] stringArray, int n, List[] listArray) {
        int n2;
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append("<html>\n<head>");
        stringBuffer.append("<title>History</title>");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("\n<h2>Alphabetical Index</h2>\n");
        Object[] objectArray = new String[n];
        System.arraycopy(stringArray, 0, objectArray, 0, n);
        Arrays.sort(objectArray);
        char c = ((String)objectArray[0]).charAt(0);
        for (n2 = 0; n2 < n; ++n2) {
            Object object = objectArray[n2];
            char c2 = ((String)object).charAt(0);
            if (c2 != c) {
                stringBuffer.append("<br />");
                c = c2;
            } else if (n2 > 0) {
                stringBuffer.append(" / ");
            }
            stringBuffer.append("<a href='#").append((String)object).append("'>").append((String)object).append("</a>");
        }
        n2 = 0;
        stringBuffer.append("\n<h2>Chronological</h2>\n");
        for (int i = 0; i < n; ++i) {
            if (n2 != 0) {
                stringBuffer.append("<span behavior='OutlineSpan' id=").append(i).append(i < 0 ? " open" : "").append('>');
                stringBuffer.append("<h4><a name='").append(stringArray[i]).append("'>").append(stringArray[i]).append("</a>\t").append(listArray[i].size()).append("</h4>");
                stringBuffer.append("<p>").append(FAULTID).append("</p></span>");
                continue;
            }
            stringBuffer.append("<p>").append("<b><a name='").append(stringArray[i]).append("'>").append(stringArray[i]).append("</a></b>");
            Iterator iterator = listArray[i].iterator();
            while (iterator.hasNext()) {
                int n3;
                DocRec docRec = (DocRec)iterator.next();
                String string = docRec.uri;
                stringBuffer.append("<br>\n").append(docRec.title);
                int n4 = string.lastIndexOf(47);
                if (n4 + 1 == string.length()) {
                    n4 = string.lastIndexOf(47, n4 - 1);
                }
                if ((n3 = string.indexOf(63, n4 + 1)) == -1) {
                    n3 = string.length();
                }
                stringBuffer.append("   (<a href='").append(string).append("'>").append(string.substring(n4 + 1, n3)).append("</a>)  ");
                stringBuffer.append(Formats.relativeDate(docRec.date, l));
            }
        }
        stringBuffer.append("</body>\n</html>\n");
        return stringBuffer.toString();
    }

    public void readHistory() {
        if (lrulist_ != null) {
            return;
        }
        lrulist_ = new ArrayList<DocRec>(500);
        hash_ = new HashMap<String, DocRec>(1000);
        Cache cache = this.getGlobal().getCache();
        File file = cache.mapTo(null, FILENAME, 2);
        if (file.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf(32);
                    int n2 = string.indexOf(32, n + 1);
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1, n2);
                    String string4 = string.substring(n2 + 1);
                    string3 = URIs.decode(string3);
                    long l = -1L;
                    try {
                        l = Long.parseLong(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    DocRec docRec = new DocRec(string2, string3, l);
                    hash_.put(string2, docRec);
                    lrulist_.add(docRec);
                    cache.setSeen(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Utility.warning("can't read history list from " + file);
            }
        }
    }

    public void writeHistory() {
        if (lrulist_ == null) {
            return;
        }
        Cache cache = this.getGlobal().getCache();
        File file = cache.mapTo(null, FILENAME, 2);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Iterator<DocRec> iterator = lrulist_.iterator();
            for (int i = 0; iterator.hasNext() && i < 500; ++i) {
                DocRec docRec = iterator.next();
                bufferedWriter.write(docRec.uri + " " + URIs.encode(docRec.title) + " " + docRec.date);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            Utility.warning("can't write history list to " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node fault(int n, Span span, INode iNode) {
        Object object;
        Object object2;
        List list = this.reclist_[n];
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer(list.size() * 100);
        stringBuffer.append("<p>");
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            int n2;
            object2 = (DocRec)object3.next();
            object = ((DocRec)object2).uri;
            stringBuffer.append("\n<br>").append(((DocRec)object2).title);
            int n3 = ((String)object).lastIndexOf(47);
            if (n3 + 1 == ((String)object).length()) {
                n3 = ((String)object).lastIndexOf(47, n3 - 1);
            }
            if ((n2 = ((String)object).indexOf(63, n3 + 1)) == -1) {
                n2 = ((String)object).length();
            }
            stringBuffer.append("   (<a href='").append((String)object).append("'>").append(((String)object).substring(n3 + 1, n2)).append("</a>)  ");
            stringBuffer.append(Formats.relativeDate(((DocRec)object2).date, l));
            stringBuffer.append("\n");
        }
        object3 = (MediaAdaptorReader)Behavior.getInstance("helper", "HTML", null, this.getLayer());
        try {
            object2 = span.getStart().leaf;
            span.moveq(null);
            object = new Document("SPLASH", null, iNode);
            ((MediaAdaptorReader)object3).setReader(new StringReader(stringBuffer.toString()));
            INode iNode2 = (INode)((MediaAdaptor)object3).parse((INode)object);
            ((Node)object).remove();
            INode iNode3 = (INode)iNode2.childAt(1);
            INode iNode4 = iNode.getParentNode();
            iNode4.setChildAt(iNode3.childAt(1), iNode.childNum());
            Leaf leaf = iNode3.getLastLeaf();
            span.moveq(((Node)object2).getFirstLeaf(), 0, leaf, leaf.size());
            ((Node)object2).dump();
            iNode3.childAt(1).dump();
            System.out.println("OutlineSpan now " + span);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                ((MediaAdaptorReader)object3).closeInputStream();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private class DocRec {
        public String uri;
        public String title = null;
        public long date = -1L;

        DocRec(String string) {
            this.uri = string;
        }

        DocRec(String string, String string2, long l) {
            this.uri = string;
            this.title = string2;
            this.date = l;
        }

        public String toString() {
            return this.title + "  /  " + this.uri + " / " + this.date;
        }
    }
}

