/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.awt.AWTEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.node.LeafImage;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineSpan
extends Span {
    public static final String MSG_OPEN = "outlineOpen";
    public static final String MSG_OPEN_ALL = "outlineOpenAll";
    public static final String MSG_CLOSE = "outlineClose";
    public static final String MSG_CLOSE_ALL = "outlineCloseAll";
    public static final String MSG_TOGGLE = "outlineToggle";
    public static final String ATTR_LEVEL = "level";
    public static final String ATTR_OPEN = "open";
    static Image OPENED;
    static Image CLOSED;
    boolean closed_ = true;
    boolean trigger_ = false;
    public int level = 0;

    public boolean isOpen() {
        return !this.closed_;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (!context.elide && this.closed_) {
            context.elide = true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 3250 + this.level;
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        if (aWTEvent.getID() == 500 && (((MouseEvent)aWTEvent).getModifiers() & 0x10) != 0) {
            Browser browser = this.getBrowser();
            if (this.closed_) {
                browser.eventq(MSG_OPEN, this);
                System.out.println(new StringBuffer().append("click on level ").append(this.level).toString());
                browser.eventq("scrollTo", browser.getCurNode());
            } else {
                Node node2 = browser.getCurNode();
                if (node2 != null && node2.getParentNode() == this.getStart().leaf.getParentNode()) {
                    browser.eventq(MSG_CLOSE, this);
                }
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (MSG_OPEN_ALL == string) {
            this.setClosed(false);
        } else if (MSG_OPEN == string && this == semanticEvent.getArg()) {
            if (this.closed_) {
                this.setClosed(false);
                browser.event(new SemanticEvent(browser, "scrollTo", this.getStart().leaf));
                browser.getCursorMark().move(null, -1);
            }
        } else if (MSG_TOGGLE == string && this == semanticEvent.getArg()) {
            browser.eventq(new SemanticEvent(browser, this.closed_ ? MSG_OPEN : MSG_CLOSE, this));
        } else if (MSG_CLOSE_ALL == string) {
            this.setClosed(true);
        } else if (MSG_CLOSE == string && this == semanticEvent.getArg()) {
            this.setClosed(true);
        } else if (this.trigger_) {
            browser.eventq(MSG_OPEN, this);
            this.trigger_ = false;
        }
        return false;
    }

    public void setClosed(boolean bl) {
        if (bl == this.closed_) {
            return;
        }
        Browser browser = this.getBrowser();
        this.closed_ = bl;
        LeafImage leafImage = (LeafImage)this.getStart().leaf;
        leafImage.setImage(this.closed_ ? CLOSED : OPENED);
        this.markDirty();
        browser.repaint(50L);
    }

    @Override
    public void moveq(Leaf leaf, int n, Leaf leaf2, int n2) {
        if (leaf != null && !(leaf instanceof LeafImage)) {
            LeafImage leafImage = new LeafImage(null, null, null, this.closed_ ? CLOSED : OPENED);
            leaf.getParentNode().insertChildAt(leafImage, 0);
            leaf = leafImage;
            n = 0;
        }
        super.moveq(leaf, n, leaf2, n2);
        if (leaf != null) {
            ((LeafImage)leaf).setImage(this.closed_ ? CLOSED : OPENED);
        }
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.level = Integers.parseInt(this.getAttr(ATTR_LEVEL), 0);
        boolean bl = this.trigger_ = this.getAttr(ATTR_OPEN) != null;
        if (OPENED == null) {
            try {
                ImageIO.setUseCache(false);
                OPENED = ImageIO.read(this.getClass().getResourceAsStream("/sys/images/opened.xbm"));
                CLOSED = ImageIO.read(this.getClass().getResourceAsStream("/sys/images/closed.xbm"));
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
    }
}

