/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.util.Map;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Span;
import phelps.lang.Floats;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSpan
extends Span {
    public static final String ATTR_FAMILY = "family";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_STYLE = "style";
    public String family = null;
    public float size = -1.0f;
    public int style = -1;

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (this.family != null) {
            context.family = this.family;
        }
        if ((double)this.size > 0.0) {
            context.size = this.size;
        }
        if (this.style > 0) {
            context.style = this.style;
        }
        return false;
    }

    @Override
    public ESISNode save() {
        this.putAttr(ATTR_FAMILY, this.family);
        if ((double)this.size > 0.0) {
            this.putAttr(ATTR_SIZE, Float.toString(this.size));
        }
        if (this.style >= 0) {
            this.putAttr(ATTR_STYLE, Integer.toString(this.style));
        }
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.family = this.getAttr(ATTR_FAMILY, null);
        this.size = Floats.parseFloat(this.getAttr(ATTR_SIZE), 0.0f);
        this.style = Integers.parseInt(this.getAttr(ATTR_STYLE), -1);
    }
}

