/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import multivalent.Multivalent;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encrypt;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.Normalize;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.SecurityHandler;
import org.apache.tools.bzip2.CBZip2OutputStream;
import phelps.awt.font.Type1;
import phelps.io.BufferedRandomAccessFile;
import phelps.lang.Integers;
import phelps.lang.StringBuffers;
import phelps.lang.Strings;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFWriter
extends COSSource {
    static final Map<String, String> INLINE_ABBREV;
    public static final int PDFOBJ_OVERHEAD;
    public static final int PDFOBJREF_OVERHEAD;
    static final int FLATE_OVERHEAD;
    static final int PREDICT_XREF_OVERHEAD;
    static final int OBJSTMC_MAX = 200;
    static final int PAGES_MAX = 20;
    static final String[] DICT_KEYS_START;
    static final String[] DICT_KEYS_END;
    static final String[] DICT_KEYS_SKIP;
    static final NumberFormat NF;
    static final Set<String> BREAK_BEFORE;
    static final Set<String> BREAK_AFTER;
    static final byte[] COMPACT_PAGE1;
    private PDFReader pdfr_;
    private BufferedRandomAccessFile w_;
    private boolean fcompress_ = true;
    private boolean fmonitor_ = false;
    private boolean fexact_ = false;
    private long startxref_ = -1L;
    private boolean finc_ = false;
    private String password_ = "";
    private Encrypt encrypt_ = null;
    private boolean[] fplain_ = null;
    private List<Object> noencrypt_;
    private Object[] objCache_;
    private short[] objGen_;
    private int objcnt_;
    private List<Integer> deleted_ = new ArrayList<Integer>(10);
    private List<Integer> deleted0_ = new ArrayList<Integer>(10);
    private int major_ = 1;
    private int minor_ = 2;
    private Dict trailer_;
    private Dict Info_;
    private Dict Catalog_;
    private File file_;
    private File outfile_;
    private boolean fbulk_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$std$adaptor$pdf$PDFWriter;

    public PDFWriter(File file, PDFReader pDFReader) throws IOException {
        this(file, pDFReader, false);
    }

    public PDFWriter(File file, PDFReader pDFReader, boolean bl) throws IOException {
        int n;
        if (!$assertionsDisabled && pDFReader == null) {
            throw new AssertionError();
        }
        this.finc_ = bl;
        PDFReader pDFReader2 = this.pdfr_ = pDFReader;
        new Normalize(pDFReader2).normalizeDoc(pDFReader2.getCatalog());
        this.setFile(file);
        this.setMinVersion(pDFReader2.getMajorVersion(), pDFReader2.getMinorVersion());
        this.objcnt_ = pDFReader2.getObjCnt();
        this.objCache_ = new Object[this.objcnt_ + 20];
        this.objGen_ = new short[this.objCache_.length];
        this.objCache_[0] = COS.OBJECT_DELETED;
        int n2 = this.objcnt_;
        for (n = 0; n < n2; ++n) {
            this.objGen_[n] = (short)pDFReader2.getObjGen(n);
        }
        n = (int)pDFReader2.getObjOff(0);
        while (n != 0) {
            if (pDFReader2.getObjGen(n) != 65535) {
                this.deleted_.add(Integers.getInteger(n));
            }
            this.objCache_[n] = COS.OBJECT_DELETED;
            n = (int)pDFReader2.getObjOff(n);
        }
        this.deleted0_.addAll(this.deleted_);
        this.trailer_ = new Dict(pDFReader2.getTrailer());
        if (file != null) {
            Object[] objectArray = (Object[])pDFReader2.getObject(this.trailer_.get("ID"));
            objectArray[1] = COS.createID(pDFReader2.getFile(), pDFReader2.getInfo());
        }
        this.Catalog_ = pDFReader2.getCatalog();
        this.Info_ = pDFReader2.getInfo();
        if (!this.fexact_ && file != null && this.Info_ == null) {
            this.Info_ = new Dict(5);
            this.addObject(this.Info_);
        }
    }

    public PDFWriter(File file) throws IOException {
        this.pdfr_ = null;
        this.setFile(file);
        this.objcnt_ = 1;
        this.objCache_ = new Object[1000];
        this.objGen_ = new short[this.objCache_.length];
        this.objCache_[0] = COS.OBJECT_DELETED;
        this.objGen_[0] = -1;
        this.trailer_ = new Dict(5);
        Object[] objectArray = new Object[2];
        objectArray[0] = objectArray[1] = COS.createID(file, null);
        this.trailer_.put("ID", objectArray);
        this.Catalog_ = new Dict(5);
        int n = this.addObject(this.Catalog_);
        this.trailer_.put("Root", new IRef(n, 0));
        this.Catalog_.put("Type", "Catalog");
        this.Info_ = new Dict(5);
        n = this.addObject(this.Info_);
        this.trailer_.put("Info", new IRef(n, 0));
        this.Info_.put("Producer", new StringBuffer(new StringBuffer().append("Multivalent ").append(Multivalent.VERSION).toString()));
        this.Info_.put("CreationDate", COS.createDate(System.currentTimeMillis()));
    }

    private void setFile(File file) throws IOException {
        if (file == null) {
            this.file_ = null;
            this.w_ = null;
            return;
        }
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        this.file_ = this.outfile_ = file.getCanonicalFile();
        if (!this.finc_ && file.exists()) {
            if (!file.canWrite()) {
                throw new IOException(new StringBuffer().append(file).append(" can't overwrite existing PDF -- may be in use by another application.").toString());
            }
            this.outfile_ = File.createTempFile("pdfw", ".pdf", file.getParentFile());
        }
        this.w_ = new BufferedRandomAccessFile(this.outfile_, "rw", 0x100000);
    }

    public void setExact(boolean bl) {
        this.fexact_ = bl;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public RandomAccessFile getRAF() {
        return this.w_;
    }

    @Override
    public int getMajorVersion() {
        return this.major_;
    }

    @Override
    public int getMinorVersion() {
        return this.minor_;
    }

    public void setMinVersion(int n, int n2) {
        if (n > this.major_) {
            this.major_ = n;
            this.minor_ = n2;
        } else if (n == this.major_ && n2 > this.minor_) {
            this.minor_ = n2;
        }
    }

    @Override
    public Dict getTrailer() {
        return this.trailer_;
    }

    public Dict getCatalog() throws IOException {
        return (Dict)this.getObject(this.getTrailer().get("Root"));
    }

    @Override
    public int getObjCnt() {
        return this.objcnt_;
    }

    public void setObjCnt(int n) {
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError(n);
        }
        if (n > this.objCache_.length) {
            int n2 = Math.max(n, this.objCache_.length + 200);
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.objCache_, 0, objectArray, 0, this.objcnt_);
            this.objCache_ = objectArray;
            short[] sArray = new short[n2];
            System.arraycopy(this.objGen_, 0, sArray, 0, this.objcnt_);
            this.objGen_ = sArray;
        } else if (n < this.getObjCnt()) {
            if (this.deleted_ != null) {
                this.deleted_.clear();
            }
            Arrays.fill(this.objCache_, n, this.getObjCnt() - 1, null);
        }
        this.objcnt_ = n;
    }

    public int addObject(Object object) {
        int n;
        if (!$assertionsDisabled && object == null) {
            throw new AssertionError();
        }
        if (this.deleted_ != null && this.deleted_.size() > 0) {
            n = this.deleted_.get(0);
        } else {
            n = this.objcnt_;
            this.setObjCnt(n + 1);
        }
        this.setObject(n, object);
        return n;
    }

    public void setObject(int n, Object object) {
        if (!($assertionsDisabled || n > 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        if (!$assertionsDisabled && (object == null || object instanceof IRef)) {
            throw new AssertionError(object);
        }
        if (this.deleted_ != null && COS.OBJECT_DELETED == object ^ COS.OBJECT_DELETED == this.objCache_[n]) {
            Integer n2 = Integers.getInteger(n);
            if (COS.OBJECT_DELETED == object) {
                if (!$assertionsDisabled && this.deleted_.contains(n2)) {
                    throw new AssertionError();
                }
                this.deleted_.add(0, n2);
                this.objCache_[0] = COS.OBJECT_DELETED;
                this.setObjGen(n, this.getObjGen(n) + 1);
            } else {
                int n3 = this.deleted_.indexOf(n2);
                if (!$assertionsDisabled && n3 == -1) {
                    throw new AssertionError();
                }
                if (n3 > 0) {
                    int n4 = this.deleted_.get(n3 - 1);
                    this.objCache_[n4] = COS.OBJECT_DELETED;
                } else {
                    this.objCache_[0] = COS.OBJECT_DELETED;
                }
                this.deleted_.remove(n2);
            }
        }
        this.objCache_[n] = object;
    }

    public Object getObject(int n, boolean bl) throws IOException {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        if (!$assertionsDisabled && this.objCache_[0] != COS.OBJECT_DELETED) {
            throw new AssertionError();
        }
        Object object = this.getCache(n);
        if (object == null) {
            try {
                object = this.pdfr_.getObject(n);
                if (this.fexact_) {
                    if (2 == this.pdfr_.getObjType(n)) {
                        object = new Long(this.pdfr_.getObjOff(n));
                    }
                } else if (COS.CLASS_DICTIONARY == object.getClass() && "ObjStm".equals(((Dict)object).get("Type"))) {
                    object = COS.OBJECT_DELETED;
                } else if (2 == this.pdfr_.getObjType(n)) {
                    this.objGen_[n] = 0;
                }
                if (bl) {
                    this.objCache_[n] = object;
                }
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError((Object)new StringBuffer().append(object).append(" @ ").append(n).toString());
                }
                if (COS.CLASS_DICTIONARY == object.getClass()) {
                    this.pdfr_.getStreamData(new IRef(n, this.getObjGen(n)), false, true);
                }
            }
            catch (IOException iOException) {
                System.err.println(new StringBuffer().append(iOException).append(" while reading object #").append(n).append(": ").append(object).toString());
                throw iOException;
            }
        }
        return object;
    }

    int getObjIndex(Object object) throws IOException {
        int n = this.getObjCnt();
        for (int i = 1; i < n; ++i) {
            if (object != this.getCache(i)) continue;
            return i;
        }
        return -1;
    }

    public Object getCache(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        return this.objCache_[n];
    }

    @Override
    public Object getObject(Object object) throws IOException {
        if (object != null && COS.CLASS_IREF == object.getClass()) {
            object = this.getObject(((IRef)object).id, true);
        }
        if (!$assertionsDisabled && object instanceof IRef) {
            throw new AssertionError();
        }
        return object;
    }

    public void readAllObjects() throws IOException {
        if (this.pdfr_ == null) {
            return;
        }
        if (this.fmonitor_) {
            System.out.print(new StringBuffer().append("READ, ").append(this.objCache_.length).append(" objects").append("   ").toString());
        }
        long l = System.currentTimeMillis();
        int n = this.getObjCnt();
        for (int i = 1; i < n; ++i) {
            if (this.fmonitor_) {
                if (i % 1000 == 0) {
                    System.out.print((n - i) / 1000);
                } else if (i % 500 == 0) {
                    System.out.print(" ");
                }
            }
            this.getObject(i, true);
            if (!$assertionsDisabled && this.objCache_[i] == null) {
                throw new AssertionError((Object)new StringBuffer().append(i).append(" of ").append(n).toString());
            }
        }
        if (this.fmonitor_) {
            System.out.println();
            System.out.println(new StringBuffer().append(System.currentTimeMillis() - l).append(" ms").toString());
        }
        this.setMinVersion(this.pdfr_.getMajorVersion(), this.pdfr_.getMinorVersion());
    }

    public Object[] getObjects() {
        this.deleted_ = null;
        Arrays.fill(this.objGen_, 1, this.getObjCnt(), (short)0);
        return this.objCache_;
    }

    public void setObjGen(int n, int n2) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        n2 = Math.min(n2, 65535);
        this.objGen_[n] = (short)n2;
    }

    public int getObjGen(int n) {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        return this.objGen_[n] & 0xFFFF;
    }

    public byte getObjType(int n) throws IOException {
        if (!($assertionsDisabled || n >= 0 && n < this.getObjCnt())) {
            throw new AssertionError(n);
        }
        Object object = this.getObject(n, false);
        return (byte)(COS.OBJECT_DELETED == object ? 0 : (COS.CLASS_OBJSTMC == object.getClass() ? 2 : 1));
    }

    public void addFilter(Dict dict, String objectArray, Object objectArray2) throws IOException {
        Object[] objectArray3;
        Object[] objectArray4;
        Object object = this.getObject(dict.get("Filter"));
        Object object2 = this.getObject(dict.get("DecodeParms"));
        if (object2 == null) {
            object2 = COS.OBJECT_NULL;
        }
        if (object == null) {
            objectArray4 = objectArray;
            objectArray3 = objectArray2;
        } else if (COS.CLASS_NAME == object.getClass()) {
            objectArray4 = new Object[]{object, objectArray};
            objectArray3 = new Object[]{object2, objectArray2};
        } else {
            if (!$assertionsDisabled && COS.CLASS_ARRAY != object.getClass()) {
                throw new AssertionError();
            }
            Object[] objectArray5 = (Object[])object;
            int n = objectArray5.length;
            Object[] objectArray6 = new Object[n];
            objectArray6[0] = objectArray;
            System.arraycopy(objectArray5, 0, objectArray6, 1, n);
            objectArray4 = objectArray6;
            Object[] objectArray7 = new Object[n];
            objectArray7[0] = objectArray2;
            if (object2 != null) {
                System.arraycopy(objectArray5, 0, objectArray7, 1, n);
            } else {
                Arrays.fill(objectArray7, 1, n, COS.OBJECT_NULL);
            }
            objectArray3 = objectArray7;
        }
        dict.put("Filter", objectArray4);
        if (COS.OBJECT_NULL != objectArray3) {
            dict.put("DecodeParms", objectArray3);
        }
    }

    public void removeFilter(Dict dict, String string) throws IOException {
        block3: {
            Object object;
            Object object2;
            block4: {
                object2 = this.getObject(dict.get("Filter"));
                object = this.getObject(dict.get("DecodeParms"));
                if (object2 == null) break block3;
                if (COS.CLASS_NAME != object2.getClass()) break block4;
                if (!object2.equals(string)) break block3;
                dict.remove("Filter");
                dict.remove("DecodeParms");
                break block3;
            }
            if (!$assertionsDisabled && COS.CLASS_ARRAY != object2.getClass()) {
                throw new AssertionError();
            }
            Object[] objectArray = (Object[])object2;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!objectArray[i].equals(string)) continue;
                if (n == 1) {
                    dict.remove("Filter");
                    dict.remove("DecodeParms");
                    break;
                }
                Object[] objectArray2 = new Object[n - 1];
                Object[] objectArray3 = new Object[n - 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, i);
                System.arraycopy(objectArray, i + 1, objectArray2, i + 1, n - i);
                if (object == null) break;
                System.arraycopy(objectArray, 0, (Object[])object, 0, i);
                System.arraycopy(objectArray, i + 1, (Object[])object, i + 1, n - i);
                break;
            }
        }
    }

    public byte[] deflateStream(Dict dict, int n, int n2) throws IOException {
        byte[] byArray;
        Object object = dict.get("DATA");
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            object = this.pdfr_.getStreamData(new IRef(n, n2), false, true);
        }
        byte[] byArray2 = (byte[])object;
        if (this.fcompress_ && dict.get("Filter") == null && dict.get("Length") == null && byArray2.length > FLATE_OVERHEAD + 25 && (byArray = PDFWriter.maybeDeflateData(byArray2)) != byArray2) {
            byArray2 = byArray;
            dict.put("Filter", "FlateDecode");
            dict.put("DATA", byArray);
        }
        dict.put("Length", Integers.getInteger(byArray2.length));
        return byArray2;
    }

    public static byte[] maybeDeflateData(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        Deflater deflater = new Deflater(9, false);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater, 8192);
        ((OutputStream)deflaterOutputStream).write(byArray);
        ((OutputStream)deflaterOutputStream).close();
        deflater.end();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.size() + "/Filter/FlateDecode".length() + 10 < byArray.length ? byteArrayOutputStream.toByteArray() : byArray;
    }

    public boolean objEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (clazz == COS.CLASS_IREF && clazz2 == COS.CLASS_IREF) {
            IRef iRef = (IRef)object;
            IRef iRef2 = (IRef)object2;
            return this.getCache(iRef.id) == this.getCache(iRef2.id);
        }
        if (clazz == COS.CLASS_IREF) {
            return this.objEquals(this.getCache(((IRef)object).id), object2);
        }
        if (clazz2 == COS.CLASS_IREF) {
            return this.objEquals(object, this.getCache(((IRef)object2).id));
        }
        if (clazz != clazz2) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        boolean bl = true;
        if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            Dict dict2 = (Dict)object2;
            boolean bl2 = bl = dict.size() == dict2.size();
            if (bl) {
                Iterator iterator = dict.entrySet().iterator();
                while (bl && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    bl = this.objEquals(entry.getValue(), dict2.get(entry.getKey()));
                }
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            bl = objectArray.length == objectArray2.length;
            int n = objectArray.length;
            for (int i = 0; i < n && bl; ++i) {
                bl = this.objEquals(objectArray[i], objectArray2[i]);
            }
        } else if (COS.CLASS_STRING == clazz) {
            StringBuffer stringBuffer = (StringBuffer)object;
            StringBuffer stringBuffer2 = (StringBuffer)object2;
            bl = stringBuffer.length() == stringBuffer2.length();
            int n = stringBuffer.length();
            for (int i = 0; i < n && bl; ++i) {
                bl = stringBuffer.charAt(i) == stringBuffer2.charAt(i);
            }
        } else {
            bl = COS.CLASS_DATA == clazz ? Arrays.equals((byte[])object, (byte[])object2) : false;
        }
        return bl;
    }

    public int[] refcnt() {
        int[] nArray = new int[this.getObjCnt()];
        ArrayList<IRef> arrayList = new ArrayList<IRef>(nArray.length / 10);
        this.refcnt(nArray, this.getTrailer(), arrayList);
        while (!arrayList.isEmpty()) {
            IRef iRef = (IRef)arrayList.remove(arrayList.size() - 1);
            try {
                this.refcnt(nArray, this.getObject(iRef), arrayList);
            }
            catch (IOException iOException) {}
        }
        return nArray;
    }

    private void refcnt(int[] nArray, Object object, List<IRef> list) {
        block7: {
            Class<?> clazz;
            block6: {
                clazz = object.getClass();
                if (COS.CLASS_IREF != clazz) break block6;
                IRef iRef = (IRef)object;
                int n = iRef.id;
                if (!($assertionsDisabled || 0 <= n && n <= nArray.length)) {
                    throw new AssertionError((Object)new StringBuffer().append(n).append(" > ").append(nArray.length).toString());
                }
                int n2 = n;
                int n3 = nArray[n2];
                nArray[n2] = n3 + 1;
                if (n3 != 0) break block7;
                list.add(iRef);
                break block7;
            }
            if (COS.CLASS_ARRAY == clazz) {
                for (Object object2 : (Object[])object) {
                    this.refcnt(nArray, object2, list);
                }
            } else if (COS.CLASS_DICTIONARY == clazz) {
                Iterator iterator = ((Dict)object).values().iterator();
                while (iterator.hasNext()) {
                    this.refcnt(nArray, iterator.next(), list);
                }
            }
        }
    }

    public int refcntRemove() {
        int n = this.getObjCnt();
        int[] nArray = this.refcnt();
        int[] nArray2 = new int[n];
        for (int i = 1; i < n; ++i) {
            nArray2[i] = nArray[i] == 0 ? 0 : i;
        }
        this.renumberRemove(nArray2);
        return this.getObjCnt() - n;
    }

    public void renumber(int[] nArray) {
        Object object;
        int n = nArray.length;
        IdentityHashMap<IRef, IRef> identityHashMap = new IdentityHashMap<IRef, IRef>(n);
        this.renumber(nArray, this.getTrailer(), identityHashMap);
        Object[] objectArray = this.getObjects();
        for (int i = 1; i < n; ++i) {
            object = objectArray[i];
            if (object == null) continue;
            this.renumber(nArray, object, identityHashMap);
        }
        short[] sArray = this.objGen_;
        object = new short[n];
        for (int i = 1; i < n; ++i) {
            object[nArray[i]] = sArray[i];
        }
    }

    void renumber(int[] nArray, Object object, Map<IRef, IRef> map) {
        block8: {
            Class<?> clazz;
            block6: {
                IRef iRef;
                block7: {
                    clazz = object.getClass();
                    if (COS.CLASS_IREF != clazz) break block6;
                    iRef = (IRef)object;
                    if (map != null) break block7;
                    iRef.id = nArray[iRef.id];
                    break block8;
                }
                if (map.get(iRef) != null) break block8;
                if (!$assertionsDisabled && nArray[iRef.id] <= 0) {
                    throw new AssertionError((Object)new StringBuffer().append(iRef.id).append(" => 0 0 R").toString());
                }
                iRef.id = nArray[iRef.id];
                map.put(iRef, iRef);
                iRef.generation = 0;
                break block8;
            }
            if (COS.CLASS_DICTIONARY == clazz) {
                Iterator iterator = ((Dict)object).values().iterator();
                while (iterator.hasNext()) {
                    this.renumber(nArray, iterator.next(), map);
                }
            } else if (COS.CLASS_ARRAY == clazz) {
                for (Object object2 : (Object[])object) {
                    this.renumber(nArray, object2, map);
                }
            }
        }
    }

    public int[] renumberRemove(int[] nArray) {
        int n;
        if (!$assertionsDisabled && nArray[0] != 0) {
            throw new AssertionError(nArray[0]);
        }
        int n2 = 0;
        int n3 = this.getObjCnt();
        Object[] objectArray = this.getObjects();
        Object[] objectArray2 = new Object[n3];
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < n3; ++n) {
            nArray2[n] = n2++;
            if (nArray[n] == n) {
                objectArray2[n - n2] = objectArray[n];
                continue;
            }
            objectArray[n] = null;
        }
        if (n2 == 0) {
            return nArray;
        }
        n = n3 - n2;
        for (int i = 0; i < n3; ++i) {
            int n4 = i;
            nArray[n4] = nArray[n4] - nArray2[nArray[i]];
        }
        this.renumber(nArray);
        if (!$assertionsDisabled && n > n3) {
            throw new AssertionError((Object)new StringBuffer().append(n).append(" > ").append(n3).toString());
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        this.setObjCnt(n);
        return nArray2;
    }

    public void resetPageTree(List<IRef> list) throws IOException {
        LinkedList<IRef> linkedList = new LinkedList<IRef>();
        linkedList.addAll(list);
        IRef iRef = null;
        int n = 0;
        while (linkedList.size() > n) {
            int n2 = 0;
            int n3 = linkedList.size();
            while (n2 < n3) {
                Dict dict = new Dict();
                dict.put("Type", "Pages");
                int n4 = 0;
                Object[] objectArray = new Object[Math.min(20, n3 - n2)];
                int n5 = this.addObject(dict);
                iRef = new IRef(n5, 0);
                int n6 = objectArray.length;
                for (int i = 0; i < n6; ++i) {
                    IRef iRef2 = (IRef)linkedList.remove(0);
                    Dict dict2 = (Dict)this.getObject(iRef2);
                    dict2.put("Parent", iRef);
                    n4 += "Pages".equals(dict2.get("Type")) ? (Integer)dict2.get("Count") : 1;
                    objectArray[i] = iRef2;
                    ++n2;
                }
                dict.put("Kids", objectArray);
                dict.put("Count", Integers.getInteger(n4));
                linkedList.add(iRef);
            }
            n = 1;
        }
        Dict dict = this.getCatalog();
        if (iRef != null) {
            dict.put("Pages", iRef);
        } else {
            dict.remove("Pages");
        }
    }

    public void liftPageTree() throws IOException {
        Dict dict = (Dict)this.getObject(this.getCatalog().get("Pages"));
        if (COS.OBJECT_NULL == dict) {
            return;
        }
        if (!$assertionsDisabled && dict.get("Parent") != null) {
            throw new AssertionError();
        }
        if (dict.get("Rotate") == null) {
            dict.put("Rotate", Integers.getInteger(0));
        }
        this.liftPageTree(dict, dict);
        if (this.getObjInt(dict.get("Rotate")) % 360 == 0) {
            dict.remove("Rotate");
        }
    }

    private void liftPageTree(Object object, Dict dict) throws IOException {
        Object object2;
        Object object32;
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return;
        }
        Dict dict2 = (Dict)object;
        String string = (String)this.getObject(dict2.get("Type"));
        Object[] objectArray = new Object[PDFReader.PAGE_INHERITABLE.size()];
        int n = PDFReader.PAGE_INHERITABLE.size();
        for (int i = 0; i < n; ++i) {
            String string2 = PDFReader.PAGE_INHERITABLE.get(i);
            Object object4 = dict2.get(string2);
            if (object4 != null || (object4 = dict.get(string2)) == null) continue;
            objectArray[i] = object4;
            dict2.put(string2, object4);
        }
        if ("Pages".equals(string)) {
            Object[] objectArray2;
            for (Object object32 : objectArray2 = (Object[])this.getObject(dict2.get("Kids"))) {
                this.liftPageTree(this.getObject(object32), dict2);
            }
            int n2 = PDFReader.PAGE_INHERITABLE.size();
            for (n = 0; n < n2; ++n) {
                String string3 = PDFReader.PAGE_INHERITABLE.get(n);
                object32 = dict2.get(string3);
                Object object5 = null;
                int n3 = objectArray2.length;
                for (int i = 0; i < n3; ++i) {
                    Dict dict3 = (Dict)this.getObject(objectArray2[i]);
                    Object object6 = dict3.get(string3);
                    if (i == 0) {
                        object5 = object6;
                        continue;
                    }
                    if ((object6 != null || object5 == null) && this.objEquals(object5, object6)) continue;
                    object5 = null;
                    break;
                }
                if (object5 == null) continue;
                dict2.put(string3, object5);
                objectArray[n] = object5;
                for (Object object6 : objectArray2) {
                    ((Dict)this.getObject(object6)).remove(string3);
                }
            }
        }
        if ((object2 = dict2.get("MediaBox")) != null) {
            Object object7 = dict2.get("CropBox");
            if (object7 == null) {
                object7 = object2;
            } else if (objectArray[2] == null && this.objEquals(object2, object7)) {
                dict2.remove("CropBox");
            }
            Object object8 = dict2.get("BleedBox");
            if (object8 != null && this.objEquals(object8, object7)) {
                dict2.remove("BleedBox");
            }
            if ((object8 = dict2.get("TrimBox")) != null && this.objEquals(object8, object7)) {
                dict2.remove("TrimBox");
            }
            if ((object8 = dict2.get("ArtBox")) != null && this.objEquals(object8, object7)) {
                dict2.remove("ArtBox");
            }
        } else if (!$assertionsDisabled && !"Pages".equals(string)) {
            throw new AssertionError((Object)new StringBuffer().append(string).append(" ").append(dict2).append(" <- ").append(this.getObject(dict2.get("Parent"))).append(" / ").append(objectArray[2]).toString());
        }
        if (dict2 != dict) {
            int n4 = PDFReader.PAGE_INHERITABLE.size();
            for (int i = 0; i < n4; ++i) {
                String string4 = PDFReader.PAGE_INHERITABLE.get(i);
                object32 = dict2.get(string4);
                if (object32 == null || !this.objEquals(object32, dict.get(string4))) continue;
                dict2.remove(string4);
            }
        }
    }

    public void setCompress(boolean bl) {
        this.fcompress_ = bl;
    }

    public void setMonitor(boolean bl) {
        this.fmonitor_ = bl;
    }

    public boolean makeObjectStreams(int n, int n2) throws IOException {
        int n3;
        this.writeBarrier();
        ArrayList<Dict> arrayList = new ArrayList<Dict>(20);
        int[] nArray = new int[200];
        int n4 = 0;
        boolean bl = false;
        for (n3 = n > 0 ? n : 1; n3 <= n2; ++n3) {
            Serializable serializable;
            Object object;
            if (n3 < n2 && !this.fplain_[n3]) {
                object = this.getObject(n3, true);
                serializable = object.getClass();
                if (COS.CLASS_DICTIONARY == serializable && "ObjStm".equals(((Dict)object).get("Type")) && arrayList.indexOf(object) == -1) {
                    this.setObject(n3, COS.OBJECT_DELETED);
                } else if ((COS.CLASS_DICTIONARY != serializable || ((Dict)object).get("DATA") == null && !"Catalog".equals(((Dict)object).get("Type")) && ((Dict)object).get("Author") == null && ((Dict)object).get("Creator") == null) && COS.OBJECT_DELETED != object) {
                    nArray[n4++] = n3;
                }
            }
            if (n4 != 200 && n3 != n2 || n4 <= 0) continue;
            object = new StringBuffer(2000);
            serializable = new StringBuffer(8192);
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray[i];
                ((StringBuffer)object).append(n5).append(' ').append(((StringBuffer)serializable).length()).append(' ');
                this.writeObject(this.getObject(n5, false), (StringBuffer)serializable, true);
                if (i + 1 >= n3) continue;
                ((StringBuffer)serializable).append(' ');
            }
            ((StringBuffer)serializable).insert(0, object);
            byte[] byArray = Strings.getBytes(((StringBuffer)serializable).toString());
            byte[] byArray2 = PDFWriter.maybeDeflateData(byArray);
            if (byArray2.length + 1024 < byArray.length + n4 * " n obj\nendobj\n".length()) {
                Dict dict = new Dict(7);
                dict.put("Type", "ObjStm");
                dict.put("N", Integers.getInteger(n4));
                dict.put("First", Integers.getInteger(((StringBuffer)object).length()));
                if (this.fcompress_) {
                    dict.put("DATA", byArray2);
                    dict.put("Filter", "FlateDecode");
                } else {
                    dict.put("DATA", byArray);
                }
                arrayList.add(dict);
                int n6 = this.addObject(dict);
                this.setObjGen(n6, 0);
                Long l = new Long(n6);
                for (int i = 0; i < n4; ++i) {
                    int n7 = nArray[i];
                    this.setObject(n7, l);
                    this.setObjGen(n7, i);
                }
            }
            n4 = 0;
        }
        int n8 = n3 = arrayList.size() > 0 ? 1 : 0;
        if (n3 != 0) {
            this.setMinVersion(1, 5);
        }
        return n3 != 0;
    }

    private void writeBarrier() throws IOException {
        Dict dict;
        Object object;
        int n;
        int n2;
        int n3;
        Cloneable cloneable;
        if (this.fplain_ != null) {
            return;
        }
        Dict dict2 = this.getTrailer();
        if (!this.fcompress_) {
            dict2.remove("Encrypt");
        }
        Object object2 = dict2.get("Encrypt");
        Dict dict3 = (Dict)this.getObject(object2);
        this.encrypt_ = new Encrypt(dict3, this);
        if (dict3 != null) {
            boolean bl;
            cloneable = this.encrypt_.getSecurityHandler();
            n3 = ((SecurityHandler)cloneable).isAuthorized() || ((SecurityHandler)cloneable).authUser("") || ((SecurityHandler)cloneable).authOwner("") ? 1 : 0;
            boolean bl2 = bl = n3 != 0 || ((SecurityHandler)cloneable).authUser(this.password_) || ((SecurityHandler)cloneable).authOwner(this.password_);
            if (!bl) {
                throw new IllegalStateException("must set valid password by now");
            }
            n2 = this.getObjInt(dict3.get("V"));
            n = n2 >= 4 ? 5 : (n2 == 2 || n2 == 3 ? 4 : (dict3.get("SubFilter") != null ? 3 : 1));
            this.setMinVersion(1, n);
            if (n3 == 0 || this.compareVersion(1, 5) >= 0) {
                // empty if block
            }
        }
        cloneable = (Dict)dict2.get("Compress");
        n3 = this.getObjCnt();
        this.fplain_ = new boolean[n3];
        if (dict3 != null) {
            List<IRef> list = this.connected(object2);
            this.noencrypt_ = new ArrayList<Object>(list.size() + 10);
            n = list.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = list.get(n2);
                this.noencrypt_.add(this.getObject(object));
                this.fplain_[((IRef)object).id] = true;
            }
            this.noencrypt_.add(this.trailer_);
        } else {
            this.noencrypt_ = new ArrayList<Object>(10);
        }
        this.fplain_[0] = true;
        IRef iRef = (IRef)this.trailer_.get("Info");
        if (iRef != null) {
            this.fplain_[iRef.id] = true;
        }
        if ((iRef = (IRef)(dict = this.getCatalog()).get("Metadata")) != null) {
            Dict dict4 = (Dict)this.getObject(iRef);
            object = this.getObject(dict4.get("Filter"));
            if (object == null) {
                this.fplain_[iRef.id] = true;
            }
            if (this.encrypt_.getCryptFilter(dict4) == CryptFilter.IDENTITY || this.compareVersion(1, 5) >= 0) {
                // empty if block
            }
        }
    }

    public void writeHeader() throws IOException {
        this.writeBarrier();
        BufferedRandomAccessFile bufferedRandomAccessFile = this.w_;
        bufferedRandomAccessFile.writeString8(new StringBuffer().append("%PDF-").append(this.getMajorVersion()).append('.').append(this.getMinorVersion()).append('\n').toString());
        bufferedRandomAccessFile.write(37);
        bufferedRandomAccessFile.write(144);
        bufferedRandomAccessFile.write(132);
        bufferedRandomAccessFile.write(134);
        bufferedRandomAccessFile.write(143);
        bufferedRandomAccessFile.write(10);
    }

    public void writeXref(Dict dict, int n, long l, long[] lArray, int n2, int n3) throws IOException {
        this.writeXref(dict, n, l, lArray, new int[]{n2}, new int[]{n3});
    }

    public void writeXref(Dict dict, int n, long l, long[] lArray, int[] nArray, int[] nArray2) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!$assertionsDisabled && nArray.length != nArray2.length) {
            throw new AssertionError();
        }
        BufferedRandomAccessFile bufferedRandomAccessFile = this.w_;
        this.startxref_ = bufferedRandomAccessFile.getFilePointer();
        int n6 = n5 = this.deleted_ != null && this.deleted_.size() > 0 ? this.deleted_.get(0) : 0;
        if (n5 > 0) {
            lArray[0] = n5;
            n4 = this.deleted_.size();
            for (n3 = 0; n3 < n4; ++n3) {
                long l2;
                n2 = this.getObjInt(this.deleted_.get(n3));
                if (!$assertionsDisabled && COS.OBJECT_DELETED != this.getObject(n2)) {
                    throw new AssertionError(this.getObject(n2, false));
                }
                lArray[n2] = l2 = n3 + 1 < n4 ? this.deleted_.get(n3 + 1).longValue() : 0L;
            }
        }
        if (l <= 0L) {
            dict.remove("Prev");
        } else {
            dict.put("Prev", new Integer((int)l));
        }
        dict.put("Size", Integers.getInteger(n));
        n3 = this.getObjIndex(dict);
        if (this.compareVersion(1, 5) >= 0 && n3 > 0 && (this.fcompress_ || this.fexact_)) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            dict.put("Type", "XRef");
            if (nArray.length == 1 && nArray[0] == 0 && nArray2[0] == n) {
                dict.remove("Index");
            } else {
                Object[] objectArray = new Object[nArray.length * 2];
                int n13 = nArray.length;
                n12 = 0;
                for (n2 = 0; n2 < n13; ++n2) {
                    objectArray[n12++] = Integers.getInteger(nArray[n2]);
                    objectArray[n12++] = Integers.getInteger(nArray2[n2]);
                }
                dict.put("Index", objectArray);
            }
            n4 = 0;
            long l3 = 0L;
            n12 = 0;
            boolean bl = true;
            int n14 = nArray.length;
            for (n11 = 0; n11 < n14; ++n11) {
                n10 = nArray[n11] + nArray2[n11];
                for (n9 = nArray[n11]; n9 < n10; ++n9) {
                    if (n9 == 0) continue;
                    if (bl && this.getObjType(n9) != 1) {
                        bl = false;
                    }
                    l3 = Math.max(lArray[n9], l3);
                    n12 = Math.max(this.getObjGen(n9), n12);
                }
                n4 += nArray2[n11];
            }
            n11 = bl ? 0 : 1;
            n14 = 0;
            n10 = 8;
            for (n9 = 0; n9 < n10; ++n9) {
                if ((255L << n9 * 8 & l3) == 0L) continue;
                n14 = n9 + 1;
            }
            n9 = n12 == 0 ? 0 : (n12 <= 255 ? 1 : 2);
            dict.put("W", new Object[]{Integers.getInteger(n11), Integers.getInteger(n14), Integers.getInteger(n9)});
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(nArray.length * 10 + (n11 + n14 + n9) * n4);
            int n15 = nArray.length;
            for (int i = 0; i < n15; ++i) {
                int n16 = nArray[i] + nArray2[i];
                for (n8 = nArray[i]; n8 < n16; ++n8) {
                    int n17;
                    n7 = this.getObjType(n8);
                    long l4 = 2 == n7 ? ((Number)this.getObject(n8, false)).longValue() : lArray[n8];
                    int n18 = this.getObjGen(n8);
                    if (n8 == 0) {
                        n7 = 0;
                        l4 = 0L;
                        n18 = 0;
                    }
                    if (n11 > 0) {
                        byteArrayOutputStream.write(n7);
                    }
                    for (n17 = n14 - 1; n17 >= 0; --n17) {
                        byteArrayOutputStream.write((int)(l4 >> n17 * 8));
                    }
                    for (n17 = n9 - 1; n17 >= 0; --n17) {
                        byteArrayOutputStream.write(n18 >> n17 * 8);
                    }
                }
            }
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            n15 = n11 + n14 + n9;
            n8 = 1;
            byte[] byArray2 = new byte[(n8 + n15) * (byArray.length / n15)];
            n7 = byArray.length - 1;
            int n19 = byArray2.length - 1;
            while (n7 > n15) {
                int n20 = 0;
                while (n20 < n15) {
                    byArray2[n19] = (byte)((byArray[n7] & 0xFF) - (byArray[n7 - n15] & 0xFF));
                    ++n20;
                    --n19;
                    --n7;
                }
                if (n8 != 1) continue;
                byArray2[n19--] = 2;
            }
            System.arraycopy(byArray, 0, byArray2, 0 + n8, n15);
            if (n8 == 1) {
                byArray2[0] = 2;
            }
            byte[] byArray3 = PDFWriter.maybeDeflateData(byArray);
            byte[] byArray4 = PDFWriter.maybeDeflateData(byArray2);
            if (byArray4.length + PREDICT_XREF_OVERHEAD + 25 < byArray3.length) {
                dict.put("DATA", byArray4);
                Dict dict2 = new Dict();
                dict2.put("Columns", Integers.getInteger(n15));
                dict2.put("Predictor", Integers.getInteger(12));
                dict.put("DecodeParms", dict2);
                if (byArray2 != byArray4) {
                    dict.put("Filter", "FlateDecode");
                }
            } else {
                dict.put("DATA", byArray3);
                if (byArray != byArray3) {
                    dict.put("Filter", "FlateDecode");
                }
            }
            this.writeObject(dict, n3, 0, false, null);
        } else {
            bufferedRandomAccessFile.writeString8("xref\n");
            n2 = nArray.length;
            for (n4 = 0; n4 < n2; ++n4) {
                bufferedRandomAccessFile.writeString8(new StringBuffer().append(nArray[n4]).append(" ").append(nArray2[n4]).append("\n").toString());
                int n21 = nArray[n4] + nArray2[n4];
                for (int i = nArray[n4]; i < n21; ++i) {
                    long l5 = lArray[i];
                    int n22 = this.getObjGen(i);
                    char c = 'n';
                    if (COS.OBJECT_DELETED == this.getCache(i)) {
                        c = 'f';
                        if (n22 != 65535 && !this.deleted0_.contains(Integers.getInteger(n4))) {
                            ++n22;
                        }
                    }
                    String string = Long.toString(l5);
                    String string2 = Integer.toString(n22);
                    bufferedRandomAccessFile.writeString8(new StringBuffer().append("0000000000".substring(string.length())).append(string).append(" ").append("00000".substring(string2.length())).append(string2).append(" ").append(c).append(" \n").toString());
                }
            }
            if (dict == null) {
                dict = new Dict(5);
            }
            bufferedRandomAccessFile.writeString8("trailer\n");
            dict.remove("Type");
            dict.remove("W");
            dict.remove("Index");
            bufferedRandomAccessFile.writeString8(this.writeObject((Object)dict, new StringBuffer(200), this.fcompress_).toString());
            bufferedRandomAccessFile.writeString8("\n");
        }
    }

    public long writeObject(Object object, int n, int n2) throws IOException {
        this.writeBarrier();
        Encrypt encrypt = n > 0 && this.noencrypt_.indexOf(object) == -1 ? this.encrypt_ : null;
        boolean bl = n < this.fplain_.length ? this.fplain_[n] : false;
        return this.writeObject(object, n, n2, bl, encrypt);
    }

    public long writeObject(Object object, int n, int n2, boolean bl, Encrypt encrypt) throws IOException {
        Object object2;
        if (n == 0 || COS.OBJECT_DELETED == object || COS.CLASS_OBJSTMC == object.getClass()) {
            return 0L;
        }
        BufferedRandomAccessFile bufferedRandomAccessFile = this.w_;
        long l = bufferedRandomAccessFile.getFilePointer();
        byte[] byArray = null;
        if (COS.CLASS_DICTIONARY == object.getClass() && (object2 = ((Dict)object).get("DATA")) != null) {
            CryptFilter cryptFilter;
            Dict dict = (Dict)object;
            if ("None".equals(dict.get("Filter"))) {
                bl = true;
                dict.remove("Filter");
            }
            if (bl) {
                byArray = object2 instanceof byte[] ? (byte[])object2 : this.pdfr_.getStreamData(new IRef(n, n2), false, true);
                dict.put("Length", Integers.getInteger(byArray.length));
            } else {
                byArray = this.deflateStream(dict, n, n2);
            }
            if (encrypt != null && byArray != null && (cryptFilter = encrypt.getCryptFilter(dict)) != CryptFilter.IDENTITY) {
                byArray = (byte[])byArray.clone();
                cryptFilter.reset(n, n2).encrypt(byArray, 0, byArray.length);
            }
        }
        bufferedRandomAccessFile.writeString8(Integers.toString(n));
        bufferedRandomAccessFile.writeString8(" ");
        bufferedRandomAccessFile.writeString8(Integers.toString(n2));
        bufferedRandomAccessFile.writeString8(" obj");
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            bufferedRandomAccessFile.writeString8("\n");
        }
        bufferedRandomAccessFile.writeString8(this.writeObject(object, n, n2, new StringBuffer(1024), this.fcompress_, encrypt).toString());
        if (byArray != null) {
            bufferedRandomAccessFile.writeString8("stream\n");
            bufferedRandomAccessFile.write(byArray);
            bufferedRandomAccessFile.writeString8("\nendstream");
        }
        bufferedRandomAccessFile.writeString8("\nendobj\n");
        return l;
    }

    public StringBuffer writeObject(Object object, StringBuffer stringBuffer, boolean bl) {
        return this.writeObject(object, -1, -1, stringBuffer, bl, null);
    }

    private StringBuffer writeObject(Object object, int n, int n2, StringBuffer stringBuffer, boolean bl, Encrypt encrypt) {
        Class<?> clazz = object.getClass();
        if (COS.CLASS_STRING == clazz) {
            char c;
            int n3;
            int n4;
            int n5;
            int n6;
            StringBuffer stringBuffer2;
            StringBuffer stringBuffer3 = stringBuffer2 = (StringBuffer)object;
            int n7 = stringBuffer3.length();
            for (n6 = 0; n6 < n7; ++n6) {
                if (stringBuffer3.charAt(n6) < '\u0100') continue;
                stringBuffer3 = new StringBuffer(stringBuffer2.length() * 2 + 2);
                stringBuffer3.append("\u00fe\u00ff");
                n5 = stringBuffer2.length();
                for (n4 = 0; n4 < n5; ++n4) {
                    n3 = stringBuffer2.charAt(n4);
                    stringBuffer3.append((char)(n3 >> 8 & 0xFF)).append((char)(n3 & 0xFF));
                }
                break;
            }
            if (encrypt != null && encrypt.getStrF() != CryptFilter.IDENTITY) {
                if (stringBuffer3 == stringBuffer2) {
                    stringBuffer3 = new StringBuffer(stringBuffer2.length());
                    stringBuffer3.append(stringBuffer2);
                }
                encrypt.getStrF().reset(n, n2).encrypt(stringBuffer3);
            }
            n6 = 0;
            n7 = 0;
            n4 = 0;
            n3 = stringBuffer3.length();
            for (n5 = 0; n5 < n3; ++n5) {
                c = stringBuffer3.charAt(n5);
                if (c == ')') {
                    ++n7;
                    continue;
                }
                if (c >= ' ' && c < '\u007f') continue;
                ++n6;
            }
            if (this.fcompress_ || n6 <= stringBuffer3.length() / 4) {
                stringBuffer.append('(');
                n3 = stringBuffer3.length();
                for (n5 = 0; n5 < n3; ++n5) {
                    c = stringBuffer3.charAt(n5);
                    if (c == ')') {
                        --n7;
                        if (n4 > 0) {
                            stringBuffer.append(')');
                            --n4;
                            continue;
                        }
                        stringBuffer.append("\\)");
                        continue;
                    }
                    if (c == '(') {
                        if (n4 < n7) {
                            stringBuffer.append('(');
                            ++n4;
                            continue;
                        }
                        stringBuffer.append("\\(");
                        continue;
                    }
                    if (c == '\\') {
                        stringBuffer.append("\\\\");
                        continue;
                    }
                    if (c < ' ' || c >= '\u007f') {
                        stringBuffer.append('\\');
                        String string = Integer.toOctalString(c);
                        if (string.length() < 3) {
                            int n8;
                            int n9 = n8 = n5 + 1 < n3 ? (int)stringBuffer3.charAt(n5 + 1) : 88;
                            if (n8 >= 48 && n8 <= 55) {
                                stringBuffer.append(string.length() == 2 ? "0" : "00");
                            }
                        }
                        stringBuffer.append(string);
                        continue;
                    }
                    stringBuffer.append(c);
                }
                if (!($assertionsDisabled || n7 == 0 && n4 == 0)) {
                    throw new AssertionError((Object)new StringBuffer().append((Object)stringBuffer).append(": ").append(n7).append(" ").append(n4).toString());
                }
                stringBuffer.append(')');
            } else {
                stringBuffer.append('<');
                n3 = stringBuffer3.length();
                for (n5 = 0; n5 < n3; ++n5) {
                    c = stringBuffer3.charAt(n5);
                    stringBuffer.append("0123456789abcdef".charAt(c >> 4 & 0xF)).append("0123456789abcdef".charAt(c & 0xF));
                }
                stringBuffer.append('>');
            }
        } else if (COS.CLASS_NAME == clazz) {
            stringBuffer.append('/');
            String string = (String)object;
            int n10 = string.length();
            for (int i = 0; i < n10; ++i) {
                char c = string.charAt(i);
                if (c > ' ' && c < '\u007f' && c != '#' && !PDFReader.WSDL[c]) {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("#").append(c < '\u0010' ? "0" : "").append(Integer.toHexString(c));
            }
        } else if (COS.CLASS_IREF == clazz) {
            IRef iRef = (IRef)object;
            int n11 = iRef.id;
            if (!$assertionsDisabled && n11 < 1) {
                throw new AssertionError(n11);
            }
            stringBuffer.append(Integers.toString(n11));
            if (this.fbulk_) {
                stringBuffer.append("R");
            } else {
                stringBuffer.append(' ').append(Integers.toString(iRef.generation)).append(" R");
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            stringBuffer.append('[');
            Class<?> clazz2 = null;
            for (Object object2 : (Object[])object) {
                Class<?> clazz3 = object2.getClass();
                if (clazz2 != null && (!bl || clazz2 != COS.CLASS_DICTIONARY && clazz2 != COS.CLASS_ARRAY && clazz2 != COS.CLASS_STRING && clazz3 != COS.CLASS_NAME && clazz3 != COS.CLASS_DICTIONARY && clazz3 != COS.CLASS_ARRAY && clazz3 != COS.CLASS_STRING)) {
                    stringBuffer.append(' ');
                }
                this.writeObject(object2, n, n2, stringBuffer, bl, encrypt);
                clazz2 = clazz3;
            }
            stringBuffer.append(']');
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Class<?> clazz4;
            Object v;
            Dict dict = (Dict)object;
            stringBuffer.append("<<");
            for (String string : DICT_KEYS_START) {
                v = dict.get((Object)string);
                if (v == null || v == COS.OBJECT_NULL) continue;
                if (!bl) {
                    stringBuffer.append(' ');
                }
                this.writeObject(string, n, n2, stringBuffer, bl, encrypt);
                clazz4 = v.getClass();
                if (!bl || clazz4 != COS.CLASS_NAME && clazz4 != COS.CLASS_DICTIONARY && clazz4 != COS.CLASS_ARRAY && clazz4 != COS.CLASS_STRING) {
                    stringBuffer.append(' ');
                }
                this.writeObject(v, n, n2, stringBuffer, bl, encrypt);
            }
            for (Map.Entry entry : dict.entrySet()) {
                String string;
                string = (String)entry.getKey();
                v = entry.getValue();
                if (!$assertionsDisabled && v == null) {
                    throw new AssertionError(v);
                }
                if (string == "DATA" || string == "REALIZED" || v == COS.OBJECT_NULL || Arrays.binarySearch(DICT_KEYS_SKIP, string) >= 0) continue;
                if (!bl) {
                    stringBuffer.append(' ');
                }
                this.writeObject(string, n, n2, stringBuffer, bl, encrypt);
                clazz4 = v.getClass();
                if (!bl || clazz4 != COS.CLASS_NAME && clazz4 != COS.CLASS_DICTIONARY && clazz4 != COS.CLASS_ARRAY && clazz4 != COS.CLASS_STRING) {
                    stringBuffer.append(' ');
                }
                this.writeObject(v, n, n2, stringBuffer, bl, encrypt);
            }
            for (String string : DICT_KEYS_END) {
                v = dict.get((Object)string);
                if (v == null || v == COS.OBJECT_NULL) continue;
                if (!bl) {
                    stringBuffer.append(' ');
                }
                this.writeObject(string, n, n2, stringBuffer, bl, encrypt);
                clazz4 = v.getClass();
                if (!bl || clazz4 != COS.CLASS_NAME && clazz4 != COS.CLASS_DICTIONARY && clazz4 != COS.CLASS_ARRAY && clazz4 != COS.CLASS_STRING) {
                    stringBuffer.append(' ');
                }
                this.writeObject(v, n, n2, stringBuffer, bl, encrypt);
            }
            stringBuffer.append(">>");
        } else if (COS.CLASS_INTEGER == clazz) {
            stringBuffer.append(Integer.toString((Integer)object));
        } else if (COS.CLASS_REAL == clazz) {
            double d = (Double)object;
            if (Math.rint(d) == d) {
                stringBuffer.append(Math.round(d));
            } else {
                stringBuffer.append(NF.format(d));
            }
        } else if (COS.CLASS_BOOLEAN == clazz) {
            stringBuffer.append(object == Boolean.TRUE ? "true" : "false");
        } else if (COS.OBJECT_NULL == object) {
            stringBuffer.append("null");
        } else if (COS.CLASS_DATA == clazz) {
            byte[] byArray = (byte[])object;
            int n12 = byArray.length;
            for (int i = 0; i < n12; ++i) {
                stringBuffer.append((char)(byArray[i] & 0xFF));
            }
        } else if (COS.OBJECT_DELETED == object) {
            if (!$assertionsDisabled) {
                throw new AssertionError(n);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)new StringBuffer().append(n).append(": ").append(object).append(" / ").append(clazz.getName()).toString());
        }
        return stringBuffer;
    }

    public byte[] writeCommandArray(Cmd[] cmdArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(cmdArray.length * 10);
        stringBuffer.append('\n');
        int n = 0;
        int n2 = 0;
        int n3 = cmdArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            Cmd cmd = cmdArray[i];
            if (!cmd.valid) continue;
            String string = cmd.op;
            Object[] objectArray = cmd.ops;
            int n6 = objectArray.length;
            ++n;
            if (bl) {
                int n7 = n5 = stringBuffer.charAt(stringBuffer.length() - 1) == '\n' ? 1 : 0;
                if (n5 == 0 && BREAK_BEFORE.contains(string)) {
                    stringBuffer.append('\n');
                    n5 = 1;
                }
                if ("ET".equals(string) || "Q".equals(string)) {
                    n2 = Math.max(n2 - 1, 0);
                }
                if (n5 != 0) {
                    int n8 = n2;
                    for (n4 = 0; n4 < n8; ++n4) {
                        stringBuffer.append("   ");
                    }
                } else {
                    stringBuffer.append("  ");
                }
                if ("BT".equals(string) || "q".equals(string)) {
                    ++n2;
                }
            }
            if ("%" == string && n6 == 1) {
                stringBuffer.append("%").append(objectArray[0]).append('\n');
                continue;
            }
            if ("BI" == string) {
                this.writeInlineImage((Dict)objectArray[0], (byte[])objectArray[1], stringBuffer);
                continue;
            }
            if ("TJ".equals(string) && n6 == 1) {
                stringBuffer.append('[');
                for (Object object : (Object[])objectArray[0]) {
                    this.writeObject(object, stringBuffer, false);
                }
                stringBuffer.append("]TJ\n");
                continue;
            }
            n4 = n6;
            for (n5 = 0; n5 < n4; ++n5) {
                this.writeObject(objectArray[n5], stringBuffer, false);
                stringBuffer.append(' ');
            }
            if (string != Cmd.NO_OP) {
                stringBuffer.append(string);
                if (BREAK_AFTER.contains(string)) {
                    stringBuffer.append('\n');
                    continue;
                }
                if (bl) continue;
                stringBuffer.append(" ");
                continue;
            }
            if (!$assertionsDisabled && i + 1 != n3) {
                throw new AssertionError(i);
            }
        }
        return Strings.getBytes(stringBuffer.toString());
    }

    public StringBuffer writeInlineImage(Dict dict, byte[] byArray, StringBuffer stringBuffer) {
        stringBuffer.append("BI  ");
        for (Map.Entry entry : dict.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = INLINE_ABBREV.get(string);
            if (string2 != null) {
                string = string2;
            }
            this.writeObject((Object)string, stringBuffer, false);
            stringBuffer.append(' ');
            this.writeObject(entry.getValue(), stringBuffer, false);
            stringBuffer.append(' ');
        }
        stringBuffer.append("\nID ");
        this.writeObject((Object)byArray, stringBuffer, false);
        stringBuffer.append("\nEI\n");
        return stringBuffer;
    }

    public long writePDF(Observer observer) throws IOException {
        int n = this.getObjCnt();
        if (n == 0) {
            System.out.println("empty PDF -- nothing written");
            return 0L;
        }
        if (this.fmonitor_) {
            System.out.print(new StringBuffer().append("WRITE, ").append(n).append(" objects\t").toString());
        }
        Dict dict = (Dict)this.trailer_.get("Compress");
        String string = null;
        if (dict != null) {
            string = (String)dict.get("Filter");
            dict.remove("Compact");
        }
        if ("Compact".equals(string)) {
            this.writeCompact(observer);
        } else {
            this.writeStandard(observer);
        }
        long l = this.w_.getFilePointer();
        this.close();
        return l;
    }

    public long writePDF() throws IOException {
        return this.writePDF(null);
    }

    private void writeStandard(Observer observer) throws IOException {
        this.writeHeader();
        int n = this.getObjCnt();
        long[] lArray = new long[n + 1];
        for (int i = 1; i < n; ++i) {
            Object object;
            if (this.fmonitor_) {
                if (i % 1000 == 0) {
                    System.out.print((n - i) / 1000);
                } else if (i % 500 == 0) {
                    System.out.print(" ");
                }
            }
            Object object2 = (object = this.getCache(i)) != null && COS.CLASS_DICTIONARY == object.getClass() ? ((Dict)object).get("DATA") : null;
            Object object3 = this.getObject(i, false);
            if (object == null) {
                this.objCache_[i] = null;
            } else if (COS.CLASS_DICTIONARY == object3.getClass() && object2 != null) {
                ((Dict)object3).put("DATA", object2);
            }
            if (observer != null) {
                observer.update(null, object3);
            }
            lArray[i] = this.writeObject(object3, i, this.getObjGen(i));
        }
        if (this.fmonitor_) {
            System.out.println();
        }
        if (this.compareVersion(1, 5) >= 0 && this.getObjIndex(this.trailer_) == -1) {
            lArray[n] = this.getRAF().getFilePointer();
            this.setObjCnt(++n);
            this.setObject(n - 1, this.trailer_);
        }
        this.writeXref(this.trailer_, n, -1L, lArray, 0, n);
    }

    private void writeCompact(Observer observer) throws IOException {
        int n;
        int n2;
        int n3;
        this.readAllObjects();
        int n4 = this.getObjCnt();
        long l = this.pdfr_ != null ? this.pdfr_.getRAF().length() : 0x400000L;
        Dict dict = new Dict(this.trailer_);
        Dict dict2 = (Dict)dict.get("Compress");
        if (!$assertionsDisabled && dict2 == null) {
            throw new AssertionError();
        }
        Dict dict3 = new Dict();
        int n5 = this.addObject(dict3);
        dict3.put("DATA", COMPACT_PAGE1);
        Dict dict4 = new Dict();
        int n6 = this.addObject(dict4);
        dict4.put("Type", "Catalog");
        dict4.put("Pages", new IRef(n6 + 1, 0));
        Object object = new Dict();
        int n7 = this.addObject(object);
        ((Dict)object).put("Type", "Pages");
        ((Dict)object).put("Count", Integers.getInteger(1));
        ((Dict)object).put("Kids", new Object[]{new IRef(n7 + 1, 0)});
        Object object2 = new Dict();
        n7 = this.addObject(object2);
        ((Dict)object2).put("Type", "Page");
        ((Dict)object2).put("Parent", new IRef(n7 - 1, 0));
        ((Dict)object2).put("Contents", new IRef(n5, 0));
        ((Dict)object2).put("MediaBox", new Object[]{Integers.getInteger(0), Integers.getInteger(0), Integers.getInteger(612), Integers.getInteger(792)});
        Object object3 = new Dict();
        ((Dict)object2).put("Resources", object3);
        Dict dict5 = new Dict();
        dict5.put("F1", new IRef(n7 + 1, 0));
        ((Dict)object3).put("Font", dict5);
        Object object4 = new Dict();
        this.addObject(object4);
        ((Dict)object4).put("Type", "Font");
        ((Dict)object4).put("Subtype", "Type1");
        ((Dict)object4).put("BaseFont", "Times-Roman");
        dict2.put("Root", dict.get("Root"));
        dict.put("Root", new IRef(n6, 0));
        dict3 = new Dict(5);
        n5 = this.addObject(dict3);
        dict2.put("Compact", new IRef(n5, 0));
        dict2.put("Producer", new StringBuffer(new StringBuffer().append("Multivalent ").append(Multivalent.VERSION).toString()));
        this.writeHeader();
        this.fbulk_ = true;
        for (n3 = 1; n3 < n4; ++n3) {
            Object object5 = this.getCache(n3);
            if (COS.CLASS_DICTIONARY != object5.getClass()) continue;
            object = (Dict)object5;
            byte[] byArray = (byte[])((Dict)object).get("DATA");
            if ("Image".equals(((Dict)object5).get("Subtype"))) {
                object2 = (String)this.getObject(((Dict)object).get("Filter"));
                object3 = Images.getFilter((Dict)object, null);
                if ("FlateDecode".equals(object2)) {
                    this.fplain_[n3] = true;
                } else if (object3 == null && byArray.length > 204800) {
                    this.deflateStream((Dict)object, -1, -1);
                    this.fplain_[n3] = true;
                } else if ("JBIG2Decode".equals(object3) || "JPXDecode".equals(object3)) {
                    this.fplain_[n3] = true;
                }
            }
            if (byArray == null || this.fplain_[n3]) continue;
            ((Dict)object).put("Length", Integers.getInteger(byArray.length));
        }
        for (n3 = 1; n3 < n4; ++n3) {
            if (this.fplain_[n3]) continue;
            this.freezeCompact(this.getCache(n3));
        }
        int[] nArray = this.sortCompact(this.objCache_, n4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        object = new Deflater(9, false);
        OutputStream outputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, (Deflater)object, 8192);
        this.writeCompactStream(nArray, outputStream);
        ((Deflater)object).end();
        object2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = new ByteArrayOutputStream((int)l);
        outputStream = new CBZip2OutputStream(byteArrayOutputStream);
        int n8 = this.writeCompactStream(nArray, outputStream);
        this.fbulk_ = false;
        boolean bl = byteArrayOutputStream.size() + 256 < ((Object)object2).length;
        object4 = bl ? (Object)byteArrayOutputStream.toByteArray() : object2;
        object2 = null;
        byteArrayOutputStream = null;
        dict3.put("N", Integers.getInteger(n8));
        dict3.put("DATA", object4);
        dict3.put("Filter", bl ? "BZip2Decode" : "FlateDecode");
        int n9 = this.getObjCnt();
        long[] lArray = new long[n9];
        for (n2 = n4; n2 < n9; ++n2) {
            lArray[n2] = this.writeObject(this.getCache(n2), n2, 0);
        }
        for (n2 = 1; n2 < n4; ++n2) {
            n = nArray[n2];
            Object object6 = this.getObject(n, false);
            if (!this.fplain_[n] || object6 == COS.OBJECT_DELETED) continue;
            if (observer != null) {
                observer.update(null, object6);
            }
            lArray[n] = this.writeObject(object6, n, this.getObjGen(n));
        }
        if (this.fmonitor_) {
            System.out.println();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
        for (n = 0; n < n4; ++n) {
            int n10;
            if (!this.fplain_[n]) continue;
            for (n10 = n + 1; n10 < n4 && this.fplain_[n10]; ++n10) {
            }
            arrayList.add(Integers.getInteger(n));
            arrayList.add(Integers.getInteger(n10 - n));
            n = n10 - 1;
        }
        arrayList.add(Integers.getInteger(n4));
        arrayList.add(Integers.getInteger(n9 - n4));
        int[] nArray2 = new int[arrayList.size() / 2];
        int[] nArray3 = new int[nArray2.length];
        int n11 = nArray2.length;
        for (int i = 0; i < n11; ++i) {
            nArray2[i] = (Integer)arrayList.get(i * 2);
            nArray3[i] = (Integer)arrayList.get(i * 2 + 1);
        }
        this.writeXref(dict, n9, -1L, lArray, nArray2, nArray3);
    }

    private int writeCompactStream(int[] nArray, OutputStream outputStream) throws IOException {
        byte[] byArray = Strings.getBytes(" 0 obj\n");
        byte[] byArray2 = Strings.getBytes("\nendobj\n");
        byte[] byArray3 = Strings.getBytes("\nstream\n");
        byte[] byArray4 = Strings.getBytes("endstream");
        byArray4 = new byte[]{32};
        byArray = byArray4;
        byArray2 = new byte[]{10};
        byArray3 = new byte[]{115};
        boolean bl = !(outputStream instanceof DeflaterOutputStream);
        StringBuffer stringBuffer = new StringBuffer(10240);
        int n = 0;
        int n2 = nArray.length;
        for (int i = 1; i < n2; ++i) {
            byte[] byArray5;
            if (this.fmonitor_) {
                if (i % 1000 == 0) {
                    System.out.print((n2 - i) / 1000);
                } else if (i % 500 == 0) {
                    System.out.print(" ");
                }
            }
            int n3 = nArray[i];
            Object object = this.getObject(n3, false);
            if (this.fplain_[n3] || COS.OBJECT_DELETED == object) continue;
            ++n;
            outputStream.write(Strings.getBytes(Integer.toString(n3)));
            outputStream.write(byArray);
            this.writeObject(object, stringBuffer, true);
            if (bl) {
                this.setObject(n3, COS.OBJECT_NULL);
            }
            outputStream.write(StringBuffers.getBytes(stringBuffer));
            stringBuffer.setLength(0);
            byte[] byArray6 = byArray5 = COS.CLASS_DICTIONARY == object.getClass() ? (byte[])((Dict)object).get("DATA") : null;
            if (byArray5 != null) {
                outputStream.write(byArray3);
                outputStream.write(byArray5);
                outputStream.write(byArray4);
            }
            outputStream.write(byArray2);
        }
        outputStream.close();
        return n;
    }

    private void freezeCompact(Object object) throws IOException {
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return;
        }
        Dict dict = (Dict)object;
        Object object2 = this.getObject(dict.get("Type"));
        Object object3 = this.getObject(dict.get("Subtype"));
        if ("Font".equals(object2) && "Type1".equals(object3)) {
            Dict dict2;
            Dict dict3 = (Dict)this.getObject(dict.get("FontDescriptor"));
            Dict dict4 = dict2 = dict3 != null ? (Dict)this.getObject(dict3.get("FontFile")) : null;
            if (dict2 != null && !"Type1U".equals(dict2.get("Type"))) {
                int n = this.getObjInt(dict2.get("Length1"));
                int n2 = this.getObjInt(dict2.get("Length2"));
                byte[] byArray = (byte[])dict2.get("DATA");
                if (!$assertionsDisabled && byArray == null) {
                    throw new AssertionError(dict2);
                }
                byArray = Type1.decrypt(byArray, n, n2, 0);
                dict2.put("DATA", byArray);
                dict2.put("Length3", Integers.getInteger(0));
                dict2.put("Type", "Type1U");
            }
        }
    }

    private int[] sortCompact(Object[] objectArray, int n) {
        int n2;
        int n3;
        Object object;
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        nArray[n - 1] = n - 1;
        blArray[n - 1] = true;
        int n4 = 1;
        for (int i = 1; i < n; ++i) {
            object = objectArray[i];
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError(i);
            }
            if (COS.CLASS_DICTIONARY != object.getClass()) continue;
            Dict dict = (Dict)object;
            if ("Page".equals(dict.get("Type")) || "Template".equals(dict.get("Type"))) {
                Object[] objectArray2;
                if ((object = ((Dict)object).get("Contents")) == null) continue;
                if (COS.CLASS_ARRAY == object.getClass()) {
                    objectArray2 = (Object[])object;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray2 = objectArray3;
                    objectArray3[0] = object;
                }
                Object[] objectArray4 = objectArray2;
                n3 = objectArray4.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n5 = ((IRef)objectArray4[n2]).id;
                    if (blArray[n5]) continue;
                    nArray[n4++] = n5;
                    blArray[n5] = true;
                }
                continue;
            }
            if (!"Form".equals(dict.get("Subtype")) || blArray[i]) continue;
            nArray[n4++] = i;
            blArray[i] = true;
        }
        String[] stringArray = new String[]{"Page", "Pages", "Font", "FontDescriptor", "ExtGState", "Encoding", "Annot"};
        int n6 = stringArray.length;
        for (int i = 0; i < n6; ++i) {
            for (n2 = 1; n2 < n; ++n2) {
                if (blArray[n2] || COS.CLASS_DICTIONARY != (object = objectArray[n2]).getClass() || !stringArray[i].equals(((Dict)object).get("Type"))) continue;
                nArray[n4++] = n2;
                blArray[n2] = true;
            }
        }
        String[] stringArray2 = new String[]{"Link"};
        n2 = stringArray2.length;
        for (n6 = 0; n6 < n2; ++n6) {
            for (n3 = 1; n3 < n; ++n3) {
                if (blArray[n3] || COS.CLASS_DICTIONARY != (object = objectArray[n3]).getClass() || !stringArray2[n6].equals(((Dict)object).get("Subtype"))) continue;
                nArray[n4++] = n3;
                blArray[n3] = true;
            }
        }
        for (n6 = 1; n6 < n; ++n6) {
            if (blArray[n6] || COS.CLASS_DICTIONARY == (object = objectArray[n6]).getClass() && ((Dict)object).get("Length") != null) continue;
            nArray[n4++] = n6;
            blArray[n6] = true;
        }
        for (n6 = 1; n6 < n; ++n6) {
            if (blArray[n6]) continue;
            object = objectArray[n6];
            n2 = 0;
            if (COS.CLASS_DICTIONARY == object.getClass()) {
                Dict dict = (Dict)object;
                Object object2 = dict.get("Filter");
                int n7 = n2 = "Image".equals(dict.get("Subtype")) && ("DCTDecode".equals(object2) || "CCITTFaxDecode".equals(object2)) ? 1 : 0;
            }
            if (n2 != 0) continue;
            nArray[n4++] = n6;
            blArray[n6] = true;
        }
        for (n6 = 1; n6 < n; ++n6) {
            if (blArray[n6]) continue;
            nArray[n4++] = n6;
        }
        if (!$assertionsDisabled && ++n4 != n) {
            throw new AssertionError((Object)new StringBuffer().append(n4).append(" != ").append(n).toString());
        }
        return nArray;
    }

    private void writeIncremental(Observer observer) throws IOException {
        PDFReader pDFReader = this.pdfr_;
        if (pDFReader == null) {
            this.writePDF(observer);
            return;
        }
        int n = this.getObjCnt();
        long[] lArray = new long[n];
        ArrayList<Integer> arrayList = new ArrayList<Integer>(100);
        int n2 = pDFReader != null ? pDFReader.getObjCnt() : 0;
        int n3 = n;
        for (int i = 1; i < n3; ++i) {
            Object object = this.getCache(i);
            if (object == null) continue;
            if (observer != null) {
                observer.update(null, object);
            }
            lArray[i] = this.writeObject(object, i, this.getObjGen(i));
            arrayList.add(Integers.getInteger(i));
        }
        if (arrayList.size() > 0) {
            long l = this.w_.getFilePointer();
        }
    }

    private void closeReader() {
        if (this.pdfr_ == null) {
            return;
        }
        try {
            this.pdfr_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pdfr_ = null;
    }

    public void close() throws IOException {
        this.closeReader();
        if (this.w_ != null) {
            BufferedRandomAccessFile bufferedRandomAccessFile = this.w_;
            if (this.startxref_ > 0L) {
                bufferedRandomAccessFile.seek(bufferedRandomAccessFile.length());
                bufferedRandomAccessFile.writeString8("startxref\n");
                bufferedRandomAccessFile.writeString8(Long.toString(this.startxref_));
                bufferedRandomAccessFile.writeString8("\n%%EOF\n");
            }
            bufferedRandomAccessFile.close();
            this.w_ = null;
            if (this.file_ != this.outfile_) {
                this.file_.delete();
                this.outfile_.renameTo(this.file_);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$std$adaptor$pdf$PDFWriter == null ? (class$multivalent$std$adaptor$pdf$PDFWriter = PDFWriter.class$("multivalent.std.adaptor.pdf.PDFWriter")) : class$multivalent$std$adaptor$pdf$PDFWriter).desiredAssertionStatus();
        INLINE_ABBREV = PDFReader.INLINE_ABBREV;
        PDFOBJ_OVERHEAD = "n m obj\n\nendobj\n".length();
        PDFOBJREF_OVERHEAD = " n m R".length();
        FLATE_OVERHEAD = "/Filter/FlateDecode".length();
        PREDICT_XREF_OVERHEAD = "/DecodeParms<</Predictor 12/Columns 5>>>>".length();
        DICT_KEYS_START = new String[]{"Type", "Subtype", "BaseFont", "Encoding", "Filter", "Width", "Height"};
        DICT_KEYS_END = new String[]{"Parent", "Count", "Length", "Border", "BS"};
        DICT_KEYS_SKIP = new String[DICT_KEYS_START.length + DICT_KEYS_END.length];
        System.arraycopy(DICT_KEYS_START, 0, DICT_KEYS_SKIP, 0, DICT_KEYS_START.length);
        System.arraycopy(DICT_KEYS_END, 0, DICT_KEYS_SKIP, DICT_KEYS_START.length, DICT_KEYS_END.length);
        Arrays.sort(DICT_KEYS_SKIP);
        NF = NumberFormat.getInstance();
        NF.setMinimumFractionDigits(0);
        NF.setMaximumFractionDigits(5);
        NF.setGroupingUsed(false);
        BREAK_BEFORE = new HashSet<String>(Arrays.asList("BT ET  q Q BMC BDC EMC BX EX  BI".split(" +")));
        BREAK_AFTER = new HashSet<String>(Arrays.asList("BT ET  q Q  Tj TJ ' \"  s S f f* F b b* B B* n  BMC BDC EMC BX EX  Do".split(" +")));
        COMPACT_PAGE1 = new StringBuffer().append("BT\n100 792 Td 0 -50 TD  /F1 12 Tf\n(Compact format was used on this PDF in order to save space.) '\n(See ").append(Multivalent.HOME_SITE).append(") '\n").append("ET").toString().getBytes();
    }
}

