/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.lang.Integers;

class Normalize {
    private static final Integer INTEGER0;
    private static final Integer INTEGER1;
    private static final Double REAL0;
    private static final Double REAL1;
    static final Object[] A01;
    static final Object[] A10;
    static final Object[] A010101;
    static final Object[] A01010101;
    static final Object[] A01f;
    static final Object[] A10f;
    static final Object[] A010101f;
    static final Object[] A01010101f;
    static final Object[] A001;
    static final Object[] A000;
    static final Object[] A000f;
    static final Object[] A111f;
    static final Object[] A100f;
    static final Object[] A010f;
    static final Object[] A001f;
    static final Object[] A100100;
    static final Object[] A100100f;
    private static final String[] KEYS_TRAILER;
    private static final String[] KEYS_CATALOG;
    private static final String[] KEYS_PAGES;
    private static final String[] KEYS_PAGE;
    private static final Object[] DEF_PAGE;
    private static final Object[] DEF_PAGES;
    private static final Object[] DEF_VIEWER;
    private static final Object[] DEF_ANNOT;
    private static final Object[] DEF_ANNOT_BS;
    private static final Object[] DEF_ANNOT_TEXT;
    private static final Object[] DEF_ANNOT_LINK;
    private static final Object[] DEF_ANNOT_FREETEXT;
    private static final Object[] DEF_ANNOT_LINE;
    private static final Object[] DEF_ANNOT_STAMP;
    private static final Object[] DEF_ANNOT_POPUP;
    private static final Object[] DEF_ANNOT_FILEATTACHMENT;
    private static final Object[] DEF_ANNOT_SOUND;
    private static final Object[] DEF_ANNOT_MOVIE;
    private static final Object[] DEF_ANNOT_WIDGET;
    private static final Object[] DEF_FONT;
    private static final Object[] DEF_FONTDESCRIPTOR;
    private static final Object[] DEF_XOBJECT;
    private static final Object[] DEF_IMAGE_FAX;
    private static final Object[] DEF_IMAGE_DCT;
    private static final Object[] DEF_FORM;
    private static final Object[] DEF_ACTION;
    private static final Object[] DEF_PATTERN;
    private static final Object[] DEF_FILESPEC;
    private static final Object[] DEF_FILE_EMBEDDED;
    private static final Object[] DEF_CRYPTFILTER;
    private static final Object[] DEF_CRYPTFILTER_DP;
    private static final Object[] DEF_OCG;
    private static final Object[] DEF_OCMD;
    private static final Object[] DEF_CATALOG;
    PDFReader pdfr_;
    static final /* synthetic */ boolean $assertionsDisabled;

    Normalize(PDFReader pDFReader) {
        if (!$assertionsDisabled && pDFReader == null) {
            throw new AssertionError();
        }
        this.pdfr_ = pDFReader;
    }

    private Object getObject(Object object) throws IOException {
        return this.pdfr_.getObject(object);
    }

    public void normalizeDoc(Dict dict) throws IOException {
        Object object;
        Object object2;
        if (!$assertionsDisabled && dict == null) {
            throw new AssertionError();
        }
        PDFReader pDFReader = this.pdfr_;
        pDFReader.setMinVersion(1, 1);
        Dict dict2 = pDFReader.getTrailer();
        if (dict2.get("ID") == null) {
            object2 = new Object[2];
            object2[0] = object2[1] = COS.createID(pDFReader.getFile(), pDFReader.getInfo());
            dict2.put("ID", object2);
        }
        if ((object2 = this.getObject(dict.get("Version"))) != null) {
            object = (String)object2;
            int n = ((String)object).indexOf(46);
            if (n != -1) {
                try {
                    pDFReader.setMinVersion(Integer.parseInt(((String)object).substring(0, n)), Integer.parseInt(((String)object).substring(n + 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            dict.remove("Version");
        }
        if ((object = (Dict)this.getObject(dict.get("Pages"))) != null && (object2 = this.getObject(((Dict)object).get("Rotate"))) != null && ((Number)object2).intValue() % 360 == 0) {
            ((Dict)object).remove("Rotate");
        }
        this.updateDests(dict);
    }

    private void updateDests(Dict dict) throws IOException {
        IRef iRef = (IRef)dict.get("Dests");
        if (iRef == null) {
            return;
        }
        this.pdfr_.setMinVersion(1, 2);
        Dict dict2 = (Dict)this.getObject(iRef);
        dict.remove("Dests");
        Dict dict3 = (Dict)this.getObject(dict.get("Names"));
        if (dict3 == null) {
            dict3 = new Dict(4);
            dict.put("Names", dict3);
        }
        Dict dict4 = new Dict(4);
        dict3.put("Dests", iRef);
        Object[] objectArray = dict2.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = new Object[objectArray.length * 2];
        int n = 0;
        int n2 = objectArray2.length;
        int n3 = 0;
        while (n < n2) {
            Object object = objectArray[n3];
            objectArray2[n] = new StringBuffer((String)object);
            objectArray2[n + 1] = dict2.get((String)object);
            n += 2;
            ++n3;
        }
        dict4.put("Names", objectArray2);
        dict2.clear();
        dict4.putAll(dict2);
    }

    public void normalizeObject(Object object) throws IOException {
        Object object2;
        Object object3;
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return;
        }
        Dict dict = (Dict)object;
        String string = (String)this.getObject(dict.get("Type"));
        String string2 = (String)this.getObject(dict.get("Subtype"));
        Object object4 = null;
        if (dict.get("DATA") != null) {
            if (dict.get("F") != null) {
                PDF.sampledata("external file " + object);
                dict.remove("Filter");
                dict.remove("DecodeParms");
                dict.put("Length", new Integer(0));
                this.simplifyArray1(dict, "FFilter");
                this.simplifyArray1(dict, "FDecodeParms");
            } else {
                this.simplifyArray1(dict, "Filter");
                object3 = dict.remove("DP");
                if (object3 != null && dict.get("DecodeParms") == null) {
                    dict.put("DecodeParms", object3);
                }
                this.simplifyArray1(dict, "DecodeParms");
            }
        }
        if (string != null) {
            if ("Page".equals(string)) {
                this.cleanDict(dict, KEYS_PAGE, DEF_PAGE);
                object4 = dict.get("Resources");
                this.simplifyArray1(dict, "Contents");
            } else if ("Pages".equals(string)) {
                this.cleanDict(dict, KEYS_PAGES, DEF_PAGES);
                object4 = dict.get("Resources");
            } else if ("Annot".equals(string)) {
                this.cleanDict(dict, null, DEF_ANNOT);
                object2 = (Object[])this.getObject(dict.get("Border"));
                if (Arrays.equals(A000, (Object[])object2)) {
                    dict.put("Border", A000);
                }
                if (!"Screen".equals(string2)) {
                    dict.remove("P");
                }
                if ("Text".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_TEXT);
                } else if ("Link".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_LINK);
                    object3 = this.getObject(dict.get("A"));
                    if (object3 != null) {
                        dict.remove("Dest");
                        Dict dict2 = (Dict)object3;
                        if ("GoTo".equals(dict2.get("S")) && (object3 = dict2.get("D")) != null) {
                            if (object3 instanceof String) {
                                object3 = new StringBuffer((String)object3);
                                dict2.put("D", object3);
                            }
                            if (dict2.size() == 2) {
                                dict.remove("A");
                                dict.put("Dest", object3);
                            }
                        }
                    } else {
                        object3 = this.getObject(dict.get("Dest"));
                        if (object3 instanceof String) {
                            dict.put("Dest", new StringBuffer((String)object3));
                        }
                    }
                } else if ("FreeText".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_FREETEXT);
                } else if ("Line".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_LINE);
                } else if ("Stamp".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_STAMP);
                } else if ("Popup".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_POPUP);
                } else if ("FileAttachment".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_FILEATTACHMENT);
                } else if ("Sound".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_SOUND);
                } else if ("Movie".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_MOVIE);
                } else if ("Widget".equals(string2)) {
                    this.cleanDict(dict, null, DEF_ANNOT_WIDGET);
                }
            } else if (!"Bead".equals(string)) {
                if ("Font".equals(string)) {
                    this.cleanDict(dict, null, DEF_FONT);
                    if ("Type3".equals(string2)) {
                        object4 = dict.get("Resources");
                    }
                    if ((object2 = (Dict)this.getObject(dict.get("FontDescriptor"))) != null) {
                        Dict dict3;
                        IRef iRef;
                        this.cleanDict((Dict)object2, null, DEF_FONTDESCRIPTOR);
                        if ("Type1".equals(string2) || "MMType1".equals(string2)) {
                            iRef = (IRef)((Dict)object2).get("FontFile");
                            if (iRef != null) {
                                dict3 = (Dict)this.getObject(iRef);
                                ((Dict)object2).remove("FontFile2");
                                ((Dict)object2).remove("FontFile3");
                                this.pdfr_.pinObject(iRef.id);
                            } else {
                                ((Dict)object2).remove("FontFile");
                                ((Dict)object2).remove("FontFile2");
                                iRef = (IRef)((Dict)object2).get("FontFile3");
                                dict3 = (Dict)this.getObject(iRef);
                                if (dict3 != null) {
                                    string2 = (String)this.getObject(dict3.get("Subtype"));
                                    if (!$assertionsDisabled && !"Type1C".equals(string2)) {
                                        throw new AssertionError();
                                    }
                                    dict3.remove("Length1");
                                    dict3.remove("Length2");
                                    dict3.remove("Length3");
                                    this.pdfr_.pinObject(iRef.id);
                                }
                            }
                        } else if ("TrueType".equals(string2) || "CIDFontType2".equals(string2)) {
                            ((Dict)object2).remove("FontFile");
                            iRef = (IRef)((Dict)object2).get("FontFile2");
                            ((Dict)object2).remove("FontFile3");
                            dict3 = (Dict)this.getObject(iRef);
                            if (dict3 != null) {
                                dict3.remove("Length2");
                                dict3.remove("Length3");
                                this.pdfr_.pinObject(iRef.id);
                            }
                        } else {
                            ((Dict)object2).remove("FontFile");
                            ((Dict)object2).remove("Fontfile2");
                            iRef = (IRef)((Dict)object2).get("FontFile3");
                            dict3 = (Dict)this.getObject(iRef);
                            if (dict3 != null) {
                                dict3.remove("Length2");
                                dict3.remove("Length3");
                                this.pdfr_.pinObject(iRef.id);
                            }
                        }
                        if (dict3 != null) {
                            this.pdfr_.objCache_[iRef.id] = dict3;
                        }
                        if ("Type1".equals(string2) && dict3 != null) {
                            int n = this.pdfr_.getObjInt(dict3.get("Length1"));
                            int n2 = this.pdfr_.getObjInt(dict3.get("Length2"));
                            int n3 = this.pdfr_.getObjInt(dict3.get("Length3"));
                            if (n3 > 0) {
                                dict3.put("Length3", Integers.getInteger(0));
                                byte[] byArray = this.pdfr_.getStreamData(iRef, false, true);
                                if (byArray.length > n + n2) {
                                    byte[] byArray2 = new byte[n + n2];
                                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                                    dict3.put("DATA", byArray2);
                                }
                            }
                        }
                    }
                } else if ("XObject".equals(string)) {
                    this.cleanDict(dict, null, DEF_XOBJECT);
                    if ("Image".equals(string2)) {
                        Object[] objectArray;
                        this.hardcode(dict, "Width");
                        this.hardcode(dict, "Height");
                        this.hardcode(dict, "BitsPerComponent");
                        object3 = this.getObject(dict.get("ImageMask"));
                        if (object3 == Boolean.TRUE) {
                            dict.remove("BitsPerComponent");
                            dict.remove("Mask");
                            dict.remove("ColorSpace");
                        } else {
                            dict.remove("ImageMask");
                        }
                        object2 = this.getObject(dict.get("ColorSpace"));
                        object3 = this.getObject(dict.get("Decode"));
                        if (object2 != null && object3 != null) {
                            objectArray = (Object[])object3;
                            if (("DeviceGray".equals(object2) || "CalGray".equals(object2) || "Separation".equals(object2)) && (Arrays.equals(A01, objectArray) || Arrays.equals(A01f, objectArray)) || ("DeviceRGB".equals(object2) || "CalRGB".equals(object2)) && (Arrays.equals(A010101, objectArray) || Arrays.equals(A010101f, objectArray)) || "DeviceCYMK".equals(object2) && (Arrays.equals(A01010101, objectArray) || Arrays.equals(A01010101f, objectArray))) {
                                dict.remove("Decode");
                            }
                        }
                        objectArray = Images.getDecodeParms(dict, this.pdfr_);
                        String string3 = Images.getFilter(dict, this.pdfr_);
                        if ("CCITTFaxDecode".equals(string3)) {
                            this.cleanDict((Dict)objectArray, null, DEF_IMAGE_FAX);
                            object3 = this.getObject(dict.get("Decode"));
                            if (object3 != null) {
                                if (Arrays.equals(A01, (Object[])object3)) {
                                    dict.remove("Decode");
                                } else if (Arrays.equals(A10, (Object[])object3)) {
                                    dict.put("Decode", A10);
                                }
                            }
                        } else if ("DCTDecode".equals(string3)) {
                            this.cleanDict((Dict)objectArray, null, DEF_IMAGE_DCT);
                        }
                        if (objectArray != null && objectArray.size() == 0) {
                            dict.remove("DecodeParms");
                        }
                    } else if ("Form".equals(string2)) {
                        this.cleanDict(dict, null, DEF_FORM);
                        object4 = dict.get("Resources");
                    }
                } else if ("Border".equals(string)) {
                    this.cleanDict(dict, null, DEF_ANNOT_BS);
                } else if ("Action".equals(string)) {
                    this.cleanDict(dict, null, DEF_ACTION);
                } else if ("Pattern".equals(string)) {
                    this.cleanDict(dict, null, DEF_PATTERN);
                    object4 = dict.get("Resources");
                } else if ("Filespec".equals(string)) {
                    this.cleanDict(dict, null, DEF_FILESPEC);
                } else if ("EmbeddedFile".equals(string)) {
                    this.cleanDict(dict, null, DEF_FILE_EMBEDDED);
                } else if ("CryptFilter".equals(string)) {
                    this.cleanDict(dict, null, DEF_CRYPTFILTER);
                } else if ("CryptFilterDecodeParms".equals(string)) {
                    this.cleanDict(dict, null, DEF_CRYPTFILTER_DP);
                } else if ("OCG".equals(string)) {
                    this.cleanDict(dict, null, DEF_OCG);
                } else if ("OCMD".equals(string)) {
                    this.cleanDict(dict, null, DEF_OCMD);
                } else if ("XRef".equals(string)) {
                    this.cleanDict(dict, KEYS_TRAILER, null);
                } else if ("Catalog".equals(string)) {
                    this.cleanDict(dict, KEYS_CATALOG, DEF_CATALOG);
                    object2 = (Dict)this.getObject(dict.get("Outlines"));
                    if (object2 != null && (object3 = ((Dict)object2).get("Count")) != null && this.pdfr_.getObjInt(object3) == 0) {
                        dict.remove("Outlines");
                        object2 = null;
                    }
                    if ("UseOutlines".equals(this.getObject(dict.get("PageMode"))) && object2 == null) {
                        dict.remove("PageMode");
                    }
                    Dict dict4 = (Dict)this.getObject(dict.get("ViewerPreferences"));
                    this.cleanDict(dict4, null, DEF_VIEWER);
                    if (dict4 != null && dict4.size() == 0) {
                        dict.remove("ViewerPreferences");
                    }
                    Dict dict5 = this.pdfr_.getInfo();
                    this.cleanDict(dict5, null, null);
                } else if (dict.get("FunctionType") != null) {
                    // empty if block
                }
            }
        }
        if ((object3 = this.getObject(object4)) != null && COS.CLASS_DICTIONARY == object3.getClass() && (object3 = ((Dict)(object2 = (Object[])object3)).remove("ProcSet")) != null) {
            this.pdfr_.setMinVersion(1, 4);
        }
        this.hardcode(dict, "Type");
        this.hardcode(dict, "Subtype");
    }

    private void hardcode(Dict dict, String string) throws IOException {
        Object object = dict.get(string);
        if (object != null && COS.CLASS_IREF == object.getClass()) {
            dict.put(string, this.getObject(object));
        }
    }

    private void simplifyArray1(Dict dict, String string) throws IOException {
        Object[] objectArray;
        Object object;
        Object object2 = dict.get(string);
        if (object2 != null && COS.CLASS_ARRAY == (object = this.getObject(object2)).getClass() && (objectArray = (Object[])object).length == 1) {
            dict.put(string, objectArray[0]);
        }
    }

    private void cleanDict(Dict dict, String[] stringArray, Object[] objectArray) throws IOException {
        Object object;
        if (dict == null) {
            return;
        }
        if (stringArray != null) {
            Iterator iterator = dict.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                object = (String)entry.getKey();
                if ("Metadata".equals(object) || Arrays.binarySearch(stringArray, object) >= 0) continue;
                iterator.remove();
            }
        }
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object2;
                object = objectArray[i];
                Object object3 = objectArray[i + 1];
                if (object3 != null && !object3.equals(object2 = this.getObject(dict.get(object))) && (object3.getClass() != COS.CLASS_ARRAY || !Arrays.equals((Object[])object3, (Object[])object2))) continue;
                dict.remove(object);
            }
        }
    }

    static {
        $assertionsDisabled = !Normalize.class.desiredAssertionStatus();
        INTEGER0 = Integers.getInteger(0);
        INTEGER1 = Integers.getInteger(1);
        REAL0 = PDFReader.getReal(0.0);
        REAL1 = PDFReader.getReal(1.0);
        A01 = new Object[]{INTEGER0, INTEGER1};
        A10 = new Object[]{INTEGER1, INTEGER0};
        A010101 = new Object[]{INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1};
        A01010101 = new Object[]{INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1};
        A01f = new Object[]{REAL0, REAL1};
        A10f = new Object[]{REAL0, REAL1};
        A010101f = new Object[]{REAL0, REAL1, REAL0, REAL1, REAL0, REAL1};
        A01010101f = new Object[]{REAL0, REAL1, REAL0, REAL1, REAL0, REAL1, REAL0, REAL1};
        A001 = new Object[]{INTEGER0, INTEGER0, INTEGER1};
        A000 = new Object[]{INTEGER0, INTEGER0, INTEGER0};
        A000f = new Object[]{REAL0, REAL0, REAL0};
        A111f = new Object[]{REAL1, REAL1, REAL1};
        A100f = new Object[]{REAL1, REAL0, REAL0};
        A010f = new Object[]{REAL0, REAL1, REAL0};
        A001f = new Object[]{REAL0, REAL0, REAL1};
        A100100 = new Object[]{INTEGER1, INTEGER0, INTEGER0, INTEGER1, INTEGER0, INTEGER0};
        A100100f = new Object[]{REAL0, REAL0, REAL1, REAL0, REAL0, REAL1};
        KEYS_TRAILER = new String[]{"Size", "Prev", "Root", "Encrypt", "Info", "ID", "Compress"};
        KEYS_CATALOG = new String[]{"Type", "Version", "Pages", "PageLabels", "Names", "Dests", "ViewerPreferences", "PageLayout", "PageMode", "Outlines", "Threads", "OpenAction", "AA", "URI", "AcroForm", "Metadata", "StructTreeRoot", "MarkInfo", "Lang", "SpiderInfo", "OutputIntents", "PieceInfo", "OCProperties", "Perms"};
        KEYS_PAGES = new String[]{"Type", "Parent", "Kids", "Count", "Resources", "MediaBox", "CropBox", "Rotate"};
        KEYS_PAGE = new String[]{"Type", "Parent", "LastModified", "Resources", "MediaBox", "CropBox", "BleedBox", "TrimBox", "ArtBox", "BoxColorInfo", "Contents", "Rotate", "Group", "Thumb", "B", "Dur", "Trans", "Annots", "AA", "Metadata", "PieceInfo", "StructParents", "ID", "PZ", "SeparationInfo"};
        Object[] objectArray = new Object[]{KEYS_TRAILER, KEYS_CATALOG, KEYS_PAGES, KEYS_PAGE};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Arrays.sort((String[])objectArray[i]);
        }
        DEF_PAGE = new Object[0];
        DEF_PAGES = new Object[0];
        DEF_VIEWER = new Object[]{"HideToolbar", Boolean.FALSE, "HideMenubar", Boolean.FALSE, "HideWindowUI", Boolean.FALSE, "FitWindow", Boolean.FALSE, "CenterWindow", Boolean.FALSE, "DisplayDocTitle", Boolean.FALSE, "NonFullScreenPageMode", "UseNone", "Direction", "L2R", "ViewArea", "CropBox", "ViewClip", "CropBox", "PrintArea", "CropBox", "PrintClip", "CropBox"};
        DEF_ANNOT = new Object[]{"Type", null, "Flags", INTEGER0, "Border", A001, "CA", REAL1};
        DEF_ANNOT_BS = new Object[]{"Type", null, "W", INTEGER1, "S", "S"};
        DEF_ANNOT_TEXT = new Object[]{"Open", Boolean.FALSE, "Name", "Note"};
        DEF_ANNOT_LINK = new Object[]{"H", "I"};
        DEF_ANNOT_FREETEXT = new Object[]{"Q", INTEGER0};
        DEF_ANNOT_LINE = new Object[]{"LE", new Object[]{"None", "None"}};
        DEF_ANNOT_STAMP = new Object[]{"Name", "Draft"};
        DEF_ANNOT_POPUP = new Object[]{"Open", Boolean.FALSE};
        DEF_ANNOT_FILEATTACHMENT = new Object[]{"Name", "PushPin"};
        DEF_ANNOT_SOUND = new Object[]{"Name", "Speaker"};
        DEF_ANNOT_MOVIE = new Object[]{"A", Boolean.TRUE};
        DEF_ANNOT_WIDGET = new Object[]{"H", "P"};
        DEF_FONT = new Object[]{"Name", null};
        DEF_FONTDESCRIPTOR = new Object[]{"Leading", INTEGER0, "XHeight", INTEGER0, "StemH", INTEGER0, "AvgWidth", INTEGER0, "MaxWidth", INTEGER0, "MissingWidth", INTEGER0};
        DEF_XOBJECT = new Object[]{"Type", null, "Name", null};
        DEF_IMAGE_FAX = new Object[]{"K", INTEGER0, "EndOfLine", Boolean.FALSE, "EncodedByteAlign", Boolean.FALSE, "Columns", new Integer(1728), "Rows", INTEGER0, "EndOfBlock", Boolean.TRUE, "BlackIs1", Boolean.FALSE, "DamagedRowsBeforeError", INTEGER0};
        DEF_IMAGE_DCT = new Object[]{"ColorTransform", INTEGER1};
        DEF_FORM = new Object[]{"Type", null, "FormType", INTEGER1, "Matrix", A100100};
        DEF_ACTION = new Object[]{"Type", null};
        DEF_PATTERN = new Object[]{"Type", null, "Matrix", A100100};
        DEF_FILESPEC = new Object[]{"V", Boolean.FALSE};
        DEF_FILE_EMBEDDED = new Object[]{"Type", "EmbeddedFile"};
        DEF_CRYPTFILTER = new Object[]{"Type", "CryptFilter", "CFM", "None", "Length", Integers.getInteger(128), "AuthEvent", "DocOpen"};
        DEF_CRYPTFILTER_DP = new Object[]{"Type", "CryptFilterDecodeParms"};
        DEF_OCG = new Object[]{"Intent", "View"};
        DEF_OCMD = new Object[]{"P", "AnyOn"};
        DEF_CATALOG = new Object[]{"PageLayout", "SinglePage", "PageMode", "UseNone"};
    }
}

