/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.Normalize;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.awt.color.ColorSpaceCMYK;
import phelps.imageio.plugins.Fax;
import phelps.io.Streams;

public class Images {
    static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Images() {
    }

    public static BufferedImage createImage(Dict dict, InputStream inputStream, Color color, PDFReader pDFReader) throws IOException {
        if (!($assertionsDisabled || dict != null && inputStream != null && "Image".equals(dict.get("Subtype")) || dict.get("Subtype") == null)) {
            throw new AssertionError();
        }
        int n = pDFReader.getObjInt(dict.get("Width"));
        int n2 = pDFReader.getObjInt(dict.get("Height"));
        String string = Images.getFilter(dict, pDFReader);
        BufferedImage bufferedImage = "DCTDecode".equals(string) ? Images.createJPEG(dict, inputStream) : ("JPXDecode".equals(string) ? Images.createJPEG2000(dict, inputStream) : ("CCITTFaxDecode".equals(string) ? Images.createFAX(dict, inputStream, color, pDFReader) : ("JBIG2Decode".equals(string) ? Images.createJBIG2(dict, inputStream) : Images.createRaw(dict, n, n2, inputStream, color, pDFReader))));
        if (bufferedImage == null) {
            return null;
        }
        if (!$assertionsDisabled && n != bufferedImage.getWidth()) {
            throw new AssertionError((Object)("width=" + bufferedImage.getWidth() + " vs param " + n));
        }
        if (!$assertionsDisabled && n2 != bufferedImage.getHeight()) {
            throw new AssertionError((Object)("height=" + bufferedImage.getHeight() + " vs param " + n2));
        }
        return bufferedImage;
    }

    public static BufferedImage createScaledImage(Dict dict, InputStream inputStream, AffineTransform affineTransform, Color color, PDFReader pDFReader) throws IOException {
        AffineTransform affineTransform2;
        double d;
        if (!($assertionsDisabled || dict != null && inputStream != null && affineTransform != null && "Image".equals(dict.get("Subtype")) || dict.get("Subtype") == null)) {
            throw new AssertionError();
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = Images.createImage(dict, inputStream, color, pDFReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bufferedImage == null) {
            return null;
        }
        int n = pDFReader.getObjInt(dict.get("Width"));
        int n2 = pDFReader.getObjInt(dict.get("Height"));
        if (affineTransform.getScaleX() != 0.0) {
            // empty if block
        }
        if (affineTransform.getScaleX() != 0.0) {
            d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            affineTransform2 = new AffineTransform(d / (double)n, affineTransform.getShearY(), affineTransform.getShearX(), -(d2 / (double)n2 + (d2 < 0.0 ? -1.0 : 1.0) / (double)n2), 0.0, 0.0);
            affineTransform2 = new AffineTransform(d / (double)n, 0.0, 0.0, -(d2 + (d2 < 0.0 ? -1.0 : 1.0)) / (double)n2, 0.0, 0.0);
            if (affineTransform2.getScaleX() < 0.0) {
                affineTransform2.translate(-n, 0.0);
            }
            if (affineTransform2.getScaleY() < 0.0) {
                affineTransform2.translate(0.0, -n2);
            }
        } else {
            d = affineTransform.getShearX();
            double d3 = affineTransform.getShearY();
            affineTransform2 = new AffineTransform(0.0, d3 / (double)n, -d / (double)n2, 0.0, 0.0, 0.0);
            if (affineTransform2.getShearX() < 0.0) {
                affineTransform2.translate(0.0, -n2);
            }
            if (affineTransform2.getShearY() < 0.0) {
                affineTransform2.translate(-n, 0.0);
            }
        }
        try {
            if ("CCITTFaxDecode".equals(Images.getFilter(dict, pDFReader))) {
                bufferedImage = Fax.scale(bufferedImage, affineTransform2);
            } else {
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform2, 2);
                bufferedImage = affineTransformOp.filter(bufferedImage, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
            System.err.println(dict.get("Name") + " " + Images.getFilter(dict, pDFReader) + " " + n + "X" + n2 + ", w/" + affineTransform + " => " + affineTransform2);
        }
        return bufferedImage;
    }

    public static BufferedImage createScaledInline(InputStreamComposite inputStreamComposite, Dict dict, AffineTransform affineTransform, Color color, PDFReader pDFReader) throws IOException {
        Dict dict2 = pDFReader.readInlineImage(inputStreamComposite);
        InputStreamComposite inputStreamComposite2 = pDFReader.getInputStream(dict2);
        Object object = dict2.get("ColorSpace");
        if (dict != null && dict.get(object) != null) {
            dict2.put("ColorSpace", dict.get(object));
        }
        BufferedImage bufferedImage = Images.createScaledImage(dict2, inputStreamComposite2, affineTransform, color, pDFReader);
        ((InputStream)inputStreamComposite2).close();
        if (!$assertionsDisabled && bufferedImage == null) {
            throw new AssertionError((Object)("bad INLINE IMG " + dict2));
        }
        return bufferedImage;
    }

    public static String getFilter(Dict dict, COSSource cOSSource) throws IOException {
        String string;
        Object object = dict.get("Filter");
        if (cOSSource != null) {
            object = cOSSource.getObject(object);
        }
        if (object == null || COS.OBJECT_NULL == object) {
            string = null;
        } else if (COS.CLASS_NAME == object.getClass()) {
            string = (String)object;
        } else {
            if (!$assertionsDisabled && COS.CLASS_ARRAY != object.getClass()) {
                throw new AssertionError();
            }
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray.length > 0 ? objectArray[objectArray.length - 1] : null;
            string = (String)(cOSSource != null ? cOSSource.getObject(object2) : object2);
        }
        if ("DCT".equals(string)) {
            string = "DCTDecode";
        } else if ("CCF".equals(string)) {
            string = "CCITTFaxDecode";
        }
        if (!("DCTDecode".equals(string) || "CCITTFaxDecode".equals(string) || "JBIG2Decode".equals(string) || "JPXDecode".equals(string))) {
            string = null;
        }
        return string;
    }

    public static Dict getDecodeParms(Dict dict, PDFReader pDFReader) throws IOException {
        Object object = pDFReader.getObject(dict.get("DecodeParms"));
        Dict dict2 = (Dict)(object == null ? null : (COS.CLASS_DICTIONARY == object.getClass() ? object : pDFReader.getObject(((Object[])object)[((Object[])object).length - 1])));
        return dict2 != COS.OBJECT_NULL ? dict2 : null;
    }

    static BufferedImage createJPEG(Dict dict, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage;
        if (!($assertionsDisabled || dict != null && inputStream != null)) {
            throw new AssertionError();
        }
        if (inputStream.markSupported()) {
            inputStream.mark(1024);
        }
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
        ImageIO.setUseCache(false);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream, true);
        try {
            bufferedImage = imageReader.read(0);
        }
        catch (IOException iOException) {
            bufferedImage = null;
            System.err.println("Couldn't read JPEG: " + iOException);
        }
        imageReader.dispose();
        imageInputStream.close();
        inputStream.reset();
        return bufferedImage;
    }

    static BufferedImage createJPEG2000(Dict dict, InputStream inputStream) throws IOException {
        BufferedImage bufferedImage;
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        if (inputStream.markSupported()) {
            inputStream.mark(1024);
        }
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG2000").next();
        ImageIO.setUseCache(false);
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        imageReader.setInput(imageInputStream, true);
        try {
            bufferedImage = imageReader.read(0);
        }
        catch (IOException iOException) {
            bufferedImage = null;
            System.err.println("Couldn't read JPEG2000: " + iOException);
        }
        imageReader.dispose();
        imageInputStream.close();
        inputStream.reset();
        return bufferedImage;
    }

    static BufferedImage createFAX(Dict dict, InputStream inputStream, Color color, PDFReader pDFReader) throws IOException {
        boolean bl;
        int n;
        Object object;
        int n2;
        if (!($assertionsDisabled || dict != null && inputStream != null)) {
            throw new AssertionError();
        }
        Dict dict2 = Images.getDecodeParms(dict, pDFReader);
        if (dict2 == null) {
            new Dict(3);
        }
        int n3 = n2 = (object = dict2.get("K")) != null ? pDFReader.getObjInt(object) : 0;
        if (n2 > 0) {
            PDF.sampledata("Group 3 mixed");
            System.exit(0);
        }
        int n4 = n = (object = dict2.get("Columns")) != null ? pDFReader.getObjInt(object) : 1728;
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError();
        }
        int n5 = pDFReader.getObjInt(dict.get("Height"));
        object = dict2.get("Rows");
        int n6 = object != null ? pDFReader.getObjInt(object) : -n5;
        object = pDFReader.getObject(dict2.get("EndOfLine"));
        boolean bl2 = object instanceof Boolean ? (Boolean)object : false;
        object = pDFReader.getObject(dict2.get("EndOfBlock"));
        boolean bl3 = object instanceof Boolean ? (Boolean)object : true;
        object = pDFReader.getObject(dict2.get("EncodedByteAlign"));
        boolean bl4 = object instanceof Boolean ? (Boolean)object : false;
        object = pDFReader.getObject(dict2.get("BlackIs1"));
        boolean bl5 = object instanceof Boolean ? (Boolean)object : false;
        object = dict2.get("DamagedRowsBeforeError");
        int n7 = object != null ? pDFReader.getObjInt(object) : 0;
        boolean bl6 = Arrays.equals(Normalize.A10, (Object[])pDFReader.getObject(dict.get("Decode")));
        byte by = (byte)(bl5 ^ bl6 ? 1 : 0);
        BufferedImage bufferedImage = Fax.decode(n2, n, n6, bl2, bl3, bl4, by, n7, inputStream);
        object = pDFReader.getObject(dict.get("ImageMask"));
        boolean bl7 = bl = object instanceof Boolean ? (Boolean)object : false;
        if (bl && !Color.BLACK.equals(color)) {
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, new int[]{0, color.getRGB()}, 0, true, 0, 0);
            bufferedImage = new BufferedImage(indexColorModel, bufferedImage.getRaster(), false, new Hashtable());
        }
        return bufferedImage;
    }

    static BufferedImage createJBIG2(Dict dict, InputStream inputStream) throws IOException {
        PDF.sampledata("JBIG2");
        return null;
    }

    static BufferedImage createRaw(Dict dict, int n, int n2, InputStream inputStream, Color color, PDFReader pDFReader) throws IOException {
        if (!($assertionsDisabled || dict != null && n > 0 && n2 > 0 && inputStream != null && color != null && pDFReader != null)) {
            throw new AssertionError();
        }
        Boolean bl = (Boolean)pDFReader.getObject(pDFReader.getObject(dict.get("ImageMask")));
        int n3 = bl == Boolean.TRUE ? 1 : pDFReader.getObjInt(dict.get("BitsPerComponent"));
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Decode"));
        ColorModel colorModel = Images.createRawColorModel(pDFReader.getObject(dict.get("ColorSpace")), bl, n3, color, pDFReader);
        int n4 = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
        byte[] byArray = Images.readRawData(inputStream, n * n2 * n4, objectArray);
        if (n3 == 8 && colorModel.getColorSpace() instanceof ColorSpaceCMYK) {
            byArray = Images.transcode4to3(byArray, n, n2, n3);
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
            n4 = 3;
        }
        if (byArray.length < (n * n2 * n4 * n3 + n3 - 1) / 8) {
            System.out.println("short data: " + byArray.length + " < " + (n * n2 * n4 * n3 + n3 - 1) / 8 + ": " + n + "x" + n2 + " * " + n4 + " @ " + n3 + " bpp");
            System.out.println(dict);
            return null;
        }
        WritableRaster writableRaster = Images.createRawRaster(byArray, n, n2, n3, n4);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, new Hashtable());
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.out.println("color model = " + colorModel);
            SampleModel sampleModel = writableRaster.getSampleModel();
            System.out.println("sample model = " + sampleModel);
            System.out.println("sample model instance of ComponentSampleModel " + (sampleModel instanceof ComponentSampleModel));
            System.out.println("num bands = " + sampleModel.getNumBands() + " ==? " + colorModel.getNumComponents() + " cm num comp");
            int[] nArray = colorModel.getComponentSize();
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("  " + sampleModel.getSampleSize(i) + " >=? " + nArray[i]);
            }
            System.out.println(writableRaster.getTransferType() + " ==? " + sampleModel.getTransferType());
        }
        return bufferedImage;
    }

    private static ColorModel createRawColorModel(Object object, Boolean bl, int n, Color color, PDFReader pDFReader) throws IOException {
        ColorModel colorModel;
        Object object2 = pDFReader.getObject(object);
        ColorSpace colorSpace = pDFReader.getColorSpace(object, null, null);
        if (!($assertionsDisabled || colorSpace != null || bl != null && bl.booleanValue())) {
            throw new AssertionError();
        }
        if (bl != null && bl.booleanValue()) {
            if (!$assertionsDisabled && n != 1) {
                throw new AssertionError();
            }
            colorModel = new IndexColorModel(1, 2, new int[]{color.getRGB(), 0}, 0, true, 1, 0);
        } else if (COS.CLASS_ARRAY == object2.getClass() && ("Indexed".equals(((Object[])object2)[0]) || "I".equals(((Object[])object2)[0]))) {
            int n2;
            Object object3;
            byte[] byArray;
            Object[] objectArray = (Object[])object2;
            int n3 = pDFReader.getObjInt(objectArray[2]);
            Object object4 = pDFReader.getObject(objectArray[3]);
            if (!$assertionsDisabled && COS.CLASS_DICTIONARY != object4.getClass() && COS.CLASS_STRING != object4.getClass()) {
                throw new AssertionError();
            }
            if (COS.CLASS_DICTIONARY == object4.getClass()) {
                byArray = pDFReader.getStreamData(objectArray[3], false, false);
            } else {
                if (!$assertionsDisabled && COS.CLASS_STRING != object4.getClass()) {
                    throw new AssertionError();
                }
                object3 = (StringBuffer)object4;
                byArray = new byte[((StringBuffer)object3).length()];
                n2 = ((StringBuffer)object3).length();
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = (byte)(((StringBuffer)object3).charAt(i) & 0xFF);
                }
            }
            object3 = pDFReader.getObject(objectArray[1]);
            if (null != object3 && !"DeviceRGB".equals(object3) && !"RGB".equals(object3)) {
                ColorSpace colorSpace2 = pDFReader.getColorSpace(object3, null, null);
                n2 = colorSpace2.getNumComponents();
                int n4 = byArray.length / n2;
                byte[] byArray2 = new byte[n4 * 3];
                float[] fArray = new float[n2];
                int n5 = 0;
                int n6 = 0;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        fArray[j] = (float)(byArray[n5++] & 0xFF) / 256.0f;
                    }
                    float[] fArray2 = colorSpace2.toRGB(fArray);
                    for (int j = 0; j < 3; ++j) {
                        byArray2[n6++] = (byte)(fArray2[j] * 256.0f);
                    }
                }
                byArray = byArray2;
            }
            colorModel = new IndexColorModel(n, Math.min(1 << n, n3 + 1), byArray, 0, false);
        } else if (colorSpace.getNumComponents() == 1 && n < 8) {
            colorModel = n == 1 ? new IndexColorModel(1, 2, new int[]{0, 0xFFFFFF}, 0, false, -1, 0) : (n == 2 ? new IndexColorModel(2, 4, new int[]{0, 0x404040, 0xC0C0C0, 0xFFFFFF}, 0, false, -1, 0) : new IndexColorModel(4, 16, new int[]{0, 0x111111, 0x222222, 0x333333, 0x444444, 0x555555, 0x666666, 0x777777, 0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB, 0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF}, 0, false, -1, 0));
        } else if (n == 8 || n == 4) {
            colorModel = new ComponentColorModel(colorSpace, false, true, 1, 0);
        } else {
            int n7 = colorSpace.getNumComponents();
            if (!$assertionsDisabled && (n7 != 3 && n7 != 4 || n != 2 && n != 1)) {
                throw new AssertionError((Object)("bpc=" + n));
            }
            int n8 = 1 << n;
            byte[] byArray = new byte[(1 << n * n7) * n7];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 1.0f / (float)n8;
            float[] fArray = new float[4];
            int n9 = 0;
            int n10 = 0;
            while (n10 < n8) {
                fArray[0] = f;
                int n11 = 0;
                while (n11 < n8) {
                    fArray[1] = f2;
                    int n12 = 0;
                    while (n12 < n8) {
                        fArray[2] = f3;
                        int n13 = 0;
                        while (n13 < n8) {
                            fArray[3] = f4;
                            Color color2 = new Color(colorSpace, fArray, 0.0f);
                            byArray[n9++] = (byte)color2.getRed();
                            byArray[n9++] = (byte)color2.getGreen();
                            byArray[n9++] = (byte)color2.getBlue();
                            if (n7 == 3) break;
                            ++n13;
                            f4 += f5;
                        }
                        ++n12;
                        f3 += f5;
                        f4 = 0.0f;
                    }
                    ++n11;
                    f2 += f5;
                    f3 = 0.0f;
                    f4 = 0.0f;
                }
                ++n10;
                f += f5;
                f2 = 0.0f;
                f3 = 0.0f;
                f4 = 0.0f;
            }
            if (!$assertionsDisabled && n9 != byArray.length) {
                throw new AssertionError((Object)(n9 + " vs " + byArray.length));
            }
            colorModel = new IndexColorModel(n, byArray.length / n7, byArray, 0, false);
        }
        return colorModel;
    }

    private static byte[] readRawData(InputStream inputStream, int n, Object[] objectArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        Streams.copy(inputStream, byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (objectArray != null) {
            int n2;
            double[] dArray = new double[objectArray.length];
            int n3 = objectArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2] = ((Number)objectArray[n2]).doubleValue();
            }
            if (dArray.length == 2 && dArray[0] == 1.0 && dArray[1] == 0.0) {
                n2 = 0;
                n3 = byArray.length;
                while (n2 < n3) {
                    int n4 = n2++;
                    byArray[n4] = (byte)(byArray[n4] ^ 0xFF);
                }
            }
        }
        return byArray;
    }

    private static byte[] transcode4to3(byte[] byArray, int n, int n2, int n3) {
        if (!$assertionsDisabled && n3 != 8) {
            throw new AssertionError(n3);
        }
        if (!$assertionsDisabled && byArray.length != n * n2 * 4) {
            throw new AssertionError((Object)(byArray.length + " vs " + n * n2 * 4));
        }
        byte[] byArray2 = new byte[n * n2 * 3];
        int n4 = 0;
        int n5 = byArray.length;
        int n6 = 0;
        while (n4 < n5) {
            int n7 = byArray[n4 + 3] & 0xFF;
            byArray2[n6] = (byte)(255 - Math.min(255, (byArray[n4] & 0xFF) + n7));
            byArray2[n6 + 1] = (byte)(255 - Math.min(255, (byArray[n4 + 1] & 0xFF) + n7));
            byArray2[n6 + 2] = (byte)(255 - Math.min(255, (byArray[n4 + 2] & 0xFF) + n7));
            n4 += 4;
            n6 += 3;
        }
        return byArray2;
    }

    private static WritableRaster createRawRaster(byte[] byArray, int n, int n2, int n3, int n4) {
        WritableRaster writableRaster;
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = i;
        }
        if (n3 == 8 || n3 == 2 && n4 == 4) {
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n * n4, n4, nArray, null);
        } else if (n4 == 1) {
            if (!$assertionsDisabled && n3 != 4 && n3 != 2 && n3 != 1) {
                throw new AssertionError();
            }
            writableRaster = Raster.createPackedRaster(new DataBufferByte(byArray, byArray.length), n, n2, n3, null);
        } else if (n3 == 4 || n3 == 1 && n4 == 4) {
            byte[] byArray2 = new byte[n * n4 * n2];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = (n * n4 * n3 + 7) / 8;
            while (n5 < n2) {
                for (int i = 0; i < n; i += 2) {
                    byte by = byArray[n7++];
                    byArray2[n6++] = (byte)(by >> 4 & 0xF);
                    if (i + 1 >= n) continue;
                    byArray2[n6++] = (byte)(by & 0xF);
                }
                n7 = ++n5 * n8;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray2, byArray2.length), n, n2, n * n4, n4, nArray, null);
            PDF.sampledata("4 bpc x 2 bytes: " + byArray.length + " => " + byArray2.length);
        } else if (n3 == 2) {
            byte[] byArray3 = new byte[n * n2];
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = (n * n4 * n3 + 7) / 8;
            while (n11 < n2) {
                for (int i = 0; i < n; ++i) {
                    if (n9 < 6) {
                        n10 = n10 << 8 | byArray[n13++];
                        n9 += 8;
                    }
                    byArray3[n12++] = (byte)(n10 >> n9 - 6 & 0x3F);
                    n9 -= 6;
                }
                n13 = ++n11 * n14;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n, n2, n * n4, n4, new int[]{0}, null);
            PDF.sampledata("2 bpc packed BYTE: " + byArray.length + " => " + byArray3.length);
        } else {
            if (!$assertionsDisabled && n3 != 1) {
                throw new AssertionError();
            }
            byte[] byArray4 = new byte[n * n2];
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = (n * n4 * n3 + 7) / 8;
            while (n17 < n2) {
                for (int i = 0; i < n; ++i) {
                    if (n15 < 3) {
                        n16 = n16 << 8 | byArray[n19++];
                        n15 += 8;
                    }
                    byArray4[n18++] = (byte)(n16 >> n15 - 3 & 7);
                    n15 -= 3;
                }
                n19 = ++n17 * n20;
            }
            writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray4, byArray4.length), n, n2, n * n4, n4, new int[]{0}, null);
            PDF.sampledata("1 bit packed byte: " + byArray.length + " => " + byArray4.length);
        }
        return writableRaster;
    }

    static {
        $assertionsDisabled = !Images.class.desiredAssertionStatus();
    }
}

