/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import multivalent.std.adaptor.pdf.Calculator;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Exponential;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.Sampled;
import multivalent.std.adaptor.pdf.Stitching;

public abstract class Function {
    float[] domain_;
    float[] range_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Function getInstance(Object object, PDFReader pDFReader) throws IOException {
        Function function;
        if (!($assertionsDisabled || object != null && pDFReader != null)) {
            throw new AssertionError();
        }
        Dict dict = (Dict)pDFReader.getObject(object);
        int n = pDFReader.getObjInt(dict.get("FunctionType"));
        if (n == 3 || n == 4) {
            PDF.sampledata("function type " + n);
        }
        switch (n) {
            case 0: {
                function = new Sampled(object, dict, pDFReader);
                break;
            }
            case 2: {
                function = new Exponential(dict, pDFReader);
                break;
            }
            case 3: {
                function = new Stitching(dict, pDFReader);
                break;
            }
            case 4: {
                function = new Calculator(object, dict, pDFReader);
                break;
            }
            default: {
                function = null;
                if (!$assertionsDisabled) {
                    throw new AssertionError(n);
                }
                break;
            }
        }
        return function;
    }

    Function(Dict dict, PDFReader pDFReader) throws IOException {
        this.domain_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("Domain")), null);
        if (!$assertionsDisabled && this.domain_ == null) {
            throw new AssertionError();
        }
        this.range_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("Range")), null);
    }

    public abstract void compute(float[] var1, float[] var2);

    public int getM() {
        return this.domain_.length / 2;
    }

    public int getN() {
        return this.range_.length / 2;
    }

    float[] toFloatArray(Object[] objectArray, float[] fArray) throws IOException {
        if (objectArray == null) {
            return fArray;
        }
        float[] fArray2 = new float[objectArray.length];
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            fArray2[i] = ((Number)objectArray[i]).floatValue();
        }
        return fArray2;
    }

    int[] toIntArray(Object[] objectArray) throws IOException {
        int[] nArray = new int[objectArray.length];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((Number)objectArray[i]).intValue();
        }
        return nArray;
    }

    void clip(float[] fArray, float[] fArray2) {
        int n = fArray2.length / 2;
        if (!$assertionsDisabled && fArray.length * 2 < n) {
            throw new AssertionError((Object)(fArray.length + " vs " + fArray2.length));
        }
        for (int i = 0; i < n; ++i) {
            float f = fArray[i];
            float f2 = fArray2[i * 2];
            float f3 = fArray2[i * 2 + 1];
            if (f < f2) {
                fArray[i] = f2;
                continue;
            }
            if (!(f > f3)) continue;
            fArray[i] = f3;
        }
    }

    static {
        $assertionsDisabled = !Function.class.desiredAssertionStatus();
    }
}

