/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import multivalent.Context;
import multivalent.Node;
import multivalent.node.FixedIClip;
import multivalent.node.FixedLeafAscii;
import multivalent.node.FixedLeafShape;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.FontPDF;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;

public class FontType3
extends FontPDF {
    static FixedLeafAscii noglyph;
    static Context cx_;
    static final Rectangle EMPTY_SHAPE;
    Node[] glyphs_;
    double[] advances_;
    AffineTransform fontMatrix_;
    AffineTransform glyph2user_;
    String[] chnames_;
    Dict charProcs_;
    Dict page_;
    private Dict localpage_ = null;
    Rectangle fontBBox_;
    PDFReader pdfr_;
    PDF pdf_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FontType3(Dict dict, double d, float f, AffineTransform affineTransform, Dict dict2, PDF pDF, PDFReader pDFReader) throws IOException {
        super(dict, d, f, affineTransform, pDFReader);
        if (!($assertionsDisabled || dict != null && pDFReader != null)) {
            throw new AssertionError((Object)(dict + ", " + pDFReader));
        }
        Dict dict3 = (Dict)pDFReader.getObject(dict.get("Resources"));
        if (dict3 != null) {
            this.localpage_ = new Dict(5);
            this.localpage_.put("Resources", dict3);
        }
        this.setPage(dict2);
        this.initGlyphs(dict, pDFReader);
        this.pdf_ = pDF;
        this.pdfr_ = pDFReader;
    }

    public FontPDF deriveFont(double d, float f, AffineTransform affineTransform) {
        FontType3 fontType3 = (FontType3)super.deriveFont(d, f, affineTransform);
        if (fontType3 == this) {
            return this;
        }
        Arrays.fill(fontType3.glyphs_, null);
        fontType3.setGlyph2User(d, affineTransform);
        return fontType3;
    }

    public void setPage(Dict dict) {
        this.page_ = this.localpage_ != null ? this.localpage_ : dict;
    }

    AffineTransform getFontMatrix() {
        return this.fontMatrix_;
    }

    void setWidths(Dict dict, PDFReader pDFReader) throws IOException {
        super.setWidths(dict, pDFReader);
        double d = this.fontMatrix_.getScaleX();
        if (d != 1.0) {
            if (this.fstdwidths_) {
                this.widths_ = (int[])this.widths_.clone();
                this.fstdwidths_ = false;
            }
            int n = 0;
            int n2 = this.widths_.length;
            while (n < n2) {
                int n3 = n++;
                this.widths_[n3] = (int)((double)this.widths_[n3] * d);
            }
        }
    }

    Font createFont(Dict dict, double d, float f, AffineTransform affineTransform, PDFReader pDFReader) throws IOException {
        Object object;
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("FontMatrix"));
        if (objectArray != null) {
            object = new double[6];
            PDF.getDoubles(objectArray, (double[])object, 6);
            this.fontMatrix_ = new AffineTransform((double[])object);
        } else {
            this.fontMatrix_ = new AffineTransform();
        }
        this.setGlyph2User(d, affineTransform);
        object = new HashMap(5);
        object.put(TextAttribute.FAMILY, "Times-Roman");
        object.put(TextAttribute.SIZE, new Float(f));
        return BASEFONT.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)object);
    }

    void setGlyph2User(double d, AffineTransform affineTransform) {
        this.glyph2user_ = new AffineTransform(this.fontMatrix_);
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX() * d, affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY() * d, 0.0, 0.0);
        this.glyph2user_.concatenate(affineTransform2);
    }

    void initGlyphs(Dict dict, PDFReader pDFReader) throws IOException {
        Object object = pDFReader.getObject(dict.get("Encoding"));
        Dict dict2 = object != null && COS.CLASS_DICTIONARY == object.getClass() ? (Dict)object : null;
        Object[] objectArray = (Object[])pDFReader.getObject(dict2.get("Differences"));
        Rectangle rectangle = COS.array2Rectangle((Object[])pDFReader.getObject(dict.get("FontBBox")), null, false);
        rectangle.width = (int)((double)rectangle.width * this.glyph2user_.getScaleX());
        rectangle.height = (int)((double)rectangle.height * this.glyph2user_.getScaleY());
        this.fontBBox_ = rectangle;
        this.charProcs_ = (Dict)pDFReader.getObject(dict.get("CharProcs"));
        this.glyphs_ = new Node[this.lastch_ - this.firstch_ + 1];
        this.advances_ = new double[this.glyphs_.length];
        this.chnames_ = new String[this.glyphs_.length];
        int n = objectArray.length;
        int n2 = 0;
        int n3 = this.glyphs_.length;
        for (int i = 0; i < n; ++i) {
            object = objectArray[i];
            if (object instanceof Number) {
                n2 = ((Number)object).intValue() - this.firstch_;
                continue;
            }
            if (!$assertionsDisabled && COS.CLASS_NAME != object.getClass()) {
                throw new AssertionError();
            }
            if (n2 >= n3) continue;
            this.chnames_[n2++] = (String)object;
        }
    }

    void createGlyph(int n) throws IOException {
        String string = this.chnames_[n];
        PDFReader pDFReader = this.pdfr_;
        Object object = this.charProcs_.get(string);
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(object, true);
        Rectangle rectangle = new Rectangle(this.fontBBox_);
        FixedIClip fixedIClip = new FixedIClip(string, null, null, rectangle, rectangle);
        try {
            this.pdf_.buildStream(this.page_, fixedIClip, new AffineTransform(this.glyph2user_), inputStreamComposite, null);
        }
        catch (Exception exception) {
            new FixedLeafShape("bad_glyph", null, fixedIClip, EMPTY_SHAPE, false, true);
        }
        inputStreamComposite.close();
        Node node = fixedIClip;
        this.advances_[n] = (double)fixedIClip.getBbox().width * this.glyph2user_.getScaleX();
        if (fixedIClip.size() == 0) {
            node = noglyph;
        } else if (fixedIClip.size() == 1 && fixedIClip.sizeSticky() == 0) {
            node = fixedIClip.removeChildAt(0);
            node.setName(fixedIClip.getName());
        }
        if (!node.isValid()) {
            cx_.reset();
            node.formatNode(0, 0, cx_);
        }
        if (!$assertionsDisabled && !node.isValid()) {
            throw new AssertionError();
        }
        this.glyphs_[n] = node;
    }

    public double measureText(StringBuffer stringBuffer, int n, int n2) {
        double d = super.measureText(stringBuffer, n, n2);
        for (int i = n; i < n2; ++i) {
            d += this.getAdvance(stringBuffer.charAt(i));
        }
        return d;
    }

    public Node getGlyph(char c) {
        if (!($assertionsDisabled || this.firstch_ <= c && c <= this.lastch_)) {
            throw new AssertionError((Object)(this.firstch_ + " .. " + c + " .. " + this.lastch_));
        }
        int n = c - this.firstch_;
        if (this.glyphs_[n] == null) {
            try {
                this.createGlyph(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!$assertionsDisabled && this.glyphs_[n] == null) {
            throw new AssertionError((int)c);
        }
        return this.glyphs_[n];
    }

    public double getAdvance(char c) {
        int n = c - this.firstch_;
        if (this.glyphs_[n] == null) {
            try {
                this.createGlyph(n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.advances_[n];
    }

    static {
        $assertionsDisabled = !FontType3.class.desiredAssertionStatus();
        noglyph = new FixedLeafAscii("", null, null);
        noglyph.getIbbox().setBounds(0, 0, 0, 0);
        noglyph.getBbox().setBounds(0, 0, 0, 0);
        noglyph.setValid(true);
        cx_ = new Context(Toolkit.getDefaultToolkit());
        EMPTY_SHAPE = new Rectangle(0, 0, 0, 0);
    }
}

