/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.OpenType;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import multivalent.Behavior;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Core14AFM;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encoding;
import multivalent.std.adaptor.pdf.FontType3;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.awt.Fonts;

public class FontPDF
implements Cloneable {
    public static final int FLAG_NOFLAG = 0;
    public static final int FLAG_FIXEDPITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALLCAP = 65536;
    public static final int FLAG_SMALLCAP = 131072;
    public static final int FLAG_FORCEBOLD = 262144;
    public static final int FLAG_DEFAULT = 34;
    static final Font BASEFONT;
    static final String[] FONTNAMES;
    private static final Map<String, String> standardFonts_;
    private static final AffineTransform IDENTITY_TRANSFORM;
    private float a2s = 72.0f / (float)Toolkit.getDefaultToolkit().getScreenResolution();
    private Font tf_;
    double size_;
    Encoding encoding_ = null;
    int[] widths_ = null;
    boolean fstdwidths_;
    Rectangle2D maxr_;
    int firstch_;
    int lastch_;
    boolean fTeX_ = false;
    AffineTransform shaping_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String[] getStandardFontNames() {
        return (String[])FONTNAMES.clone();
    }

    public static String getCanonical(String string) {
        return standardFonts_.get(string);
    }

    public static FontPDF create(Dict dict, double d, float f, AffineTransform affineTransform, Dict dict2, PDF pDF, PDFReader pDFReader) throws IOException {
        String string = (String)pDFReader.getObject(dict.get("Subtype"));
        FontPDF fontPDF = "Type3".equals(string) ? new FontType3(dict, d, f, affineTransform, dict2, pDF, pDFReader) : new FontPDF(dict, d, f, affineTransform, pDFReader);
        return fontPDF;
    }

    FontPDF(Dict dict, double d, float f, AffineTransform affineTransform, PDFReader pDFReader) throws IOException {
        this.size_ = f;
        this.tf_ = this.createFont(dict, d, f, affineTransform, pDFReader);
        this.setEncoding(dict, pDFReader);
        this.setWidths(dict, pDFReader);
        this.shaping_ = this.computeShaping(dict, pDFReader);
        f = (float)((double)f * this.shaping_.getScaleX() * (double)this.a2s);
        if ((double)Math.abs(f - this.tf_.getSize2D()) > 0.001) {
            this.tf_ = this.tf_.deriveFont(f);
        }
        this.setMaxr(affineTransform);
    }

    public FontPDF deriveFont(double d, float f, AffineTransform affineTransform) {
        float f2 = (float)((double)f * this.shaping_.getScaleX()) * this.a2s;
        if ((double)Math.abs(f2 - this.tf_.getSize2D()) < 0.001) {
            return this;
        }
        FontPDF fontPDF = null;
        try {
            fontPDF = (FontPDF)this.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        fontPDF.size_ = f;
        fontPDF.tf_ = this.tf_.deriveFont(f2);
        fontPDF.setMaxr(affineTransform);
        return fontPDF;
    }

    public double getSize2D() {
        return this.size_;
    }

    public String getFamily() {
        return this.tf_.getFamily();
    }

    public Font getFont() {
        return this.tf_;
    }

    public Rectangle2D getMaxCharBounds() {
        return this.maxr_;
    }

    public boolean canRender() {
        return this.widths_ != null;
    }

    void setMaxr(AffineTransform affineTransform) {
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        this.maxr_ = this.tf_.getMaxCharBounds(fontRenderContext);
    }

    void setWidths(Dict dict, PDFReader pDFReader) throws IOException {
        if (!$assertionsDisabled && this.encoding_ == null) {
            throw new AssertionError();
        }
        Object object = pDFReader.getObject(dict.get("Widths"));
        if (object != null && object.getClass() == COS.CLASS_ARRAY) {
            Object[] objectArray = (Object[])object;
            int[] nArray = new int[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                nArray[i] = pDFReader.getObjInt(objectArray[i]);
            }
            this.widths_ = nArray;
            object = dict.get("FirstChar");
            this.firstch_ = object != null ? pDFReader.getObjInt(object) : 0;
            this.fstdwidths_ = false;
        } else {
            if (!$assertionsDisabled && object != null) {
                throw new AssertionError(object);
            }
            this.widths_ = Core14AFM.getWidths(FontPDF.getCanonical((String)dict.get("BaseFont")));
            this.firstch_ = 32;
            this.fstdwidths_ = true;
            boolean bl = this.fstdwidths_ = !this.fTeX_;
        }
        if (this.widths_ != null) {
            object = dict.get("LastChar");
            this.lastch_ = object != null ? pDFReader.getObjInt(object) : this.firstch_ + this.widths_.length;
        }
    }

    AffineTransform computeShaping(Dict dict, PDFReader pDFReader) throws IOException {
        int n;
        int n2;
        int[] nArray = this.widths_;
        if (nArray == null) {
            return IDENTITY_TRANSFORM;
        }
        String string = (String)pDFReader.getObject(dict.get("BaseFont"));
        Dict dict2 = (Dict)pDFReader.getObject(dict.get("FontDescriptor"));
        if (dict2 == null) {
            dict2 = Core14AFM.getFontDescriptor(string);
        }
        Object object = null;
        int n3 = n2 = dict2 != null && (object = dict2.get("Flags")) != null ? pDFReader.getObjInt(object) : 34;
        if ((n2 & 4) != 0) {
            return IDENTITY_TRANSFORM;
        }
        int n4 = nArray.length;
        Font font = this.tf_;
        int n5 = this.firstch_;
        int n6 = this.lastch_;
        double d = this.size_;
        StringBuffer stringBuffer = new StringBuffer(n4);
        int n7 = Math.min(123, n6);
        for (n = Math.max(n5, 97); n < n7; ++n) {
            stringBuffer.append((char)n);
        }
        n7 = Math.min(91, n6);
        for (n = Math.max(n5, 65); n < n7; ++n) {
            stringBuffer.append((char)n);
        }
        n7 = Math.min(58, n6);
        for (n = Math.max(n5, 48); n < n7; ++n) {
            stringBuffer.append((char)n);
        }
        if (stringBuffer.length() == 0) {
            return IDENTITY_TRANSFORM;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        String string2 = this.translate(stringBuffer);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, string2);
        float f = 0.0f;
        float f2 = 0.0f;
        int n8 = glyphVector.getNumGlyphs();
        for (int i = 0; i < n8; ++i) {
            int n9 = nArray[string2.charAt(i) - n5];
            if (n9 == 0) continue;
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(i);
            float f3 = (float)((double)n9 / 1000.0 * d);
            float f4 = glyphMetrics.getAdvanceX();
            f += f3;
            f2 += f4;
        }
        double d2 = (double)f > 0.0 && (double)f2 > 0.0 ? (double)(f / f2) : 1.0;
        return AffineTransform.getScaleInstance(d2, d2);
    }

    public double measureText(char c) {
        int n = c - this.firstch_;
        return this.widths_ != null && n >= 0 && n < this.widths_.length ? (double)this.widths_[n] / 1000.0 * this.size_ : 0.0;
    }

    public double measureText(StringBuffer stringBuffer, int n, int n2) {
        int[] nArray = this.widths_;
        if (nArray == null) {
            return 0.0;
        }
        int n3 = 0;
        int n4 = this.firstch_;
        int n5 = nArray.length;
        for (int i = n; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            int n6 = c - n4;
            if (n6 < 0 || n6 >= n5) continue;
            n3 += nArray[n6];
        }
        return (double)n3 / 1000.0 * this.size_;
    }

    void setEncoding(Dict dict, PDFReader pDFReader) throws IOException {
        Object object;
        Object object2 = pDFReader.getObject(dict.get("Encoding"));
        if (this.fTeX_ && object2 instanceof Dict) {
            if (object2 == null) {
                object2 = new Dict(3);
                dict.put("Encoding", object2);
            }
            object = (Dict)object2;
            ((Dict)object).put("BaseEncoding", "TeX");
        }
        this.encoding_ = Encoding.getInstance(dict, pDFReader);
        if (this.fTeX_) {
            object = (char[])this.encoding_.toUni_.clone();
            int n = this.tf_.canDisplay('\u00ab') ? 161 : 163;
            int n2 = ((Object)object).length;
            for (int i = 0; i < n2; ++i) {
                if (object[i] >= 32) continue;
                Object object3 = object;
                int n3 = i;
                object3[n3] = (char)(object3[n3] + n);
            }
            this.encoding_.toUni_ = (char[])object;
        }
        if (!$assertionsDisabled && this.encoding_ == null) {
            throw new AssertionError(dict);
        }
    }

    public String translate(StringBuffer stringBuffer) {
        return this.encoding_.translate(stringBuffer, this.fstdwidths_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Font createFont(Dict dict, double d, float f, AffineTransform affineTransform, PDFReader pDFReader) throws IOException {
        if (!($assertionsDisabled || dict != null && f >= 0.0f)) {
            throw new AssertionError((Object)(dict + ", size=" + f));
        }
        if (!$assertionsDisabled && !"Font".equals(dict.get("Type")) && null != dict.get("Type")) {
            throw new AssertionError();
        }
        String string = (String)pDFReader.getObject(dict.get("BaseFont"));
        Dict dict2 = (Dict)pDFReader.getObject(dict.get("FontDescriptor"));
        if (dict2 == null) {
            dict2 = Core14AFM.getFontDescriptor(string);
        }
        Font font = BASEFONT;
        String string2 = (String)pDFReader.getObject(dict.get("Subtype"));
        if ("Type0".equals(string2)) {
            font = BASEFONT;
            PDF.unsupported("embedded Type 0 font " + string);
        } else {
            Object object;
            boolean bl = false;
            if (dict2 == null) {
                font = new Font(string, 0, 12);
                font = font.deriveFont(f);
            } else {
                Object object2 = (IRef)dict2.get("FontFile");
                if (object2 != null || "Type1C".equals(string2) && (object2 = (IRef)dict2.get("FontFile3")) != null) {
                    object = pDFReader.getInputStream(object2);
                    ((InputStream)object).close();
                } else {
                    object2 = dict2.get("FontFile2");
                    if (object2 != null) {
                        object = pDFReader.getInputStream(object2);
                        try {
                            font = Font.createFont(0, (InputStream)object);
                            font = font.deriveFont(f);
                            bl = true;
                        }
                        catch (FontFormatException fontFormatException) {
                            System.err.println("couldn't create embedded TrueType:" + fontFormatException);
                        }
                        finally {
                            ((InputStream)object).close();
                        }
                    } else if (dict2.get("FontFile3") != null) {
                        // empty if block
                    }
                }
            }
            if (!bl && (object = Behavior.getInstance("dvi", "DVI", null, null, null)) != null) {
                InputStream inputStream;
                String string3 = string.toLowerCase();
                int n = string3.indexOf(43);
                if (n != -1) {
                    string3 = string3.substring(n + 1);
                }
                if ((inputStream = object.getClass().getResourceAsStream("fonts/" + string3 + ".ttf")) != null) {
                    try {
                        font = Font.createFont(0, inputStream);
                        font = font.deriveFont(f);
                        bl = true;
                        this.fTeX_ = true;
                    }
                    catch (FontFormatException fontFormatException) {
                        System.out.println(fontFormatException);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            if (!bl) {
                object = dict2 != null ? dict2.get("Flags") : null;
                int n = object != null ? pDFReader.getObjInt(object) : 34;
                font = Fonts.createFont(string, FontPDF.getCanonical(string), f, n);
            }
        }
        if (font instanceof OpenType) {
            OpenType openType = (OpenType)((Object)font);
            System.out.println("OpenType v" + (openType.getVersion() >> 16) + "." + (openType.getVersion() & 0xFFFF));
        }
        if (!$assertionsDisabled && font == null) {
            throw new AssertionError((Object)string);
        }
        return font;
    }

    static {
        $assertionsDisabled = !FontPDF.class.desiredAssertionStatus();
        BASEFONT = new Font("Times", 0, 12);
        FONTNAMES = new String[]{"Times-Roman", "TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", null, "Times-Bold", "TimesNewRomanPS-BoldMT", "TimesNewRoman,Bold", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", null, "Times-Italic", "TimesNewRomanPS-ItalicMT", "TimesNewRoman,Italic", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", null, "Times-BoldItalic", "TimesNewRomanPS-BoldItalicMT", "TimesNewRoman,BoldItalic", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", null, "Helvetica", "ArialMT", "Arial", null, "Helvetica-Bold", "Arial-BoldMT", "Arial,Bold", "Arial-Bold", "Helvetica,Bold", null, "Helvetica-Oblique", "Arial-ItalicMT", "Arial,Italic", "Arial-Italic", "Helvetica,Italic", "Helvetica-Italic", null, "Helvetica-BoldOblique", "Arial-BoldItalicMT", "Arial,BoldItalic", "Arial-BoldItalic", "Helvetica,BoldItalic", "Helvetica-BoldItalic", null, "Courier", "CourierNew", "CourierNewPSMT", null, "Courier-Bold", "CourierNew,Bold", "Courier,Bold", "CourierNewPS-BoldMT", "CourierNew-Bold", null, "Courier-Oblique", "CourierNew,Italic", "Courier,Italic", "CourierNewPS-ItalicMT", "CourierNew-Italic", null, "Courier-BoldOblique", "CourierNew,BoldItalic", "Courier,BoldItalic", "CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", null, "Symbol", null, "ZapfDingbats", null};
        standardFonts_ = new HashMap<String, String>(FONTNAMES.length);
        String string = null;
        int n = FONTNAMES.length;
        for (int i = 0; i < n; ++i) {
            String string2 = FONTNAMES[i];
            if (string2 == null) {
                string = null;
                continue;
            }
            if (string == null) {
                string = string2;
            }
            standardFonts_.put(string2, string);
        }
        IDENTITY_TRANSFORM = new AffineTransform();
    }
}

