/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.io.IOException;
import multivalent.Context;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.node.Fixed;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.FixedLeafShadeAxial;
import multivalent.std.adaptor.pdf.FixedLeafShadeCoons;
import multivalent.std.adaptor.pdf.FixedLeafShadeFn;
import multivalent.std.adaptor.pdf.FixedLeafShadeGFree;
import multivalent.std.adaptor.pdf.FixedLeafShadeGLattice;
import multivalent.std.adaptor.pdf.FixedLeafShadeRadial;
import multivalent.std.adaptor.pdf.FixedLeafShadeTensor;
import multivalent.std.adaptor.pdf.Function;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;

public class FixedLeafShade
extends Leaf
implements Fixed {
    Rectangle ibbox_;
    ColorSpace cs_;
    Color bg_;
    boolean antialias_;
    Object fun_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static FixedLeafShade getInstance(Dict dict, ColorSpace colorSpace, Rectangle rectangle, INode iNode, PDFReader pDFReader) throws IOException {
        FixedLeafShade fixedLeafShade;
        int n = pDFReader.getObjInt(dict.get("ShadingType"));
        switch (n) {
            case 1: {
                fixedLeafShade = new FixedLeafShadeFn(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 2: {
                fixedLeafShade = new FixedLeafShadeAxial(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 3: {
                fixedLeafShade = new FixedLeafShadeRadial(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 4: {
                fixedLeafShade = new FixedLeafShadeGFree(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 5: {
                fixedLeafShade = new FixedLeafShadeGLattice(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 6: {
                fixedLeafShade = new FixedLeafShadeCoons(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            case 7: {
                fixedLeafShade = new FixedLeafShadeTensor(iNode, dict, colorSpace, rectangle, pDFReader);
                break;
            }
            default: {
                fixedLeafShade = null;
                if (!$assertionsDisabled) {
                    throw new AssertionError(n);
                }
                break;
            }
        }
        return fixedLeafShade;
    }

    protected FixedLeafShade(String string, Dict dict, INode iNode, ColorSpace colorSpace, Rectangle rectangle, PDFReader pDFReader) throws IOException {
        super(string, null, iNode);
        Object object;
        this.ibbox_ = new Rectangle(rectangle);
        this.getBbox().setBounds(rectangle);
        this.cs_ = colorSpace;
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Background"));
        if (objectArray != null) {
            object = new float[objectArray.length];
            PDF.getFloats(objectArray, (float[])object, objectArray.length);
            float[] fArray = colorSpace.toRGB((float[])object);
            this.bg_ = new Color(fArray[0], fArray[1], fArray[2], 1.0f);
        }
        boolean bl = (object = (Object)pDFReader.getObject(dict.get("AntiAlias"))) instanceof Boolean && (Boolean)object != false;
        Object object2 = dict.get("Function");
        object = pDFReader.getObject(object2);
        if (object == null) {
            this.fun_ = null;
        } else if (COS.CLASS_DICTIONARY == object.getClass()) {
            this.fun_ = Function.getInstance(object2, pDFReader);
        } else {
            if (!$assertionsDisabled && COS.CLASS_ARRAY != object.getClass()) {
                throw new AssertionError(object);
            }
            objectArray = (Object[])object;
            Function[] functionArray = new Function[objectArray.length];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                functionArray[i] = Function.getInstance(objectArray[i], pDFReader);
            }
            this.fun_ = functionArray;
        }
    }

    public Rectangle getIbbox() {
        return this.ibbox_;
    }

    void compute(Object object, float[] fArray, float[] fArray2) {
        int n = fArray2.length;
        if (object instanceof Function) {
            ((Function)object).compute(fArray, fArray2);
        } else {
            if (!$assertionsDisabled && !(object instanceof Function[])) {
                throw new AssertionError();
            }
            Function[] functionArray = (Function[])object;
            if (!$assertionsDisabled && n != functionArray.length) {
                throw new AssertionError((Object)(n + " vs " + functionArray.length));
            }
            float[] fArray3 = new float[1];
            for (int i = 0; i < n; ++i) {
                functionArray[i].compute(fArray, fArray3);
                fArray2[i] = fArray3[0];
            }
        }
    }

    public boolean paintNodeContent(Context context, int n, int n2) {
        if (this.bg_ != null) {
            Graphics2D graphics2D = context.g;
            graphics2D.setColor(this.bg_);
            graphics2D.fill(this.getBbox());
        }
        return false;
    }

    static {
        $assertionsDisabled = !FixedLeafShade.class.desiredAssertionStatus();
    }
}

