/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.SecurityHandler;

public class Encrypt {
    private COSSource coss_;
    private int V_ = -1;
    private Dict CF_ = null;
    private SecurityHandler sh_;
    private CryptFilter StmF_;
    private CryptFilter StrF_;
    private Map<String, CryptFilter> cache_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Encrypt(Dict dict, COSSource cOSSource) {
        this.coss_ = cOSSource;
        if (dict == null || dict.size() == 0) {
            this.sh_ = SecurityHandler.IDENTITY;
            this.StmF_ = this.StrF_ = CryptFilter.IDENTITY;
        } else {
            Object object = dict.get("V");
            int n = this.V_ = object != null ? ((Number)object).intValue() : 0;
            if (!($assertionsDisabled || this.V_ >= 0 && this.V_ <= 4)) {
                throw new AssertionError(this.V_);
            }
            String string = (String)dict.get("Filter");
            String string2 = (String)dict.get("SubFilter");
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            this.sh_ = SecurityHandler.getInstance(string, dict, cOSSource);
            if (!$assertionsDisabled && this.sh_ == null) {
                throw new AssertionError(dict);
            }
            if (this.V_ < 4) {
                this.StrF_ = this.StmF_ = new CryptFilter(null, this.sh_);
            } else if (this.V_ >= 4) {
                object = dict.get("CF");
                this.CF_ = object != null ? (Dict)object : new Dict(5);
                this.cache_ = new HashMap<String, CryptFilter>(7);
                this.StmF_ = this.getCryptFilter((String)dict.get("StmF"));
                this.StrF_ = this.getCryptFilter((String)dict.get("StrF"));
            }
        }
    }

    public CryptFilter getStmF() {
        return this.StmF_;
    }

    public CryptFilter getStrF() {
        return this.StrF_;
    }

    public SecurityHandler getSecurityHandler() {
        return this.sh_;
    }

    public int getV() {
        return this.V_;
    }

    public CryptFilter getCryptFilter(String string) {
        if ("Identity".equals(string) || null == string) {
            return CryptFilter.IDENTITY;
        }
        CryptFilter cryptFilter = this.cache_.get(string);
        if (cryptFilter != null) {
            return cryptFilter;
        }
        Dict dict = (Dict)this.CF_.get(string);
        if (!$assertionsDisabled && dict == null) {
            throw new AssertionError((Object)(string + " not i " + this.CF_));
        }
        return new CryptFilter(dict, this.sh_);
    }

    public CryptFilter getCryptFilter(Dict dict) throws IOException {
        CryptFilter cryptFilter = this.getStmF();
        if (this.coss_.compareVersion(1, 5) >= 0) {
            String string;
            Dict dict2 = (Dict)this.coss_.getDecodeParms(dict, "Crypt");
            String string2 = string = dict2 != null ? (String)this.coss_.getObject(dict2.get("Name")) : null;
            if (string != null) {
                cryptFilter = this.getCryptFilter(string);
            }
        }
        return cryptFilter;
    }

    public String toString() {
        return this.getStrF() + " / " + this.getStmF();
    }

    static {
        $assertionsDisabled = !Encrypt.class.desiredAssertionStatus();
    }
}

