/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IdentityH;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.awt.Fonts;
import phelps.lang.Strings;

public class Encoding {
    static final char[] macRomanMap_;
    static final char[] macExpertMap_;
    static final char[] winAnsiMap_;
    static final char[] standardMap_;
    static final char[] pdfMap_;
    static final char[] symbolMap_;
    static final char[] zapfMap_;
    static final char[] texMap_;
    static final char[] macRoman2std_;
    static final char[] winAnsi2std_;
    static final char[] pdf2std_;
    static final char[] IDENTITY_MAP;
    static final Encoding IDENTITY_ENCODING;
    static final Encoding IDENTITY_H_ENCODING;
    static final char INVALID_CHAR = '\u0000';
    static final String[] refTable_;
    static final String[] refTableSym_;
    static final String[] refTableZapf_;
    static final String[] refTableMacExpert_;
    static final String[] refTableTeX_;
    static final Map<String, String> uname2char_;
    static final Map<String, String> unameEx2char_;
    static final Map<String, String> unameTeX2char_;
    char[] toUni_;
    char[] toBase_;
    char[] toStd_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Encoding getInstance(Dict dict, PDFReader pDFReader) throws IOException {
        Encoding encoding;
        String string = (String)pDFReader.getObject(dict.get("Subtype"));
        if ("Type3".equals(string)) {
            return IDENTITY_ENCODING;
        }
        String string2 = (String)pDFReader.getObject(dict.get("BaseFont"));
        Dict dict2 = (Dict)pDFReader.getObject(dict.get("FontDescriptor"));
        Object object = pDFReader.getObject(dict.get("Encoding"));
        boolean bl = false;
        if ("Symbol".equals(string2) && File.separatorChar == '\\' && Arrays.binarySearch(Fonts.FAMILIES, "Standard Symbols L") >= 0) {
            bl = false;
        } else if ("TrueType".equals(string) && (object == null || "WinAnsiEncoding".equals(object)) && dict2 != null) {
            int n = pDFReader.getObjInt(dict2.get("Flags"));
            boolean bl2 = bl = (n & 4) != 0;
        }
        if (object == null) {
            encoding = new Encoding(null, string2, null, bl);
        } else if (object.getClass() == COS.CLASS_NAME) {
            encoding = "Identity-H".equals(object) || "Identity-V".equals(object) ? IDENTITY_H_ENCODING : ("Type0".equals(string) ? IDENTITY_ENCODING : new Encoding((String)object, string2, null, bl));
        } else {
            if (!$assertionsDisabled && object.getClass() != COS.CLASS_DICTIONARY) {
                throw new AssertionError();
            }
            Dict dict3 = (Dict)object;
            encoding = new Encoding((String)pDFReader.getObject(dict3.get("BaseEncoding")), string2, (Object[])pDFReader.getObject(dict3.get("Differences")), bl);
            if (dict2 != null && (dict2.get("FontFile") != null || dict2.get("FontFile2") != null || dict2.get("FontFile3") != null)) {
                encoding.toBase_ = IDENTITY_MAP;
            }
        }
        return encoding;
    }

    Encoding(char[] cArray) {
        this.toUni_ = cArray;
        this.toStd_ = IDENTITY_MAP;
        this.toBase_ = IDENTITY_MAP;
    }

    Encoding(String string, String string2, Object[] objectArray, boolean bl) {
        int n;
        int n2;
        int n3;
        char[] cArray;
        if (string == null && string2 != null) {
            string = "Symbol".equals(string2) ? "SymbolEncoding" : ("ZapfDingbats".equals(string2) ? "ZapfDingbatsEncoding" : "StandardEncoding");
        }
        this.toStd_ = IDENTITY_MAP;
        Map<String, String> map = uname2char_;
        if ("MacRomanEncoding".equals(string)) {
            cArray = macRomanMap_;
            n3 = 1;
            this.toStd_ = macRoman2std_;
        } else if ("MacExpertEncoding".equals(string)) {
            cArray = macExpertMap_;
            n3 = 0;
            map = unameEx2char_;
        } else if ("WinAnsiEncoding".equals(string)) {
            cArray = winAnsiMap_;
            n3 = 2;
            this.toStd_ = winAnsi2std_;
        } else if ("PDFDocEncoding".equals(string)) {
            cArray = pdfMap_;
            n3 = 3;
            this.toStd_ = pdf2std_;
        } else if ("SymbolEncoding".equals(string)) {
            cArray = symbolMap_;
            n3 = 0;
        } else if ("ZapfDingbatsEncoding".equals(string)) {
            cArray = zapfMap_;
            n3 = 0;
        } else if ("TeX".equals(string)) {
            cArray = texMap_;
            n3 = 0;
            map = unameTeX2char_;
        } else {
            if (!$assertionsDisabled && !"StandardEncoding".equals(string)) {
                throw new AssertionError();
            }
            cArray = standardMap_;
            n3 = 0;
        }
        if (objectArray != null || bl) {
            cArray = (char[])cArray.clone();
        }
        char[] cArray2 = IDENTITY_MAP;
        if (objectArray != null) {
            cArray2 = (char[])cArray2.clone();
            n2 = 0;
            int n4 = objectArray.length;
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                Object object = objectArray[n];
                if (object instanceof Number) {
                    n5 = ((Number)object).intValue();
                    continue;
                }
                if (!$assertionsDisabled && COS.CLASS_NAME != object.getClass()) {
                    throw new AssertionError();
                }
                if (".notdef".equals(object)) {
                    cArray[n5] = 32;
                } else {
                    String string3 = map.get(object);
                    if (string3 != null) {
                        cArray[n5] = string3.charAt(string3.length() - 1);
                        char c = string3.charAt(n3);
                        cArray2[n5] = c != '\u0000' ? c : (char)n5;
                    } else {
                        cArray[n5] = cArray2[n5] = (char)n5;
                    }
                }
                ++n5;
            }
        }
        if (bl) {
            n = cArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                cArray[n2] = (char)(cArray2[n2] + 61440);
            }
        }
        this.toUni_ = cArray;
        this.toBase_ = cArray2;
    }

    public String translate(StringBuffer stringBuffer, boolean bl) {
        if (!$assertionsDisabled && stringBuffer == null) {
            throw new AssertionError();
        }
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        if (!bl || this.toBase_ == IDENTITY_MAP && this.toStd_ == IDENTITY_MAP) {
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                stringBuffer2.append(this.toUni_[stringBuffer.charAt(i)]);
            }
        } else {
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                char c = stringBuffer.charAt(i);
                stringBuffer.setCharAt(i, this.toStd_[this.toBase_[c]]);
                stringBuffer2.append(this.toUni_[c]);
            }
        }
        return Strings.valueOf(stringBuffer2);
    }

    static {
        String string;
        int n;
        $assertionsDisabled = !Encoding.class.desiredAssertionStatus();
        macRomanMap_ = new char[256];
        macExpertMap_ = new char[256];
        winAnsiMap_ = new char[256];
        standardMap_ = new char[256];
        pdfMap_ = new char[256];
        symbolMap_ = new char[256];
        zapfMap_ = new char[256];
        texMap_ = new char[256];
        IDENTITY_MAP = new char[256];
        IDENTITY_H_ENCODING = new IdentityH();
        refTable_ = new String[]{"AE", "\u00e1\u00ae\u00c6\u00c6\u00c6", "Aacute", "\u0000\u00e7\u00c1\u00c1\u00c1", "Acircumflex", "\u0000\u00e5\u00c2\u00c2\u00c2", "Adieresis", "\u0000\u0080\u00c4\u00c4\u00c4", "Agrave", "\u0000\u00cb\u00c0\u00c0\u00c0", "Aring", "\u0000\u0081\u00c5\u00c5\u00c5", "Atilde", "\u0000\u00cc\u00c3\u00c3\u00c3", "Ccedilla", "\u0000\u0082\u00c7\u00c7\u00c7", "Eacute", "\u0000\u0083\u00c9\u00c9\u00c9", "Ecircumflex", "\u0000\u00e6\u00ca\u00ca\u00ca", "Edieresis", "\u0000\u00e8\u00cb\u00cb\u00cb", "Egrave", "\u0000\u00e9\u00c8\u00c8\u00c8", "Eth", "\u0000\u0000\u00d0\u00d0\u00d0", "Euro", "\u0000\u0000\u0080\u00a0\u20ac", "Iacute", "\u0000\u00ea\u00cd\u00cd\u00cd", "Icircumflex", "\u0000\u00eb\u00ce\u00ce\u00ce", "Idieresis", "\u0000\u00ec\u00cf\u00cf\u00cf", "Igrave", "\u0000\u00ed\u00cc\u00cc\u00cc", "Lslash", "\u00e8\u0000\u0000\u0095\u0141", "Ntilde", "\u0000\u0084\u00d1\u00d1\u00d1", "OE", "\u00ea\u00ce\u008c\u0096\u0152", "Oacute", "\u0000\u00ee\u00d3\u00d3\u00d3", "Ocircumflex", "\u0000\u00ef\u00d4\u00d4\u00d4", "Odieresis", "\u0000\u0085\u00d6\u00d6\u00d6", "Ograve", "\u0000\u00f1\u00d2\u00d2\u00d2", "Oslash", "\u00e9\u00af\u00d8\u00d8\u00d8", "Otilde", "\u0000\u00cd\u00d5\u00d5\u00d5", "Scaron", "\u0000\u0000\u008a\u0097\u0160", "Thorn", "\u0000\u0000\u00de\u00de\u00de", "Uacute", "\u0000\u00f2\u00da\u00da\u00da", "Ucircumflex", "\u0000\u00f3\u00db\u00db\u00db", "Udieresis", "\u0000\u0086\u00dc\u00dc\u00dc", "Ugrave", "\u0000\u00f4\u00d9\u00d9\u00d9", "Yacute", "\u0000\u0000\u00dd\u00dd\u00dd", "Ydieresis", "\u0000\u00d9\u009f\u0098\u0178", "Zcaron", "\u0000\u0000\u008e\u0099\u017d", "aacute", "\u0000\u0087\u00e1\u00e1\u00e1", "acircumflex", "\u0000\u0089\u00e2\u00e2\u00e2", "acute", "\u00c2\u00ab\u00b4\u00b4\u00b4", "adieresis", "\u0000\u008a\u00e4\u00e4\u00e4", "ae", "\u00f1\u00be\u00e6\u00e6\u00e6", "agrave", "\u0000\u0088\u00e0\u00e0\u00e0", "aring", "\u0000\u008c\u00e5\u00e5\u00e5", "asciicircum", "^^^^^", "asciitilde", "~~~~~", "asterisk", "*****", "atilde", "\u0000\u008b\u00e3\u00e3\u00e3", "breve", "\u00c6\u00f9\u0000\u0018\u0306", "brokenbar", "\u0000\u0000\u00a6\u00a6\u00a6", "bullet", "\u00b7\u00a5\u0095\u0080\u2022", "caron", "\u00cf\u00ff\u0000\u0019\u02c7", "ccedilla", "\u0000\u008d\u00e7\u00e7\u00e7", "cedilla", "\u00cb\u00fc\u00b8\u00b8\u00b8", "cent", "\u00a2\u00a2\u00a2\u00a2\u00a2", "circumflex", "\u00c3\u00f6\u0088\u001a\u02c6", "copyright", "\u0000\u00a9\u00a9\u00a9\u00a9", "currency", "\u00a8\u00db\u00a4\u00a4\u00a4", "dagger", "\u00b2\u00a0\u0086\u0081\u2020", "daggerdbl", "\u00b3\u00e0\u0087\u0082\u2021", "degree", "\u0000\u00a1\u00b0\u00b0\u00b0", "dieresis", "\u00c8\u00ac\u00a8\u00a8\u00a8", "divide", "\u0000\u00d6\u00f7\u00f7\u00f7", "dotaccent", "\u00c7\u00fa\u0000\u001b\u02d9", "dotlessi", "\u00f5\u00f5\u0000\u009a\u0131", "eacute", "\u0000\u008e\u00e9\u00e9\u00e9", "ecircumflex", "\u0000\u0090\u00ea\u00ea\u00ea", "edieresis", "\u0000\u0091\u00eb\u00eb\u00eb", "egrave", "\u0000\u008f\u00e8\u00e8\u00e8", "ellipsis", "\u00bc\u00c9\u0085\u0083\u2026", "emdash", "\u00d0\u00d1\u0097\u0084\u2014", "endash", "\u00b1\u00d0\u0096\u0085\u2013", "eth", "\u0000\u0000\u00f0\u00f0\u00f0", "exclamdown", "\u00a1\u00c1\u00a1\u00a1\u00a1", "fi", "\u00ae\u00de\u0000\u0093\ufb01", "fl", "\u00af\u00df\u0000\u0094\ufb02", "florin", "\u00a6\u00c4\u0083\u0086\u0192", "fraction", "\u00a4\u00da\u0000\u0087\u2044", "germandbls", "\u00fb\u00a7\u00df\u00df\u00df", "grave", "\u00c1````", "guillemotleft", "\u00ab\u00c7\u00ab\u00ab\u00ab", "guillemotright", "\u00bb\u00c8\u00bb\u00bb\u00bb", "guilsinglleft", "\u00ac\u00dc\u008b\u0088\u2039", "guilsinglright", "\u00ad\u00dd\u009b\u0089\u203a", "hungarumlaut", "\u00cd\u00fd\u0000\u001c\u00a8", "iacute", "\u0000\u0092\u00ed\u00ed\u00ed", "icircumflex", "\u0000\u0094\u00ee\u00ee\u00ee", "idieresis", "\u0000\u0095\u00ef\u00ef\u00ef", "igrave", "\u0000\u0093\u00ec\u00ec\u00ec", "logicalnot", "\u0000\u00c2\u00ac\u00ac\u00ac", "lslash", "\u00f8\u0000\u0000\u009b\u0142", "macron", "\u00c5\u00f8\u00af\u00af\u00af", "minus", "\u0000\u0000\u0000\u008a\u2212", "mu", "\u0000\u00b5\u00b5\u00b5\u03bc", "multiply", "\u0000\u0000\u00d7\u00d7\u00d7", "ntilde", "\u0000\u0096\u00f1\u00f1\u00f1", "oacute", "\u0000\u0097\u00f3\u00f3\u00f3", "ocircumflex", "\u0000\u0099\u00f4\u00f4\u00f4", "odieresis", "\u0000\u009a\u00f6\u00f6\u00f6", "oe", "\u00fa\u00cf\u009c\u009c\u0153", "ogonek", "\u00ce\u00fe\u0000\u001d\u02db", "ograve", "\u0000\u0098\u00f2\u00f2\u00f2", "onehalf", "\u0000\u0000\u00bd\u00bd\u00bd", "onequarter", "\u0000\u0000\u00bc\u00bc\u00bc", "onesuperior", "\u0000\u0000\u00b9\u00b9\u00b9", "ordfeminine", "\u00e3\u00bb\u00aa\u00aa\u00aa", "ordmasculine", "\u00eb\u00bc\u00ba\u00ba\u00ba", "oslash", "\u00f9\u00bf\u00f8\u00f8\u00f8", "otilde", "\u0000\u009b\u00f5\u00f5\u00f5", "paragraph", "\u00b6\u00a6\u00b6\u00b6\u00b6", "periodcentered", "\u00b4\u00e1\u00b7\u00b7\u00b7", "perthousand", "\u00bd\u00e4\u0089\u008b\u2030", "plusminus", "\u0000\u00b1\u00b1\u00b1\u00b1", "questiondown", "\u00bf\u00c0\u00bf\u00bf\u00bf", "quotedbl", "\"\"\"\"\"", "quotedblbase", "\u00b9\u00e3\u0084\u008c\u201e", "quotedblleft", "\u00aa\u00d2\u0093\u008d\u201c", "quotedblright", "\u00ba\u00d3\u0094\u008e\u201d", "quoteleft", "`\u00d4\u0091\u008f\u2018", "quoteright", "'\u00d5\u0092\u0090\u2019", "quotesinglbase", "\u00b8\u00e2\u0082\u0091\u201a", "quotesingle", "\u00a9''''", "registered", "\u0000\u00a8\u00ae\u00ae\u00ae", "ring", "\u00ca\u00fb\u0000\u001e\u02da", "scaron", "\u0000\u0000\u009a\u009d\u0161", "section", "\u00a7\u00a4\u00a7\u00a7\u00a7", "sterling", "\u00a3\u00a3\u00a3\u00a3\u00a3", "thorn", "\u0000\u0000\u00fe\u00fe\u00fe", "threequarters", "\u0000\u0000\u00be\u00be\u00be", "threesuperior", "\u0000\u0000\u00b3\u00b3\u00b3", "tilde", "\u00c4\u00f7\u0098\u001f\u02dc", "trademark", "\u0000\u00aa\u0099\u0092\u2122", "twosuperior", "\u0000\u0000\u00b2\u00b2\u00b2", "uacute", "\u0000\u009c\u00fa\u00fa\u00fa", "ucircumflex", "\u0000\u009e\u00fb\u00fb\u00fb", "udieresis", "\u0000\u009f\u00fc\u00fc\u00fc", "ugrave", "\u0000\u009d\u00f9\u00f9\u00f9", "underscore", "_____", "yacute", "\u0000\u0000\u00fd\u00fd\u00fd", "ydieresis", "\u0000\u00d8\u00ff\u00ff\u00ff", "yen", "\u00a5\u00b4\u00a5\u00a5\u00a5", "zcaron", "\u0000\u0000\u009e\u009e\u017e", "shy", "\u0000\u0000\u00ad\u0000\u00ad"};
        refTableSym_ = new String[]{"Alpha", "A\u0391", "Beta", "B\u0392", "Chi", "C\u03a7", "Delta", "D\u0394", "Epsilon", "E\u0395", "Eta", "H\u0397", "Euro", "\u00a0\u20ac", "Gamma", "G\u0393", "Ifraktur", "\u00c1\u2111", "Iota", "I\u0399", "Kappa", "K\u039a", "Lambda", "L\u039b", "Mu", "M\u039c", "Nu", "N\u039d", "Omega", "W\u03a9", "Omicron", "O\u039f", "Phi", "F\u03a6", "Pi", "P\u03a0", "Psi", "Y\u03a8", "RFraktur", "\u00c2\u211c", "Rho", "R\u03a1", "Sigma", "S\u03a3", "Tau", "T\u03a4", "Theta", "Q\u0398", "Upsilon", "U\u03a5", "Upsilon1", "\u00a1\u03d2", "Xi", "X\u039e", "Zeta", "Z\u0396", "aleph", "\u00c0\u2135", "alpha", "a\u03b1", "angle", "\u00d0\u2220", "angleleft", "\u00e1\u2329", "angleright", "\u00f1\u232a", "approxequal", "\u009f\u2248", "arrowboth", "\u00ab\u2194", "arrowdblboth", "\u00db\u21d4", "arrowdbldown", "\u00df\u21d3", "arrowdblleft", "\u00dc\u21d0", "arrowdblright", "\u00de\u21d2", "arrowdblup", "\u00dd\u21d1", "arrowdown", "\u00af\u2193", "arrowhorizex", "\u00be\uf8e7", "arrowleft", "\u00ac\u2190", "arrowright", "\u00ae\u2192", "arrowup", "\u00ad\u2191", "arrowvertex", "\u00bd\uf8e6", "asteriskmath", "*\u2217", "beta", "b\u03b2", "bracelefttp", "\u00ec\uf8f1", "braceleftmid", "\u00ed\uf8f2", "braceleftbt", "\u00ee\uf8f3", "bracerighttp", "\u00fc\uf8fc", "bracerightmid", "\u00fd\uf8fd", "bracerightbt", "\u00fe\uf8fe", "braceex", "\u00ef\uf8f4", "bracketlefttp", "\u00e9\uf8ee", "bracketleftex", "\u00ea\uf8ef", "bracketleftbt", "\u00eb\uf8f0", "bracketrighttp", "\u00f9\uf8f9", "bracketrightex", "\u00fa\uf8fa", "bracketrightbt", "\u00fb\uf8fb", "bullet", "\u00b7\u2022", "carriagereturn", "\u00bf\u21b5", "chi", "c\u03c7", "circlemultiply", "\u00c4\u2297", "circleplus", "\u00c5\u2295", "club", "\u00a7\u2663", "congruent", "@\u2245", "copyrightsans", "\u00e3\uf8e9", "copyrightserif", "\u00d3\uf6d9", "degree", "\u00b0\u00b0", "delta", "d\u03b4", "diamond", "\u00a8\u2666", "divide", "\u00b8\u00f7", "dotmath", "\u00d7\u22c5", "element", "\u00ce\u2208", "ellipsis", "\u00bc\u2026", "emptyset", "\u00c6\u2205", "epsilon", "c\u03b5", "equivalence", "\u00ba\u2261", "eta", "h\u03b7", "existential", "$\u2203", "florin", "\u00a6\u0192", "fraction", "\u00a4\u2044", "gamma", "g\u03b3", "gradient", "\u00d1\u2207", "greaterequal", "\u00b3\u2265", "heart", "\u00a9\u2665", "infinity", "\u00a5\u221e", "integral", "\u00f2\u222b", "integraltp", "\u00f3\u2320", "integralex", "\u00f4\uf8f5", "integralbt", "\u00f5\u2321", "intersection", "\u00c7\u2229", "iota", "i\u03b9", "kappa", "k\u03ba", "lambda", "l\u03bb", "lessequal", "\u00a3\u2264", "logicaland", "\u00d9\u2227", "logicalnot", "\u00d8\u00ac", "logicalor", "\u00da\u2228", "lozenge", "\u00e0\u25ca", "minus", "-\u2212", "minute", "\u00a2\u2032", "mu", "m\u03bc", "multiply", "\u00b4\u00d7", "notlement", "\u00cf\u2209", "notequal", "\u00b9\u2260", "notsubset", "\u00cb\u2284", "nu", "n\u03bd", "omega", "w\u03c9", "omega1", "v\u03d6", "omicron", "o\u03bf", "parenlefttp", "\u00e6\uf8eb", "parenleftex", "\u00e7\uf8ec", "parenleftbt", "\u00e8\uf8ed", "parenrighttp", "\u00f6\uf8f6", "parenrightex", "\u00f7\uf8f7", "parentrightbt", "\u00f8\uf8f8", "partialdiff", "\u00b6\u2202", "perpendicular", "^\u22a5", "phi", "f\u03c6", "phi1", "j\u03d5", "pi", "p\u03c0", "plusminus", "\u00b1\u00b1", "product", "\u00d5\u220f", "propersubset", "\u00cc\u2282", "propersuperset", "\u00c9\u2283", "proportional", "\u00b5\u221d", "psi", "y\u03c8", "radical", "\u00d6\u221a", "radicalex", "`\uf8e5", "reflexsubset", "\u00cd\u2286", "reflexsuperset", "\u00ca\u2287", "registersans", "\u00e2\uf8e8", "registerserif", "\u00d2\uf6da", "rho", "r\u03c1", "second", "\u00b2\u2033", "sigma", "s\u03c3", "sigma1", "V\u03c2", "similar", "~\u223c", "spade", "\u00aa\u2660", "suchthat", "'\u220b", "summation", "\u00e5\u2211", "tau", "t\u03c4", "therefore", "\\\u2234", "theta", "q\u03b8", "theta1", "J\u03d1", "trademarksans", "\u00e4\uf8ea", "trademarkserif", "\u00d4\uf6db", "union", "\u00c8\u222a", "universal", "\"\u2200", "upsilon", "u\u03c5", "weierstrass", "\u00c3\u2118", "xi", "x\u03be", "zeta", "z\u03b6"};
        refTableZapf_ = new String[]{"space", "  ", "a1", "!\u2701", "a2", "\"\u2702", "a202", "#\u2703", "a3", "$\u2704", "a4", "%\u260e", "a5", "&\u2706", "a119", "'\u2707", "a118", "(\u2708", "a117", ")\u2709", "a11", "*\u261b", "a12", "+\u261e", "a13", ",\u270c", "a14", "-\u270d", "a15", ".\u270e", "a16", "/\u270f", "a105", "0\u2710", "a17", "1\u2711", "a18", "2\u2712", "a19", "3\u2713", "a20", "4\u2714", "a21", "5\u2715", "a22", "6\u2716", "a23", "7\u2717", "a24", "8\u2718", "a25", "9\u2719", "a26", ":\u271a", "a27", ";\u271b", "a28", "<\u271c", "a6", "=\u271d", "a7", ">\u271e", "a8", "?\u271f", "a9", "@\u2720", "a10", "A\u2721", "a29", "B\u2722", "a30", "C\u2723", "a31", "D\u2724", "a32", "E\u2725", "a33", "F\u2726", "a34", "G\u2727", "a35", "H\u2605", "a36", "I\u2729", "a37", "J\u272a", "a38", "K\u272b", "a39", "L\u272c", "a40", "M\u272d", "a41", "N\u272e", "a42", "O\u272f", "a43", "P\u2730", "a44", "Q\u2731", "a45", "R\u2732", "a46", "S\u2733", "a47", "T\u2734", "a48", "U\u2735", "a49", "V\u2736", "a50", "W\u2737", "a51", "X\u2738", "a52", "Y\u2739", "a53", "Z\u273a", "a54", "[\u273b", "a55", "\\\u273c", "a56", "]\u273d", "a57", "^\u273e", "a58", "_\u273f", "a59", "`\u2740", "a60", "a\u2741", "a61", "b\u2742", "a62", "c\u2743", "a63", "d\u2744", "a64", "e\u2745", "a65", "f\u2746", "a66", "g\u2747", "a67", "h\u2748", "a68", "i\u2749", "a69", "j\u274a", "a70", "k\u274b", "a71", "l\u25cf", "a72", "m\u274d", "a73", "n\u25a0", "a74", "o\u274f", "a203", "p\u2750", "a75", "q\u2751", "a204", "r\u2752", "a76", "s\u25b5", "a77", "t\u25bc", "a78", "u\u25c6", "a79", "v\u2756", "a81", "w\u25d7", "a82", "x\u2758", "a83", "y\u2759", "a84", "z\u275a", "a97", "{\u275b", "a98", "|\u275c", "a99", "}\u275d", "a100", "~\u275e", "a89", "\u007f\uf8d7", "a90", "\u0080\uf8d8", "a93", "\u0081\uf8d9", "a94", "\u0082\uf8da", "a91", "\u0083\uf8db", "a92", "\u0084\uf8dc", "a205", "\u0085\uf8dd", "a85", "\u0086\uf8de", "a206", "\u0087\uf8df", "a86", "\u0088\uf8e0", "a87", "\u0089\uf8e1", "a88", "\u008a\uf8e2", "a95", "\u008b\uf8e3", "a96", "\u008d\uf8e4", "a101", "\u00a1\u2761", "a102", "\u00a2\u2762", "a103", "\u00a3\u2763", "a104", "\u00a4\u2764", "a106", "\u00a5\u2765", "a107", "\u00a6\u2766", "a108", "\u00a7\u2767", "a112", "\u00a8\u2663", "a111", "\u00a9\u2666", "a110", "\u00aa\u2665", "a109", "\u00ab\u2660", "a120", "\u00ac\u2460", "a121", "\u00ad\u2461", "a122", "\u00ae\u2462", "a123", "\u00af\u2463", "a124", "\u00b0\u2464", "a125", "\u00b1\u2465", "a126", "\u00b2\u2466", "a127", "\u00b3\u2467", "a128", "\u00b4\u2468", "a129", "\u00b5\u2469", "a130", "\u00b6\u2776", "a131", "\u00b7\u2777", "a132", "\u00b8\u2778", "a133", "\u00b9\u2779", "a134", "\u00ba\u277a", "a135", "\u00bb\u277b", "a136", "\u00bc\u277c", "a137", "\u00bd\u277d", "a138", "\u00be\u277e", "a139", "\u00bf\u277f", "a140", "\u00c0\u2780", "a141", "\u00c1\u2781", "a142", "\u00c2\u2782", "a143", "\u00c3\u2783", "a144", "\u00c4\u2784", "a145", "\u00c5\u2785", "a146", "\u00c6\u2786", "a147", "\u00c7\u2787", "a148", "\u00c8\u2788", "a149", "\u00c9\u2789", "a150", "\u00ca\u278a", "a151", "\u00cb\u278b", "a152", "\u00cc\u278c", "a153", "\u00cd\u278d", "a154", "\u00ce\u278e", "a155", "\u00cf\u278f", "a156", "\u00d0\u2790", "a157", "\u00d1\u2791", "a158", "\u00d2\u2792", "a159", "\u00d3\u2793", "a160", "\u00d4\u2794", "a161", "\u00d5\u2192", "a163", "\u00d6\u2194", "a164", "\u00d7\u2195", "a196", "\u00d8\u2798", "a165", "\u00d9\u2799", "a192", "\u00da\u279a", "a166", "\u00db\u279b", "a167", "\u00dc\u279c", "a168", "\u00dd\u279d", "a169", "\u00de\u279e", "a170", "\u00df\u279f", "a171", "\u00e0\u27a0", "a172", "\u00e1\u27a1", "a173", "\u00e2\u27a2", "a162", "\u00e3\u27a3", "a174", "\u00e4\u27a4", "a175", "\u00e5\u27a5", "a176", "\u00e6\u27a6", "a177", "\u00e7\u27a7", "a178", "\u00e8\u27a8", "a179", "\u00e9\u27a9", "a193", "\u00ea\u27aa", "a180", "\u00eb\u27ab", "a199", "\u00ec\u27ac", "a181", "\u00ed\u27ad", "a200", "\u00ee\u27ae", "a182", "\u00ef\u27af", "a201", "\u00f1\u27b1", "a183", "\u00f2\u27b2", "a184", "\u00f3\u27b3", "a197", "\u00f4\u27b4", "a185", "\u00f5\u27b5", "a194", "\u00f6\u27b6", "a198", "\u00f7\u27b7", "a186", "\u00f8\u27b8", "a195", "\u00f9\u27b9", "a187", "\u00fa\u27ba", "a188", "\u00fb\u27bb", "a189", "\u00fc\u27bc", "a190", "\u00fd\u27bd", "a191", "\u00fe\u27be"};
        refTableMacExpert_ = new String[]{"AEsmall", "\u00be\uf7e6", "Aacutesmall", "\u0087\uf7b4", "Acircumflexsmall", "\u0089\uf7e2", "Acutesmall", "'\uf7e1", "Adieresissmall", "\u008a\uf7e4", "Agravesmall", "\u0088\uf7e0", "Aringsmall", "\u008c\uf7e5", "Asmall", "a\uf761", "Atildesmall", "\u008b\uf7e3", "Brevesmall", "\u00f3\uf6f4", "Bsmall", "b\uf762", "Caronsmall", "\u00ae\uf7f5", "Ccedillasmall", "\u008d\uf7e7", "Cedillasmall", "\u00c9\uf7b8", "Circumflexsmall", "^\uf6f6", "Csmall", "c\uf763", "Dieresissmall", "\u00ac\uf7a8", "Dotaccentsmall", "\u00fa\uf6f7", "Dsmall", "d\uf764", "Eacutesmall", "\u008e\uf7e9", "Ecircumflexsmall", "\u0090\uf7ea", "Edieresissmall", "\u0091\uf7eb", "Egravesmall", "\u008f\uf7e8", "Esmall", "e\uf765", "Ethsmall", "D\uf7f0", "Fsmall", "f\uf766", "Gravesmall", "`\uf760", "Gsmall", "g\uf767", "Hsmall", "h\uf768", "Hungarumlautsmall", "\"\uf6f8", "Iacutesmall", "\u0092\uf7ed", "Icircumflexsmall", "\u0094\uf7ee", "Idieresissmall", "\u0095\uf7ef", "Igravesmall", "\u0093\uf7ec", "Ismall", "i\uf769", "Jsmall", "j\uf76a", "Ksmall", "k\uf76b", "Lslashsmall", "\u00c2\uf6f9", "Lsmall", "l\uf76c", "Macronsmall", "\u00f4\uf7af", "Msmall", "m\uf76d", "Nsmall", "n\uf76e", "Ntildesmall", "\u0096\uf7f1", "OEsmall", "\u00cf\uf6fa", "Oacutesmall", "\u0097\uf7f3", "Ocircumflexsmall", "\u0099\uf7f4", "Odieresissmall", "\u009a\uf7f6", "Ogoneksmall", "\u00f2\uf6fb", "Ogravesmall", "\u0098\uf7f2", "Oslashsmall", "\u00bf\uf7f8", "Osmall", "o\uf76f", "Otildesmall", "\u009b\uf7f5", "Psmall", "p\uf770", "Qsmall", "q\uf771", "Ringsmall", "\u00fb\uf6fd", "Rsmall", "r\uf772", "Scaronsmall", "\u00a7\uf6fd", "Ssmall", "s\uf773", "Thornsmall", "\u00b9\uf7fe", "Tildesmall", "~\uf6fe", "Tsmall", "t\uf774", "Uacutesmall", "\u009c\uf7fa", "Ucircumflexsmall", "\u009e\uf7fb", "Udieresissmall", "\u009f\uf7fc", "Ugravesmall", "\u009d\uf7f9", "Usmall", "u\uf775", "Vsmall", "v\uf776", "Wsmall", "w\uf777", "Xsmall", "x\uf778", "Yacutesmall", "\u00b4\uf7fd", "Ydieresissmall", "\u00d8\uf7ff", "Ysmall", "y\uf779", "Zcaronsmall", "\u00bd\uf6ff", "Zsmall", "z\uf77a", "ampersandsmall", "&\uf726", "asuperior", "\u0081\uf6e9", "bsuperior", "\u00f5\uf6ea", "centinferior", "\u00a9\uf6df", "centoldstyle", "#\uf7a2", "centsuperior", "\u0082\uf6e0", "colon", "::", "colonmonetary", "{\u20a1", "comma", ",,", "commainferior", "\u00b2\uf6e1", "commasuperior", "\u00f8\uf6e2", "dollarinferior", "\u00b6\uf6e3", "dollaroldstyle", "$\uf724", "dollarsuperior", "%\uf6e4", "dsuperior", "\u00eb\uf6eb", "eightinferior", "\u00a5\u2088", "eightoldstyle", "8\uf738", "eightsuperior", "\u00a1\u2078", "esuperior", "\u00e4\uf6ec", "exclamdownsmall", "\u00d6\uf7a1", "exclamsmall", "!\uf721", "ff", "V\ufb00", "ffi", "Y\ufb03", "ffl", "Z\ufb04", "fi", "W\ufb01", "figuredash", "\u00d0\u2012", "fiveeighths", "L\u215d", "fiveinferior", "\u00b0\u2085", "fiveoldstyle", "5\uf735", "fivesuperior", "\u00de\u2075", "fl", "X\ufb02", "fourinferior", "\u00a2\u2084", "fouroldstyle", "4\uf734", "foursuperior", "\u00dd\u2074", "fraction", "/\u2044", "hyphen", "--", "hypheninferior", "_\uf6e5", "hyphensuperior", "\u00d1\uf6e6", "isuperior", "\u00e9\uf6ed", "lsuperior", "\u00f1\uf6ee", "msuperior", "\u00f7\uf6ef", "nineinferior", "\u00bb\u2089", "nineoldstyle", "9\uf739", "ninesuperior", "\u00e1\u2079", "nsuperior", "\u00f6\u207f", "onedotenleader", "+\u2024", "oneeighth", "J\u215b", "onefitted", "|\uf6dc", "onehalf", "H\u00bd", "oneinferior", "\u00c1\u2081", "oneoldstyle", "1\uf731", "onequarter", "G\u00bc", "onesuperior", "\u00da\u00b9", "onethird", "N\u2153", "osuperior", "\u00af\uf6f0", "parenleftinferior", "[\u208d", "parenleftsuperior", "(\u207d", "parenrightinferior", "]\u208e", "parenrightsuperior", ")\u207e", "period", "..", "periodinferior", "\u00b3\uf6e7", "periodsuperior", "\u00f9\uf6e8", "questiondownsmall", "\u00c0\uf7bf", "questionsmall", "?\uf73f", "rsuperior", "\u00e5\uf6f0", "rupiah", "}\uf6dd", "semicolon", ";;", "seveneighths", "M\u215e", "seveninferior", "\u00a6\u2087", "sevenoldstyle", "7\uf7e7", "sevensuperior", "\u00e0\u2077", "sixinferior", "\u00a4\u2086", "sixoldstyle", "6\uf736", "sixsuperior", "\u00df\u2076", "space", "  ", "ssuperior", "\u00ea\uf6f2", "threeeighths", "K\u215c", "threeinferior", "\u00a3\u2083", "threeoldstyle", "3\uf733", "threequarters", "I\u00be", "threequartersemdash", "=\uf6de", "threesuperior", "\u00dc\u00b3", "tsuperior", "\u00e6\uf6f3", "twodotenleader", "*\u2025", "twoinferior", "\u00aa\u2082", "twooldstyle", "2\uf732", "twosuperior", "\u00db\u00b2", "twothirds", "O\u2154", "zeroinferior", "\u00bc\u2080", "zerooldstyle", "0\uf730", "zerosuperior", "\u00e2\u2070"};
        refTableTeX_ = new String[]{"Gamma", "\u0000\u0393", "Delta", "\u0001\u0394", "Theta", "\u0002\u0398", "Lambda", "\u0003\u039b", "Xi", "\u0004\u039e", "Pi", "\u0005\u03a0", "Sigma", "\u0006\u03a3", "Upsilon", "\u0007\u03a5", "Phi", "\b\u03a6", "Psi", "\t\u03a8", "Omega", "\n\u03a9", "ff", "\u000b\ufb00", "fi", "\f\ufb01", "fl", "\r\ufb02", "ffi", "\u000e\ufb03", "ffl", "\u000f\ufb04", "dotlessi", "\u0010\u0131", "dotlessj", "\u0011\uf6be", "grave", "\u0012`", "acute", "\u0013\u00b4", "caron", "\u0014\u02c7", "breve", "\u0015\u0306", "overscore", "\u0016\u0016", "ring", "\u0017\u02da", "cedilla", "\u0018\u00b8", "germandbls", "\u0019\u00df", "ae", "\u001a\u00e6", "oe", "\u001b\u0153", "oslash", "\u001c\u00f8", "AE", "\u001d\u00c6", "OE", "\u001e\u0152", "Oslash", "\u001f\u00d8", "polishlcross", "  ", "quotedblright", "\"\u201d", "quoteright", "'\u2019", "exclamdown", "<\u00a1", "questiondown", ">\u00bf", "quotedblleft", "\\\u201d", "dotaccent", "_\u02d9", "quoteleft", "`\u2018", "endash", "{\u2013", "emdash", "|\u2014", "hungarumlaut", "}\u00a8", "dieresis", "\u007f\u00a8", "alpha", "\u000b\u03b1", "beta", "\f\u03b2", "gamma", "\r\u03b3", "delta", "\u000e\u03b4", "epsilon1", "\u000f\u02b5", "zeta", "\u0010\u03b6", "eta", "\u0011\u03b7", "theta", "\u0012\u03b8", "iota", "\u0013\u03b9", "kappa", "\u0014\u03ba", "lambda", "\u0015\u03bb", "mu", "\u0016\u03bc", "nu", "\u0017\u03bd", "xi", "\u0018\u03be", "pi", "\u0019\u03c0", "rho", "\u001a\u03c1", "sigma", "\u001b\u03c3", "tau", "\u001c\u03c4", "upsilon", "\u001d\u03c5", "phi", "\u001e\u03c6", "chi", "\u001f\u03c7", "psi", " \u03c8", "omega", "!\u03c9", "epsilon", "\"\u03b5", "theta1", "#\u03d1", "pi1", "$\u03d6", "rho1", "%\u03f1", "sigma1", "&\u03c2", "phi1", "'\u03d5", "arrowlefttophalf", "(\u21bc", "arrowleftbothalf", ")\u21bd", "arrowrighttophalf", "*\u21c0", "arrowrightbothalf", "+\u21c1", "arrowhookleft", ",\u21a9", "arrowhookright", "-\u21aa", "triangleright", ".\u22b2", "triangleleft", "/\u22b3", "zerooldstyle", "0\uf730", "oneoldstyle", "1\uf731", "twooldstyle", "2\uf732", "threeoldstyle", "3\uf733", "fouroldstyle", "4\uf734", "fiveoldstyle", "5\uf735", "sixoldstyle", "6\uf736", "sevenoldstyle", "7\uf737", "eightoldstyle", "8\uf738", "nineoldstyle", "9\uf739", "star", "?\u22c6", "partialdiff", "@\u2202", "flat", "[\u266d", "natural", "\\\u266e", "sharp", "]\u266f", "slurbelow", "^\u2323", "slurabove", "_\u2322", "lscript", "`\u2113", "weierstrass", "}\u2118", "vector", "~~", "tie", "\u007f\u007f", "minus", "\u0000\u2212", "middot", "\u0001\u2219", "multiply", "\u0002\u00d7", "asteriskmath", "\u0003\u2217", "divide", "\u0004\u00f7", "diamondmath", "\u0005\u22c4", "plusminus", "\u0006\u00b1", "minusplus", "\u0007\u2213", "circleplus", "\b\u2295", "circleminus", "\t\u2296", "circlemultiply", "\n\u2297", "circledivide", "\u000b\u2298", "circledot", "\f\u2299", "circlecopyrt", "\r\r", "openbullet", "\u000e\u25e6", "bullet", "\u000f\u2022", "equivasymptotic", "\u0010\u224d", "equivalence", "\u0011\u2261", "reflexsubset", "\u0012\u2286", "reflexsuperset", "\u0013\u2287", "lessequal", "\u0014\u2264", "greaterequal", "\u0015\u2265", "precedesequal", "\u0016\u0016", "followsequal", "\u0017\u0017", "similar", "\u0018\u223c", "approxequal", "\u0019\u2248", "propersubset", "\u001a\u2282", "propersuperset", "\u001b\u2283", "lessmuch", "\u001c\u226a", "greatermuch", "\u001d\u226b", "precedes", "\u001e\u227a", "follows", "\u001f\u227b", "arrowleft", " \u2190", "arrowright", "!\u2192", "arrowup", "\"\u2191", "arrowdown", "#\u2193", "arrowboth", "$\u2914", "arrownortheast", "%\u2197", "arrowsoutheast", "&\u2198", "similarequal", "''", "arrowdblleft", "(\u21d0", "arrowdblright", ")\u21d2", "arrowdblup", "*\u21d1", "arrowdbldown", "+\u21d3", "arrowdblboth", ",\u21d4", "arrownorthwest", "-\u2196", "arrowsouthwest", ".\u2199", "proportional", "/\u221d", "prime", "00", "infinity", "1\u221e", "element", "2\u2208", "owner", "3\u220b", "triangle", "4\u25b3", "triangleinv", "5\u25bd", "negationslash", "66", "mapsto", "77", "universal", "8\u2200", "existential", "9\u2203", "logicalnot", ":\u00ac", "emptyset", ";\u2205", "Rfractur", "<\u211c", "Ifractur", "==", "latticetop", ">\u22a4", "perpendicular", "?\u22a5", "aleph", "@\u2135", "union", "[\u222a", "intersection", "\\\u2229", "unionmulti", "]\u228e", "logicaland", "^\u2227", "logicalor", "_\u2228", "turnstileleft", "`\u22a2", "turnstileright", "a\u22a3", "floorleft", "b\u230a", "floorright", "c\u230b", "ceilingleft", "d\u2308", "ceilingright", "e\u2309", "braceleft", "f{", "braceright", "g}", "angbracketleft", "hh", "angbracketright", "ii", "bar", "j|", "bardbl", "kk", "arrowbothv", "ll", "arrowdblbothv", "mm", "backslash", "n\\", "wreathproduct", "o\u2240", "radical", "p\u221a", "coproduct", "q\u2210", "nabla", "r\u2207", "integral", "s\u222b", "unionsq", "t\u2294", "intersectionsq", "u\u2293", "subsetsqequal", "v\u2291", "supersetsqequal", "w\u2292", "section", "x\u00a7", "dagger", "y\u2020", "daggerdbl", "z\u2021", "paragraph", "{\u00b6", "club", "|\u2663", "diamond", "}\u2666", "heart", "~\u2665", "spade", "\u007f\u2660"};
        uname2char_ = new HashMap<String, String>(refTable_.length);
        unameEx2char_ = new HashMap<String, String>(refTableMacExpert_.length);
        unameTeX2char_ = new HashMap<String, String>(refTableTeX_.length);
        if (!$assertionsDisabled && refTable_.length % 2 != 0) {
            throw new AssertionError();
        }
        int n2 = IDENTITY_MAP.length;
        for (n = 0; n < n2; ++n) {
            Encoding.IDENTITY_MAP[n] = (char)n;
        }
        for (n = 0; n < 256; ++n) {
            uname2char_.put(Strings.valueOf((char)n), "     ");
        }
        for (n = 33; n < 127; ++n) {
            uname2char_.put(Strings.valueOf((char)n), "" + (char)n + (char)n + (char)n + (char)n + (char)n);
            unameTeX2char_.put(Strings.valueOf((char)n), "" + (char)n + (char)n);
        }
        String[] stringArray = new String[]{"zero", "0", "one", "1", "two", "2", "three", "3", "four", "4", "five", "5", "six", "6", "seven", "7", "eight", "8", "nine", "9", "ampersand", "&", "at", "@", "backslash", "\\", "bar", "|", "braceleft", "{", "braceright", "}", "bracketleft", "[", "bracketright", "]", "colon", ":", "comma", ",", "dollar", "$", "equal", "=", "exclam", "!", "greater", ">", "hyphen", "-", "less", "<", "numbersign", "#", "parenleft", "(", "parenright", ")", "percent", "%", "period", ".", "plus", "+", "question", "?", "semicolon", ";", "slash", "/", "space", " ", "ff", "\ufb00", "ffi", "\ufb03", "ffl", "\ufb04", "dotlessj", "\uf6be"};
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            string = stringArray[n2 + 1];
            String string2 = string.charAt(0) < '\u0100' ? string : "\u0000";
            uname2char_.put(stringArray[n2], string2 + string2 + string2 + string2 + string);
            unameTeX2char_.put(stringArray[n2], string2);
        }
        for (n2 = 0; n2 < 256; ++n2) {
            Encoding.texMap_[n2] = 32;
            Encoding.zapfMap_[n2] = 32;
            Encoding.symbolMap_[n2] = 32;
            Encoding.pdfMap_[n2] = 32;
            Encoding.standardMap_[n2] = 32;
            Encoding.winAnsiMap_[n2] = 32;
            Encoding.macExpertMap_[n2] = 32;
            Encoding.macRomanMap_[n2] = 32;
        }
        for (n2 = 33; n2 < 127; ++n2) {
            Encoding.symbolMap_[n2] = Encoding.texMap_[n2] = (char)n2;
            Encoding.pdfMap_[n2] = Encoding.texMap_[n2];
            Encoding.standardMap_[n2] = Encoding.texMap_[n2];
            Encoding.winAnsiMap_[n2] = Encoding.texMap_[n2];
            Encoding.macRomanMap_[n2] = Encoding.texMap_[n2];
        }
        macRoman2std_ = (char[])IDENTITY_MAP.clone();
        winAnsi2std_ = (char[])IDENTITY_MAP.clone();
        pdf2std_ = (char[])IDENTITY_MAP.clone();
        n3 = refTable_.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            char c;
            int n4;
            string = refTable_[n2 + 1];
            if (!$assertionsDisabled && string.length() != 5) {
                throw new AssertionError();
            }
            char c2 = string.charAt(4);
            if (!$assertionsDisabled && c2 == '\u0000') {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && uname2char_.get(refTable_[n2]) != null) {
                throw new AssertionError();
            }
            uname2char_.put(refTable_[n2], string);
            int n5 = string.charAt(0);
            int n6 = n4 = n5 != 0 ? n5 : 32;
            if (n5 != 0) {
                Encoding.standardMap_[n5] = c2;
            }
            if ((c = string.charAt(1)) != '\u0000') {
                Encoding.macRomanMap_[c] = c2;
                Encoding.macRoman2std_[c] = n4;
            }
            if ((c = string.charAt(2)) != '\u0000') {
                Encoding.winAnsiMap_[c] = c2;
                Encoding.winAnsi2std_[c] = n4;
            }
            if ((c = string.charAt(3)) == '\u0000') continue;
            Encoding.pdfMap_[c] = c2;
            Encoding.pdf2std_[c] = n4;
        }
        Encoding.winAnsiMap_[127] = 8226;
        n3 = refTableSym_.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            string = refTableSym_[n2 + 1];
            if (!$assertionsDisabled && string.length() != 2) {
                throw new AssertionError();
            }
            String string3 = refTableSym_[n2];
            String string4 = uname2char_.get(string3);
            if (string4 == null) {
                uname2char_.put(string3, string);
            } else if (string4.charAt(0) != string.charAt(0)) {
                if (!$assertionsDisabled && string4.charAt(0) != '\u0000') {
                    throw new AssertionError();
                }
                uname2char_.put(string3, string.charAt(0) + string4.substring(1));
            }
            Encoding.symbolMap_[string.charAt((int)0)] = string.charAt(1);
        }
        n3 = refTableZapf_.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            string = refTableZapf_[n2 + 1];
            if (!$assertionsDisabled && string.length() != 2) {
                throw new AssertionError();
            }
            String string5 = refTableZapf_[n2];
            String string6 = uname2char_.get(string5);
            if (string6 == null) {
                uname2char_.put(string5, string);
            }
            Encoding.zapfMap_[string.charAt((int)0)] = string.charAt(1);
        }
        n3 = refTableMacExpert_.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            string = refTableMacExpert_[n2 + 1];
            if (!$assertionsDisabled && string.length() != 2) {
                throw new AssertionError((Object)("@" + n2 + ": " + refTableMacExpert_[n2]));
            }
            unameEx2char_.put(refTableMacExpert_[n2], string);
            Encoding.macExpertMap_[string.charAt((int)0)] = string.charAt(1);
        }
        n3 = refTableTeX_.length;
        for (n2 = 0; n2 < n3; n2 += 2) {
            string = refTableTeX_[n2 + 1];
            if (!$assertionsDisabled && string.length() != 2) {
                throw new AssertionError((Object)("@" + n2 + ": " + refTableTeX_[n2]));
            }
            unameTeX2char_.put(refTableTeX_[n2], string.substring(0, 1));
            Encoding.texMap_[string.charAt((int)0)] = string.charAt(0);
        }
        IDENTITY_ENCODING = new Encoding(IDENTITY_MAP);
    }
}

