/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDFReader;

public class DecodeLZW
extends FilterInputStream {
    static final boolean DEBUG = false;
    static final int CLEAR = 256;
    static final int EOD = 257;
    static final int MINBITS = 9;
    static final int MAXBITS = 12;
    static final int MAXLEN = 4096;
    static final int TABLESTART = 258;
    private byte[] nextByte_ = new byte[4096];
    private int[] prevEntry_ = new int[this.nextByte_.length];
    private int tablei_ = 258;
    private int tablelen_;
    private int codelen_ = 9;
    private int mask_ = 511;
    private int prevcode_ = -1;
    private int bits_ = 0;
    private int validcnt_ = 0;
    private int early_ = 1;
    private byte[] phrase_ = new byte[4096];
    private int phrasei_ = 4096;
    private boolean eof_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DecodeLZW(InputStream inputStream, Dict dict, PDFReader pDFReader) throws IOException {
        super(inputStream);
        Object object;
        if (dict != null && (object = dict.get("EarlyChange")) != null) {
            this.early_ = pDFReader.getObjInt(object);
            if (!$assertionsDisabled && this.early_ != 0 && this.early_ != 1) {
                throw new AssertionError(this.early_);
            }
        }
        for (int i = 0; i < 257; ++i) {
            this.nextByte_[i] = (byte)i;
            this.prevEntry_[i] = -1;
        }
        this.tablelen_ = 512 - this.early_;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (this.eof_) {
            return -1;
        }
        n2 = Math.min(n2, byArray.length - n);
        byte[] byArray2 = this.phrase_;
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (this.phrasei_ < 4096) {
                int n4 = this.phrasei_;
                int n5 = Math.min(4096 - n4, n3 - i);
                int n6 = i + n5;
                for (int j = i; j < n6; ++j) {
                    byArray[j] = byArray2[n4++];
                }
                i += n5 - 1;
                this.phrasei_ += n5;
                continue;
            }
            int n7 = this.read();
            if (n7 != -1) {
                byArray[i] = (byte)n7;
                continue;
            }
            return i - n;
        }
        return n2;
    }

    public int read() throws IOException {
        int n;
        if (this.phrasei_ < 4096) {
            n = this.phrase_[this.phrasei_++] & 0xFF;
        } else if (this.eof_) {
            n = -1;
        } else {
            if (!$assertionsDisabled && this.validcnt_ >= this.codelen_) {
                throw new AssertionError();
            }
            int n2 = this.in.read();
            this.bits_ = this.bits_ << 8 | n2;
            this.validcnt_ += 8;
            if (this.validcnt_ < this.codelen_) {
                n2 = this.in.read();
                this.bits_ = this.bits_ << 8 | n2;
                this.validcnt_ += 8;
            }
            int n3 = this.bits_ >> this.validcnt_ - this.codelen_ & this.mask_;
            this.validcnt_ -= this.codelen_;
            if (!$assertionsDisabled && this.validcnt_ >= 9) {
                throw new AssertionError(this.validcnt_);
            }
            if (n3 == 256) {
                this.codelen_ = 9;
                this.mask_ = (1 << this.codelen_) - 1;
                this.tablei_ = 258;
                this.tablelen_ = 512 - this.early_;
                this.prevcode_ = -1;
                n = this.read();
            } else if (n3 == 257 || n2 == -1) {
                n = -1;
                this.eof_ = true;
            } else if (this.tablei_ == this.tablelen_) {
                if (n3 < 256) {
                    n = n3;
                } else {
                    int n4 = n3;
                    while (n4 != -1) {
                        this.phrase_[--this.phrasei_] = this.nextByte_[n4];
                        n4 = this.prevEntry_[n4];
                    }
                    n = this.phrase_[this.phrasei_++] & 0xFF;
                }
            } else {
                this.prevEntry_[this.tablei_] = this.prevcode_;
                if (n3 < 256) {
                    this.nextByte_[this.tablei_] = (byte)n3;
                    n = n3;
                } else {
                    if (n3 > this.tablei_) {
                        int n5 = -1;
                        this.close();
                        throw new StreamCorruptedException("illegal LZW code " + n3 + " > table len " + this.tablei_);
                    }
                    int n6 = n3;
                    while (n6 != -1) {
                        this.phrase_[--this.phrasei_] = this.nextByte_[n6];
                        n6 = this.prevEntry_[n6];
                    }
                    n = this.nextByte_[this.tablei_] = this.phrase_[this.phrasei_++];
                    if (n3 == this.tablei_) {
                        this.phrase_[4095] = (byte)n;
                    }
                    n &= 0xFF;
                }
                if (this.prevcode_ != -1) {
                    ++this.tablei_;
                    if (this.tablei_ == this.tablelen_ && this.codelen_ < 12) {
                        ++this.codelen_;
                        this.mask_ = (1 << this.codelen_) - 1;
                        this.tablelen_ = (1 << this.codelen_) - this.early_;
                    }
                }
                this.prevcode_ = n3;
            }
        }
        if (!($assertionsDisabled || -1 <= n && n <= 255)) {
            throw new AssertionError();
        }
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.eof_ = true;
        super.close();
    }

    static {
        $assertionsDisabled = !DecodeLZW.class.desiredAssertionStatus();
    }
}

