/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Function;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.lang.Integers;

class Calculator
extends Function {
    static final Integer FALSE;
    static final Integer TRUE;
    static final Character PROC_OPEN;
    static final Character PROC_CLOSE;
    static final Map<String, Integer> op2code;
    Object[] cmds_;
    static final /* synthetic */ boolean $assertionsDisabled;

    Calculator(Object object, Dict dict, PDFReader pDFReader) throws IOException {
        super(dict, pDFReader);
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(object);
        this.readToken(inputStreamComposite);
        this.cmds_ = this.parse(inputStreamComposite);
    }

    public void compute(float[] fArray, float[] fArray2) {
        int n;
        this.clip(fArray, this.domain_);
        if (!$assertionsDisabled && this.getM() > fArray.length) {
            throw new AssertionError((Object)(this.getM() + " <= " + fArray.length));
        }
        Number[] numberArray = new Number[100];
        int n2 = 0;
        int n3 = this.getM();
        for (n = 0; n < n3; ++n) {
            numberArray[n2++] = new Double(fArray[n]);
        }
        n2 = this.execute(this.cmds_, numberArray, n2);
        if (!$assertionsDisabled && n2 != this.getN()) {
            throw new AssertionError((Object)(n2 + " vs " + this.getN()));
        }
        n3 = this.getN();
        for (n = 0; n < n3; ++n) {
            fArray2[n] = numberArray[n].floatValue();
        }
        this.clip(fArray2, this.range_);
    }

    Object[] parse(InputStreamComposite inputStreamComposite) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(100);
        while (true) {
            Object object;
            if ((object = this.readToken(inputStreamComposite)) == PROC_OPEN) {
                arrayList.add(this.parse(inputStreamComposite));
                continue;
            }
            if (object == PROC_CLOSE) break;
            if (object instanceof Number) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof Op)) continue;
            Op op = (Op)object;
            if (op.code == 34) {
                op.iftrue = (Op[])arrayList.remove(arrayList.size() - 1);
            } else if (op.code == 35) {
                op.iffalse = (Op[])arrayList.remove(arrayList.size() - 1);
                op.iftrue = (Op[])arrayList.remove(arrayList.size() - 1);
            }
            arrayList.add(op);
        }
        return arrayList.toArray();
    }

    Object readToken(InputStreamComposite inputStreamComposite) throws IOException {
        Object object;
        int n;
        while ((n = inputStreamComposite.read()) != -1 && Character.isWhitespace((char)n)) {
        }
        if (n == 123) {
            object = PROC_OPEN;
        } else if (n == 125 || n == -1) {
            object = PROC_CLOSE;
        } else if (n >= 97 && n <= 122) {
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            while ((n = inputStreamComposite.read()) >= 97 && n <= 122) {
                stringBuffer.append((char)n);
            }
            inputStreamComposite.unread(n);
            String string = stringBuffer.toString();
            Integer n2 = op2code.get(string);
            if (!$assertionsDisabled && n2 == null) {
                throw new AssertionError(stringBuffer);
            }
            object = new Op(string, n2);
        } else {
            if (!($assertionsDisabled || n >= 48 && n <= 57 || n == 46)) {
                throw new AssertionError((Object)(n + " " + (char)n));
            }
            StringBuffer stringBuffer = new StringBuffer(10);
            stringBuffer.append((char)n);
            boolean bl = false;
            while (true) {
                if ((n = inputStreamComposite.read()) >= 48 && n <= 57) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if (n != 46) break;
                bl = true;
            }
            inputStreamComposite.unread(n);
            String string = stringBuffer.toString();
            object = bl ? (Number)new Double(string) : (Number)new Integer(string);
        }
        return object;
    }

    int execute(Object[] objectArray, Number[] numberArray, int n) {
        int n2 = objectArray.length;
        block44: for (int i = 0; i < n2; ++i) {
            Object object = objectArray[i];
            if (object instanceof Number) {
                numberArray[n++] = (Number)object;
                continue;
            }
            Op op = (Op)object;
            Number number = n > 0 ? (Number)numberArray[n - 1] : (Number)null;
            switch (op.code) {
                case 0: {
                    numberArray[n - 1] = new Double(Math.abs(number.doubleValue()));
                    continue block44;
                }
                case 1: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() + number.doubleValue());
                    --n;
                    continue block44;
                }
                case 2: {
                    numberArray[n - 1] = new Double(Math.atan(number.doubleValue()));
                    continue block44;
                }
                case 3: {
                    numberArray[n - 1] = new Double(Math.ceil(number.doubleValue()));
                    continue block44;
                }
                case 4: {
                    numberArray[n - 1] = new Double(Math.cos(number.doubleValue()));
                    continue block44;
                }
                case 5: {
                    numberArray[n - 1] = Integers.getInteger(number.intValue());
                    continue block44;
                }
                case 6: {
                    numberArray[n - 1] = new Double(number.doubleValue());
                    continue block44;
                }
                case 7: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() / number.doubleValue());
                    --n;
                    continue block44;
                }
                case 8: {
                    numberArray[n - 2] = new Double(Math.pow(numberArray[n - 2].doubleValue(), number.doubleValue()));
                    --n;
                    continue block44;
                }
                case 9: {
                    numberArray[n - 1] = new Double(Math.floor(number.doubleValue()));
                    continue block44;
                }
                case 10: {
                    numberArray[n - 2] = Integers.getInteger(numberArray[n - 2].intValue() / number.intValue());
                    --n;
                    continue block44;
                }
                case 11: {
                    numberArray[n - 1] = new Double(Math.log(number.doubleValue()));
                    continue block44;
                }
                case 12: {
                    numberArray[n - 1] = new Double(Math.log(number.doubleValue()) / Math.log(10.0));
                    continue block44;
                }
                case 13: {
                    numberArray[n - 2] = Integers.getInteger(number.intValue() % numberArray[n - 2].intValue());
                    --n;
                    continue block44;
                }
                case 14: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() * number.doubleValue());
                    --n;
                    continue block44;
                }
                case 15: {
                    numberArray[n - 1] = new Double(-number.doubleValue());
                    continue block44;
                }
                case 16: {
                    numberArray[n - 1] = new Double(Math.sin(number.doubleValue()));
                    continue block44;
                }
                case 17: {
                    numberArray[n - 1] = new Double(Math.sqrt(number.doubleValue()));
                    continue block44;
                }
                case 18: {
                    numberArray[n - 2] = new Double(numberArray[n - 2].doubleValue() - number.doubleValue());
                    --n;
                    continue block44;
                }
                case 19: {
                    numberArray[n - 1] = Integers.getInteger(Math.round(number.floatValue()));
                    continue block44;
                }
                case 20: {
                    numberArray[n - 1] = Integers.getInteger((int)number.doubleValue());
                    continue block44;
                }
                case 21: {
                    numberArray[n - 2] = Integers.getInteger(numberArray[i - 2].intValue() & number.intValue());
                    --n;
                    continue block44;
                }
                case 22: {
                    numberArray[n - 2] = Integers.getInteger(numberArray[n - 2].intValue() << number.intValue());
                    --n;
                    continue block44;
                }
                case 23: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() == number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 24: {
                    numberArray[n++] = FALSE;
                    continue block44;
                }
                case 25: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() >= number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 26: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() > number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 27: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() <= number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 28: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() < number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 29: {
                    numberArray[n - 2] = numberArray[i - 2].doubleValue() != number.doubleValue() ? TRUE : FALSE;
                    --n;
                    continue block44;
                }
                case 30: {
                    numberArray[n - 1] = number == TRUE ? FALSE : (number == FALSE ? TRUE : Integers.getInteger(~number.intValue()));
                    continue block44;
                }
                case 31: {
                    numberArray[n - 2] = Integers.getInteger(numberArray[i - 2].intValue() | number.intValue());
                    --n;
                    continue block44;
                }
                case 32: {
                    numberArray[n++] = TRUE;
                    continue block44;
                }
                case 33: {
                    numberArray[n - 2] = Integers.getInteger(numberArray[i - 2].intValue() ^ number.intValue());
                    --n;
                    continue block44;
                }
                case 34: {
                    --n;
                    if (number.intValue() == 0) continue block44;
                    n = this.execute(op.iftrue, numberArray, n);
                    continue block44;
                }
                case 35: {
                    --n;
                    n = this.execute(number.intValue() != 0 ? op.iftrue : op.iffalse, numberArray, n);
                    continue block44;
                }
                case 36: {
                    int n3 = number.intValue();
                    System.arraycopy(numberArray, --n - n3, numberArray, n, n3);
                    n += n3;
                    continue block44;
                }
                case 37: {
                    numberArray[n - 1] = numberArray[n - 2];
                    numberArray[n - 2] = number;
                    continue block44;
                }
                case 38: {
                    --n;
                    continue block44;
                }
                case 39: {
                    numberArray[n++] = number;
                    continue block44;
                }
                case 40: {
                    int n3 = number.intValue();
                    numberArray[--n] = numberArray[n - n3 - 1];
                    ++n;
                    continue block44;
                }
                case 41: {
                    int n3 = numberArray[n - 2].intValue();
                    int n4 = number.intValue();
                    continue block44;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError(op.code);
                    }
                    continue block44;
                }
            }
        }
        return n;
    }

    static {
        $assertionsDisabled = !Calculator.class.desiredAssertionStatus();
        FALSE = new Integer(0);
        TRUE = new Integer(1);
        PROC_OPEN = new Character('{');
        PROC_CLOSE = new Character('}');
        String[] stringArray = "abs add atan ceiling cos cvi cvr div exp floor idiv ln log mod mul neg sin sqrt sub round truncate and bitshift eq false ge gt le lt ne not or true xor if ifelse copy exch pop dup index roll".split("\\s+");
        int n = stringArray.length;
        if (!$assertionsDisabled && n != 42) {
            throw new AssertionError(stringArray.length);
        }
        op2code = new HashMap<String, Integer>(n * 2);
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            op2code.put(stringArray[i], new Integer(i));
        }
    }

    class Op {
        public String op;
        public int code;
        public Op[] iftrue;
        public Op[] iffalse;

        public Op(String string, int n) {
            this.op = string;
            this.code = n;
        }

        public String toString() {
            return this.op + "/" + this.code;
        }
    }
}

