/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import multivalent.Behavior;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.PDF;
import multivalent.std.adaptor.pdf.PDFReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Anno
extends Behavior {
    public static final String LAYER = "PDFAnno";
    public static final String MSG_CREATE = "pdfAnnoCreate";
    public static final String MSG_EXECUTE = "pdfAnnoExecute";
    private List<Leaf> leaves_ = null;

    protected boolean checkArgs(String string, SemanticEvent semanticEvent) {
        boolean bl = false;
        Object object = semanticEvent.getArg();
        if ((MSG_CREATE == semanticEvent.getMessage() || MSG_EXECUTE == semanticEvent.getMessage()) && object != null && object.getClass() == COS.CLASS_DICTIONARY && semanticEvent.getIn() instanceof PDF && semanticEvent.getOut() instanceof Node) {
            Dict dict = (Dict)object;
            PDF pDF = (PDF)semanticEvent.getIn();
            PDFReader pDFReader = pDF.getReader();
            try {
                bl = string.equals(pDFReader.getObject(dict.get("Subtype")));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    List<Leaf> findLeaves(SemanticEvent semanticEvent) {
        ArrayList<Leaf> arrayList = new ArrayList<Leaf>(10);
        Dict dict = (Dict)semanticEvent.getArg();
        PDF pDF = (PDF)semanticEvent.getIn();
        PDFReader pDFReader = pDF.getReader();
        try {
            Object object = pDFReader.getObject(dict.get("Rect"));
            if (object instanceof Object[]) {
                Rectangle rectangle = COS.array2Rectangle((Object[])object, pDF.getTransform(), false);
                rectangle.grow(-1, -1);
                this.findLeaves(rectangle, (Node)semanticEvent.getOut(), arrayList);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    List<Leaf> findLeaves(Rectangle rectangle, Node node, List<Leaf> list) {
        Leaf leaf;
        int n;
        List<Leaf> list2 = this.leaves_;
        if (this.leaves_ == null) {
            list2 = this.leaves_ = new ArrayList<Leaf>(500);
            Leaf leaf2 = node.getLastLeaf().getNextLeaf();
            for (Leaf leaf3 = node.getFirstLeaf(); leaf3 != leaf2; leaf3 = leaf3.getNextLeaf()) {
                list2.add(leaf3);
            }
        }
        int n2 = list2.size();
        for (n = 0; n < n2; ++n) {
            leaf = list2.get(n);
            Rectangle rectangle2 = leaf.bbox;
            if (!rectangle.intersects(rectangle2)) continue;
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            if (rectangle3.width <= rectangle2.width / 2 || rectangle3.height <= rectangle2.height / 2) continue;
            list.add(leaf);
        }
        if (list.size() == 0) {
            n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                leaf = list2.get(n);
                if (!rectangle.intersects(leaf.bbox)) continue;
                list.add(leaf);
            }
        }
        return list;
    }

    protected Span createSpan(SemanticEvent semanticEvent, String string, String string2) {
        Span span = null;
        List<Leaf> list = this.findLeaves(semanticEvent);
        if (list.size() > 0) {
            span = (Span)Behavior.getInstance(string, string2, null, this.getDocument().getLayer(LAYER));
            Leaf leaf = list.get(list.size() - 1);
            span.moveq(list.get(0), 0, leaf, leaf.size());
        }
        return span;
    }

    protected void decorate() {
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (string == "openDocumentPage") {
            this.leaves_ = null;
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

