/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import multivalent.Cache;
import multivalent.Document;
import multivalent.INode;
import multivalent.std.adaptor.ArchiveFileEntry;
import multivalent.std.adaptor.ArchiveMediaAdaptor;
import phelps.io.Streams;
import phelps.text.Formats;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zip
extends ArchiveMediaAdaptor {
    static final boolean DEBUG = false;

    @Override
    public Object parse(INode iNode) throws Exception {
        Document document = iNode.getDocument();
        URI uRI = document.getURI();
        return Zip.parseHelper(this.toHTML(uRI), "HTML", this.getLayer(), iNode);
    }

    public String toHTML(URI uRI) {
        ZipFile zipFile;
        String string = uRI.getPath();
        boolean bl = "file".equals(uRI.getScheme());
        Cache cache = this.getGlobal().getCache();
        File file = cache.mapTo(uRI, null, 3);
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            return new StringBuffer().append("Can't make parse Zip: ").append(exception).toString();
        }
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        stringBuffer.append("<html>\n<head>");
        stringBuffer.append("\t<title>").append("Contents of zip file ").append(string).append("</title>\n");
        stringBuffer.append("\t<base href='").append(uRI).append("/'>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        int n = stringBuffer.length();
        int n2 = 0;
        stringBuffer.append(" files, ");
        int n3 = stringBuffer.length();
        long l2 = 0L;
        long l3 = 0L;
        stringBuffer.append("\n<table width='90%'>\n");
        stringBuffer.append("<tr><span Behavior='ScriptSpan' script='event tableSort <node>'  title='Sort table'>");
        stringBuffer.append("<th align='left'>File / <b>Directory<th align='right'>Compressed<th align='right'>Size<th align='right'>Method<th align='right'>Last Modified</b></span>\n");
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            ++n2;
            String string2 = zipEntry.getName();
            stringBuffer.append("<tr>");
            if (zipEntry.isDirectory()) {
                stringBuffer.append("<td><b>").append(string2).append("</b></td>");
                stringBuffer.append("<td align='right'><span Behavior='ElideSpan'>0</span> --<td align='right'><span Behavior='ElideSpan'>0</span> --");
            } else {
                if (bl) {
                    stringBuffer.append("<td><a href='").append(string2).append("'>").append(string2).append("</a>");
                } else {
                    stringBuffer.append("<td>").append(string2);
                }
                stringBuffer.append("<td align='right'>").append(Long.toString(zipEntry.getCompressedSize())).append("<td align='right'>").append(Long.toString(zipEntry.getSize()));
                l3 += zipEntry.getCompressedSize();
                l2 += zipEntry.getSize();
            }
            stringBuffer.append("<td align='right'>").append(zipEntry.getMethod() == 8 ? "deflated" : "STORED");
            long l4 = zipEntry.getTime();
            stringBuffer.append("<td align='right'><span Behavior='ElideSpan'>").append(l4).append("</span> ").append(Formats.relativeDate(l4, l));
            if (zipEntry.getComment() == null) continue;
            stringBuffer.append("<td>").append(zipEntry.getComment());
        }
        stringBuffer.insert(n3, new StringBuffer().append(Formats.prettySize(l3)).append(" / ").append(Formats.prettySize(l2)).toString());
        stringBuffer.insert(n, n2);
        stringBuffer.append("</table>\n</body></html>\n");
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    @Override
    protected String[] getPatterns() {
        String[] stringArray = new String[]{".zip/", ".jar/"};
        return stringArray;
    }

    @Override
    public List<ArchiveFileEntry> getCatalog(File file) throws IOException {
        ArrayList<ArchiveFileEntry> arrayList = new ArrayList<ArchiveFileEntry>(500);
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            arrayList.add(new ArchiveFileEntry(zipEntry.getName(), -1, null, zipEntry.getSize(), zipEntry.getCompressedSize(), -1L, zipEntry.getTime(), zipEntry.getTime()));
        }
        return arrayList;
    }

    @Override
    public File extractFile(File file, String string, File file2) throws IOException {
        File file3 = null;
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string != ALLFILES && !string.equals(string2)) continue;
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            file3 = new File(file2, string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
            long l = Streams.copy(bufferedInputStream, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
            ((InputStream)bufferedInputStream).close();
            if (string == ALLFILES) continue;
            break;
        }
        zipFile.close();
        return file3;
    }
}

