/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import multivalent.Cache;
import multivalent.Document;
import multivalent.INode;
import multivalent.std.adaptor.ArchiveFileEntry;
import multivalent.std.adaptor.ArchiveMediaAdaptor;
import phelps.text.Formats;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tar
extends ArchiveMediaAdaptor {
    static final boolean DEBUG = false;
    static final int BLOCKSIZE = 512;

    @Override
    public Object parse(INode iNode) throws Exception {
        Document document = iNode.getDocument();
        URI uRI = document.getURI();
        return Tar.parseHelper(this.toHTML(uRI), "HTML", this.getLayer(), iNode);
    }

    public String toHTML(URI uRI) throws IOException {
        Cache cache = this.getGlobal().getCache();
        File file = cache.mapTo(uRI, null, 3);
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        stringBuffer.append("<html>\n<head>");
        stringBuffer.append("\t<base href='").append(uRI).append("/'>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        int n = stringBuffer.length();
        int n2 = 0;
        stringBuffer.append(" files, ");
        int n3 = stringBuffer.length();
        long l2 = 0L;
        stringBuffer.append("\n<table width='90%'>\n");
        stringBuffer.append("<tr><span Behavior='ScriptSpan' script='event tableSort <node>'\ttitle='Sort table'>");
        stringBuffer.append("<th align='left'>File / <b>Directory<th align='right'>Size<th align='right'>Last Modified</b></span>\n");
        byte[] byArray = new byte[512];
        InputStream inputStream = this.getInputStream();
        while (inputStream.read(byArray) == 512) {
            if (byArray[0] != 0) {
                int n4;
                byte by;
                int n5;
                String string = null;
                for (n5 = 0; n5 < 100; ++n5) {
                    if (byArray[n5] != 0) continue;
                    string = new String(byArray, 0, n5);
                    break;
                }
                System.out.println(new StringBuffer().append("name = |").append(string).append("|").toString());
                stringBuffer.append("<tr><td>");
                n5 = string.endsWith("/") ? 1 : 0;
                if (n5 != 0) {
                    stringBuffer.append("<b>").append(string).append("</b>");
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append("\n");
                int n6 = 0;
                for (int i = 124; i < 136; ++i) {
                    by = byArray[i];
                    if (by >= 48 && by <= 55) {
                        n6 = n6 * 8 + by - 48;
                        continue;
                    }
                    if (by != 32) break;
                }
                stringBuffer.append("<td align='right'>").append(n6);
                l2 += (long)n6;
                long l3 = 0L;
                for (n4 = 136; n4 < 148; ++n4) {
                    by = byArray[n4];
                    if (by >= 48 && by <= 55) {
                        l3 = l3 * 8L + (long)by - 48L;
                        continue;
                    }
                    if (by != 32) break;
                }
                stringBuffer.append("<td align='right'><span Behavior='ElideSpan'>").append(l3 *= 1000L).append("</span> ").append(Formats.relativeDate(l3, l));
                n4 = n6;
                while (n4 > 0) {
                    n4 = (int)((long)n4 - inputStream.skip(512L));
                }
            }
            ++n2;
        }
        stringBuffer.insert(n3, Formats.prettySize(l2));
        stringBuffer.insert(n, n2);
        stringBuffer.append("</table>\n</body></html>\n");
        return stringBuffer.toString();
    }

    @Override
    protected String[] getPatterns() {
        String[] stringArray = new String[]{".tar/"};
        return stringArray;
    }

    @Override
    public List<ArchiveFileEntry> getCatalog(File file) throws IOException {
        ArrayList<ArchiveFileEntry> arrayList = new ArrayList<ArchiveFileEntry>(500);
        return arrayList;
    }

    @Override
    public File extractFile(File file, String string, File file2) throws IOException {
        File file3 = null;
        return file3;
    }
}

