/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Cache;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.MediaAdaptor;
import multivalent.SemanticEvent;
import multivalent.StyleSheet;
import multivalent.std.adaptor.CSS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetSetter
extends Behavior {
    public static final String PREFIX = "/sys/stylesheet/";
    static Map<String, Entry> cache_ = new HashMap<String, Entry>(20);
    String suffix_;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        Object object = semanticEvent.getArg();
        if (("buildDocument" == string || "openedDocument" == string) && object instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)object;
            Document document = docInfo.doc;
            if ("buildDocument" == string) {
                this.setCascade(document, document.getAttr("genre"));
            }
        }
        return false;
    }

    void setCascade(Document document, String string) {
        Cache cache = this.getGlobal().getCache();
        this.setStyleSheet(document, "user-pan", cache.mapTo(null, new StringBuffer().append("/sys/stylesheet/EVERYWHERE").append(this.suffix_).toString(), 2), null);
        MediaAdaptor mediaAdaptor = document.getMediaAdaptor();
        URL uRL = mediaAdaptor.getClass().getResource(new StringBuffer().append(PREFIX).append(string).append(this.suffix_).toString());
        if (uRL != null) {
            if ("file".equals(uRL.getProtocol())) {
                this.setStyleSheet(document, "genre", new File(uRL.getPath()), null);
            } else {
                this.setStyleSheet(document, "genre", uRL, -1L, null);
            }
        }
        this.setStyleSheet(document, "user-genre", cache.mapTo(null, new StringBuffer().append(PREFIX).append(string).append(this.suffix_).toString(), 2), null);
    }

    void setStyleSheet(Document document, String string, File file, StyleSheet styleSheet) {
        if (file.canRead()) {
            try {
                this.setStyleSheet(document, string, file.toURL(), file.lastModified(), styleSheet);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    void setStyleSheet(Document document, String string, URL uRL, long l, StyleSheet styleSheet) {
        if (uRL == null) {
            return;
        }
        String string2 = uRL.toString();
        Entry entry = cache_.get(string2);
        StyleSheet styleSheet2 = null;
        if (entry == null || entry.lastmod < l) {
            styleSheet2 = new CSS();
            styleSheet2.parse(uRL);
            entry = new Entry(styleSheet2, l);
            cache_.put(string2, entry);
        } else {
            styleSheet2 = entry.ss;
        }
        if (styleSheet2.size() > 0) {
            styleSheet2 = styleSheet2.copy();
            styleSheet2.setName(string);
            if (styleSheet == null) {
                styleSheet2.setCascade(document);
            } else {
                styleSheet2.setCascade(styleSheet.getCascade());
                styleSheet.setCascade(styleSheet2);
            }
        }
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.suffix_ = ".css";
    }

    private static class Entry {
        public StyleSheet ss;
        long lastmod;

        public Entry(StyleSheet styleSheet, long l) {
            this.ss = styleSheet;
            this.lastmod = l;
        }
    }
}

