/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import multivalent.Cache;
import multivalent.Document;
import multivalent.INode;
import multivalent.std.adaptor.ArchiveFileEntry;
import multivalent.std.adaptor.ArchiveMediaAdaptor;
import phelps.text.Formats;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPM
extends ArchiveMediaAdaptor {
    static final boolean DEBUG = false;
    public static final int RPMTAG_NAME = 1000;
    public static final int RPMTAG_VERSION = 1001;
    public static final int RPMTAG_RELEASE = 1002;
    public static final int RPMTAG_SERIAL = 1003;
    public static final int RPMTAG_SUMMARY = 1004;
    public static final int RPMTAG_DESCRIPTION = 1005;
    public static final int RPMTAG_BUILDTIME = 1006;
    public static final int RPMTAG_BUILDHOST = 1007;
    public static final int RPMTAG_INSTALLTIME = 1008;
    public static final int RPMTAG_SIZE = 1009;
    public static final int RPMTAG_DISTRIBUTION = 1010;
    public static final int RPMTAG_VENDOR = 1011;
    public static final int RPMTAG_GIF = 1012;
    public static final int RPMTAG_XPM = 1013;
    public static final int RPMTAG_COPYRIGHT = 1014;
    public static final int RPMTAG_PACKAGER = 1015;
    public static final int RPMTAG_GROUP = 1016;
    public static final int RPMTAG_CHANGELOG = 1017;
    public static final int RPMTAG_SOURCE = 1018;
    public static final int RPMTAG_PATCH = 1019;
    public static final int RPMTAG_URL = 1020;
    public static final int RPMTAG_OS = 1021;
    public static final int RPMTAG_ARCH = 1022;
    public static final int RPMTAG_PREIN = 1023;
    public static final int RPMTAG_POSTIN = 1024;
    public static final int RPMTAG_PREUN = 1025;
    public static final int RPMTAG_POSTUN = 1026;
    public static final int RPMTAG_FILENAMES = 1027;
    public static final int RPMTAG_FILESIZES = 1028;
    public static final int RPMTAG_FILESTATES = 1029;
    public static final int RPMTAG_FILEMODES = 1030;
    public static final int RPMTAG_FILEUIDS = 1031;
    public static final int RPMTAG_FILEGIDS = 1032;
    public static final int RPMTAG_FILERDEVS = 1033;
    public static final int RPMTAG_FILEMTIMES = 1034;
    public static final int RPMTAG_FILEMD5S = 1035;
    public static final int RPMTAG_FILELINKTOS = 1036;
    public static final int RPMTAG_FILEFLAGS = 1037;
    public static final int RPMTAG_ROOT = 1038;
    public static final int RPMTAG_FILEUSERNAME = 1039;
    public static final int RPMTAG_FILEGROUPNAME = 1040;
    public static final int RPMTAG_EXCLUDE = 1041;
    public static final int RPMTAG_EXCLUSIVE = 1042;
    public static final int RPMTAG_ICON = 1043;
    public static final int RPMTAG_SOURCERPM = 1044;
    public static final int RPMTAG_FILEVERIFYFLAGS = 1045;
    public static final int RPMTAG_ARCHIVESIZE = 1046;
    public static final int RPMTAG_PROVIDES = 1047;
    public static final int RPMTAG_REQUIREFLAGS = 1048;
    public static final int RPMTAG_REQUIRENAME = 1049;
    public static final int RPMTAG_REQUIREVERSION = 1050;
    public static final int RPMTAG_NOSOURCE = 1051;
    public static final int RPMTAG_NOPATCH = 1052;
    public static final int RPMTAG_CONFLICTFLAGS = 1053;
    public static final int RPMTAG_CONFLICTNAME = 1054;
    public static final int RPMTAG_CONFLICTVERSION = 1055;
    public static final int RPMTAG_DEFAULTPREFIX = 1056;
    public static final int RPMTAG_BUILDROOT = 1057;
    public static final int RPMTAG_INSTALLPREFIX = 1058;
    public static final int RPMTAG_EXCLUDEARCH = 1059;
    public static final int RPMTAG_EXCLUDEOS = 1060;
    public static final int RPMTAG_EXCLUSIVEARCH = 1061;
    public static final int RPMTAG_EXCLUSIVEOS = 1062;
    public static final int RPMTAG_AUTOREQPROV = 1063;
    public static final int RPMTAG_RPMVERSION = 1064;
    public static final int RPMTAG_TRIGGERSCRIPTS = 1065;
    public static final int RPMTAG_TRIGGERNAME = 1066;
    public static final int RPMTAG_TRIGGERVERSION = 1067;
    public static final int RPMTAG_TRIGGERFLAGS = 1068;
    public static final int RPMTAG_TRIGGERINDEX = 1069;
    public static final int RPMTAG_VERIFYSCRIPT = 1079;
    public static final int SIGTAG_SIZE = 1000;
    public static final int SIGTAG_MD5 = 1001;
    public static final int SIGTAG_PGP = 1002;
    public static final int NULL = 0;
    public static final int CHAR = 1;
    public static final int INT8 = 2;
    public static final int INT16 = 3;
    public static final int INT32 = 4;
    public static final int INT64 = 5;
    public static final int STRING = 6;
    public static final int BIN = 7;
    public static final int STRING_ARRAY = 8;
    public static final int C_IRUSR = 256;
    public static final int C_IWUSR = 128;
    public static final int C_IXUSR = 64;
    public static final int C_IRGRP = 32;
    public static final int C_IWGRP = 16;
    public static final int C_IXGRP = 8;
    public static final int C_IROTH = 4;
    public static final int C_IWOTH = 2;
    public static final int C_IXOTH = 1;
    public static final int C_ISUID = 2048;
    public static final int C_ISGID = 1024;
    public static final int C_ISVTX = 512;
    public static final int C_ISBLK = 24576;
    public static final int C_ISCHR = 8192;
    public static final int C_ISDIR = 16384;
    public static final int C_ISFIFO = 4096;
    public static final int C_ISSOCK = 49152;
    public static final int C_ISLNK = 40960;
    public static final int C_ISCTG = 36864;
    public static final int C_ISREG = 32768;
    static final String CPIO_END = "TRAILER!!!";
    static final int CPIO_MAGIC = 29121;
    GZIPInputStream isz_ = null;

    int read4() throws IOException {
        InputStream inputStream = this.getInputStream();
        return ((inputStream.read() << 8 | inputStream.read()) << 8 | inputStream.read()) << 8 | inputStream.read();
    }

    int readoct6() throws IOException {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n = (n << 3) + (this.isz_.read() - 48);
        }
        return n;
    }

    int readhex8() throws IOException {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            int n2 = this.isz_.read();
            n2 = n2 >= 48 && n2 <= 57 ? (n2 -= 48) : (n2 -= 87);
            n = (n << 4) + n2;
        }
        return n;
    }

    @Override
    public Object parse(INode iNode) throws Exception {
        Document document = iNode.getDocument();
        URI uRI = document.getURI();
        return RPM.parseHelper(this.toHTML(uRI), "HTML", this.getLayer(), iNode);
    }

    public String toHTML(URI uRI) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Cache cache = this.getGlobal().getCache();
        File file = cache.mapTo(uRI, null, 3);
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer((int)file.length());
        stringBuffer.append("<html>\n<head>");
        stringBuffer.append("\t<base href='").append(uRI).append("/'>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        InputStream inputStream = this.getInputStream();
        if (inputStream.read() != 237 || inputStream.read() != 171 || inputStream.read() != 238 || inputStream.read() != 219) {
            return "Not a valid RPM file -- bad magic number.";
        }
        int n8 = 96;
        for (n7 = 4; n7 < n8; ++n7) {
            inputStream.read();
        }
        if (inputStream.read() != 142 || inputStream.read() != 173 || inputStream.read() != 232) {
            return "Not a valid RPM file -- in signature's \"header structure header\".";
        }
        inputStream.read();
        this.read4();
        n7 = this.read4();
        n8 = this.read4();
        int n9 = 16 * n7 + n8 + 4;
        for (n6 = 0; n6 < n9; ++n6) {
            inputStream.read();
        }
        if (inputStream.read() != 142 || inputStream.read() != 173 || inputStream.read() != 232) {
            return "Not a valid RPM file -- in \"header structure header\".";
        }
        inputStream.read();
        this.read4();
        n6 = this.read4();
        n9 = this.read4();
        Index[] indexArray = new Index[n6];
        for (int i = 0; i < n6; ++i) {
            int n10 = this.read4();
            int n11 = this.read4();
            n5 = this.read4();
            n4 = this.read4();
            indexArray[i] = new Index(n10, n11, n5, n4);
        }
        byte[] byArray = new byte[n9];
        inputStream.read(byArray);
        this.isz_ = new GZIPInputStream(inputStream);
        StringBuffer stringBuffer2 = new StringBuffer(200);
        ArrayList<ArchiveFileEntry> arrayList = new ArrayList<ArchiveFileEntry>(200);
        block3: while (true) {
            n5 = 0;
            while ((n4 = this.isz_.read()) != 48 || (n4 = this.isz_.read()) != 55 || (n4 = this.isz_.read()) != 48 || (n4 = this.isz_.read()) != 55 || (n4 = this.isz_.read()) != 48 || (n4 = this.isz_.read()) != 49) {
                ++n5;
            }
            System.out.println(new StringBuffer().append("skip = ").append(n5).toString());
            n4 = this.readhex8();
            int n12 = this.readhex8();
            int n13 = this.readhex8();
            n3 = this.readhex8();
            n2 = this.readhex8();
            int n14 = this.readhex8();
            int n15 = this.readhex8();
            n = this.readhex8();
            int n16 = this.readhex8();
            int n17 = this.readhex8();
            int n18 = this.readhex8();
            int n19 = this.readhex8();
            int n20 = this.readhex8();
            System.out.println(new StringBuffer().append("namesize=").append(n19).append(", filesize=").append(n15).toString());
            stringBuffer2.setLength(0);
            int n21 = n19 - 1;
            for (int i = 0; i < n21; ++i) {
                stringBuffer2.append((char)this.isz_.read());
            }
            this.isz_.read();
            String string = stringBuffer2.substring(0);
            System.out.println(new StringBuffer().append("read ").append(string).toString());
            if (string.equals(CPIO_END)) break;
            for (n21 = 0; n21 < n15; ++n21) {
                this.isz_.read();
            }
            arrayList.add(new ArchiveFileEntry(string, 0, null, n15, n15, -1L, n14, n14));
            n21 = 110 + n19 + n15;
            int n22 = n21 % 4;
            System.out.println(new StringBuffer().append("elen=").append(n21).append(", /4=").append(n21 / 4 * 4).append(", mod4=").append(n21 % 4).toString());
            int n23 = 0;
            int n24 = 4 - n22;
            while (true) {
                if (n23 >= n24) continue block3;
                this.isz_.read();
                ++n23;
            }
            break;
        }
        this.isz_.close();
        n5 = arrayList.size();
        stringBuffer.append(n5).append(" file").append(n5 > 0 ? "s" : "").append(", ");
        n4 = stringBuffer.length();
        long l2 = 0L;
        stringBuffer.append("\n<table width='90%'>\n");
        stringBuffer.append("<tr><span Behavior='ScriptSpan' script='event tableSort <node>'\ttitle='Sort table'>");
        stringBuffer.append("<th align='left'>File / <b>Directory<th align='right'>Size<th align='right'>Last Modified</b></span>\n");
        n2 = arrayList.size();
        for (n3 = 0; n3 < n2; ++n3) {
            ArchiveFileEntry archiveFileEntry = (ArchiveFileEntry)arrayList.get(n3);
            String string = archiveFileEntry.filename;
            stringBuffer.append("<tr><td>");
            n = string.endsWith("/") ? 1 : 0;
            if (n != 0) {
                stringBuffer.append("<b>").append(string).append("</b>");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
            long l3 = archiveFileEntry.length;
            stringBuffer.append("<td align='right'>").append(l3);
            l2 += l3;
            long l4 = archiveFileEntry.lastmod;
            stringBuffer.append("<td align='right'><span Behavior='ElideSpan'>").append(l4 *= 1000L).append("</span> ").append(Formats.relativeDate(l4, l));
        }
        stringBuffer.insert(n4, Formats.prettySize(l2));
        stringBuffer.append("</table>\n</body></html>\n");
        return stringBuffer.toString();
    }

    @Override
    protected String[] getPatterns() {
        String[] stringArray = new String[]{".rpm/"};
        return stringArray;
    }

    @Override
    public List<ArchiveFileEntry> getCatalog(File file) throws IOException {
        ArrayList<ArchiveFileEntry> arrayList = new ArrayList<ArchiveFileEntry>(500);
        return arrayList;
    }

    @Override
    public File extractFile(File file, String string, File file2) throws IOException {
        File file3 = null;
        return file3;
    }

    static class Index {
        int tag;
        int type;
        int offset;
        int count;

        Index(int n, int n2, int n3, int n4) {
            this.tag = n;
            this.type = n2;
            this.offset = n3;
            this.count = n4;
        }
    }
}

