/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Cache;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.SemanticEvent;

public class PersonalAnnos
extends Behavior {
    static final boolean DEBUG = false;
    static final String PREFIX = "annos/";
    static final String FILENAME = "annos.hub";

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("openedDocument" == string) {
            Cache cache = this.getGlobal().getCache();
            DocInfo docInfo = (DocInfo)semanticEvent.getArg();
            Document document = docInfo.doc;
            URI uRI = document.getURI();
            File file = cache.mapTo(uRI, "hub.mvd", 2);
            File file2 = cache.mapTo(uRI, FILENAME, 2);
            if (file.exists()) {
                file.renameTo(file2);
            }
            if (file2.exists() && file2.length() > 10L) {
                browser.eventq(new SemanticEvent(browser, "loadLayer", file2.toURI(), null, document));
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if ("closeDocument" == string) {
            Document document = (Document)semanticEvent.getArg();
            if (document == null) {
                document = browser.getCurDocument();
            }
            if (document.getAttr("loading") == null) {
                boolean bl;
                Cache cache = this.getGlobal().getCache();
                URI uRI = document.getURI();
                File file = cache.mapTo(uRI, FILENAME, 2);
                Layer layer = document.getLayer("personal");
                ESISNode eSISNode = layer.save();
                if (eSISNode != null) {
                    if (eSISNode.getAttr("uri") == null) {
                        eSISNode.putAttr("uri", uRI.toString());
                    }
                    try {
                        File file2 = file.getParentFile();
                        if (!file2.exists()) {
                            file2.mkdirs();
                        }
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                        String string2 = eSISNode.writeXML();
                        bufferedWriter.write(string2);
                        ((Writer)bufferedWriter).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("couldn't write hub: " + iOException);
                    }
                } else if (file.exists() && !(bl = file.delete())) {
                    System.out.println("ERROR: couldn't delete hub " + file);
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

