/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.SemanticEvent;
import multivalent.node.LeafAscii;
import multivalent.std.adaptor.MediaAdaptorReader;
import multivalent.std.adaptor.XML;

public class MultivalentAdaptor
extends MediaAdaptorReader {
    protected URI refURI_ = null;

    public Object parse(INode iNode) throws Exception {
        String string = null;
        try {
            ESISNode eSISNode = XML.parseDOM(this.docURI);
            String string2 = eSISNode.getAttr("uri");
            if (string2 == null && (string2 = eSISNode.getAttr("url")) != null) {
                eSISNode.putAttr("uri", string2);
            }
            eSISNode.removeAttr("url");
            if (string2 != null) {
                string = "Loading " + string2;
                try {
                    this.refURI_ = new URI(string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    string = "Bad URI in hub: " + string2;
                }
            } else {
                string = "no URI attribute set in hub!";
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            return null;
        }
        return new LeafAscii(string, null, iNode);
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("openedDocument" == string && this.refURI_ != null) {
            Browser browser = this.getBrowser();
            Document document = this.getDocument();
            DocInfo docInfo = new DocInfo(this.refURI_);
            docInfo.doc = document;
            browser.eventq("openDocument", docInfo);
            browser.eventq(new SemanticEvent(browser, "loadLayer", this.docURI, null, document));
            browser.eventq("redirectedDocument", null);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

