/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import multivalent.Browser;
import multivalent.Document;
import multivalent.INode;
import multivalent.SemanticEvent;
import multivalent.gui.VCheckbox;
import multivalent.std.adaptor.ArchiveFileEntry;
import multivalent.std.adaptor.ArchiveMediaAdaptor;
import phelps.io.Files;
import phelps.lang.Booleans;
import phelps.lang.Strings;
import phelps.text.Formats;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDirectory
extends ArchiveMediaAdaptor {
    public static final String MSG_SET_DIRTYPE = "setDirectoryType";
    public static final String MSG_SET_BKUP = "setShowBackup";
    public static final String PREF_TYPE = "Directory/Type";
    public static final String PREF_NOBKUP = "ZapBkup";
    public static final String SHORT = "short";
    public static final String FIELDS = "fields";
    static final int SHORTCOLS = 5;

    @Override
    public File extractFile(File file, String string, File file2) throws IOException {
        return null;
    }

    @Override
    protected String[] getPatterns() {
        return null;
    }

    @Override
    public List<ArchiveFileEntry> getCatalog(File file) throws IOException {
        return null;
    }

    @Override
    public Object parse(INode iNode) throws Exception {
        Browser browser = this.getBrowser();
        Document document = this.getDocument();
        URI uRI = this.docURI;
        String string = uRI.getPath();
        if (!string.endsWith("/")) {
            string = new StringBuffer().append(string).append("/").toString();
            try {
                uRI = document.uri = uRI.resolve(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Object object = LocalDirectory.parseHelper(this.toHTML(string), "HTML", this.getLayer(), document);
        String string2 = this.getPreference("DirectoryMediaAdaptor/SortBy", "filename");
        String string3 = "Name";
        String string4 = "tableSortAscending";
        if (string2.equals("length")) {
            string3 = "Size";
            string4 = "tableSortDescending";
        } else if (string2.equals("lastModified")) {
            string3 = "Last";
            string4 = "tableSortDescending";
        }
        if (!string2.equals("none") && browser != null) {
            browser.event(new SemanticEvent(browser, string4, document.findDFS(string3)));
        }
        return object;
    }

    public String toHTML(String string) {
        String string2;
        File file = new File(string);
        boolean bl = "/".equals(string);
        File[] fileArray = bl ? File.listRoots() : file.listFiles();
        StringBuffer stringBuffer = new StringBuffer(10000);
        stringBuffer.append("<html>\n<head>");
        stringBuffer.append("\t<title>").append("Directory ").append(string).append("</title>\n");
        stringBuffer.append("\t<base href='").append(string).append("'>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        if (bl) {
            String string3;
            stringBuffer.append("<h3>Roots:\t");
            if (fileArray.length == 1) {
                stringBuffer.append("/ (shown below), ");
            } else {
                try {
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append("<a href='").append(fileArray[i].toURL()).append("'>").append(fileArray[i]).append("</a>, ");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            string2 = System.getProperty("user.home");
            String string4 = System.getProperty("user.name");
            if (string2 != null && string4 != null) {
                string3 = string2.endsWith(string4) ? string2 : new StringBuffer().append(string2).append(File.separatorChar).append(string4).toString();
                try {
                    stringBuffer.append("<a href='").append(new File(string3).toURL().toString()).append("'>HOME").append("</a>, ");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((string3 = System.getProperty("java.io.tmpdir")) != null) {
                try {
                    stringBuffer.append("<a href='").append(new File(string3).toURL().toString()).append("'>TMP").append("</a>, ");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append("</h3>");
        }
        if (!bl || fileArray.length == 1) {
            long l;
            stringBuffer.append("<h3>Directory ");
            if (!bl) {
                stringBuffer.append(" &nbsp; <a href='..'>").append("<img src='systemresource:/sys/images/Up16.gif'>").append("</a> &nbsp; ");
                stringBuffer.append("<a href='file:///'>").append("(roots)").append("</a> ");
                int n = string.indexOf(47, 1);
                int n2 = string.lastIndexOf(47);
                int n3 = 1;
                while (n < n2) {
                    stringBuffer.append('/').append("<a href='file:").append(string.substring(0, n + 1)).append("'>").append(string.substring(n3, n)).append("</a>");
                    n3 = n + 1;
                    n = string.indexOf(47, n + 1);
                }
                string2 = string.substring(Math.max(string.indexOf(47), string.lastIndexOf(47, string.length() - 1 - 1)) + 1, string.length() - 1);
                stringBuffer.append('/').append(string2);
            }
            stringBuffer.append('/');
            stringBuffer.append("</h3>\n");
            if (bl) {
                fileArray = fileArray[0].listFiles();
            }
            stringBuffer.append("<p>").append(fileArray.length).append(" file");
            if (fileArray.length != 1) {
                stringBuffer.append('s');
            }
            int n = stringBuffer.length();
            String string5 = this.getPreference(PREF_TYPE, FIELDS);
            long l2 = l = SHORT.equals(string5) ? this.buildShort(stringBuffer, file, fileArray) : this.buildFields(stringBuffer, file, fileArray);
            if (l > 0L) {
                stringBuffer.insert(n, new StringBuffer().append(", ").append(Formats.prettySize(l)).append(" in directory").toString());
            }
        }
        stringBuffer.append("</body></html>\n");
        return stringBuffer.toString();
    }

    protected long buildShort(StringBuffer stringBuffer, File file, File[] fileArray) {
        stringBuffer.append("<table width='90%' cellpadding=0 cellspacing=0>\n");
        String[] stringArray = new String[fileArray.length];
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fileArray[i].getName();
        }
        Arrays.sort(stringArray, Strings.DICTIONARY_CASE_INSENSITIVE_ORDER);
        long l = 0L;
        int n2 = fileArray.length;
        for (int i = 0; i < n2; i += 5) {
            int n3;
            stringBuffer.append("<tr>");
            int n4 = Math.min(n3 + 5, n2);
            for (n3 = i; n3 < n4; ++n3) {
                File file2 = fileArray[n3];
                boolean bl = file2.isDirectory();
                if (!bl) {
                    l += file2.length();
                }
                stringBuffer.append("<td><a href='").append(stringArray[i]).append(bl ? "/" : "").append("'>").append(stringArray[i]).append(bl ? "/" : "").append("</a>");
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("</table>\n");
        return l;
    }

    protected long buildFields(StringBuffer stringBuffer, File file, File[] fileArray) {
        stringBuffer.append("<table width='95%'>\n");
        stringBuffer.append("<tr><span Behavior='ScriptSpan' script='event tableSort <node>'  title='Sort table'>");
        stringBuffer.append("<th align='left' width=1><b>Type</b><!--icon--><th align='left'><b>Name</b><th align='right'><b>Size</b><th align='right'><b>Last Modified</b></span></tr>");
        boolean bl = true;
        long l = System.currentTimeMillis();
        long l2 = 0L;
        boolean bl2 = Booleans.parseBoolean(this.getPreference(PREF_NOBKUP, "true"), true);
        for (File file2 : fileArray) {
            String string = file2.getName();
            String string2 = string.toLowerCase();
            String string3 = file2.toURI().toString();
            if (bl2 && Files.isBackup(string)) continue;
            boolean bl3 = file2.isDirectory();
            long l3 = bl3 ? 0L : file2.length();
            long l4 = file2.lastModified();
            l2 += l3;
            stringBuffer.append("<tr>");
            int n = string.lastIndexOf(46);
            stringBuffer.append("<td><span Behavior='ElideSpan'>").append(n != -1 ? string.substring(n + 1) : "--").append("</span>");
            if (bl3) {
                stringBuffer.append("<img src='systemresource:/sys/images/Open24.gif'>");
            }
            stringBuffer.append("<td><a href='").append(string3).append("'>").append(string).append("</a>");
            stringBuffer.append("<td align='right'>");
            if (bl3 || bl) {
                stringBuffer.append("<span Behavior='ElideSpan'>").append(l3).append("</span> ");
            }
            if (bl3) {
                stringBuffer.append("--");
            } else {
                stringBuffer.append(bl ? Formats.prettySize(l3) : Long.toString(l3));
            }
            stringBuffer.append("<td align='right'>").append("<span Behavior='ElideSpan'>").append(l4).append("</span> ").append(Formats.relativeDate(l4, l));
            stringBuffer.append('\n');
        }
        stringBuffer.append("</table>\n");
        return l2;
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            String string2 = this.getPreference(PREF_TYPE, FIELDS);
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Short Directory Display", "event setDirectoryType", (INode)semanticEvent.getOut(), "medium", false);
            vCheckbox.setState(SHORT.equals(string2));
            vCheckbox = (VCheckbox)this.createUI("checkbox", "Don't show backup files", "event setShowBackup", (INode)semanticEvent.getOut(), "medium", false);
            vCheckbox.setState(Booleans.parseBoolean(this.getPreference(PREF_NOBKUP, "true"), true));
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        boolean bl;
        boolean bl2;
        Browser browser = this.getBrowser();
        Object object = semanticEvent.getArg();
        if (MSG_SET_DIRTYPE == string) {
            String string2;
            String string3 = this.getPreference(PREF_TYPE, FIELDS);
            String string4 = FIELDS.equals(object) ? FIELDS : (SHORT.equals(object) ? SHORT : (string2 = FIELDS.equals(string3) ? SHORT : FIELDS));
            if (!string2.equals(string3)) {
                this.putPreference(PREF_TYPE, string2);
                browser.eventq("reloadDocument", null);
            }
        } else if (MSG_SET_BKUP == string && (bl2 = Booleans.parseBoolean(object, !(bl = Booleans.parseBoolean(this.getPreference(PREF_NOBKUP, "true"), true)))) != bl) {
            this.putPreference(PREF_NOBKUP, !bl2 ? "true" : "false");
            browser.eventq("reloadDocument", null);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

