/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.awt.Color;
import java.util.Map;
import java.util.StringTokenizer;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Span;
import multivalent.std.adaptor.HTML;
import phelps.awt.Colors;
import phelps.awt.Fonts;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HTMLFONT
extends Span {
    int fontsize = 0;
    int fontdelta = 0;
    Color newcolor = null;
    String face = null;

    public HTMLFONT(String string) {
        this.setName(string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.newcolor = Colors.getColor(this.getAttr("color"), null);
        String string = this.getAttr("size");
        if (string != null) {
            try {
                int n = Integer.parseInt(string.startsWith("+") ? string.substring(1) : string);
                if (string.startsWith("+") || string.startsWith("-")) {
                    this.fontdelta = n;
                } else {
                    this.fontsize = Math.min(7, Math.max(1, n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = this.getAttr("face")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = Fonts.getNormalFamily(stringTokenizer.nextToken());
                if (string2 == null) continue;
                this.face = string2;
                break;
            }
        }
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (this.newcolor != null) {
            context.foreground = this.newcolor;
        }
        if (this.fontdelta != 0) {
            int n = (int)context.size;
            if (n < HTML.points2size.length && HTML.points2size[n] != 0) {
                context.size = HTML.validpoints[Math.min(7, Math.max(1, HTML.points2size[n] + this.fontdelta)) - 1];
            }
        } else if (this.fontsize > 0) {
            context.size = HTML.validpoints[this.fontsize - 1];
        }
        if (this.face != null) {
            context.family = this.face;
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("multivalent.std.adaptor.HTMLFONT, ").append(this.attr_).append(" ").append(super.toString()).toString();
    }
}

