/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import multivalent.Context;
import multivalent.INode;

public class CSSContext
extends Context {
    static final String BORDER_NONE = "none";
    static final String BORDER_SOLID = "solid";
    static final String BORDER_DOUBLE = "double";
    static final String BORDER_DASHED = "dashed";
    static final String BORDER_DOTTED = "dotted";
    static final String BORDER_GROOVE = "groove";
    static final String BORDER_RIDGE = "ridge";
    static final String BORDER_INSET = "inset";
    static final String BORDER_OUTSET = "outset";
    public Color cbordertop;
    public Color cborderbottom;
    public Color cborderleft;
    public Color cborderright;
    public String borderstyle;

    public CSSContext(Toolkit toolkit) {
        super(toolkit);
    }

    public void clear() {
        super.clear();
    }

    public void clearNonInherited() {
        super.clearNonInherited();
        this.cborderleft = this.cborderright = Context.COLOR_INHERIT;
        this.cborderbottom = this.cborderright;
        this.cbordertop = this.cborderright;
        this.borderstyle = Context.STRING_INVALID;
    }

    public boolean paintBefore(Context context, INode iNode) {
        Insets insets = iNode.border;
        iNode.border = INode.INSETS_ZERO;
        boolean bl = super.paintBefore(context, iNode);
        iNode.border = insets;
        Rectangle rectangle = iNode.bbox;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (insets != INode.INSETS_ZERO && !BORDER_NONE.equals(this.borderstyle)) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = insets.left;
            if (n9 > 0) {
                this.g.setColor(this.cborderleft != Context.COLOR_INHERIT ? this.cborderleft : this.foreground);
                if (BORDER_SOLID.equals(this.borderstyle) || this.borderstyle == Context.STRING_INVALID) {
                    this.g.fillRect(n, n2, n9, n4);
                } else if (BORDER_DOUBLE.equals(this.borderstyle)) {
                    n8 = Math.max(n9 / 3, 1);
                    this.g.fillRect(n, n2, n8, n4);
                    this.g.fillRect(n + n9 - n8, n2 + n9, n8, n4 - n9 - n9);
                } else if (BORDER_DASHED.equals(this.borderstyle)) {
                    if (n4 >= 10) {
                        n7 = n4 - 5;
                        for (n8 = 0; n8 < n7; n8 += 10) {
                            this.g.fillRect(n, n2 + n8, n9, 5);
                        }
                    } else {
                        this.g.fillRect(n, n2, n9, n4);
                    }
                } else if (BORDER_DOTTED.equals(this.borderstyle)) {
                    if (n4 >= n9) {
                        n7 = n4 - n9;
                        for (n8 = 0; n8 < n7; n8 += n9 + n9) {
                            this.g.fillOval(n, n2 + n8, n9, n9);
                        }
                    } else {
                        this.g.fillRect(n, n2, n9, n4);
                    }
                } else if (BORDER_GROOVE.equals(this.borderstyle)) {
                    n8 = n9 / 2;
                    this.g.setColor(Color.GRAY);
                    this.g.fillRect(n, n2, n8, n4);
                    this.g.setColor(Color.WHITE);
                    this.g.fillRect(n + n8, n2, n8, n4);
                } else if (BORDER_RIDGE.equals(this.borderstyle) || BORDER_INSET.equals(this.borderstyle) || BORDER_OUTSET.equals(this.borderstyle)) {
                    // empty if block
                }
            }
            if ((n9 = insets.right) > 0) {
                n8 = n + n3 - n9;
                this.g.setColor(this.cborderright != Context.COLOR_INHERIT ? this.cborderright : this.foreground);
                if (BORDER_SOLID.equals(this.borderstyle) || this.borderstyle == Context.STRING_INVALID) {
                    this.g.fillRect(n8, n2, n9, n4);
                } else if (BORDER_DOUBLE.equals(this.borderstyle)) {
                    n7 = Math.max(n9 / 3, 1);
                    this.g.fillRect(n + n3 - n7, n2, n7, n4);
                    this.g.fillRect(n8, n2 + n9, n7, n4 - n9 - n9);
                } else if (BORDER_DASHED.equals(this.borderstyle)) {
                    if (n4 >= 10) {
                        n6 = n4 - 5;
                        for (n7 = 0; n7 < n6; n7 += 10) {
                            this.g.fillRect(n8, n2 + n7, n9, 5);
                        }
                    } else {
                        this.g.fillRect(n8, n2, n9, n4);
                    }
                } else if (BORDER_DOTTED.equals(this.borderstyle)) {
                    if (n4 >= n9) {
                        n6 = n4 - n9;
                        for (n7 = 0; n7 < n6; n7 += n9 + n9) {
                            this.g.fillOval(n8, n2 + n7, n9, n9);
                        }
                    } else {
                        this.g.fillRect(n8, n2, n9, n4);
                    }
                } else if (BORDER_GROOVE.equals(this.borderstyle)) {
                    n7 = n9 / 2;
                    this.g.setColor(Color.GRAY);
                    this.g.fillRect(n8, n2, n7, n4);
                    this.g.setColor(Color.WHITE);
                    this.g.fillRect(n8 + n7, n2, n7, n4);
                }
            }
            if ((n5 = insets.top) > 0) {
                this.g.setColor(this.cbordertop != Context.COLOR_INHERIT ? this.cbordertop : this.foreground);
                if (BORDER_SOLID.equals(this.borderstyle) || this.borderstyle == Context.STRING_INVALID) {
                    this.g.fillRect(n, n2, n3, n5);
                } else if (BORDER_DOUBLE.equals(this.borderstyle)) {
                    n8 = Math.max(n5 / 3, 1);
                    this.g.fillRect(n, n2, n3, n8);
                    this.g.fillRect(n + n5, n2 + n5 - n8, n3 - n5 - n5, n8);
                } else if (BORDER_DASHED.equals(this.borderstyle)) {
                    if (n3 >= 10) {
                        n7 = n3 - 5;
                        for (n8 = 0; n8 < n7; n8 += 10) {
                            this.g.fillRect(n + n8, n2, 5, n5);
                        }
                    } else {
                        this.g.fillRect(n, n2, n3, n5);
                    }
                } else if (BORDER_DOTTED.equals(this.borderstyle)) {
                    if (n3 >= n5) {
                        n7 = n3 - n5;
                        for (n8 = 0; n8 < n7; n8 += n5 + n5) {
                            this.g.fillOval(n + n8, n2, n9, n9);
                        }
                    } else {
                        this.g.fillRect(n, n2, n3, n5);
                    }
                } else if (BORDER_GROOVE.equals(this.borderstyle)) {
                    n8 = n5 / 2;
                    this.g.setColor(Color.GRAY);
                    this.g.fillRect(n, n2, n3, n8);
                    this.g.setColor(Color.WHITE);
                    this.g.fillRect(n + n5, n2 + n8, n3 - n5, n8);
                }
            }
            if ((n5 = insets.bottom) > 0) {
                n8 = n2 + n4 - n5;
                this.g.setColor(this.cborderbottom != Context.COLOR_INHERIT ? this.cborderbottom : this.foreground);
                if (BORDER_SOLID.equals(this.borderstyle) || this.borderstyle == Context.STRING_INVALID) {
                    this.g.fillRect(n, n8, n3, n5);
                } else if (BORDER_DOUBLE.equals(this.borderstyle)) {
                    n7 = Math.max(n5 / 3, 1);
                    this.g.fillRect(n, n2 + n4 - n7, n3, n7);
                    this.g.fillRect(n + n5, n8, n3 - n5 - n5, n7);
                } else if (BORDER_DASHED.equals(this.borderstyle)) {
                    if (n3 >= 10) {
                        n6 = n3 - 5;
                        for (n7 = 0; n7 < n6; n7 += 10) {
                            this.g.fillRect(n + n7, n8, 5, n5);
                        }
                    } else {
                        this.g.fillRect(n, n8, n3, n5);
                    }
                } else if (BORDER_DOTTED.equals(this.borderstyle)) {
                    if (n3 >= n5) {
                        n6 = n3 - n5;
                        for (n7 = 0; n7 < n6; n7 += n5 + n5) {
                            this.g.fillOval(n + n7, n8, n9, n9);
                        }
                    } else {
                        this.g.fillRect(n, n8, n3, n5);
                    }
                } else if (BORDER_GROOVE.equals(this.borderstyle)) {
                    n7 = n5 / 2;
                    this.g.setColor(Color.GRAY);
                    this.g.fillRect(n + n5, n8, n3 - n5 - n5, n7);
                    this.g.setColor(Color.WHITE);
                    this.g.fillRect(n + n5, n8 + n7, n3 - n5, n7);
                }
            }
        }
        return bl;
    }

    public boolean paintAfter(Context context, INode iNode) {
        boolean bl = super.paintAfter(context, iNode);
        return bl;
    }
}

