/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import multivalent.Browser;
import multivalent.Cache;
import multivalent.DocInfo;
import multivalent.INode;
import multivalent.SemanticEvent;
import multivalent.gui.VRadiobox;
import multivalent.gui.VRadiogroup;
import multivalent.std.adaptor.ArchiveFileEntry;
import multivalent.std.adaptor.MediaAdaptorByte;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveMediaAdaptor
extends MediaAdaptorByte {
    static final boolean DEBUG = false;
    public static final String MSG_SORTBY = "DirectoryMediaAdaptor/SortBy";
    public static final String PREF_SORTBY = "DirectoryMediaAdaptor/SortBy";
    public static final String FILENAME = "filename";
    public static final String LENGTH = "length";
    public static final String LASTMOD = "lastModified";
    public static final String NONE = "none";
    public static final String ALLFILES = new String();
    protected boolean verbose = false;
    protected boolean fulltext = false;
    protected boolean standard = false;

    public abstract File extractFile(File var1, String var2, File var3) throws IOException;

    protected abstract String[] getPatterns();

    public abstract List<ArchiveFileEntry> getCatalog(File var1) throws IOException;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventAfter(semanticEvent, string)) {
            return true;
        }
        Object object = semanticEvent.getArg();
        if ("openDocument" == string && object instanceof DocInfo) {
            File file;
            int n;
            DocInfo docInfo = (DocInfo)object;
            URI uRI = docInfo.uri;
            String string2 = uRI.getPath();
            String string3 = string2.toLowerCase();
            String[] stringArray = this.getPatterns();
            int n2 = -1;
            int n3 = n = stringArray != null ? stringArray.length : 0;
            for (int i = 0; i < n; ++i) {
                n2 = string3.indexOf(stringArray[i]);
                if (n2 == -1) continue;
                n2 += stringArray[i].length();
                break;
            }
            if (n2 == -1) {
                return false;
            }
            Cache cache = this.getGlobal().getCache();
            URI uRI2 = null;
            try {
                uRI2 = uRI.resolve(string2.substring(0, n2 - 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println(new StringBuffer().append("bad URI: ").append(illegalArgumentException).toString());
            }
            if (n2 != -1 && "file".equals(uRI.getScheme()) && (file = cache.mapTo(uRI2, null, 3)).exists() && !file.isDirectory()) {
                try {
                    File file2 = cache.getOutputFile(uRI, null, 4, null);
                    if (!file2.exists()) {
                        String string4 = string2.substring(n2);
                        this.extractFile(file, string4, file2.getParentFile());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("createWidget/View" == string) {
            String string2 = this.getPreference("DirectoryMediaAdaptor/SortBy", FILENAME);
            String[] stringArray = new String[]{"Default Sort by Filename", "Default Sort by Length", "Default Sort by Last Modified", "Natural Ordering (No Sorting)"};
            String[] stringArray2 = new String[]{FILENAME, LENGTH, LASTMOD, NONE};
            VRadiogroup vRadiogroup = new VRadiogroup();
            Browser browser = this.getBrowser();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                VRadiobox vRadiobox = (VRadiobox)this.createUI("radiobox", stringArray[i], new SemanticEvent(browser, "DirectoryMediaAdaptor/SortBy", stringArray2[i]), (INode)semanticEvent.getOut(), "SortBy", false);
                vRadiobox.setRadiogroup(vRadiogroup);
                if (!string2.equals(stringArray2[i])) continue;
                vRadiogroup.setActive(vRadiobox);
            }
        } else if ("DirectoryMediaAdaptor/SortBy" == string) {
            String string3;
            String string4 = this.getPreference("DirectoryMediaAdaptor/SortBy", FILENAME);
            Object object = semanticEvent.getArg();
            if (object instanceof String && (string3 = ((String)object).intern()) != string4 && (string3 == FILENAME || string3 == LENGTH || string3 == LASTMOD || string3 == NONE)) {
                this.putPreference("DirectoryMediaAdaptor/SortBy", string3);
                this.getBrowser().eventq("reloadDocument", null);
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

